/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.batch;

import java.util.Date;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import org.apache.tika.batch.FileResource;
import org.apache.tika.batch.FileResourceCrawlerFutureResult;
import org.apache.tika.batch.IFileProcessorFutureResult;
import org.apache.tika.batch.PoisonFileResource;
import org.apache.tika.extractor.DocumentSelector;
import org.apache.tika.metadata.Metadata;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class FileResourceCrawler
implements Callable<IFileProcessorFutureResult> {
    protected static final int SKIPPED = 0;
    protected static final int ADDED = 1;
    protected static final int STOP_NOW = 2;
    private volatile boolean hasCompletedCrawling = false;
    private volatile boolean shutDownNoPoison = false;
    private volatile boolean isActive = true;
    private volatile boolean timedOut = false;
    private static final long PAUSE_INCREMENT_MILLIS = 1000L;
    protected static Logger logger = LoggerFactory.getLogger((String)FileResourceCrawler.class.toString());
    private int maxFilesToAdd = -1;
    private int maxFilesToConsider = -1;
    private final ArrayBlockingQueue<FileResource> queue;
    private final int numConsumers;
    private long maxConsecWaitInMillis = 300000L;
    private DocumentSelector documentSelector = null;
    private int added = 0;
    private int considered = 0;

    public FileResourceCrawler(ArrayBlockingQueue<FileResource> queue, int numConsumers) {
        this.queue = queue;
        this.numConsumers = numConsumers;
    }

    public abstract void start() throws InterruptedException;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public FileResourceCrawlerFutureResult call() {
        try {
            this.start();
        }
        catch (InterruptedException e) {
            logger.info("InterruptedException in FileCrawler: " + e.getMessage());
        }
        catch (Exception e) {
            logger.error("Exception in FileResourceCrawler: " + e.getMessage());
        }
        finally {
            this.isActive = false;
        }
        try {
            this.shutdown();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return new FileResourceCrawlerFutureResult(this.considered, this.added);
    }

    protected int tryToAdd(FileResource fileResource) throws InterruptedException {
        if (this.maxFilesToAdd > -1 && this.added >= this.maxFilesToAdd) {
            return 2;
        }
        if (this.maxFilesToConsider > -1 && this.considered > this.maxFilesToConsider) {
            return 2;
        }
        boolean isAdded = false;
        if (this.select(fileResource.getMetadata())) {
            long totalConsecutiveWait = 0L;
            while (!this.queue.offer(fileResource, 1L, TimeUnit.SECONDS)) {
                logger.info("FileResourceCrawler is pausing.  Queue is full: " + this.queue.size());
                Thread.sleep(1000L);
                if (this.maxConsecWaitInMillis > -1L && (totalConsecutiveWait += 1000L) > this.maxConsecWaitInMillis) {
                    this.timedOut = true;
                    logger.error("Crawler had to wait longer than max consecutive wait time.");
                    throw new InterruptedException("FileResourceCrawler had to wait longer than max consecutive wait time.");
                }
                if (!Thread.currentThread().isInterrupted()) continue;
                logger.info("FileResourceCrawler shutting down because of interrupted thread.");
                throw new InterruptedException("FileResourceCrawler interrupted.");
            }
            isAdded = true;
            ++this.added;
        } else {
            logger.debug("crawler did not select: " + fileResource.getResourceId());
        }
        ++this.considered;
        return isAdded ? 1 : 0;
    }

    private void shutdown() throws InterruptedException {
        logger.debug("FileResourceCrawler entering shutdown");
        if (this.hasCompletedCrawling || this.shutDownNoPoison) {
            return;
        }
        int i = 0;
        long start = new Date().getTime();
        while (this.queue.offer(new PoisonFileResource(), 1L, TimeUnit.SECONDS)) {
            if (this.shutDownNoPoison) {
                logger.debug("quitting the poison loop because shutDownNoPoison is now true");
                return;
            }
            if (Thread.currentThread().isInterrupted()) {
                logger.debug("thread interrupted while trying to add poison");
                return;
            }
            long elapsed = new Date().getTime() - start;
            if (this.maxConsecWaitInMillis > -1L && elapsed > this.maxConsecWaitInMillis) {
                logger.error("Crawler timed out while trying to add poison");
                return;
            }
            logger.debug("added " + i + " number of PoisonFileResource(s)");
            if (i++ < this.numConsumers) continue;
            break;
        }
        this.hasCompletedCrawling = true;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public void setMaxConsecWaitInMillis(long maxConsecWaitInMillis) {
        this.maxConsecWaitInMillis = maxConsecWaitInMillis;
    }

    public void setDocumentSelector(DocumentSelector documentSelector) {
        this.documentSelector = documentSelector;
    }

    public int getConsidered() {
        return this.considered;
    }

    protected boolean select(Metadata m) {
        return this.documentSelector.select(m);
    }

    public void setMaxFilesToAdd(int maxFilesToAdd) {
        this.maxFilesToAdd = maxFilesToAdd;
    }

    public void setMaxFilesToConsider(int maxFilesToConsider) {
        this.maxFilesToConsider = maxFilesToConsider;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isQueueEmpty() {
        int size = 0;
        ArrayBlockingQueue<FileResource> arrayBlockingQueue = this.queue;
        synchronized (arrayBlockingQueue) {
            for (FileResource aQueue : this.queue) {
                if (aQueue instanceof PoisonFileResource) continue;
                ++size;
            }
        }
        return size == 0;
    }

    public boolean wasTimedOut() {
        return this.timedOut;
    }

    public int getAdded() {
        return this.added;
    }

    public void shutDownNoPoison() {
        this.shutDownNoPoison = true;
    }
}

