/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.Charset;
import java.nio.charset.IllegalCharsetNameException;
import java.util.HashMap;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class CharsetUtils {
    private static final Pattern CHARSET_NAME_PATTERN = Pattern.compile("[ \\\"]*([^ >,;\\\"]+).*");
    private static final Pattern ISO_NAME_PATTERN = Pattern.compile("(?i).*8859-([\\d]+)");
    private static final Pattern CP_NAME_PATTERN = Pattern.compile("(?i)cp-([\\d]+)");
    private static final Pattern WIN_NAME_PATTERN = Pattern.compile("(?i)win(|-)([\\d]+)");
    private static final Map<String, String> CHARSET_ALIASES = new HashMap<String, String>(){
        {
            this.put("none", null);
            this.put("no", null);
            this.put("iso-8851-1", "iso-8859-1");
            this.put("windows", "windows-1252");
            this.put("koi8r", "KOI8-R");
        }
    };
    private static Method getCharsetICU;
    private static Method isSupportedICU;

    public static boolean isSupported(String charsetName) {
        try {
            if (isSupportedICU != null && ((Boolean)isSupportedICU.invoke(null, charsetName)).booleanValue()) {
                return true;
            }
            return Charset.isSupported(charsetName);
        }
        catch (IllegalCharsetNameException e) {
            return false;
        }
        catch (IllegalArgumentException e) {
            return false;
        }
        catch (Exception e) {
            return false;
        }
    }

    public static String clean(String charsetName) {
        if (charsetName == null) {
            return null;
        }
        Matcher m = CHARSET_NAME_PATTERN.matcher(charsetName);
        if (!m.matches()) {
            return null;
        }
        String result = m.group(1);
        if (CHARSET_ALIASES.containsKey(result.toLowerCase())) {
            result = CHARSET_ALIASES.get(result.toLowerCase());
        } else if (ISO_NAME_PATTERN.matcher(result).matches()) {
            m = ISO_NAME_PATTERN.matcher(result);
            m.matches();
            result = "iso-8859-" + m.group(1);
        } else if (CP_NAME_PATTERN.matcher(result).matches()) {
            m = CP_NAME_PATTERN.matcher(result);
            m.matches();
            result = "cp" + m.group(1);
        } else if (WIN_NAME_PATTERN.matcher(result).matches()) {
            m = WIN_NAME_PATTERN.matcher(result);
            m.matches();
            result = "windows-" + m.group(2);
        }
        try {
            Charset cs = CharsetUtils.forName(result);
            return cs.name();
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Charset forName(String name) {
        if (getCharsetICU != null) {
            try {
                Charset cs = (Charset)getCharsetICU.invoke(null, name);
                if (cs != null) {
                    return cs;
                }
            }
            catch (InvocationTargetException ite) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
        }
        return Charset.forName(name);
    }

    static {
        Class<?> icuCharset = null;
        try {
            icuCharset = CharsetUtils.class.getClassLoader().loadClass("com.ibm.icu.charset.CharsetICU");
        }
        catch (ClassNotFoundException e) {
            // empty catch block
        }
        if (icuCharset != null) {
            try {
                getCharsetICU = icuCharset.getMethod("forNameICU", String.class);
            }
            catch (Throwable t) {
                throw new RuntimeException(t);
            }
            try {
                isSupportedICU = icuCharset.getMethod("isSupported", String.class);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }
}

