/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika;

import org.apache.tika.Tika;
import org.junit.Assert;
import org.junit.Test;

public class TikaDetectionTest {
    private final Tika tika = new Tika();

    @Test
    public void testHttpServerFileExtensions() {
        Assert.assertEquals((Object)"application/andrew-inset", (Object)this.tika.detect("x.ez"));
        Assert.assertEquals((Object)"application/applixware", (Object)this.tika.detect("x.aw"));
        Assert.assertEquals((Object)"application/atom+xml", (Object)this.tika.detect("x.atom"));
        Assert.assertEquals((Object)"application/atomcat+xml", (Object)this.tika.detect("x.atomcat"));
        Assert.assertEquals((Object)"application/atomsvc+xml", (Object)this.tika.detect("x.atomsvc"));
        Assert.assertEquals((Object)"application/ccxml+xml", (Object)this.tika.detect("x.ccxml"));
        Assert.assertEquals((Object)"application/cu-seeme", (Object)this.tika.detect("x.cu"));
        Assert.assertEquals((Object)"application/davmount+xml", (Object)this.tika.detect("x.davmount"));
        Assert.assertEquals((Object)"application/ecmascript", (Object)this.tika.detect("x.ecma"));
        Assert.assertEquals((Object)"application/emma+xml", (Object)this.tika.detect("x.emma"));
        Assert.assertEquals((Object)"application/epub+zip", (Object)this.tika.detect("x.epub"));
        Assert.assertEquals((Object)"application/font-tdpfr", (Object)this.tika.detect("x.pfr"));
        Assert.assertEquals((Object)"application/hyperstudio", (Object)this.tika.detect("x.stk"));
        Assert.assertEquals((Object)"application/java-archive", (Object)this.tika.detect("x.jar"));
        Assert.assertEquals((Object)"application/java-serialized-object", (Object)this.tika.detect("x.ser"));
        Assert.assertEquals((Object)"application/java-vm", (Object)this.tika.detect("x.class"));
        Assert.assertEquals((Object)"application/javascript", (Object)this.tika.detect("x.js"));
        Assert.assertEquals((Object)"application/json", (Object)this.tika.detect("x.json"));
        Assert.assertEquals((Object)"application/lost+xml", (Object)this.tika.detect("x.lostxml"));
        Assert.assertEquals((Object)"application/mac-binhex40", (Object)this.tika.detect("x.hqx"));
        Assert.assertEquals((Object)"application/mac-compactpro", (Object)this.tika.detect("x.cpt"));
        Assert.assertEquals((Object)"application/marc", (Object)this.tika.detect("x.mrc"));
        Assert.assertEquals((Object)"application/mathematica", (Object)this.tika.detect("x.ma"));
        Assert.assertEquals((Object)"application/mathematica", (Object)this.tika.detect("x.nb"));
        Assert.assertEquals((Object)"application/mathematica", (Object)this.tika.detect("x.mb"));
        Assert.assertEquals((Object)"application/mathml+xml", (Object)this.tika.detect("x.mathml"));
        Assert.assertEquals((Object)"application/mbox", (Object)this.tika.detect("x.mbox"));
        Assert.assertEquals((Object)"application/mediaservercontrol+xml", (Object)this.tika.detect("x.mscml"));
        Assert.assertEquals((Object)"application/mp4", (Object)this.tika.detect("x.mp4s"));
        Assert.assertEquals((Object)"application/msword", (Object)this.tika.detect("x.doc"));
        Assert.assertEquals((Object)"application/msword", (Object)this.tika.detect("x.dot"));
        Assert.assertEquals((Object)"application/mxf", (Object)this.tika.detect("x.mxf"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.bin"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.dms"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.lha"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.lrf"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.lzh"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.so"));
        Assert.assertEquals((Object)"application/x-iso9660-image", (Object)this.tika.detect("x.iso"));
        Assert.assertEquals((Object)"application/x-apple-diskimage", (Object)this.tika.detect("x.dmg"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.dist"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.distz"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.pkg"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.bpk"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.dump"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.elc"));
        Assert.assertEquals((Object)"application/octet-stream", (Object)this.tika.detect("x.deploy"));
        Assert.assertEquals((Object)"application/oda", (Object)this.tika.detect("x.oda"));
        Assert.assertEquals((Object)"application/oebps-package+xml", (Object)this.tika.detect("x.opf"));
        Assert.assertEquals((Object)"application/ogg", (Object)this.tika.detect("x.ogx"));
        Assert.assertEquals((Object)"application/onenote", (Object)this.tika.detect("x.onetoc"));
        Assert.assertEquals((Object)"application/onenote", (Object)this.tika.detect("x.onetoc2"));
        Assert.assertEquals((Object)"application/onenote", (Object)this.tika.detect("x.onetmp"));
        Assert.assertEquals((Object)"application/onenote", (Object)this.tika.detect("x.onepkg"));
        Assert.assertEquals((Object)"application/patch-ops-error+xml", (Object)this.tika.detect("x.xer"));
        Assert.assertEquals((Object)"application/pdf", (Object)this.tika.detect("x.pdf"));
        Assert.assertEquals((Object)"application/pgp-encrypted", (Object)this.tika.detect("x.pgp"));
        Assert.assertEquals((Object)"application/pgp-signature", (Object)this.tika.detect("x.asc"));
        Assert.assertEquals((Object)"application/pgp-signature", (Object)this.tika.detect("x.sig"));
        Assert.assertEquals((Object)"application/pics-rules", (Object)this.tika.detect("x.prf"));
        Assert.assertEquals((Object)"application/pkcs10", (Object)this.tika.detect("x.p10"));
        Assert.assertEquals((Object)"application/pkcs7-mime", (Object)this.tika.detect("x.p7m"));
        Assert.assertEquals((Object)"application/pkcs7-mime", (Object)this.tika.detect("x.p7c"));
        Assert.assertEquals((Object)"application/pkcs7-signature", (Object)this.tika.detect("x.p7s"));
        Assert.assertEquals((Object)"application/pkix-cert", (Object)this.tika.detect("x.cer"));
        Assert.assertEquals((Object)"application/pkix-crl", (Object)this.tika.detect("x.crl"));
        Assert.assertEquals((Object)"application/pkix-pkipath", (Object)this.tika.detect("x.pkipath"));
        Assert.assertEquals((Object)"application/pkixcmp", (Object)this.tika.detect("x.pki"));
        Assert.assertEquals((Object)"application/pls+xml", (Object)this.tika.detect("x.pls"));
        Assert.assertEquals((Object)"application/illustrator", (Object)this.tika.detect("x.ai"));
        Assert.assertEquals((Object)"application/postscript", (Object)this.tika.detect("x.eps"));
        Assert.assertEquals((Object)"application/postscript", (Object)this.tika.detect("x.ps"));
        Assert.assertEquals((Object)"application/prs.cww", (Object)this.tika.detect("x.cww"));
        Assert.assertEquals((Object)"application/rdf+xml", (Object)this.tika.detect("x.rdf"));
        Assert.assertEquals((Object)"application/reginfo+xml", (Object)this.tika.detect("x.rif"));
        Assert.assertEquals((Object)"application/relax-ng-compact-syntax", (Object)this.tika.detect("x.rnc"));
        Assert.assertEquals((Object)"application/resource-lists+xml", (Object)this.tika.detect("x.rl"));
        Assert.assertEquals((Object)"application/resource-lists-diff+xml", (Object)this.tika.detect("x.rld"));
        Assert.assertEquals((Object)"application/rls-services+xml", (Object)this.tika.detect("x.rs"));
        Assert.assertEquals((Object)"application/rsd+xml", (Object)this.tika.detect("x.rsd"));
        Assert.assertEquals((Object)"application/rss+xml", (Object)this.tika.detect("x.rss"));
        Assert.assertEquals((Object)"application/rtf", (Object)this.tika.detect("x.rtf"));
        Assert.assertEquals((Object)"application/sbml+xml", (Object)this.tika.detect("x.sbml"));
        Assert.assertEquals((Object)"application/scvp-cv-request", (Object)this.tika.detect("x.scq"));
        Assert.assertEquals((Object)"application/scvp-cv-response", (Object)this.tika.detect("x.scs"));
        Assert.assertEquals((Object)"application/scvp-vp-request", (Object)this.tika.detect("x.spq"));
        Assert.assertEquals((Object)"application/scvp-vp-response", (Object)this.tika.detect("x.spp"));
        Assert.assertEquals((Object)"application/sdp", (Object)this.tika.detect("x.sdp"));
        Assert.assertEquals((Object)"application/set-payment-initiation", (Object)this.tika.detect("x.setpay"));
        Assert.assertEquals((Object)"application/set-registration-initiation", (Object)this.tika.detect("x.setreg"));
        Assert.assertEquals((Object)"application/sldworks", (Object)this.tika.detect("x.sldprt"));
        Assert.assertEquals((Object)"application/sldworks", (Object)this.tika.detect("x.sldasm"));
        Assert.assertEquals((Object)"application/sldworks", (Object)this.tika.detect("x.slddrw"));
        Assert.assertEquals((Object)"application/shf+xml", (Object)this.tika.detect("x.shf"));
        Assert.assertEquals((Object)"application/smil+xml", (Object)this.tika.detect("x.smi"));
        Assert.assertEquals((Object)"application/smil+xml", (Object)this.tika.detect("x.smil"));
        Assert.assertEquals((Object)"application/sparql-query", (Object)this.tika.detect("x.rq"));
        Assert.assertEquals((Object)"application/sparql-results+xml", (Object)this.tika.detect("x.srx"));
        Assert.assertEquals((Object)"application/srgs", (Object)this.tika.detect("x.gram"));
        Assert.assertEquals((Object)"application/srgs+xml", (Object)this.tika.detect("x.grxml"));
        Assert.assertEquals((Object)"application/ssml+xml", (Object)this.tika.detect("x.ssml"));
        Assert.assertEquals((Object)"application/vnd.3gpp.pic-bw-large", (Object)this.tika.detect("x.plb"));
        Assert.assertEquals((Object)"application/vnd.3gpp.pic-bw-small", (Object)this.tika.detect("x.psb"));
        Assert.assertEquals((Object)"application/vnd.3gpp.pic-bw-var", (Object)this.tika.detect("x.pvb"));
        Assert.assertEquals((Object)"application/vnd.3gpp2.tcap", (Object)this.tika.detect("x.tcap"));
        Assert.assertEquals((Object)"application/vnd.3m.post-it-notes", (Object)this.tika.detect("x.pwn"));
        Assert.assertEquals((Object)"application/vnd.accpac.simply.aso", (Object)this.tika.detect("x.aso"));
        Assert.assertEquals((Object)"application/vnd.accpac.simply.imp", (Object)this.tika.detect("x.imp"));
        Assert.assertEquals((Object)"application/vnd.acucobol", (Object)this.tika.detect("x.acu"));
        Assert.assertEquals((Object)"application/vnd.acucorp", (Object)this.tika.detect("x.atc"));
        Assert.assertEquals((Object)"application/vnd.acucorp", (Object)this.tika.detect("x.acutc"));
        Assert.assertEquals((Object)"application/vnd.adobe.air-application-installer-package+zip", (Object)this.tika.detect("x.air"));
        Assert.assertEquals((Object)"application/vnd.adobe.xdp+xml", (Object)this.tika.detect("x.xdp"));
        Assert.assertEquals((Object)"application/vnd.adobe.xfdf", (Object)this.tika.detect("x.xfdf"));
        Assert.assertEquals((Object)"application/vnd.airzip.filesecure.azf", (Object)this.tika.detect("x.azf"));
        Assert.assertEquals((Object)"application/vnd.airzip.filesecure.azs", (Object)this.tika.detect("x.azs"));
        Assert.assertEquals((Object)"application/vnd.amazon.ebook", (Object)this.tika.detect("x.azw"));
        Assert.assertEquals((Object)"application/vnd.americandynamics.acc", (Object)this.tika.detect("x.acc"));
        Assert.assertEquals((Object)"application/vnd.amiga.ami", (Object)this.tika.detect("x.ami"));
        Assert.assertEquals((Object)"application/vnd.android.package-archive", (Object)this.tika.detect("x.apk"));
        Assert.assertEquals((Object)"application/vnd.anser-web-certificate-issue-initiation", (Object)this.tika.detect("x.cii"));
        Assert.assertEquals((Object)"application/vnd.anser-web-funds-transfer-initiation", (Object)this.tika.detect("x.fti"));
        Assert.assertEquals((Object)"application/vnd.antix.game-component", (Object)this.tika.detect("x.atx"));
        Assert.assertEquals((Object)"application/vnd.apple.installer+xml", (Object)this.tika.detect("x.mpkg"));
        Assert.assertEquals((Object)"application/vnd.arastra.swi", (Object)this.tika.detect("x.swi"));
        Assert.assertEquals((Object)"application/vnd.blueice.multipass", (Object)this.tika.detect("x.mpm"));
        Assert.assertEquals((Object)"application/vnd.bmi", (Object)this.tika.detect("x.bmi"));
        Assert.assertEquals((Object)"application/vnd.businessobjects", (Object)this.tika.detect("x.rep"));
        Assert.assertEquals((Object)"application/vnd.chemdraw+xml", (Object)this.tika.detect("x.cdxml"));
        Assert.assertEquals((Object)"application/vnd.chipnuts.karaoke-mmd", (Object)this.tika.detect("x.mmd"));
        Assert.assertEquals((Object)"application/vnd.cinderella", (Object)this.tika.detect("x.cdy"));
        Assert.assertEquals((Object)"application/vnd.claymore", (Object)this.tika.detect("x.cla"));
        Assert.assertEquals((Object)"application/vnd.clonk.c4group", (Object)this.tika.detect("x.c4g"));
        Assert.assertEquals((Object)"application/vnd.clonk.c4group", (Object)this.tika.detect("x.c4d"));
        Assert.assertEquals((Object)"application/vnd.clonk.c4group", (Object)this.tika.detect("x.c4f"));
        Assert.assertEquals((Object)"application/vnd.clonk.c4group", (Object)this.tika.detect("x.c4p"));
        Assert.assertEquals((Object)"application/vnd.clonk.c4group", (Object)this.tika.detect("x.c4u"));
        Assert.assertEquals((Object)"application/vnd.commonspace", (Object)this.tika.detect("x.csp"));
        Assert.assertEquals((Object)"application/vnd.contact.cmsg", (Object)this.tika.detect("x.cdbcmsg"));
        Assert.assertEquals((Object)"application/vnd.cosmocaller", (Object)this.tika.detect("x.cmc"));
        Assert.assertEquals((Object)"application/vnd.crick.clicker", (Object)this.tika.detect("x.clkx"));
        Assert.assertEquals((Object)"application/vnd.crick.clicker.keyboard", (Object)this.tika.detect("x.clkk"));
        Assert.assertEquals((Object)"application/vnd.crick.clicker.palette", (Object)this.tika.detect("x.clkp"));
        Assert.assertEquals((Object)"application/vnd.crick.clicker.template", (Object)this.tika.detect("x.clkt"));
        Assert.assertEquals((Object)"application/vnd.crick.clicker.wordbank", (Object)this.tika.detect("x.clkw"));
        Assert.assertEquals((Object)"application/vnd.criticaltools.wbs+xml", (Object)this.tika.detect("x.wbs"));
        Assert.assertEquals((Object)"application/vnd.ctc-posml", (Object)this.tika.detect("x.pml"));
        Assert.assertEquals((Object)"application/vnd.cups-ppd", (Object)this.tika.detect("x.ppd"));
        Assert.assertEquals((Object)"application/vnd.curl.car", (Object)this.tika.detect("x.car"));
        Assert.assertEquals((Object)"application/vnd.curl.pcurl", (Object)this.tika.detect("x.pcurl"));
        Assert.assertEquals((Object)"application/vnd.data-vision.rdz", (Object)this.tika.detect("x.rdz"));
        Assert.assertEquals((Object)"application/vnd.denovo.fcselayout-link", (Object)this.tika.detect("x.fe_launch"));
        Assert.assertEquals((Object)"application/vnd.dna", (Object)this.tika.detect("x.dna"));
        Assert.assertEquals((Object)"application/vnd.dolby.mlp", (Object)this.tika.detect("x.mlp"));
        Assert.assertEquals((Object)"application/vnd.dpgraph", (Object)this.tika.detect("x.dpg"));
        Assert.assertEquals((Object)"application/vnd.dreamfactory", (Object)this.tika.detect("x.dfac"));
        Assert.assertEquals((Object)"application/vnd.dynageo", (Object)this.tika.detect("x.geo"));
        Assert.assertEquals((Object)"application/vnd.ecowin.chart", (Object)this.tika.detect("x.mag"));
        Assert.assertEquals((Object)"application/vnd.enliven", (Object)this.tika.detect("x.nml"));
        Assert.assertEquals((Object)"application/vnd.epson.esf", (Object)this.tika.detect("x.esf"));
        Assert.assertEquals((Object)"application/vnd.epson.msf", (Object)this.tika.detect("x.msf"));
        Assert.assertEquals((Object)"application/vnd.epson.quickanime", (Object)this.tika.detect("x.qam"));
        Assert.assertEquals((Object)"application/vnd.epson.salt", (Object)this.tika.detect("x.slt"));
        Assert.assertEquals((Object)"application/vnd.epson.ssf", (Object)this.tika.detect("x.ssf"));
        Assert.assertEquals((Object)"application/vnd.eszigno3+xml", (Object)this.tika.detect("x.es3"));
        Assert.assertEquals((Object)"application/vnd.eszigno3+xml", (Object)this.tika.detect("x.et3"));
        Assert.assertEquals((Object)"application/vnd.ezpix-album", (Object)this.tika.detect("x.ez2"));
        Assert.assertEquals((Object)"application/vnd.ezpix-package", (Object)this.tika.detect("x.ez3"));
        Assert.assertEquals((Object)"application/vnd.fdf", (Object)this.tika.detect("x.fdf"));
        Assert.assertEquals((Object)"application/vnd.fdsn.mseed", (Object)this.tika.detect("x.mseed"));
        Assert.assertEquals((Object)"application/vnd.fdsn.seed", (Object)this.tika.detect("x.seed"));
        Assert.assertEquals((Object)"application/vnd.fdsn.seed", (Object)this.tika.detect("x.dataless"));
        Assert.assertEquals((Object)"application/vnd.flographit", (Object)this.tika.detect("x.gph"));
        Assert.assertEquals((Object)"application/vnd.fluxtime.clip", (Object)this.tika.detect("x.ftc"));
        Assert.assertEquals((Object)"application/vnd.framemaker", (Object)this.tika.detect("x.fm"));
        Assert.assertEquals((Object)"application/vnd.framemaker", (Object)this.tika.detect("x.frame"));
        Assert.assertEquals((Object)"application/vnd.framemaker", (Object)this.tika.detect("x.maker"));
        Assert.assertEquals((Object)"application/vnd.framemaker", (Object)this.tika.detect("x.book"));
        Assert.assertEquals((Object)"application/vnd.frogans.fnc", (Object)this.tika.detect("x.fnc"));
        Assert.assertEquals((Object)"application/vnd.frogans.ltf", (Object)this.tika.detect("x.ltf"));
        Assert.assertEquals((Object)"application/vnd.fsc.weblaunch", (Object)this.tika.detect("x.fsc"));
        Assert.assertEquals((Object)"application/vnd.fujitsu.oasys", (Object)this.tika.detect("x.oas"));
        Assert.assertEquals((Object)"application/vnd.fujitsu.oasys2", (Object)this.tika.detect("x.oa2"));
        Assert.assertEquals((Object)"application/vnd.fujitsu.oasys3", (Object)this.tika.detect("x.oa3"));
        Assert.assertEquals((Object)"application/vnd.fujitsu.oasysgp", (Object)this.tika.detect("x.fg5"));
        Assert.assertEquals((Object)"application/vnd.fujitsu.oasysprs", (Object)this.tika.detect("x.bh2"));
        Assert.assertEquals((Object)"application/vnd.fujixerox.ddd", (Object)this.tika.detect("x.ddd"));
        Assert.assertEquals((Object)"application/vnd.fujixerox.docuworks", (Object)this.tika.detect("x.xdw"));
        Assert.assertEquals((Object)"application/vnd.fujixerox.docuworks.binder", (Object)this.tika.detect("x.xbd"));
        Assert.assertEquals((Object)"application/vnd.fuzzysheet", (Object)this.tika.detect("x.fzs"));
        Assert.assertEquals((Object)"application/vnd.genomatix.tuxedo", (Object)this.tika.detect("x.txd"));
        Assert.assertEquals((Object)"application/vnd.geogebra.file", (Object)this.tika.detect("x.ggb"));
        Assert.assertEquals((Object)"application/vnd.geogebra.tool", (Object)this.tika.detect("x.ggt"));
        Assert.assertEquals((Object)"application/vnd.geometry-explorer", (Object)this.tika.detect("x.gex"));
        Assert.assertEquals((Object)"application/vnd.geometry-explorer", (Object)this.tika.detect("x.gre"));
        Assert.assertEquals((Object)"application/vnd.gmx", (Object)this.tika.detect("x.gmx"));
        Assert.assertEquals((Object)"application/vnd.google-earth.kml+xml", (Object)this.tika.detect("x.kml"));
        Assert.assertEquals((Object)"application/vnd.google-earth.kmz", (Object)this.tika.detect("x.kmz"));
        Assert.assertEquals((Object)"application/vnd.grafeq", (Object)this.tika.detect("x.gqf"));
        Assert.assertEquals((Object)"application/vnd.grafeq", (Object)this.tika.detect("x.gqs"));
        Assert.assertEquals((Object)"application/vnd.groove-account", (Object)this.tika.detect("x.gac"));
        Assert.assertEquals((Object)"application/vnd.groove-help", (Object)this.tika.detect("x.ghf"));
        Assert.assertEquals((Object)"application/vnd.groove-identity-message", (Object)this.tika.detect("x.gim"));
        Assert.assertEquals((Object)"application/vnd.groove-injector", (Object)this.tika.detect("x.grv"));
        Assert.assertEquals((Object)"application/vnd.groove-tool-message", (Object)this.tika.detect("x.gtm"));
        Assert.assertEquals((Object)"application/vnd.groove-tool-template", (Object)this.tika.detect("x.tpl"));
        Assert.assertEquals((Object)"application/vnd.groove-vcard", (Object)this.tika.detect("x.vcg"));
        Assert.assertEquals((Object)"application/vnd.handheld-entertainment+xml", (Object)this.tika.detect("x.zmm"));
        Assert.assertEquals((Object)"application/vnd.hbci", (Object)this.tika.detect("x.hbci"));
        Assert.assertEquals((Object)"application/vnd.hhe.lesson-player", (Object)this.tika.detect("x.les"));
        Assert.assertEquals((Object)"application/vnd.hp-hpgl", (Object)this.tika.detect("x.hpgl"));
        Assert.assertEquals((Object)"application/vnd.hp-hpid", (Object)this.tika.detect("x.hpid"));
        Assert.assertEquals((Object)"application/vnd.hp-hps", (Object)this.tika.detect("x.hps"));
        Assert.assertEquals((Object)"application/vnd.hp-jlyt", (Object)this.tika.detect("x.jlt"));
        Assert.assertEquals((Object)"application/vnd.hp-pcl", (Object)this.tika.detect("x.pcl"));
        Assert.assertEquals((Object)"application/vnd.hp-pclxl", (Object)this.tika.detect("x.pclxl"));
        Assert.assertEquals((Object)"application/vnd.hydrostatix.sof-data", (Object)this.tika.detect("x.sfd-hdstx"));
        Assert.assertEquals((Object)"application/vnd.hzn-3d-crossword", (Object)this.tika.detect("x.x3d"));
        Assert.assertEquals((Object)"application/vnd.ibm.minipay", (Object)this.tika.detect("x.mpy"));
        Assert.assertEquals((Object)"application/vnd.ibm.modcap", (Object)this.tika.detect("x.afp"));
        Assert.assertEquals((Object)"application/vnd.ibm.modcap", (Object)this.tika.detect("x.listafp"));
        Assert.assertEquals((Object)"application/vnd.ibm.modcap", (Object)this.tika.detect("x.list3820"));
        Assert.assertEquals((Object)"application/vnd.ibm.rights-management", (Object)this.tika.detect("x.irm"));
        Assert.assertEquals((Object)"application/vnd.ibm.secure-container", (Object)this.tika.detect("x.sc"));
        Assert.assertEquals((Object)"application/vnd.iccprofile", (Object)this.tika.detect("x.icc"));
        Assert.assertEquals((Object)"application/vnd.iccprofile", (Object)this.tika.detect("x.icm"));
        Assert.assertEquals((Object)"application/vnd.igloader", (Object)this.tika.detect("x.igl"));
        Assert.assertEquals((Object)"application/vnd.immervision-ivp", (Object)this.tika.detect("x.ivp"));
        Assert.assertEquals((Object)"application/vnd.immervision-ivu", (Object)this.tika.detect("x.ivu"));
        Assert.assertEquals((Object)"application/vnd.intercon.formnet", (Object)this.tika.detect("x.xpw"));
        Assert.assertEquals((Object)"application/vnd.intercon.formnet", (Object)this.tika.detect("x.xpx"));
        Assert.assertEquals((Object)"application/vnd.intu.qbo", (Object)this.tika.detect("x.qbo"));
        Assert.assertEquals((Object)"application/vnd.intu.qfx", (Object)this.tika.detect("x.qfx"));
        Assert.assertEquals((Object)"application/vnd.ipunplugged.rcprofile", (Object)this.tika.detect("x.rcprofile"));
        Assert.assertEquals((Object)"application/vnd.irepository.package+xml", (Object)this.tika.detect("x.irp"));
        Assert.assertEquals((Object)"application/vnd.is-xpr", (Object)this.tika.detect("x.xpr"));
        Assert.assertEquals((Object)"application/vnd.jam", (Object)this.tika.detect("x.jam"));
        Assert.assertEquals((Object)"application/vnd.jcp.javame.midlet-rms", (Object)this.tika.detect("x.rms"));
        Assert.assertEquals((Object)"application/vnd.jisp", (Object)this.tika.detect("x.jisp"));
        Assert.assertEquals((Object)"application/vnd.joost.joda-archive", (Object)this.tika.detect("x.joda"));
        Assert.assertEquals((Object)"application/vnd.kahootz", (Object)this.tika.detect("x.ktz"));
        Assert.assertEquals((Object)"application/vnd.kahootz", (Object)this.tika.detect("x.ktr"));
        Assert.assertEquals((Object)"application/vnd.kde.karbon", (Object)this.tika.detect("x.karbon"));
        Assert.assertEquals((Object)"application/vnd.kde.kchart", (Object)this.tika.detect("x.chrt"));
        Assert.assertEquals((Object)"application/vnd.kde.kformula", (Object)this.tika.detect("x.kfo"));
        Assert.assertEquals((Object)"application/vnd.kde.kivio", (Object)this.tika.detect("x.flw"));
        Assert.assertEquals((Object)"application/vnd.kde.kontour", (Object)this.tika.detect("x.kon"));
        Assert.assertEquals((Object)"application/vnd.kde.kpresenter", (Object)this.tika.detect("x.kpr"));
        Assert.assertEquals((Object)"application/vnd.kde.kpresenter", (Object)this.tika.detect("x.kpt"));
        Assert.assertEquals((Object)"application/vnd.kde.kspread", (Object)this.tika.detect("x.ksp"));
        Assert.assertEquals((Object)"application/vnd.kde.kword", (Object)this.tika.detect("x.kwd"));
        Assert.assertEquals((Object)"application/vnd.kde.kword", (Object)this.tika.detect("x.kwt"));
        Assert.assertEquals((Object)"application/vnd.kenameaapp", (Object)this.tika.detect("x.htke"));
        Assert.assertEquals((Object)"application/vnd.kidspiration", (Object)this.tika.detect("x.kia"));
        Assert.assertEquals((Object)"application/vnd.kinar", (Object)this.tika.detect("x.kne"));
        Assert.assertEquals((Object)"application/vnd.kinar", (Object)this.tika.detect("x.knp"));
        Assert.assertEquals((Object)"application/vnd.koan", (Object)this.tika.detect("x.skp"));
        Assert.assertEquals((Object)"application/vnd.koan", (Object)this.tika.detect("x.skd"));
        Assert.assertEquals((Object)"application/vnd.koan", (Object)this.tika.detect("x.skt"));
        Assert.assertEquals((Object)"application/vnd.koan", (Object)this.tika.detect("x.skm"));
        Assert.assertEquals((Object)"application/vnd.kodak-descriptor", (Object)this.tika.detect("x.sse"));
        Assert.assertEquals((Object)"application/vnd.llamagraphics.life-balance.desktop", (Object)this.tika.detect("x.lbd"));
        Assert.assertEquals((Object)"application/vnd.llamagraphics.life-balance.exchange+xml", (Object)this.tika.detect("x.lbe"));
        Assert.assertEquals((Object)"application/vnd.lotus-1-2-3", (Object)this.tika.detect("x.123"));
        Assert.assertEquals((Object)"application/vnd.lotus-approach", (Object)this.tika.detect("x.apr"));
        Assert.assertEquals((Object)"application/vnd.lotus-freelance", (Object)this.tika.detect("x.pre"));
        Assert.assertEquals((Object)"application/vnd.lotus-notes", (Object)this.tika.detect("x.nsf"));
        Assert.assertEquals((Object)"application/vnd.lotus-organizer", (Object)this.tika.detect("x.org"));
        Assert.assertEquals((Object)"text/x-scheme", (Object)this.tika.detect("x.scm"));
        Assert.assertEquals((Object)"application/vnd.lotus-wordpro", (Object)this.tika.detect("x.lwp"));
        Assert.assertEquals((Object)"application/vnd.macports.portpkg", (Object)this.tika.detect("x.portpkg"));
        Assert.assertEquals((Object)"application/vnd.mcd", (Object)this.tika.detect("x.mcd"));
        Assert.assertEquals((Object)"application/vnd.medcalcdata", (Object)this.tika.detect("x.mc1"));
        Assert.assertEquals((Object)"application/vnd.mediastation.cdkey", (Object)this.tika.detect("x.cdkey"));
        Assert.assertEquals((Object)"application/vnd.mfer", (Object)this.tika.detect("x.mwf"));
        Assert.assertEquals((Object)"application/vnd.mfmp", (Object)this.tika.detect("x.mfm"));
        Assert.assertEquals((Object)"application/vnd.micrografx.flo", (Object)this.tika.detect("x.flo"));
        Assert.assertEquals((Object)"application/vnd.micrografx.igx", (Object)this.tika.detect("x.igx"));
        Assert.assertEquals((Object)"application/vnd.mif", (Object)this.tika.detect("x.mif"));
        Assert.assertEquals((Object)"application/vnd.mobius.daf", (Object)this.tika.detect("x.daf"));
        Assert.assertEquals((Object)"application/vnd.mobius.dis", (Object)this.tika.detect("x.dis"));
        Assert.assertEquals((Object)"application/vnd.mobius.mbk", (Object)this.tika.detect("x.mbk"));
        Assert.assertEquals((Object)"application/vnd.mobius.mqy", (Object)this.tika.detect("x.mqy"));
        Assert.assertEquals((Object)"application/vnd.mobius.msl", (Object)this.tika.detect("x.msl"));
        Assert.assertEquals((Object)"application/vnd.mobius.plc", (Object)this.tika.detect("x.plc"));
        Assert.assertEquals((Object)"application/vnd.mobius.txf", (Object)this.tika.detect("x.txf"));
        Assert.assertEquals((Object)"application/vnd.mophun.application", (Object)this.tika.detect("x.mpn"));
        Assert.assertEquals((Object)"application/vnd.mophun.certificate", (Object)this.tika.detect("x.mpc"));
        Assert.assertEquals((Object)"application/vnd.mozilla.xul+xml", (Object)this.tika.detect("x.xul"));
        Assert.assertEquals((Object)"application/vnd.ms-artgalry", (Object)this.tika.detect("x.cil"));
        Assert.assertEquals((Object)"application/vnd.ms-cab-compressed", (Object)this.tika.detect("x.cab"));
        Assert.assertEquals((Object)"application/vnd.ms-excel", (Object)this.tika.detect("x.xls"));
        Assert.assertEquals((Object)"application/vnd.ms-excel", (Object)this.tika.detect("x.xlm"));
        Assert.assertEquals((Object)"application/vnd.ms-excel", (Object)this.tika.detect("x.xla"));
        Assert.assertEquals((Object)"application/vnd.ms-excel", (Object)this.tika.detect("x.xlc"));
        Assert.assertEquals((Object)"application/vnd.ms-excel", (Object)this.tika.detect("x.xlt"));
        Assert.assertEquals((Object)"application/vnd.ms-excel", (Object)this.tika.detect("x.xlw"));
        Assert.assertEquals((Object)"application/vnd.ms-excel.addin.macroenabled.12", (Object)this.tika.detect("x.xlam"));
        Assert.assertEquals((Object)"application/vnd.ms-excel.sheet.binary.macroenabled.12", (Object)this.tika.detect("x.xlsb"));
        Assert.assertEquals((Object)"application/vnd.ms-excel.sheet.macroenabled.12", (Object)this.tika.detect("x.xlsm"));
        Assert.assertEquals((Object)"application/vnd.ms-excel.template.macroenabled.12", (Object)this.tika.detect("x.xltm"));
        Assert.assertEquals((Object)"application/vnd.ms-fontobject", (Object)this.tika.detect("x.eot"));
        Assert.assertEquals((Object)"application/vnd.ms-htmlhelp", (Object)this.tika.detect("x.chm"));
        Assert.assertEquals((Object)"application/vnd.ms-ims", (Object)this.tika.detect("x.ims"));
        Assert.assertEquals((Object)"application/vnd.ms-lrm", (Object)this.tika.detect("x.lrm"));
        Assert.assertEquals((Object)"application/vnd.ms-pki.seccat", (Object)this.tika.detect("x.cat"));
        Assert.assertEquals((Object)"application/vnd.ms-pki.stl", (Object)this.tika.detect("x.stl"));
        Assert.assertEquals((Object)"application/vnd.ms-powerpoint", (Object)this.tika.detect("x.ppt"));
        Assert.assertEquals((Object)"application/vnd.ms-powerpoint", (Object)this.tika.detect("x.pps"));
        Assert.assertEquals((Object)"application/vnd.ms-powerpoint", (Object)this.tika.detect("x.pot"));
        Assert.assertEquals((Object)"application/vnd.ms-powerpoint.addin.macroenabled.12", (Object)this.tika.detect("x.ppam"));
        Assert.assertEquals((Object)"application/vnd.ms-powerpoint.presentation.macroenabled.12", (Object)this.tika.detect("x.pptm"));
        Assert.assertEquals((Object)"application/vnd.ms-powerpoint.slide.macroenabled.12", (Object)this.tika.detect("x.sldm"));
        Assert.assertEquals((Object)"application/vnd.ms-powerpoint.slideshow.macroenabled.12", (Object)this.tika.detect("x.ppsm"));
        Assert.assertEquals((Object)"application/vnd.ms-powerpoint.template.macroenabled.12", (Object)this.tika.detect("x.potm"));
        Assert.assertEquals((Object)"application/vnd.ms-project", (Object)this.tika.detect("x.mpp"));
        Assert.assertEquals((Object)"application/vnd.ms-project", (Object)this.tika.detect("x.mpt"));
        Assert.assertEquals((Object)"application/vnd.ms-word.document.macroenabled.12", (Object)this.tika.detect("x.docm"));
        Assert.assertEquals((Object)"application/vnd.ms-word.template.macroenabled.12", (Object)this.tika.detect("x.dotm"));
        Assert.assertEquals((Object)"application/vnd.ms-works", (Object)this.tika.detect("x.wps"));
        Assert.assertEquals((Object)"application/vnd.ms-works", (Object)this.tika.detect("x.wks"));
        Assert.assertEquals((Object)"application/vnd.ms-works", (Object)this.tika.detect("x.wcm"));
        Assert.assertEquals((Object)"application/vnd.ms-works", (Object)this.tika.detect("x.wdb"));
        Assert.assertEquals((Object)"application/vnd.ms-wpl", (Object)this.tika.detect("x.wpl"));
        Assert.assertEquals((Object)"application/vnd.ms-xpsdocument", (Object)this.tika.detect("x.xps"));
        Assert.assertEquals((Object)"application/vnd.mseq", (Object)this.tika.detect("x.mseq"));
        Assert.assertEquals((Object)"application/vnd.musician", (Object)this.tika.detect("x.mus"));
        Assert.assertEquals((Object)"application/vnd.muvee.style", (Object)this.tika.detect("x.msty"));
        Assert.assertEquals((Object)"application/vnd.neurolanguage.nlu", (Object)this.tika.detect("x.nlu"));
        Assert.assertEquals((Object)"application/vnd.noblenet-directory", (Object)this.tika.detect("x.nnd"));
        Assert.assertEquals((Object)"application/vnd.noblenet-sealer", (Object)this.tika.detect("x.nns"));
        Assert.assertEquals((Object)"application/vnd.noblenet-web", (Object)this.tika.detect("x.nnw"));
        Assert.assertEquals((Object)"application/vnd.nokia.n-gage.data", (Object)this.tika.detect("x.ngdat"));
        Assert.assertEquals((Object)"application/vnd.nokia.n-gage.symbian.install", (Object)this.tika.detect("x.n-gage"));
        Assert.assertEquals((Object)"application/vnd.nokia.radio-preset", (Object)this.tika.detect("x.rpst"));
        Assert.assertEquals((Object)"application/vnd.nokia.radio-presets", (Object)this.tika.detect("x.rpss"));
        Assert.assertEquals((Object)"application/vnd.novadigm.edm", (Object)this.tika.detect("x.edm"));
        Assert.assertEquals((Object)"application/vnd.novadigm.edx", (Object)this.tika.detect("x.edx"));
        Assert.assertEquals((Object)"application/vnd.novadigm.ext", (Object)this.tika.detect("x.ext"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.chart", (Object)this.tika.detect("x.odc"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.chart-template", (Object)this.tika.detect("x.otc"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.database", (Object)this.tika.detect("x.odb"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.formula", (Object)this.tika.detect("x.odf"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.formula-template", (Object)this.tika.detect("x.odft"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.graphics", (Object)this.tika.detect("x.odg"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.graphics-template", (Object)this.tika.detect("x.otg"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.image", (Object)this.tika.detect("x.odi"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.image-template", (Object)this.tika.detect("x.oti"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.presentation", (Object)this.tika.detect("x.odp"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.presentation-template", (Object)this.tika.detect("x.otp"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.spreadsheet", (Object)this.tika.detect("x.ods"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.spreadsheet-template", (Object)this.tika.detect("x.ots"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.text", (Object)this.tika.detect("x.odt"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.text-master", (Object)this.tika.detect("x.otm"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.text-template", (Object)this.tika.detect("x.ott"));
        Assert.assertEquals((Object)"application/vnd.oasis.opendocument.text-web", (Object)this.tika.detect("x.oth"));
        Assert.assertEquals((Object)"application/vnd.olpc-sugar", (Object)this.tika.detect("x.xo"));
        Assert.assertEquals((Object)"application/vnd.oma.dd2+xml", (Object)this.tika.detect("x.dd2"));
        Assert.assertEquals((Object)"application/vnd.openofficeorg.extension", (Object)this.tika.detect("x.oxt"));
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.presentationml.presentation", (Object)this.tika.detect("x.pptx"));
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.presentationml.slide", (Object)this.tika.detect("x.sldx"));
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.presentationml.slideshow", (Object)this.tika.detect("x.ppsx"));
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.presentationml.template", (Object)this.tika.detect("x.potx"));
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.sheet", (Object)this.tika.detect("x.xlsx"));
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.spreadsheetml.template", (Object)this.tika.detect("x.xltx"));
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.document", (Object)this.tika.detect("x.docx"));
        Assert.assertEquals((Object)"application/vnd.openxmlformats-officedocument.wordprocessingml.template", (Object)this.tika.detect("x.dotx"));
        Assert.assertEquals((Object)"application/vnd.osgi.dp", (Object)this.tika.detect("x.dp"));
        Assert.assertEquals((Object)"chemical/x-pdb", (Object)this.tika.detect("x.pdb"));
        Assert.assertEquals((Object)"application/vnd.palm", (Object)this.tika.detect("x.pqa"));
        Assert.assertEquals((Object)"application/vnd.palm", (Object)this.tika.detect("x.oprc"));
        Assert.assertEquals((Object)"application/vnd.pg.format", (Object)this.tika.detect("x.str"));
        Assert.assertEquals((Object)"application/vnd.pg.osasli", (Object)this.tika.detect("x.ei6"));
        Assert.assertEquals((Object)"application/vnd.picsel", (Object)this.tika.detect("x.efif"));
        Assert.assertEquals((Object)"application/vnd.pocketlearn", (Object)this.tika.detect("x.plf"));
        Assert.assertEquals((Object)"application/vnd.powerbuilder6", (Object)this.tika.detect("x.pbd"));
        Assert.assertEquals((Object)"application/vnd.previewsystems.box", (Object)this.tika.detect("x.box"));
        Assert.assertEquals((Object)"application/vnd.proteus.magazine", (Object)this.tika.detect("x.mgz"));
        Assert.assertEquals((Object)"application/vnd.publishare-delta-tree", (Object)this.tika.detect("x.qps"));
        Assert.assertEquals((Object)"application/vnd.pvi.ptid1", (Object)this.tika.detect("x.ptid"));
        Assert.assertEquals((Object)"application/vnd.quark.quarkxpress", (Object)this.tika.detect("x.qxd"));
        Assert.assertEquals((Object)"application/vnd.quark.quarkxpress", (Object)this.tika.detect("x.qxt"));
        Assert.assertEquals((Object)"application/vnd.quark.quarkxpress", (Object)this.tika.detect("x.qwd"));
        Assert.assertEquals((Object)"application/vnd.quark.quarkxpress", (Object)this.tika.detect("x.qwt"));
        Assert.assertEquals((Object)"application/vnd.quark.quarkxpress", (Object)this.tika.detect("x.qxl"));
        Assert.assertEquals((Object)"application/vnd.quark.quarkxpress", (Object)this.tika.detect("x.qxb"));
        Assert.assertEquals((Object)"application/vnd.recordare.musicxml", (Object)this.tika.detect("x.mxl"));
        Assert.assertEquals((Object)"application/vnd.recordare.musicxml+xml", (Object)this.tika.detect("x.musicxml"));
        Assert.assertEquals((Object)"application/vnd.rim.cod", (Object)this.tika.detect("x.cod"));
        Assert.assertEquals((Object)"application/vnd.rn-realmedia", (Object)this.tika.detect("x.rm"));
        Assert.assertEquals((Object)"application/vnd.route66.link66+xml", (Object)this.tika.detect("x.link66"));
        Assert.assertEquals((Object)"application/vnd.seemail", (Object)this.tika.detect("x.see"));
        Assert.assertEquals((Object)"application/vnd.sema", (Object)this.tika.detect("x.sema"));
        Assert.assertEquals((Object)"application/vnd.semd", (Object)this.tika.detect("x.semd"));
        Assert.assertEquals((Object)"application/vnd.semf", (Object)this.tika.detect("x.semf"));
        Assert.assertEquals((Object)"application/vnd.shana.informed.formdata", (Object)this.tika.detect("x.ifm"));
        Assert.assertEquals((Object)"application/vnd.shana.informed.formtemplate", (Object)this.tika.detect("x.itp"));
        Assert.assertEquals((Object)"application/vnd.shana.informed.interchange", (Object)this.tika.detect("x.iif"));
        Assert.assertEquals((Object)"application/vnd.shana.informed.package", (Object)this.tika.detect("x.ipk"));
        Assert.assertEquals((Object)"application/vnd.simtech-mindmapper", (Object)this.tika.detect("x.twd"));
        Assert.assertEquals((Object)"application/vnd.simtech-mindmapper", (Object)this.tika.detect("x.twds"));
        Assert.assertEquals((Object)"application/vnd.smaf", (Object)this.tika.detect("x.mmf"));
        Assert.assertEquals((Object)"application/vnd.smart.teacher", (Object)this.tika.detect("x.teacher"));
        Assert.assertEquals((Object)"application/vnd.solent.sdkm+xml", (Object)this.tika.detect("x.sdkm"));
        Assert.assertEquals((Object)"application/vnd.solent.sdkm+xml", (Object)this.tika.detect("x.sdkd"));
        Assert.assertEquals((Object)"application/vnd.spotfire.dxp", (Object)this.tika.detect("x.dxp"));
        Assert.assertEquals((Object)"application/vnd.spotfire.sfs", (Object)this.tika.detect("x.sfs"));
        Assert.assertEquals((Object)"application/vnd.stardivision.calc", (Object)this.tika.detect("x.sdc"));
        Assert.assertEquals((Object)"application/vnd.stardivision.draw", (Object)this.tika.detect("x.sda"));
        Assert.assertEquals((Object)"application/vnd.stardivision.impress", (Object)this.tika.detect("x.sdd"));
        Assert.assertEquals((Object)"application/vnd.stardivision.math", (Object)this.tika.detect("x.smf"));
        Assert.assertEquals((Object)"application/vnd.stardivision.writer", (Object)this.tika.detect("x.sdw"));
        Assert.assertEquals((Object)"application/x-staroffice-template", (Object)this.tika.detect("x.vor"));
        Assert.assertEquals((Object)"application/vnd.stardivision.writer-global", (Object)this.tika.detect("x.sgl"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.calc", (Object)this.tika.detect("x.sxc"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.calc.template", (Object)this.tika.detect("x.stc"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.draw", (Object)this.tika.detect("x.sxd"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.draw.template", (Object)this.tika.detect("x.std"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.impress", (Object)this.tika.detect("x.sxi"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.impress.template", (Object)this.tika.detect("x.sti"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.math", (Object)this.tika.detect("x.sxm"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.writer", (Object)this.tika.detect("x.sxw"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.writer.global", (Object)this.tika.detect("x.sxg"));
        Assert.assertEquals((Object)"application/vnd.sun.xml.writer.template", (Object)this.tika.detect("x.stw"));
        Assert.assertEquals((Object)"application/vnd.sus-calendar", (Object)this.tika.detect("x.sus"));
        Assert.assertEquals((Object)"application/vnd.sus-calendar", (Object)this.tika.detect("x.susp"));
        Assert.assertEquals((Object)"application/vnd.svd", (Object)this.tika.detect("x.svd"));
        Assert.assertEquals((Object)"application/vnd.symbian.install", (Object)this.tika.detect("x.sis"));
        Assert.assertEquals((Object)"application/vnd.symbian.install", (Object)this.tika.detect("x.sisx"));
        Assert.assertEquals((Object)"application/vnd.syncml+xml", (Object)this.tika.detect("x.xsm"));
        Assert.assertEquals((Object)"application/vnd.syncml.dm+wbxml", (Object)this.tika.detect("x.bdm"));
        Assert.assertEquals((Object)"application/vnd.syncml.dm+xml", (Object)this.tika.detect("x.xdm"));
        Assert.assertEquals((Object)"application/vnd.tao.intent-module-archive", (Object)this.tika.detect("x.tao"));
        Assert.assertEquals((Object)"application/vnd.tmobile-livetv", (Object)this.tika.detect("x.tmo"));
        Assert.assertEquals((Object)"application/vnd.trid.tpt", (Object)this.tika.detect("x.tpt"));
        Assert.assertEquals((Object)"application/vnd.triscape.mxs", (Object)this.tika.detect("x.mxs"));
        Assert.assertEquals((Object)"application/vnd.trueapp", (Object)this.tika.detect("x.tra"));
        Assert.assertEquals((Object)"application/vnd.ufdl", (Object)this.tika.detect("x.ufd"));
        Assert.assertEquals((Object)"application/vnd.ufdl", (Object)this.tika.detect("x.ufdl"));
        Assert.assertEquals((Object)"application/vnd.uiq.theme", (Object)this.tika.detect("x.utz"));
        Assert.assertEquals((Object)"application/vnd.umajin", (Object)this.tika.detect("x.umj"));
        Assert.assertEquals((Object)"application/vnd.unity", (Object)this.tika.detect("x.unityweb"));
        Assert.assertEquals((Object)"application/vnd.uoml+xml", (Object)this.tika.detect("x.uoml"));
        Assert.assertEquals((Object)"application/vnd.vcx", (Object)this.tika.detect("x.vcx"));
        Assert.assertEquals((Object)"application/vnd.visio", (Object)this.tika.detect("x.vsd"));
        Assert.assertEquals((Object)"application/vnd.visio", (Object)this.tika.detect("x.vst"));
        Assert.assertEquals((Object)"application/vnd.visio", (Object)this.tika.detect("x.vss"));
        Assert.assertEquals((Object)"application/vnd.visio", (Object)this.tika.detect("x.vsw"));
        Assert.assertEquals((Object)"application/vnd.visionary", (Object)this.tika.detect("x.vis"));
        Assert.assertEquals((Object)"application/vnd.vsf", (Object)this.tika.detect("x.vsf"));
        Assert.assertEquals((Object)"application/vnd.wap.wbxml", (Object)this.tika.detect("x.wbxml"));
        Assert.assertEquals((Object)"application/vnd.wap.wmlc", (Object)this.tika.detect("x.wmlc"));
        Assert.assertEquals((Object)"application/vnd.wap.wmlscriptc", (Object)this.tika.detect("x.wmlsc"));
        Assert.assertEquals((Object)"application/vnd.webturbo", (Object)this.tika.detect("x.wtb"));
        Assert.assertEquals((Object)"application/vnd.wordperfect", (Object)this.tika.detect("x.wpd"));
        Assert.assertEquals((Object)"application/vnd.wqd", (Object)this.tika.detect("x.wqd"));
        Assert.assertEquals((Object)"application/vnd.wt.stf", (Object)this.tika.detect("x.stf"));
        Assert.assertEquals((Object)"application/vnd.xara", (Object)this.tika.detect("x.xar"));
        Assert.assertEquals((Object)"application/vnd.xfdl", (Object)this.tika.detect("x.xfdl"));
        Assert.assertEquals((Object)"application/vnd.yamaha.hv-dic", (Object)this.tika.detect("x.hvd"));
        Assert.assertEquals((Object)"application/vnd.yamaha.hv-script", (Object)this.tika.detect("x.hvs"));
        Assert.assertEquals((Object)"application/vnd.yamaha.hv-voice", (Object)this.tika.detect("x.hvp"));
        Assert.assertEquals((Object)"application/vnd.yamaha.openscoreformat", (Object)this.tika.detect("x.osf"));
        Assert.assertEquals((Object)"application/vnd.yamaha.openscoreformat.osfpvg+xml", (Object)this.tika.detect("x.osfpvg"));
        Assert.assertEquals((Object)"application/vnd.yamaha.smaf-audio", (Object)this.tika.detect("x.saf"));
        Assert.assertEquals((Object)"application/vnd.yamaha.smaf-phrase", (Object)this.tika.detect("x.spf"));
        Assert.assertEquals((Object)"application/vnd.yellowriver-custom-menu", (Object)this.tika.detect("x.cmp"));
        Assert.assertEquals((Object)"application/vnd.zul", (Object)this.tika.detect("x.zir"));
        Assert.assertEquals((Object)"application/vnd.zul", (Object)this.tika.detect("x.zirz"));
        Assert.assertEquals((Object)"application/vnd.zzazz.deck+xml", (Object)this.tika.detect("x.zaz"));
        Assert.assertEquals((Object)"application/voicexml+xml", (Object)this.tika.detect("x.vxml"));
        Assert.assertEquals((Object)"application/winhlp", (Object)this.tika.detect("x.hlp"));
        Assert.assertEquals((Object)"application/wsdl+xml", (Object)this.tika.detect("x.wsdl"));
        Assert.assertEquals((Object)"application/wspolicy+xml", (Object)this.tika.detect("x.wspolicy"));
        Assert.assertEquals((Object)"application/x-abiword", (Object)this.tika.detect("x.abw"));
        Assert.assertEquals((Object)"application/x-ace-compressed", (Object)this.tika.detect("x.ace"));
        Assert.assertEquals((Object)"application/x-authorware-bin", (Object)this.tika.detect("x.aab"));
        Assert.assertEquals((Object)"application/x-authorware-bin", (Object)this.tika.detect("x.x32"));
        Assert.assertEquals((Object)"application/x-authorware-bin", (Object)this.tika.detect("x.u32"));
        Assert.assertEquals((Object)"application/x-authorware-bin", (Object)this.tika.detect("x.vox"));
        Assert.assertEquals((Object)"application/x-authorware-map", (Object)this.tika.detect("x.aam"));
        Assert.assertEquals((Object)"application/x-authorware-seg", (Object)this.tika.detect("x.aas"));
        Assert.assertEquals((Object)"application/x-bcpio", (Object)this.tika.detect("x.bcpio"));
        Assert.assertEquals((Object)"application/x-bittorrent", (Object)this.tika.detect("x.torrent"));
        Assert.assertEquals((Object)"application/x-bzip", (Object)this.tika.detect("x.bz"));
        Assert.assertEquals((Object)"application/x-bzip2", (Object)this.tika.detect("x.bz2"));
        Assert.assertEquals((Object)"application/x-bzip2", (Object)this.tika.detect("x.boz"));
        Assert.assertEquals((Object)"application/x-cdlink", (Object)this.tika.detect("x.vcd"));
        Assert.assertEquals((Object)"application/x-chat", (Object)this.tika.detect("x.chat"));
        Assert.assertEquals((Object)"application/x-chess-pgn", (Object)this.tika.detect("x.pgn"));
        Assert.assertEquals((Object)"application/x-cpio", (Object)this.tika.detect("x.cpio"));
        Assert.assertEquals((Object)"application/x-csh", (Object)this.tika.detect("x.csh"));
        Assert.assertEquals((Object)"application/x-debian-package", (Object)this.tika.detect("x.deb"));
        Assert.assertEquals((Object)"application/x-debian-package", (Object)this.tika.detect("x.udeb"));
        Assert.assertEquals((Object)"application/x-director", (Object)this.tika.detect("x.dir"));
        Assert.assertEquals((Object)"application/x-director", (Object)this.tika.detect("x.dcr"));
        Assert.assertEquals((Object)"application/x-director", (Object)this.tika.detect("x.dxr"));
        Assert.assertEquals((Object)"application/x-director", (Object)this.tika.detect("x.cst"));
        Assert.assertEquals((Object)"application/x-director", (Object)this.tika.detect("x.cct"));
        Assert.assertEquals((Object)"application/x-director", (Object)this.tika.detect("x.cxt"));
        Assert.assertEquals((Object)"application/x-director", (Object)this.tika.detect("x.w3d"));
        Assert.assertEquals((Object)"application/x-director", (Object)this.tika.detect("x.fgd"));
        Assert.assertEquals((Object)"application/x-director", (Object)this.tika.detect("x.swa"));
        Assert.assertEquals((Object)"application/x-doom", (Object)this.tika.detect("x.wad"));
        Assert.assertEquals((Object)"application/x-dtbncx+xml", (Object)this.tika.detect("x.ncx"));
        Assert.assertEquals((Object)"application/x-dtbook+xml", (Object)this.tika.detect("x.dtb"));
        Assert.assertEquals((Object)"application/x-dtbresource+xml", (Object)this.tika.detect("x.res"));
        Assert.assertEquals((Object)"application/x-dvi", (Object)this.tika.detect("x.dvi"));
        Assert.assertEquals((Object)"application/x-font-bdf", (Object)this.tika.detect("x.bdf"));
        Assert.assertEquals((Object)"application/x-font-ghostscript", (Object)this.tika.detect("x.gsf"));
        Assert.assertEquals((Object)"application/x-font-linux-psf", (Object)this.tika.detect("x.psf"));
        Assert.assertEquals((Object)"application/x-font-otf", (Object)this.tika.detect("x.otf"));
        Assert.assertEquals((Object)"application/x-font-pcf", (Object)this.tika.detect("x.pcf"));
        Assert.assertEquals((Object)"application/x-font-snf", (Object)this.tika.detect("x.snf"));
        Assert.assertEquals((Object)"application/x-font-ttf", (Object)this.tika.detect("x.ttf"));
        Assert.assertEquals((Object)"application/x-font-ttf", (Object)this.tika.detect("x.ttc"));
        Assert.assertEquals((Object)"application/x-font-type1", (Object)this.tika.detect("x.pfa"));
        Assert.assertEquals((Object)"application/x-font-type1", (Object)this.tika.detect("x.pfb"));
        Assert.assertEquals((Object)"application/x-font-printer-metric", (Object)this.tika.detect("x.pfm"));
        Assert.assertEquals((Object)"application/x-font-adobe-metric", (Object)this.tika.detect("x.afm"));
        Assert.assertEquals((Object)"application/x-futuresplash", (Object)this.tika.detect("x.spl"));
        Assert.assertEquals((Object)"application/x-gnumeric", (Object)this.tika.detect("x.gnumeric"));
        Assert.assertEquals((Object)"application/x-gtar", (Object)this.tika.detect("x.gtar"));
        Assert.assertEquals((Object)"application/x-hdf", (Object)this.tika.detect("x.hdf"));
        Assert.assertEquals((Object)"application/x-java-jnlp-file", (Object)this.tika.detect("x.jnlp"));
        Assert.assertEquals((Object)"application/x-latex", (Object)this.tika.detect("x.latex"));
        Assert.assertEquals((Object)"application/x-mobipocket-ebook", (Object)this.tika.detect("x.prc"));
        Assert.assertEquals((Object)"application/x-mobipocket-ebook", (Object)this.tika.detect("x.mobi"));
        Assert.assertEquals((Object)"application/x-ms-application", (Object)this.tika.detect("x.application"));
        Assert.assertEquals((Object)"application/x-ms-wmd", (Object)this.tika.detect("x.wmd"));
        Assert.assertEquals((Object)"application/x-ms-wmz", (Object)this.tika.detect("x.wmz"));
        Assert.assertEquals((Object)"application/x-ms-xbap", (Object)this.tika.detect("x.xbap"));
        Assert.assertEquals((Object)"application/x-msaccess", (Object)this.tika.detect("x.mdb"));
        Assert.assertEquals((Object)"application/x-msbinder", (Object)this.tika.detect("x.obd"));
        Assert.assertEquals((Object)"application/x-mscardfile", (Object)this.tika.detect("x.crd"));
        Assert.assertEquals((Object)"application/x-msclip", (Object)this.tika.detect("x.clp"));
        Assert.assertEquals((Object)"application/x-dosexec", (Object)this.tika.detect("x.exe"));
        Assert.assertEquals((Object)"application/x-msdownload", (Object)this.tika.detect("x.dll"));
        Assert.assertEquals((Object)"application/x-msdownload", (Object)this.tika.detect("x.com"));
        Assert.assertEquals((Object)"application/x-msdownload", (Object)this.tika.detect("x.bat"));
        Assert.assertEquals((Object)"application/x-msmediaview", (Object)this.tika.detect("x.mvb"));
        Assert.assertEquals((Object)"application/x-msmediaview", (Object)this.tika.detect("x.m13"));
        Assert.assertEquals((Object)"application/x-msmediaview", (Object)this.tika.detect("x.m14"));
        Assert.assertEquals((Object)"application/x-msmetafile", (Object)this.tika.detect("x.wmf"));
        Assert.assertEquals((Object)"application/x-msmoney", (Object)this.tika.detect("x.mny"));
        Assert.assertEquals((Object)"application/x-mspublisher", (Object)this.tika.detect("x.pub"));
        Assert.assertEquals((Object)"application/x-msschedule", (Object)this.tika.detect("x.scd"));
        Assert.assertEquals((Object)"application/x-msterminal", (Object)this.tika.detect("x.trm"));
        Assert.assertEquals((Object)"application/x-mswrite", (Object)this.tika.detect("x.wri"));
        Assert.assertEquals((Object)"application/x-netcdf", (Object)this.tika.detect("x.nc"));
        Assert.assertEquals((Object)"application/x-netcdf", (Object)this.tika.detect("x.cdf"));
        Assert.assertEquals((Object)"application/x-pkcs12", (Object)this.tika.detect("x.p12"));
        Assert.assertEquals((Object)"application/x-pkcs12", (Object)this.tika.detect("x.pfx"));
        Assert.assertEquals((Object)"application/x-pkcs7-certificates", (Object)this.tika.detect("x.p7b"));
        Assert.assertEquals((Object)"application/x-pkcs7-certificates", (Object)this.tika.detect("x.spc"));
        Assert.assertEquals((Object)"application/x-pkcs7-certreqresp", (Object)this.tika.detect("x.p7r"));
        Assert.assertEquals((Object)"application/x-rar-compressed", (Object)this.tika.detect("x.rar"));
        Assert.assertEquals((Object)"application/x-sh", (Object)this.tika.detect("x.sh"));
        Assert.assertEquals((Object)"application/x-shar", (Object)this.tika.detect("x.shar"));
        Assert.assertEquals((Object)"application/x-shockwave-flash", (Object)this.tika.detect("x.swf"));
        Assert.assertEquals((Object)"application/x-silverlight-app", (Object)this.tika.detect("x.xap"));
        Assert.assertEquals((Object)"application/x-stuffit", (Object)this.tika.detect("x.sit"));
        Assert.assertEquals((Object)"application/x-stuffitx", (Object)this.tika.detect("x.sitx"));
        Assert.assertEquals((Object)"application/x-sv4cpio", (Object)this.tika.detect("x.sv4cpio"));
        Assert.assertEquals((Object)"application/x-sv4crc", (Object)this.tika.detect("x.sv4crc"));
        Assert.assertEquals((Object)"application/x-tar", (Object)this.tika.detect("x.tar"));
        Assert.assertEquals((Object)"text/x-tcl", (Object)this.tika.detect("x.tcl"));
        Assert.assertEquals((Object)"application/x-tex", (Object)this.tika.detect("x.tex"));
        Assert.assertEquals((Object)"application/x-tex-tfm", (Object)this.tika.detect("x.tfm"));
        Assert.assertEquals((Object)"application/x-texinfo", (Object)this.tika.detect("x.texinfo"));
        Assert.assertEquals((Object)"application/x-texinfo", (Object)this.tika.detect("x.texi"));
        Assert.assertEquals((Object)"application/x-ustar", (Object)this.tika.detect("x.ustar"));
        Assert.assertEquals((Object)"application/x-wais-source", (Object)this.tika.detect("x.src"));
        Assert.assertEquals((Object)"application/x-x509-ca-cert", (Object)this.tika.detect("x.der"));
        Assert.assertEquals((Object)"application/x-x509-ca-cert", (Object)this.tika.detect("x.crt"));
        Assert.assertEquals((Object)"application/x-xfig", (Object)this.tika.detect("x.fig"));
        Assert.assertEquals((Object)"application/x-xpinstall", (Object)this.tika.detect("x.xpi"));
        Assert.assertEquals((Object)"application/xenc+xml", (Object)this.tika.detect("x.xenc"));
        Assert.assertEquals((Object)"application/xhtml+xml", (Object)this.tika.detect("x.xhtml"));
        Assert.assertEquals((Object)"application/xhtml+xml", (Object)this.tika.detect("x.xht"));
        Assert.assertEquals((Object)"application/xml", (Object)this.tika.detect("x.xml"));
        Assert.assertEquals((Object)"application/xml", (Object)this.tika.detect("x.xsl"));
        Assert.assertEquals((Object)"application/xml-dtd", (Object)this.tika.detect("x.dtd"));
        Assert.assertEquals((Object)"application/xop+xml", (Object)this.tika.detect("x.xop"));
        Assert.assertEquals((Object)"application/xslt+xml", (Object)this.tika.detect("x.xslt"));
        Assert.assertEquals((Object)"application/xspf+xml", (Object)this.tika.detect("x.xspf"));
        Assert.assertEquals((Object)"application/xv+xml", (Object)this.tika.detect("x.mxml"));
        Assert.assertEquals((Object)"application/xv+xml", (Object)this.tika.detect("x.xhvml"));
        Assert.assertEquals((Object)"application/xv+xml", (Object)this.tika.detect("x.xvml"));
        Assert.assertEquals((Object)"application/xv+xml", (Object)this.tika.detect("x.xvm"));
        Assert.assertEquals((Object)"application/zip", (Object)this.tika.detect("x.zip"));
        Assert.assertEquals((Object)"audio/adpcm", (Object)this.tika.detect("x.adp"));
        Assert.assertEquals((Object)"audio/basic", (Object)this.tika.detect("x.au"));
        Assert.assertEquals((Object)"audio/basic", (Object)this.tika.detect("x.snd"));
        Assert.assertEquals((Object)"audio/midi", (Object)this.tika.detect("x.mid"));
        Assert.assertEquals((Object)"audio/midi", (Object)this.tika.detect("x.midi"));
        Assert.assertEquals((Object)"audio/midi", (Object)this.tika.detect("x.kar"));
        Assert.assertEquals((Object)"audio/midi", (Object)this.tika.detect("x.rmi"));
        Assert.assertEquals((Object)"audio/mp4", (Object)this.tika.detect("x.mp4a"));
        Assert.assertEquals((Object)"audio/mpeg", (Object)this.tika.detect("x.mpga"));
        Assert.assertEquals((Object)"audio/mpeg", (Object)this.tika.detect("x.mp2"));
        Assert.assertEquals((Object)"audio/mpeg", (Object)this.tika.detect("x.mp2a"));
        Assert.assertEquals((Object)"audio/mpeg", (Object)this.tika.detect("x.mp3"));
        Assert.assertEquals((Object)"audio/mpeg", (Object)this.tika.detect("x.m2a"));
        Assert.assertEquals((Object)"audio/mpeg", (Object)this.tika.detect("x.m3a"));
        Assert.assertEquals((Object)"audio/ogg", (Object)this.tika.detect("x.oga"));
        Assert.assertEquals((Object)"audio/vnd.digital-winds", (Object)this.tika.detect("x.eol"));
        Assert.assertEquals((Object)"audio/vnd.dts", (Object)this.tika.detect("x.dts"));
        Assert.assertEquals((Object)"audio/vnd.dts.hd", (Object)this.tika.detect("x.dtshd"));
        Assert.assertEquals((Object)"audio/vnd.lucent.voice", (Object)this.tika.detect("x.lvp"));
        Assert.assertEquals((Object)"audio/vnd.ms-playready.media.pya", (Object)this.tika.detect("x.pya"));
        Assert.assertEquals((Object)"audio/vnd.nuera.ecelp4800", (Object)this.tika.detect("x.ecelp4800"));
        Assert.assertEquals((Object)"audio/vnd.nuera.ecelp7470", (Object)this.tika.detect("x.ecelp7470"));
        Assert.assertEquals((Object)"audio/vnd.nuera.ecelp9600", (Object)this.tika.detect("x.ecelp9600"));
        Assert.assertEquals((Object)"audio/x-aac", (Object)this.tika.detect("x.aac"));
        Assert.assertEquals((Object)"audio/x-aiff", (Object)this.tika.detect("x.aif"));
        Assert.assertEquals((Object)"audio/x-aiff", (Object)this.tika.detect("x.aiff"));
        Assert.assertEquals((Object)"audio/x-aiff", (Object)this.tika.detect("x.aifc"));
        Assert.assertEquals((Object)"audio/x-mpegurl", (Object)this.tika.detect("x.m3u"));
        Assert.assertEquals((Object)"audio/x-ms-wax", (Object)this.tika.detect("x.wax"));
        Assert.assertEquals((Object)"audio/x-ms-wma", (Object)this.tika.detect("x.wma"));
        Assert.assertEquals((Object)"audio/x-pn-realaudio", (Object)this.tika.detect("x.ram"));
        Assert.assertEquals((Object)"audio/x-pn-realaudio", (Object)this.tika.detect("x.ra"));
        Assert.assertEquals((Object)"audio/x-pn-realaudio-plugin", (Object)this.tika.detect("x.rmp"));
        Assert.assertEquals((Object)"audio/x-wav", (Object)this.tika.detect("x.wav"));
        Assert.assertEquals((Object)"chemical/x-cdx", (Object)this.tika.detect("x.cdx"));
        Assert.assertEquals((Object)"chemical/x-cif", (Object)this.tika.detect("x.cif"));
        Assert.assertEquals((Object)"chemical/x-cmdf", (Object)this.tika.detect("x.cmdf"));
        Assert.assertEquals((Object)"chemical/x-cml", (Object)this.tika.detect("x.cml"));
        Assert.assertEquals((Object)"chemical/x-csml", (Object)this.tika.detect("x.csml"));
        Assert.assertEquals((Object)"chemical/x-xyz", (Object)this.tika.detect("x.xyz"));
        Assert.assertEquals((Object)"image/x-ms-bmp", (Object)this.tika.detect("x.bmp"));
        Assert.assertEquals((Object)"image/cgm", (Object)this.tika.detect("x.cgm"));
        Assert.assertEquals((Object)"image/g3fax", (Object)this.tika.detect("x.g3"));
        Assert.assertEquals((Object)"image/gif", (Object)this.tika.detect("x.gif"));
        Assert.assertEquals((Object)"image/ief", (Object)this.tika.detect("x.ief"));
        Assert.assertEquals((Object)"image/jpeg", (Object)this.tika.detect("x.jpeg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)this.tika.detect("x.jpg"));
        Assert.assertEquals((Object)"image/jpeg", (Object)this.tika.detect("x.jpe"));
        Assert.assertEquals((Object)"image/jpm", (Object)this.tika.detect("x.jpm"));
        Assert.assertEquals((Object)"image/jpm", (Object)this.tika.detect("x.jpgm"));
        Assert.assertEquals((Object)"image/png", (Object)this.tika.detect("x.png"));
        Assert.assertEquals((Object)"image/prs.btif", (Object)this.tika.detect("x.btif"));
        Assert.assertEquals((Object)"image/svg+xml", (Object)this.tika.detect("x.svg"));
        Assert.assertEquals((Object)"image/svg+xml", (Object)this.tika.detect("x.svgz"));
        Assert.assertEquals((Object)"image/tiff", (Object)this.tika.detect("x.tiff"));
        Assert.assertEquals((Object)"image/tiff", (Object)this.tika.detect("x.tif"));
        Assert.assertEquals((Object)"image/vnd.adobe.photoshop", (Object)this.tika.detect("x.psd"));
        Assert.assertEquals((Object)"image/vnd.djvu", (Object)this.tika.detect("x.djvu"));
        Assert.assertEquals((Object)"image/vnd.djvu", (Object)this.tika.detect("x.djv"));
        Assert.assertEquals((Object)"image/vnd.dwg", (Object)this.tika.detect("x.dwg"));
        Assert.assertEquals((Object)"image/vnd.dxf", (Object)this.tika.detect("x.dxf"));
        Assert.assertEquals((Object)"image/vnd.fastbidsheet", (Object)this.tika.detect("x.fbs"));
        Assert.assertEquals((Object)"image/vnd.fpx", (Object)this.tika.detect("x.fpx"));
        Assert.assertEquals((Object)"image/vnd.fst", (Object)this.tika.detect("x.fst"));
        Assert.assertEquals((Object)"image/vnd.fujixerox.edmics-mmr", (Object)this.tika.detect("x.mmr"));
        Assert.assertEquals((Object)"image/vnd.fujixerox.edmics-rlc", (Object)this.tika.detect("x.rlc"));
        Assert.assertEquals((Object)"image/vnd.ms-modi", (Object)this.tika.detect("x.mdi"));
        Assert.assertEquals((Object)"image/vnd.net-fpx", (Object)this.tika.detect("x.npx"));
        Assert.assertEquals((Object)"image/vnd.wap.wbmp", (Object)this.tika.detect("x.wbmp"));
        Assert.assertEquals((Object)"image/vnd.xiff", (Object)this.tika.detect("x.xif"));
        Assert.assertEquals((Object)"image/x-cmu-raster", (Object)this.tika.detect("x.ras"));
        Assert.assertEquals((Object)"image/x-cmx", (Object)this.tika.detect("x.cmx"));
        Assert.assertEquals((Object)"image/x-freehand", (Object)this.tika.detect("x.fh"));
        Assert.assertEquals((Object)"image/x-freehand", (Object)this.tika.detect("x.fhc"));
        Assert.assertEquals((Object)"image/x-freehand", (Object)this.tika.detect("x.fh4"));
        Assert.assertEquals((Object)"image/x-freehand", (Object)this.tika.detect("x.fh5"));
        Assert.assertEquals((Object)"image/x-freehand", (Object)this.tika.detect("x.fh7"));
        Assert.assertEquals((Object)"image/x-pcx", (Object)this.tika.detect("x.pcx"));
        Assert.assertEquals((Object)"image/x-pict", (Object)this.tika.detect("x.pic"));
        Assert.assertEquals((Object)"image/x-pict", (Object)this.tika.detect("x.pct"));
        Assert.assertEquals((Object)"image/x-portable-anymap", (Object)this.tika.detect("x.pnm"));
        Assert.assertEquals((Object)"image/x-portable-bitmap", (Object)this.tika.detect("x.pbm"));
        Assert.assertEquals((Object)"image/x-portable-graymap", (Object)this.tika.detect("x.pgm"));
        Assert.assertEquals((Object)"image/x-portable-pixmap", (Object)this.tika.detect("x.ppm"));
        Assert.assertEquals((Object)"image/x-rgb", (Object)this.tika.detect("x.rgb"));
        Assert.assertEquals((Object)"image/x-xbitmap", (Object)this.tika.detect("x.xbm"));
        Assert.assertEquals((Object)"image/x-xpixmap", (Object)this.tika.detect("x.xpm"));
        Assert.assertEquals((Object)"image/x-xwindowdump", (Object)this.tika.detect("x.xwd"));
        Assert.assertEquals((Object)"message/rfc822", (Object)this.tika.detect("x.eml"));
        Assert.assertEquals((Object)"message/rfc822", (Object)this.tika.detect("x.mime"));
        Assert.assertEquals((Object)"model/iges", (Object)this.tika.detect("x.igs"));
        Assert.assertEquals((Object)"model/iges", (Object)this.tika.detect("x.iges"));
        Assert.assertEquals((Object)"model/mesh", (Object)this.tika.detect("x.msh"));
        Assert.assertEquals((Object)"model/mesh", (Object)this.tika.detect("x.mesh"));
        Assert.assertEquals((Object)"model/mesh", (Object)this.tika.detect("x.silo"));
        Assert.assertEquals((Object)"model/vnd.dwf", (Object)this.tika.detect("x.dwf"));
        Assert.assertEquals((Object)"model/vnd.gdl", (Object)this.tika.detect("x.gdl"));
        Assert.assertEquals((Object)"model/vnd.gtw", (Object)this.tika.detect("x.gtw"));
        Assert.assertEquals((Object)"model/vnd.mts", (Object)this.tika.detect("x.mts"));
        Assert.assertEquals((Object)"model/vnd.vtu", (Object)this.tika.detect("x.vtu"));
        Assert.assertEquals((Object)"model/vrml", (Object)this.tika.detect("x.wrl"));
        Assert.assertEquals((Object)"model/vrml", (Object)this.tika.detect("x.vrml"));
        Assert.assertEquals((Object)"text/calendar", (Object)this.tika.detect("x.ics"));
        Assert.assertEquals((Object)"text/calendar", (Object)this.tika.detect("x.ifb"));
        Assert.assertEquals((Object)"text/css", (Object)this.tika.detect("x.css"));
        Assert.assertEquals((Object)"text/csv", (Object)this.tika.detect("x.csv"));
        Assert.assertEquals((Object)"text/html", (Object)this.tika.detect("x.html"));
        Assert.assertEquals((Object)"text/html", (Object)this.tika.detect("x.htm"));
        Assert.assertEquals((Object)"text/plain", (Object)this.tika.detect("x.txt"));
        Assert.assertEquals((Object)"text/plain", (Object)this.tika.detect("x.text"));
        Assert.assertEquals((Object)"text/plain", (Object)this.tika.detect("x.conf"));
        Assert.assertEquals((Object)"text/plain", (Object)this.tika.detect("x.def"));
        Assert.assertEquals((Object)"text/plain", (Object)this.tika.detect("x.list"));
        Assert.assertEquals((Object)"text/x-log", (Object)this.tika.detect("x.log"));
        Assert.assertEquals((Object)"text/plain", (Object)this.tika.detect("x.in"));
        Assert.assertEquals((Object)"text/prs.lines.tag", (Object)this.tika.detect("x.dsc"));
        Assert.assertEquals((Object)"text/richtext", (Object)this.tika.detect("x.rtx"));
        Assert.assertEquals((Object)"text/sgml", (Object)this.tika.detect("x.sgml"));
        Assert.assertEquals((Object)"text/sgml", (Object)this.tika.detect("x.sgm"));
        Assert.assertEquals((Object)"text/tab-separated-values", (Object)this.tika.detect("x.tsv"));
        Assert.assertEquals((Object)"text/troff", (Object)this.tika.detect("x.t"));
        Assert.assertEquals((Object)"text/troff", (Object)this.tika.detect("x.tr"));
        Assert.assertEquals((Object)"text/troff", (Object)this.tika.detect("x.roff"));
        Assert.assertEquals((Object)"text/troff", (Object)this.tika.detect("x.man"));
        Assert.assertEquals((Object)"text/troff", (Object)this.tika.detect("x.me"));
        Assert.assertEquals((Object)"text/troff", (Object)this.tika.detect("x.ms"));
        Assert.assertEquals((Object)"text/uri-list", (Object)this.tika.detect("x.uri"));
        Assert.assertEquals((Object)"text/uri-list", (Object)this.tika.detect("x.uris"));
        Assert.assertEquals((Object)"text/uri-list", (Object)this.tika.detect("x.urls"));
        Assert.assertEquals((Object)"text/vnd.curl", (Object)this.tika.detect("x.curl"));
        Assert.assertEquals((Object)"text/vnd.curl.dcurl", (Object)this.tika.detect("x.dcurl"));
        Assert.assertEquals((Object)"text/vnd.curl.scurl", (Object)this.tika.detect("x.scurl"));
        Assert.assertEquals((Object)"text/vnd.curl.mcurl", (Object)this.tika.detect("x.mcurl"));
        Assert.assertEquals((Object)"text/vnd.fly", (Object)this.tika.detect("x.fly"));
        Assert.assertEquals((Object)"text/vnd.fmi.flexstor", (Object)this.tika.detect("x.flx"));
        Assert.assertEquals((Object)"text/vnd.graphviz", (Object)this.tika.detect("x.gv"));
        Assert.assertEquals((Object)"text/vnd.in3d.3dml", (Object)this.tika.detect("x.3dml"));
        Assert.assertEquals((Object)"text/vnd.in3d.spot", (Object)this.tika.detect("x.spot"));
        Assert.assertEquals((Object)"text/vnd.sun.j2me.app-descriptor", (Object)this.tika.detect("x.jad"));
        Assert.assertEquals((Object)"text/vnd.wap.wml", (Object)this.tika.detect("x.wml"));
        Assert.assertEquals((Object)"text/vnd.wap.wmlscript", (Object)this.tika.detect("x.wmls"));
        Assert.assertEquals((Object)"text/x-assembly", (Object)this.tika.detect("x.s"));
        Assert.assertEquals((Object)"text/x-assembly", (Object)this.tika.detect("x.asm"));
        Assert.assertEquals((Object)"text/x-csrc", (Object)this.tika.detect("x.c"));
        Assert.assertEquals((Object)"text/x-c++src", (Object)this.tika.detect("x.cc"));
        Assert.assertEquals((Object)"text/x-c++src", (Object)this.tika.detect("x.cxx"));
        Assert.assertEquals((Object)"text/x-c++src", (Object)this.tika.detect("x.cpp"));
        Assert.assertEquals((Object)"text/x-chdr", (Object)this.tika.detect("x.h"));
        Assert.assertEquals((Object)"text/x-c++hdr", (Object)this.tika.detect("x.hh"));
        Assert.assertEquals((Object)"text/x-fortran", (Object)this.tika.detect("x.f"));
        Assert.assertEquals((Object)"text/x-fortran", (Object)this.tika.detect("x.for"));
        Assert.assertEquals((Object)"text/x-fortran", (Object)this.tika.detect("x.f77"));
        Assert.assertEquals((Object)"text/x-fortran", (Object)this.tika.detect("x.f90"));
        Assert.assertEquals((Object)"text/x-pascal", (Object)this.tika.detect("x.p"));
        Assert.assertEquals((Object)"text/x-pascal", (Object)this.tika.detect("x.pas"));
        Assert.assertEquals((Object)"text/x-java-source", (Object)this.tika.detect("x.java"));
        Assert.assertEquals((Object)"text/x-setext", (Object)this.tika.detect("x.etx"));
        Assert.assertEquals((Object)"text/x-uuencode", (Object)this.tika.detect("x.uu"));
        Assert.assertEquals((Object)"text/x-vcalendar", (Object)this.tika.detect("x.vcs"));
        Assert.assertEquals((Object)"text/x-vcard", (Object)this.tika.detect("x.vcf"));
        Assert.assertEquals((Object)"video/3gpp", (Object)this.tika.detect("x.3gp"));
        Assert.assertEquals((Object)"video/3gpp2", (Object)this.tika.detect("x.3g2"));
        Assert.assertEquals((Object)"video/h261", (Object)this.tika.detect("x.h261"));
        Assert.assertEquals((Object)"video/h263", (Object)this.tika.detect("x.h263"));
        Assert.assertEquals((Object)"video/h264", (Object)this.tika.detect("x.h264"));
        Assert.assertEquals((Object)"video/jpeg", (Object)this.tika.detect("x.jpgv"));
        Assert.assertEquals((Object)"video/mj2", (Object)this.tika.detect("x.mj2"));
        Assert.assertEquals((Object)"video/mj2", (Object)this.tika.detect("x.mjp2"));
        Assert.assertEquals((Object)"video/mp4", (Object)this.tika.detect("x.mp4"));
        Assert.assertEquals((Object)"video/mp4", (Object)this.tika.detect("x.mp4v"));
        Assert.assertEquals((Object)"video/mp4", (Object)this.tika.detect("x.mpg4"));
        Assert.assertEquals((Object)"video/mpeg", (Object)this.tika.detect("x.mpeg"));
        Assert.assertEquals((Object)"video/mpeg", (Object)this.tika.detect("x.mpg"));
        Assert.assertEquals((Object)"video/mpeg", (Object)this.tika.detect("x.mpe"));
        Assert.assertEquals((Object)"video/mpeg", (Object)this.tika.detect("x.m1v"));
        Assert.assertEquals((Object)"video/mpeg", (Object)this.tika.detect("x.m2v"));
        Assert.assertEquals((Object)"video/ogg", (Object)this.tika.detect("x.ogv"));
        Assert.assertEquals((Object)"video/quicktime", (Object)this.tika.detect("x.qt"));
        Assert.assertEquals((Object)"video/quicktime", (Object)this.tika.detect("x.mov"));
        Assert.assertEquals((Object)"video/vnd.fvt", (Object)this.tika.detect("x.fvt"));
        Assert.assertEquals((Object)"video/vnd.mpegurl", (Object)this.tika.detect("x.mxu"));
        Assert.assertEquals((Object)"video/vnd.mpegurl", (Object)this.tika.detect("x.m4u"));
        Assert.assertEquals((Object)"video/vnd.ms-playready.media.pyv", (Object)this.tika.detect("x.pyv"));
        Assert.assertEquals((Object)"video/vnd.vivo", (Object)this.tika.detect("x.viv"));
        Assert.assertEquals((Object)"video/x-f4v", (Object)this.tika.detect("x.f4v"));
        Assert.assertEquals((Object)"video/x-fli", (Object)this.tika.detect("x.fli"));
        Assert.assertEquals((Object)"video/x-flv", (Object)this.tika.detect("x.flv"));
        Assert.assertEquals((Object)"video/x-m4v", (Object)this.tika.detect("x.m4v"));
        Assert.assertEquals((Object)"video/x-ms-asf", (Object)this.tika.detect("x.asf"));
        Assert.assertEquals((Object)"video/x-ms-asf", (Object)this.tika.detect("x.asx"));
        Assert.assertEquals((Object)"video/x-ms-wm", (Object)this.tika.detect("x.wm"));
        Assert.assertEquals((Object)"video/x-ms-wmv", (Object)this.tika.detect("x.wmv"));
        Assert.assertEquals((Object)"video/x-ms-wmx", (Object)this.tika.detect("x.wmx"));
        Assert.assertEquals((Object)"video/x-ms-wvx", (Object)this.tika.detect("x.wvx"));
        Assert.assertEquals((Object)"video/x-msvideo", (Object)this.tika.detect("x.avi"));
        Assert.assertEquals((Object)"video/x-sgi-movie", (Object)this.tika.detect("x.movie"));
        Assert.assertEquals((Object)"x-conference/x-cooltalk", (Object)this.tika.detect("x.ice"));
        Assert.assertEquals((Object)"application/x-grib", (Object)this.tika.detect("x.grb"));
        Assert.assertEquals((Object)"application/x-grib", (Object)this.tika.detect("x.grb1"));
        Assert.assertEquals((Object)"application/x-grib", (Object)this.tika.detect("x.grb2"));
        Assert.assertEquals((Object)"application/dif+xml", (Object)this.tika.detect("x.dif"));
    }
}

