/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika;

import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.tika.extractor.EmbeddedResourceHandler;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AutoDetectParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ToXMLContentHandler;
import org.junit.Assert;
import org.xml.sax.ContentHandler;

public abstract class TikaTest {
    public File getResourceAsFile(String name) throws URISyntaxException {
        URL url = this.getClass().getResource(name);
        if (url != null) {
            return new File(url.toURI());
        }
        url = this.getClass().getResource(".");
        File file = new File(new File(url.toURI()), name);
        if (file == null) {
            Assert.fail((String)("Unable to find requested file " + name));
        }
        return file;
    }

    public InputStream getResourceAsStream(String name) {
        InputStream stream = this.getClass().getResourceAsStream(name);
        if (stream == null) {
            Assert.fail((String)("Unable to find requested resource " + name));
        }
        return stream;
    }

    public static void assertContains(String needle, String haystack) {
        Assert.assertTrue((String)(needle + " not found in:\n" + haystack), (boolean)haystack.contains(needle));
    }

    public static <T> void assertContains(T needle, Collection<? extends T> haystack) {
        Assert.assertTrue((String)(needle + " not found in:\n" + haystack), (boolean)haystack.contains(needle));
    }

    public static void assertNotContained(String needle, String haystack) {
        Assert.assertFalse((String)(needle + " unexpectedly found in:\n" + haystack), (boolean)haystack.contains(needle));
    }

    public static <T> void assertNotContained(T needle, Collection<? extends T> haystack) {
        Assert.assertFalse((String)(needle + " unexpectedly found in:\n" + haystack), (boolean)haystack.contains(needle));
    }

    protected XMLResult getXML(String filePath, Parser parser, Metadata metadata) throws Exception {
        return this.getXML(this.getResourceAsStream("/test-documents/" + filePath), parser, metadata);
    }

    protected XMLResult getXML(String filePath, Metadata metadata) throws Exception {
        return this.getXML(this.getResourceAsStream("/test-documents/" + filePath), (Parser)new AutoDetectParser(), metadata);
    }

    protected XMLResult getXML(String filePath) throws Exception {
        return this.getXML(this.getResourceAsStream("/test-documents/" + filePath), (Parser)new AutoDetectParser(), new Metadata());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected XMLResult getXML(InputStream input, Parser parser, Metadata metadata) throws Exception {
        ParseContext context = new ParseContext();
        context.set(Parser.class, (Object)parser);
        try {
            ToXMLContentHandler handler = new ToXMLContentHandler();
            parser.parse(input, (ContentHandler)handler, metadata, context);
            XMLResult xMLResult = new XMLResult(handler.toString(), metadata);
            return xMLResult;
        }
        finally {
            input.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getText(InputStream is, Parser parser, ParseContext context, Metadata metadata) throws Exception {
        BodyContentHandler handler = new BodyContentHandler(1000000);
        try {
            parser.parse(is, (ContentHandler)handler, metadata, context);
        }
        finally {
            is.close();
        }
        return handler.toString();
    }

    public String getText(InputStream is, Parser parser, Metadata metadata) throws Exception {
        return this.getText(is, parser, new ParseContext(), metadata);
    }

    public String getText(InputStream is, Parser parser, ParseContext context) throws Exception {
        return this.getText(is, parser, context, new Metadata());
    }

    public String getText(InputStream is, Parser parser) throws Exception {
        return this.getText(is, parser, new ParseContext(), new Metadata());
    }

    public static class ByteCopyingHandler
    implements EmbeddedResourceHandler {
        public List<byte[]> bytes = new ArrayList<byte[]>();

        public void handle(String filename, MediaType mediaType, InputStream stream) {
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            if (!stream.markSupported()) {
                stream = TikaInputStream.get((InputStream)stream);
            }
            stream.mark(0);
            try {
                IOUtils.copy((InputStream)stream, (OutputStream)os);
                this.bytes.add(os.toByteArray());
                stream.reset();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    public static class TrackingHandler
    implements EmbeddedResourceHandler {
        public List<String> filenames = new ArrayList<String>();
        public List<MediaType> mediaTypes = new ArrayList<MediaType>();
        private final Set<MediaType> skipTypes;

        public TrackingHandler() {
            this.skipTypes = new HashSet<MediaType>();
        }

        public TrackingHandler(Set<MediaType> skipTypes) {
            this.skipTypes = skipTypes;
        }

        public void handle(String filename, MediaType mediaType, InputStream stream) {
            if (this.skipTypes.contains(mediaType)) {
                return;
            }
            this.mediaTypes.add(mediaType);
            this.filenames.add(filename);
        }
    }

    protected static class XMLResult {
        public final String xml;
        public final Metadata metadata;

        public XMLResult(String xml, Metadata metadata) {
            this.xml = xml;
            this.metadata = metadata;
        }
    }
}

