/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.config;

import java.net.URI;
import java.net.URL;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ThreadPoolExecutor;
import org.apache.tika.ResourceLoggingClassLoader;
import org.apache.tika.config.AbstractTikaConfigTest;
import org.apache.tika.config.DummyExecutor;
import org.apache.tika.config.DummyParser;
import org.apache.tika.config.LoadErrorHandler;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.config.TikaConfig;
import org.apache.tika.exception.TikaException;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.CompositeParser;
import org.apache.tika.parser.DefaultParser;
import org.apache.tika.parser.EmptyParser;
import org.apache.tika.parser.ErrorParser;
import org.apache.tika.parser.Parser;
import org.apache.tika.parser.ParserDecorator;
import org.junit.Assert;
import org.junit.Test;

public class TikaConfigTest
extends AbstractTikaConfigTest {
    @Test
    public void withInvalidParser() throws Exception {
        try {
            TikaConfigTest.getConfig("TIKA-866-invalid.xml");
            Assert.fail((String)"AutoDetectParser allowed in a <parser> element");
        }
        catch (TikaException tikaException) {
            // empty catch block
        }
    }

    @Test
    public void testUnknownParser() throws Exception {
        ServiceLoader ignoreLoader = new ServiceLoader(this.getClass().getClassLoader(), LoadErrorHandler.IGNORE);
        ServiceLoader warnLoader = new ServiceLoader(this.getClass().getClassLoader(), LoadErrorHandler.WARN);
        ServiceLoader throwLoader = new ServiceLoader(this.getClass().getClassLoader(), LoadErrorHandler.THROW);
        Path configPath = Paths.get(new URI(TikaConfigTest.getConfigPath("TIKA-1700-unknown-parser.xml")));
        TikaConfig ignore = new TikaConfig(configPath, ignoreLoader);
        Assert.assertNotNull((Object)ignore);
        Assert.assertNotNull((Object)ignore.getParser());
        Assert.assertEquals((long)1L, (long)((CompositeParser)ignore.getParser()).getAllComponentParsers().size());
        TikaConfig warn = new TikaConfig(configPath, warnLoader);
        Assert.assertNotNull((Object)warn);
        Assert.assertNotNull((Object)warn.getParser());
        Assert.assertEquals((long)1L, (long)((CompositeParser)warn.getParser()).getAllComponentParsers().size());
        try {
            new TikaConfig(configPath, throwLoader);
            Assert.fail((String)"Shouldn't get here, invalid parser class");
        }
        catch (TikaException tikaException) {
            // empty catch block
        }
    }

    @Test
    public void asCompositeParser() throws Exception {
        try {
            TikaConfigTest.getConfig("TIKA-866-composite.xml");
        }
        catch (TikaException e) {
            Assert.fail((String)("Unexpected TikaException: " + (Object)((Object)e)));
        }
    }

    @Test
    public void onlyValidParser() throws Exception {
        try {
            TikaConfigTest.getConfig("TIKA-866-valid.xml");
        }
        catch (TikaException e) {
            Assert.fail((String)("Unexpected TikaException: " + (Object)((Object)e)));
        }
    }

    @Test
    public void ensureClassLoaderUsedEverywhere() throws Exception {
        ResourceLoggingClassLoader customLoader = new ResourceLoggingClassLoader(this.getClass().getClassLoader());
        TikaConfig config = new TikaConfig();
        config.getMediaTypeRegistry();
        config.getParser();
        Assert.assertEquals((long)0L, (long)customLoader.getLoadedResources().size());
        config = new TikaConfig((ClassLoader)customLoader);
        config.getMediaTypeRegistry();
        config.getParser();
        Map<String, List<URL>> resources = customLoader.getLoadedResources();
        int resourcesCount = resources.size();
        Assert.assertTrue((String)("Not enough things used the classloader, found only " + resourcesCount), (resourcesCount > 3 ? 1 : 0) != 0);
        Assert.assertNotNull(resources.get("META-INF/services/org.apache.tika.parser.Parser"));
        Assert.assertNotNull(resources.get("META-INF/services/org.apache.tika.detect.Detector"));
        Assert.assertNotNull(resources.get("org/apache/tika/mime/tika-mimetypes.xml"));
        Assert.assertNotNull(resources.get("org/apache/tika/mime/custom-mimetypes.xml"));
    }

    @Test
    public void defaultParserWithExcludes() throws Exception {
        try {
            TikaConfig config = TikaConfigTest.getConfig("TIKA-1445-default-except.xml");
            CompositeParser cp = (CompositeParser)config.getParser();
            List parsers = cp.getAllComponentParsers();
            Assert.assertEquals((long)3L, (long)parsers.size());
            Parser p = (Parser)parsers.get(0);
            Assert.assertTrue((String)p.toString(), (boolean)(p instanceof ParserDecorator));
            Assert.assertEquals(DefaultParser.class, ((ParserDecorator)p).getWrappedParser().getClass());
            p = (Parser)parsers.get(1);
            Assert.assertTrue((String)p.toString(), (boolean)(p instanceof ParserDecorator));
            Assert.assertEquals(EmptyParser.class, ((ParserDecorator)p).getWrappedParser().getClass());
            Assert.assertEquals((Object)"hello/world", (Object)((MediaType)p.getSupportedTypes(null).iterator().next()).toString());
            p = (Parser)parsers.get(2);
            Assert.assertTrue((String)p.toString(), (boolean)(p instanceof ParserDecorator));
            Assert.assertEquals(ErrorParser.class, ((ParserDecorator)p).getWrappedParser().getClass());
            Assert.assertEquals((Object)"fail/world", (Object)((MediaType)p.getSupportedTypes(null).iterator().next()).toString());
        }
        catch (TikaException e) {
            Assert.fail((String)("Unexpected TikaException: " + (Object)((Object)e)));
        }
    }

    @Test
    public void parserWithChildParsers() throws Exception {
        try {
            TikaConfig config = TikaConfigTest.getConfig("TIKA-1653-norepeat.xml");
            CompositeParser cp = (CompositeParser)config.getParser();
            List parsers = cp.getAllComponentParsers();
            Assert.assertEquals((long)2L, (long)parsers.size());
            Parser p = (Parser)parsers.get(0);
            Assert.assertTrue((String)p.toString(), (boolean)(p instanceof CompositeParser));
            Assert.assertEquals((long)2L, (long)((CompositeParser)p).getAllComponentParsers().size());
            p = (Parser)parsers.get(1);
            Assert.assertTrue((String)p.toString(), (boolean)(p instanceof ParserDecorator));
            Assert.assertEquals(EmptyParser.class, ((ParserDecorator)p).getWrappedParser().getClass());
            Assert.assertEquals((Object)"hello/world", (Object)((MediaType)p.getSupportedTypes(null).iterator().next()).toString());
        }
        catch (TikaException e) {
            Assert.fail((String)("Unexpected TikaException: " + (Object)((Object)e)));
        }
    }

    @Test
    public void testDynamicServiceLoaderFromConfig() throws Exception {
        URL url = TikaConfigTest.class.getResource("TIKA-1700-dynamic.xml");
        TikaConfig config = new TikaConfig(url);
        DummyParser parser = (DummyParser)config.getParser();
        ServiceLoader loader = parser.getLoader();
        boolean dynamicValue = loader.isDynamic();
        Assert.assertTrue((String)"Dynamic Service Loading Should be true", (boolean)dynamicValue);
    }

    @Test
    public void testTikaExecutorServiceFromConfig() throws Exception {
        URL url = TikaConfigTest.class.getResource("TIKA-1762-executors.xml");
        TikaConfig config = new TikaConfig(url);
        ThreadPoolExecutor executorService = (ThreadPoolExecutor)config.getExecutorService();
        Assert.assertTrue((String)"Should use Dummy Executor", (boolean)(executorService instanceof DummyExecutor));
        Assert.assertEquals((String)"Should have configured Core Threads", (long)3L, (long)executorService.getCorePoolSize());
        Assert.assertEquals((String)"Should have configured Max Threads", (long)10L, (long)executorService.getMaximumPoolSize());
    }
}

