/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.MagicDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.junit.Assert;
import org.junit.Test;

public class MagicDetectorTest {
    @Test
    public void testDetectNull() throws Exception {
        MediaType html = new MediaType("text", "html");
        MagicDetector detector = new MagicDetector(html, "<html".getBytes(StandardCharsets.US_ASCII));
        Assert.assertEquals((Object)MediaType.OCTET_STREAM, (Object)detector.detect(null, new Metadata()));
    }

    @Test
    public void testDetectSimple() throws Exception {
        MediaType html = new MediaType("text", "html");
        MagicDetector detector = new MagicDetector(html, "<html".getBytes(StandardCharsets.US_ASCII));
        this.assertDetect((Detector)detector, html, "<html");
        this.assertDetect((Detector)detector, html, "<html><head/><body/></html>");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "<HTML");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "<?xml?><html");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, " <html");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "");
    }

    @Test
    public void testDetectOffsetRange() throws Exception {
        MediaType html = new MediaType("text", "html");
        MagicDetector detector = new MagicDetector(html, "<html".getBytes(StandardCharsets.US_ASCII), null, 0, 64);
        this.assertDetect((Detector)detector, html, "<html");
        this.assertDetect((Detector)detector, html, "<html><head/><body/></html>");
        this.assertDetect((Detector)detector, html, "<?xml?><html/>");
        this.assertDetect((Detector)detector, html, "\n    <html");
        this.assertDetect((Detector)detector, html, "\u0000<html");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "<htm");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, " html");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "<HTML");
        this.assertDetect((Detector)detector, html, "0........1.........2.........3.........4.........5.........61234<html");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "0........1.........2.........3.........4.........5.........612345<html");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "");
    }

    @Test
    public void testDetectMask() throws Exception {
        MediaType html = new MediaType("text", "html");
        byte up = -33;
        MagicDetector detector = new MagicDetector(html, new byte[]{60, 72, 84, 77, 76}, new byte[]{-1, up, up, up, up}, 0, 64);
        this.assertDetect((Detector)detector, html, "<html");
        this.assertDetect((Detector)detector, html, "<HTML><head/><body/></html>");
        this.assertDetect((Detector)detector, html, "<?xml?><HtMl/>");
        this.assertDetect((Detector)detector, html, "\n    <html");
        this.assertDetect((Detector)detector, html, "\u0000<HTML");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "<htm");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, " html");
        this.assertDetect((Detector)detector, html, "0        1         2         3         4         5         61234<html");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "0        1         2         3         4         5         612345<html");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "");
    }

    @Test
    public void testDetectRegExPDF() throws Exception {
        MediaType pdf = new MediaType("application", "pdf");
        MagicDetector detector = new MagicDetector(pdf, "(?s)\\A.{0,144}%PDF-".getBytes(StandardCharsets.US_ASCII), null, true, 0, 0);
        this.assertDetect((Detector)detector, pdf, "%PDF-1.0");
        this.assertDetect((Detector)detector, pdf, "0        10        20        30        40        50        60        70        80        90        100       110       120       130       14034%PDF-1.0");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "0        10        20        30        40        50        60        70        80        90        100       110       120       130       140345%PDF-1.0");
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, "");
    }

    @Test
    public void testDetectRegExGreedy() throws Exception {
        String pattern = "(?s)\\x3chtml xmlns=\"http://www\\.w3\\.org/1999/xhtml\".*\\x3ctitle\\x3e.*\\x3c/title\\x3e";
        MediaType xhtml = new MediaType("application", "xhtml+xml");
        MagicDetector detector = new MagicDetector(xhtml, pattern.getBytes(StandardCharsets.US_ASCII), null, true, 0, 8192);
        this.assertDetect((Detector)detector, xhtml, "<html xmlns=\"http://www.w3.org/1999/xhtml\"><head><title>XHTML test document</title></head>");
    }

    @Test
    public void testDetectRegExOptions() throws Exception {
        String pattern = "(?s)\\A.{0,1024}\\x3c\\!(?:DOCTYPE|doctype) (?:HTML|html) (?:PUBLIC|public) \"-//.{1,16}//(?:DTD|dtd) .{0,64}(?:HTML|html) 4\\.01";
        String data = "<!DOCTYPE HTML PUBLIC \"-//W3C//DTD HTML 4.01//EN\"\"http://www.w3.org/TR/html4/strict.dtd\"><HTML><HEAD><TITLE>HTML document</TITLE></HEAD><BODY><P>Hello world!</BODY></HTML>";
        String data1 = "<!DOCTYPE html PUBLIC \"-//W3C//dtd html 4.01//EN\"\"http://www.w3.org/TR/html4/strict.dtd\"><HTML><HEAD><TITLE>HTML document</TITLE></HEAD><BODY><P>Hello world!</BODY></HTML>";
        String data2 = "<!DoCtYpE hTmL pUbLiC \"-//W3C//dTd HtMl 4.01//EN\"\"http://www.w3.org/TR/html4/strict.dtd\"><HTML><HEAD><TITLE>HTML document</TITLE></HEAD><BODY><P>Hello world!</BODY></HTML>";
        MediaType html = new MediaType("text", "html");
        MagicDetector detector = new MagicDetector(html, pattern.getBytes(StandardCharsets.US_ASCII), null, true, 0, 0);
        this.assertDetect((Detector)detector, html, data);
        this.assertDetect((Detector)detector, html, data1);
        this.assertDetect((Detector)detector, MediaType.OCTET_STREAM, data2);
    }

    @Test
    public void testDetectStreamReadProblems() throws Exception {
        byte[] data = "abcdefghijklmnopqrstuvwxyz0123456789".getBytes(StandardCharsets.US_ASCII);
        MediaType testMT = new MediaType("application", "test");
        MagicDetector detector = new MagicDetector(testMT, data, null, false, 0, 0);
        RestrictiveInputStream stream = new RestrictiveInputStream(data);
        Assert.assertEquals((Object)testMT, (Object)detector.detect((InputStream)stream, new Metadata()));
    }

    @Test
    public void testDetectString() throws Exception {
        String data = "abcdEFGhijklmnoPQRstuvwxyz0123456789";
        MediaType testMT = new MediaType("application", "test");
        MagicDetector detector = MagicDetector.parse((MediaType)testMT, (String)"string", (String)"0:20", (String)"abcd", null);
        this.assertDetect((Detector)detector, testMT, data.getBytes(StandardCharsets.US_ASCII));
        detector = MagicDetector.parse((MediaType)testMT, (String)"string", (String)"0:20", (String)"cdEFGh", null);
        this.assertDetect((Detector)detector, testMT, data.getBytes(StandardCharsets.US_ASCII));
        detector = MagicDetector.parse((MediaType)testMT, (String)"unicodeLE", (String)"0:20", (String)"cdEFGh", null);
        this.assertDetect((Detector)detector, testMT, data.getBytes(StandardCharsets.UTF_16LE));
        detector = MagicDetector.parse((MediaType)testMT, (String)"unicodeBE", (String)"0:20", (String)"cdEFGh", null);
        this.assertDetect((Detector)detector, testMT, data.getBytes(StandardCharsets.UTF_16BE));
        detector = MagicDetector.parse((MediaType)testMT, (String)"stringignorecase", (String)"0:20", (String)"BcDeFgHiJKlm", null);
        this.assertDetect((Detector)detector, testMT, data.getBytes(StandardCharsets.US_ASCII));
    }

    private void assertDetect(Detector detector, MediaType type, String data) {
        byte[] bytes = data.getBytes(StandardCharsets.US_ASCII);
        this.assertDetect(detector, type, bytes);
    }

    private void assertDetect(Detector detector, MediaType type, byte[] bytes) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(bytes);
            Assert.assertEquals((Object)type, (Object)detector.detect((InputStream)stream, new Metadata()));
            for (int i = 0; i < bytes.length; ++i) {
                Assert.assertEquals((long)bytes[i], (long)((byte)((InputStream)stream).read()));
            }
            Assert.assertEquals((long)-1L, (long)((InputStream)stream).read());
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception from MagicDetector");
        }
    }

    private class RestrictiveInputStream
    extends ByteArrayInputStream {
        public RestrictiveInputStream(byte[] buf) {
            super(buf);
        }

        @Override
        public int read(byte[] b, int off, int len) {
            if (len > 10) {
                return super.read(b, off, len - 10);
            }
            return super.read(b, off, len);
        }
    }
}

