/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.util.HashMap;
import java.util.regex.Pattern;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.NameDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class NameDetectorTest {
    private Detector detector;

    @Before
    public void setUp() {
        HashMap<Pattern, MediaType> patterns = new HashMap<Pattern, MediaType>();
        patterns.put(Pattern.compile(".*\\.txt", 2), MediaType.TEXT_PLAIN);
        patterns.put(Pattern.compile("README"), MediaType.TEXT_PLAIN);
        this.detector = new NameDetector(patterns);
    }

    @Test
    public void testDetect() {
        this.assertDetect(MediaType.TEXT_PLAIN, "text.txt");
        this.assertDetect(MediaType.TEXT_PLAIN, "text.txt ");
        this.assertDetect(MediaType.TEXT_PLAIN, "text.txt\n");
        this.assertDetect(MediaType.TEXT_PLAIN, "text.txt?a=b");
        this.assertDetect(MediaType.TEXT_PLAIN, "text.txt#abc");
        this.assertDetect(MediaType.TEXT_PLAIN, "text%2Etxt");
        this.assertDetect(MediaType.TEXT_PLAIN, "text.TXT");
        this.assertDetect(MediaType.OCTET_STREAM, "text.txt.gz");
        this.assertDetect(MediaType.TEXT_PLAIN, "README");
        this.assertDetect(MediaType.TEXT_PLAIN, " README ");
        this.assertDetect(MediaType.TEXT_PLAIN, "\tREADME\n");
        this.assertDetect(MediaType.TEXT_PLAIN, "/a/README");
        this.assertDetect(MediaType.TEXT_PLAIN, "\\b\\README");
        this.assertDetect(MediaType.OCTET_STREAM, "ReadMe");
        this.assertDetect(MediaType.OCTET_STREAM, "README.NOW");
        this.assertDetect(MediaType.TEXT_PLAIN, " See http://www.example.com:1234/README.txt?a=b#c \n");
        this.assertDetect(MediaType.TEXT_PLAIN, "See README.txt");
        this.assertDetect(MediaType.OCTET_STREAM, "See README");
        this.assertDetect(MediaType.OCTET_STREAM, "");
        this.assertDetect(MediaType.OCTET_STREAM, null);
        try {
            Assert.assertEquals((Object)MediaType.OCTET_STREAM, (Object)this.detector.detect(null, new Metadata()));
        }
        catch (IOException e) {
            Assert.fail((String)"NameDetector should never throw an IOException");
        }
    }

    private void assertDetect(MediaType type, String name) {
        Metadata metadata = new Metadata();
        metadata.set("resourceName", name);
        try {
            Assert.assertEquals((Object)type, (Object)this.detector.detect(null, metadata));
        }
        catch (IOException e) {
            Assert.fail((String)"NameDetector should never throw an IOException");
        }
    }
}

