/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.TextDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.junit.Assert;
import org.junit.Test;

public class TextDetectorTest {
    private final Detector detector = new TextDetector();

    @Test
    public void testDetectNull() throws Exception {
        Assert.assertEquals((Object)MediaType.OCTET_STREAM, (Object)this.detector.detect(null, new Metadata()));
    }

    @Test
    public void testDetectEmpty() throws Exception {
        this.assertNotText(new byte[0]);
    }

    @Test
    public void testDetectText() throws Exception {
        this.assertText("Hello, World!".getBytes(StandardCharsets.UTF_8));
        this.assertText(" \t\r\n".getBytes(StandardCharsets.UTF_8));
        this.assertNotText(new byte[]{-1, -2, -3, 9, 10, 12, 13, 27});
        this.assertNotText(new byte[]{0});
        this.assertNotText(new byte[]{72, 101, 108, 108, 111, 0});
        byte[] data = new byte[512];
        Arrays.fill(data, (byte)46);
        this.assertText(data);
        Arrays.fill(data, 100, 110, (byte)31);
        this.assertText(data);
        Arrays.fill(data, 100, 111, (byte)31);
        this.assertNotText(data);
        Arrays.fill(data, (byte)31);
        this.assertNotText(data);
        data = new byte[513];
        Arrays.fill(data, (byte)46);
        data[0] = 31;
        this.assertText(data);
        Arrays.fill(data, 100, 150, (byte)-125);
        this.assertText(data);
        Arrays.fill(data, 100, 200, (byte)-125);
        this.assertNotText(data);
        Arrays.fill(data, (byte)31);
        this.assertNotText(data);
    }

    private void assertText(byte[] data) {
        try {
            ByteArrayInputStream stream = new ByteArrayInputStream(data);
            Assert.assertEquals((Object)MediaType.TEXT_PLAIN, (Object)this.detector.detect((InputStream)stream, new Metadata()));
            for (int i = 0; i < data.length; ++i) {
                Assert.assertEquals((long)data[i], (long)((byte)((InputStream)stream).read()));
            }
            Assert.assertEquals((long)-1L, (long)((InputStream)stream).read());
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception from TextDetector");
        }
    }

    private void assertNotText(byte[] data) {
        try {
            Assert.assertEquals((Object)MediaType.OCTET_STREAM, (Object)this.detector.detect((InputStream)new ByteArrayInputStream(data), new Metadata()));
        }
        catch (IOException e) {
            Assert.fail((String)"Unexpected exception from TextDetector");
        }
    }
}

