/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.detect;

import java.io.IOException;
import java.util.Map;
import java.util.TreeMap;
import org.apache.tika.detect.Detector;
import org.apache.tika.detect.TypeDetector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.junit.Assert;
import org.junit.Test;

public class TypeDetectorTest {
    private Detector detector = new TypeDetector();
    private static final Map<String, String> params = new TreeMap<String, String>();
    private static final MediaType TEXT_PLAIN_A_EQ_B;

    @Test
    public void testDetect() {
        this.assertDetect(MediaType.TEXT_PLAIN, "text/plain");
        this.assertDetect(MediaType.TEXT_PLAIN, "TEXT/PLAIN");
        this.assertDetect(MediaType.TEXT_PLAIN, " text/\tplain\n");
        this.assertDetect(TEXT_PLAIN_A_EQ_B, "text/plain; a=b");
        this.assertDetect(TEXT_PLAIN_A_EQ_B, "\ttext/plain; a=b\n");
        this.assertDetect(MediaType.OCTET_STREAM, "text\\plain");
        this.assertDetect(MediaType.OCTET_STREAM, "");
        this.assertDetect(MediaType.OCTET_STREAM, null);
        try {
            Assert.assertEquals((Object)MediaType.OCTET_STREAM, (Object)this.detector.detect(null, new Metadata()));
        }
        catch (IOException e) {
            Assert.fail((String)"TypeDetector should never throw an IOException");
        }
    }

    private void assertDetect(MediaType type, String name) {
        Metadata metadata = new Metadata();
        metadata.set("Content-Type", name);
        try {
            Assert.assertEquals((Object)type, (Object)this.detector.detect(null, metadata));
        }
        catch (IOException e) {
            Assert.fail((String)"TypeDetector should never throw an IOException");
        }
    }

    static {
        params.put("a", "b");
        TEXT_PLAIN_A_EQ_B = new MediaType("text", "plain", params);
    }
}

