/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.fork;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Semaphore;
import org.apache.tika.fork.ForkParser;
import org.apache.tika.fork.ForkTestParser;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.BodyContentHandler;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.helpers.DefaultHandler;

public class ForkParserTest {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testHelloWorld() throws Exception {
        try (ForkParser parser = new ForkParser(ForkParserTest.class.getClassLoader(), (Parser)new ForkTestParser());){
            Metadata metadata = new Metadata();
            BodyContentHandler output = new BodyContentHandler();
            ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
            ParseContext context = new ParseContext();
            parser.parse((InputStream)stream, (ContentHandler)output, metadata, context);
            Assert.assertEquals((Object)"Hello, World!", (Object)output.toString().trim());
            Assert.assertEquals((Object)"text/plain", (Object)metadata.get("Content-Type"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testSerialParsing() throws Exception {
        try (ForkParser parser = new ForkParser(ForkParserTest.class.getClassLoader(), (Parser)new ForkTestParser());){
            ParseContext context = new ParseContext();
            for (int i = 0; i < 10; ++i) {
                BodyContentHandler output = new BodyContentHandler();
                ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
                parser.parse((InputStream)stream, (ContentHandler)output, new Metadata(), context);
                Assert.assertEquals((Object)"Hello, World!", (Object)output.toString().trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testParallelParsing() throws Exception {
        try (final ForkParser parser = new ForkParser(ForkParserTest.class.getClassLoader(), (Parser)new ForkTestParser());){
            int i;
            ParseContext context = new ParseContext();
            Thread[] threads = new Thread[10];
            ContentHandler[] output = new ContentHandler[threads.length];
            for (i = 0; i < threads.length; ++i) {
                BodyContentHandler o = new BodyContentHandler();
                output[i] = o;
                threads[i] = new Thread((ContentHandler)o, context){
                    final /* synthetic */ ContentHandler val$o;
                    final /* synthetic */ ParseContext val$context;
                    {
                        this.val$o = contentHandler;
                        this.val$context = parseContext;
                    }

                    @Override
                    public void run() {
                        try {
                            ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
                            parser.parse((InputStream)stream, this.val$o, new Metadata(), this.val$context);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                threads[i].start();
            }
            for (i = 0; i < threads.length; ++i) {
                threads[i].join();
                Assert.assertEquals((Object)"Hello, World!", (Object)output[i].toString().trim());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testPoolSizeReached() throws Exception {
        try (final ForkParser parser = new ForkParser(ForkParserTest.class.getClassLoader(), (Parser)new ForkTestParser());){
            final Semaphore barrier = new Semaphore(0);
            Thread[] threads = new Thread[parser.getPoolSize()];
            PipedOutputStream[] pipes = new PipedOutputStream[threads.length];
            final ParseContext context = new ParseContext();
            for (int i = 0; i < threads.length; ++i) {
                final PipedInputStream input = new PipedInputStream(){

                    @Override
                    public synchronized int read() throws IOException {
                        barrier.release();
                        return super.read();
                    }
                };
                pipes[i] = new PipedOutputStream(input);
                threads[i] = new Thread(){

                    @Override
                    public void run() {
                        try {
                            DefaultHandler o = new DefaultHandler();
                            parser.parse((InputStream)input, (ContentHandler)o, new Metadata(), context);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                        }
                    }
                };
                threads[i].start();
            }
            barrier.acquire(parser.getPoolSize());
            BodyContentHandler o = new BodyContentHandler();
            Thread blocked = new Thread((ContentHandler)o, context){
                final /* synthetic */ ContentHandler val$o;
                final /* synthetic */ ParseContext val$context;
                {
                    this.val$o = contentHandler;
                    this.val$context = parseContext;
                }

                @Override
                public void run() {
                    try {
                        barrier.release();
                        ByteArrayInputStream stream = new ByteArrayInputStream(new byte[0]);
                        parser.parse((InputStream)stream, this.val$o, new Metadata(), this.val$context);
                    }
                    catch (Exception e) {
                        e.printStackTrace();
                    }
                }
            };
            blocked.start();
            barrier.acquire();
            Thread.sleep(1000L);
            Assert.assertEquals((Object)"", (Object)o.toString());
            for (int i = 0; i < threads.length; ++i) {
                pipes[i].close();
                threads[i].join();
            }
            blocked.join();
            Assert.assertEquals((Object)"Hello, World!", (Object)o.toString().trim());
        }
    }
}

