/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.io;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import org.apache.tika.io.IOUtils;
import org.apache.tika.io.TikaInputStream;
import org.apache.tika.metadata.Metadata;
import org.junit.Assert;
import org.junit.Test;

public class TikaInputStreamTest {
    @Test
    public void testFileBased() throws IOException {
        Path path = this.createTempFile("Hello, World!");
        TikaInputStream stream = TikaInputStream.get((Path)path);
        Assert.assertEquals((String)"The file returned by the getFile() method should be the file used to instantiate a TikaInputStream", (Object)path, (Object)TikaInputStream.get((InputStream)stream).getPath());
        Assert.assertEquals((String)"The contents of the TikaInputStream should equal the contents of the underlying file", (Object)"Hello, World!", (Object)this.readStream((InputStream)stream));
        stream.close();
        Assert.assertTrue((String)"The close() method must not remove the file used to instantiate a TikaInputStream", (boolean)Files.exists(path, new LinkOption[0]));
        Files.delete(path);
    }

    @Test
    public void testStreamBased() throws IOException {
        InputStream input = IOUtils.toInputStream((String)"Hello, World!", (String)StandardCharsets.UTF_8.name());
        TikaInputStream stream = TikaInputStream.get((InputStream)input);
        Path file = TikaInputStream.get((InputStream)stream).getPath();
        Assert.assertTrue((file != null && Files.isRegularFile(file, new LinkOption[0]) ? 1 : 0) != 0);
        Assert.assertEquals((String)"The contents of the file returned by the getFile method should equal the contents of the TikaInputStream", (Object)"Hello, World!", (Object)this.readFile(file));
        Assert.assertEquals((String)"The contents of the TikaInputStream should not get modified by reading the file first", (Object)"Hello, World!", (Object)this.readStream((InputStream)stream));
        stream.close();
        Assert.assertFalse((String)"The close() method must remove the temporary file created by a TikaInputStream", (boolean)Files.exists(file, new LinkOption[0]));
    }

    private Path createTempFile(String data) throws IOException {
        Path file = Files.createTempFile("tika-", ".tmp", new FileAttribute[0]);
        Files.write(file, data.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        return file;
    }

    private String readFile(Path file) throws IOException {
        return new String(Files.readAllBytes(file), StandardCharsets.UTF_8);
    }

    private String readStream(InputStream stream) throws IOException {
        return IOUtils.toString((InputStream)stream, (String)StandardCharsets.UTF_8.name());
    }

    @Test
    public void testGetMetadata() throws Exception {
        URL url = TikaInputStreamTest.class.getResource("test.txt");
        Metadata metadata = new Metadata();
        TikaInputStream.get((URL)url, (Metadata)metadata).close();
        Assert.assertEquals((Object)"test.txt", (Object)metadata.get("resourceName"));
        Assert.assertEquals((Object)Long.toString(Files.size(Paths.get(url.toURI()))), (Object)metadata.get("Content-Length"));
    }
}

