/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.language;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.net.URISyntaxException;
import java.nio.charset.StandardCharsets;
import org.apache.tika.exception.TikaException;
import org.apache.tika.language.LanguageIdentifier;
import org.apache.tika.language.LanguageProfile;
import org.apache.tika.language.LanguageProfilerBuilder;
import org.junit.After;
import org.junit.Assert;
import org.junit.Test;

public class LanguageProfilerBuilderTest {
    private LanguageProfilerBuilder ngramProfile = null;
    private LanguageProfile langProfile = null;
    private final String profileName = "../tika-core/src/test/resources/org/apache/tika/language/langbuilder/" + LanguageProfilerBuilderTest.class.getName();
    private final String corpusName = "langbuilder/welsh_corpus.txt";
    private final String FILE_EXTENSION = "ngp";
    private final String LANGUAGE = "welsh";
    private final int maxlen = 1000;

    @Test
    public void testCreateProfile() throws TikaException, IOException, URISyntaxException {
        try (InputStream is = LanguageProfilerBuilderTest.class.getResourceAsStream("langbuilder/welsh_corpus.txt");){
            this.ngramProfile = LanguageProfilerBuilder.create((String)this.profileName, (InputStream)is, (String)StandardCharsets.UTF_8.name());
        }
        File f = new File(this.profileName + "." + "ngp");
        FileOutputStream fos = new FileOutputStream(f);
        this.ngramProfile.save((OutputStream)fos);
        fos.close();
        Assert.assertEquals((long)1000L, (long)this.ngramProfile.getSorted().size());
    }

    @Test
    public void testNGramProfile() throws IOException, TikaException, URISyntaxException {
        this.createLanguageProfile();
        LanguageIdentifier.addProfile((String)"welsh", (LanguageProfile)this.langProfile);
        LanguageIdentifier identifier = new LanguageIdentifier(this.langProfile);
        Assert.assertEquals((Object)"welsh", (Object)identifier.getLanguage());
        Assert.assertTrue((boolean)identifier.isReasonablyCertain());
    }

    private void createLanguageProfile() throws IOException, TikaException, URISyntaxException {
        if (this.ngramProfile == null) {
            this.testCreateProfile();
        }
        this.langProfile = new LanguageProfile();
        try (FileInputStream stream = new FileInputStream(new File(this.profileName + "." + "ngp"));){
            BufferedReader reader = new BufferedReader(new InputStreamReader((InputStream)stream, StandardCharsets.UTF_8));
            String line = reader.readLine();
            while (line != null) {
                if (line.length() > 0 && !line.startsWith("#")) {
                    int space = line.indexOf(32);
                    this.langProfile.add(line.substring(0, space), Long.parseLong(line.substring(space + 1)));
                }
                line = reader.readLine();
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        File profile = new File(this.profileName + "." + "ngp");
        if (profile.exists()) {
            profile.delete();
        }
    }
}

