/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata;

import java.util.Date;
import java.util.Properties;
import org.apache.tika.metadata.DublinCore;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.Property;
import org.apache.tika.metadata.PropertyTypeException;
import org.apache.tika.metadata.TikaCoreProperties;
import org.apache.tika.utils.DateUtils;
import org.junit.Assert;
import org.junit.Test;

public class TestMetadata {
    private static final String CONTENTTYPE = "contenttype";

    @Test
    public void testAdd() {
        String[] values = null;
        Metadata meta = new Metadata();
        values = meta.getValues(CONTENTTYPE);
        Assert.assertEquals((long)0L, (long)values.length);
        meta.add(CONTENTTYPE, "value1");
        values = meta.getValues(CONTENTTYPE);
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"value1", (Object)values[0]);
        meta.add(CONTENTTYPE, "value2");
        values = meta.getValues(CONTENTTYPE);
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertEquals((Object)"value1", (Object)values[0]);
        Assert.assertEquals((Object)"value2", (Object)values[1]);
        meta.add(CONTENTTYPE, "value1");
        values = meta.getValues(CONTENTTYPE);
        Assert.assertEquals((long)3L, (long)values.length);
        Assert.assertEquals((Object)"value1", (Object)values[0]);
        Assert.assertEquals((Object)"value2", (Object)values[1]);
        Assert.assertEquals((Object)"value1", (Object)values[2]);
        Property nonMultiValued = Property.internalText((String)"nonMultiValued");
        meta.add(nonMultiValued, "value1");
        try {
            meta.add(nonMultiValued, "value2");
            Assert.fail((String)"add should fail on the second call of a non-multi valued item");
        }
        catch (PropertyTypeException propertyTypeException) {
            // empty catch block
        }
    }

    @Test
    public void testSet() {
        String[] values = null;
        Metadata meta = new Metadata();
        values = meta.getValues(CONTENTTYPE);
        Assert.assertEquals((long)0L, (long)values.length);
        meta.set(CONTENTTYPE, "value1");
        values = meta.getValues(CONTENTTYPE);
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"value1", (Object)values[0]);
        meta.set(CONTENTTYPE, "value2");
        values = meta.getValues(CONTENTTYPE);
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"value2", (Object)values[0]);
        meta.set(CONTENTTYPE, "new value 1");
        meta.add(CONTENTTYPE, "new value 2");
        values = meta.getValues(CONTENTTYPE);
        Assert.assertEquals((long)2L, (long)values.length);
        Assert.assertEquals((Object)"new value 1", (Object)values[0]);
        Assert.assertEquals((Object)"new value 2", (Object)values[1]);
    }

    @Test
    public void testSetProperties() {
        String[] values = null;
        Metadata meta = new Metadata();
        Properties props = new Properties();
        meta.setAll(props);
        Assert.assertEquals((long)0L, (long)meta.size());
        props.setProperty("name-one", "value1.1");
        meta.setAll(props);
        Assert.assertEquals((long)1L, (long)meta.size());
        values = meta.getValues("name-one");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"value1.1", (Object)values[0]);
        props.setProperty("name-two", "value2.1");
        meta.setAll(props);
        Assert.assertEquals((long)2L, (long)meta.size());
        values = meta.getValues("name-one");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"value1.1", (Object)values[0]);
        values = meta.getValues("name-two");
        Assert.assertEquals((long)1L, (long)values.length);
        Assert.assertEquals((Object)"value2.1", (Object)values[0]);
    }

    @Test
    public void testGet() {
        Metadata meta = new Metadata();
        Assert.assertNull((Object)meta.get("a-name"));
        meta.add("a-name", "value-1");
        Assert.assertEquals((Object)"value-1", (Object)meta.get("a-name"));
        meta.add("a-name", "value-2");
        Assert.assertEquals((Object)"value-1", (Object)meta.get("a-name"));
    }

    @Test
    public void testIsMultiValued() {
        Metadata meta = new Metadata();
        Assert.assertFalse((boolean)meta.isMultiValued("key"));
        meta.add("key", "value1");
        Assert.assertFalse((boolean)meta.isMultiValued("key"));
        meta.add("key", "value2");
        Assert.assertTrue((boolean)meta.isMultiValued("key"));
    }

    @Test
    public void testNames() {
        String[] names = null;
        Metadata meta = new Metadata();
        names = meta.names();
        Assert.assertEquals((long)0L, (long)names.length);
        meta.add("name-one", "value");
        names = meta.names();
        Assert.assertEquals((long)1L, (long)names.length);
        Assert.assertEquals((Object)"name-one", (Object)names[0]);
        meta.add("name-two", "value");
        names = meta.names();
        Assert.assertEquals((long)2L, (long)names.length);
    }

    @Test
    public void testRemove() {
        Metadata meta = new Metadata();
        meta.remove("name-one");
        Assert.assertEquals((long)0L, (long)meta.size());
        meta.add("name-one", "value-1.1");
        meta.add("name-one", "value-1.2");
        meta.add("name-two", "value-2.2");
        Assert.assertEquals((long)2L, (long)meta.size());
        Assert.assertNotNull((Object)meta.get("name-one"));
        Assert.assertNotNull((Object)meta.get("name-two"));
        meta.remove("name-one");
        Assert.assertEquals((long)1L, (long)meta.size());
        Assert.assertNull((Object)meta.get("name-one"));
        Assert.assertNotNull((Object)meta.get("name-two"));
        meta.remove("name-two");
        Assert.assertEquals((long)0L, (long)meta.size());
        Assert.assertNull((Object)meta.get("name-one"));
        Assert.assertNull((Object)meta.get("name-two"));
    }

    @Test
    public void testObject() {
        Metadata meta1 = new Metadata();
        Metadata meta2 = new Metadata();
        Assert.assertFalse((boolean)meta1.equals(null));
        Assert.assertFalse((boolean)meta1.equals((Object)"String"));
        Assert.assertTrue((boolean)meta1.equals((Object)meta2));
        meta1.add("name-one", "value-1.1");
        Assert.assertFalse((boolean)meta1.equals((Object)meta2));
        meta2.add("name-one", "value-1.1");
        Assert.assertTrue((boolean)meta1.equals((Object)meta2));
        meta1.add("name-one", "value-1.2");
        Assert.assertFalse((boolean)meta1.equals((Object)meta2));
        meta2.add("name-one", "value-1.2");
        Assert.assertTrue((boolean)meta1.equals((Object)meta2));
        meta1.add("name-two", "value-2.1");
        Assert.assertFalse((boolean)meta1.equals((Object)meta2));
        meta2.add("name-two", "value-2.1");
        Assert.assertTrue((boolean)meta1.equals((Object)meta2));
        meta1.add("name-two", "value-2.2");
        Assert.assertFalse((boolean)meta1.equals((Object)meta2));
        meta2.add("name-two", "value-2.x");
        Assert.assertFalse((boolean)meta1.equals((Object)meta2));
    }

    @Test
    public void testGetSetInt() {
        Metadata meta = new Metadata();
        Assert.assertEquals(null, (Object)meta.get(Metadata.IMAGE_WIDTH));
        Assert.assertEquals(null, (Object)meta.getInt(Metadata.IMAGE_WIDTH));
        try {
            meta.set(Metadata.BITS_PER_SAMPLE, 1);
            Assert.fail((String)"Shouldn't be able to set a multi valued property as an int");
        }
        catch (PropertyTypeException propertyTypeException) {
            // empty catch block
        }
        try {
            meta.set(TikaCoreProperties.CREATED, 1);
            Assert.fail((String)"Shouldn't be able to set a date property as an int");
        }
        catch (PropertyTypeException propertyTypeException) {
            // empty catch block
        }
        meta.set(Metadata.IMAGE_WIDTH, 22);
        Assert.assertEquals((Object)"22", (Object)meta.get(Metadata.IMAGE_WIDTH));
        Assert.assertEquals((long)22L, (long)meta.getInt(Metadata.IMAGE_WIDTH).intValue());
        meta.set(Metadata.IMAGE_WIDTH, "INVALID");
        Assert.assertEquals((Object)"INVALID", (Object)meta.get(Metadata.IMAGE_WIDTH));
        Assert.assertEquals(null, (Object)meta.getInt(Metadata.IMAGE_WIDTH));
        meta.set(Metadata.IMAGE_WIDTH, 22);
        Assert.assertEquals((long)22L, (long)meta.getInt(Metadata.IMAGE_WIDTH).intValue());
        Assert.assertEquals(null, (Object)meta.getInt(Metadata.BITS_PER_SAMPLE));
        Assert.assertEquals(null, (Object)meta.getInt(TikaCoreProperties.CREATED));
    }

    @Test
    public void testGetSetDate() {
        Metadata meta = new Metadata();
        long hour = 3600000L;
        Assert.assertEquals(null, (Object)meta.get(TikaCoreProperties.CREATED));
        Assert.assertEquals(null, (Object)meta.getInt(TikaCoreProperties.CREATED));
        try {
            meta.set(Metadata.BITS_PER_SAMPLE, new Date(1000L));
            Assert.fail((String)"Shouldn't be able to set a multi valued property as a date");
        }
        catch (PropertyTypeException propertyTypeException) {
            // empty catch block
        }
        try {
            meta.set(Metadata.IMAGE_WIDTH, new Date(1000L));
            Assert.fail((String)"Shouldn't be able to set an int property as an date");
        }
        catch (PropertyTypeException propertyTypeException) {
            // empty catch block
        }
        meta.set(TikaCoreProperties.CREATED, new Date(1000L));
        Assert.assertEquals((Object)"1970-01-01T00:00:01Z", (Object)meta.get(TikaCoreProperties.CREATED));
        Assert.assertEquals((long)1000L, (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        meta.set(TikaCoreProperties.CREATED, "INVALID");
        Assert.assertEquals((Object)"INVALID", (Object)meta.get(TikaCoreProperties.CREATED));
        Assert.assertEquals(null, (Object)meta.getDate(TikaCoreProperties.CREATED));
        meta.set(TikaCoreProperties.CREATED, new Date(1000L));
        Assert.assertEquals((long)1000L, (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        Assert.assertEquals(null, (Object)meta.getInt(Metadata.BITS_PER_SAMPLE));
        Assert.assertEquals(null, (Object)meta.getInt(TikaCoreProperties.CREATED));
        meta.set(TikaCoreProperties.CREATED, new Date(1050L));
        Assert.assertEquals((Object)"1970-01-01T00:00:01Z", (Object)meta.get(TikaCoreProperties.CREATED));
        Assert.assertEquals((long)1000L, (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        meta.set(TikaCoreProperties.CREATED, "1970-01-01T00:00:01Z");
        Assert.assertEquals((long)1000L, (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        meta.set(TikaCoreProperties.CREATED, "1970-01-01 00:00:01Z");
        Assert.assertEquals((long)1000L, (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        meta.set(TikaCoreProperties.CREATED, "1970-01-01T01:00:01+01:00");
        Assert.assertEquals((long)1000L, (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        meta.set(TikaCoreProperties.CREATED, "1970-01-01 01:00:01+01:00");
        Assert.assertEquals((long)1000L, (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        meta.set(TikaCoreProperties.CREATED, "1970-01-01T12:00:01+12:00");
        Assert.assertEquals((long)1000L, (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        meta.set(TikaCoreProperties.CREATED, "1969-12-31T12:00:01-12:00");
        Assert.assertEquals((long)1000L, (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        meta.set(TikaCoreProperties.CREATED, "1970-01-01");
        Assert.assertEquals((long)(12L * hour), (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
        meta.set(TikaCoreProperties.CREATED, "1970:01:01");
        Assert.assertEquals((long)(12L * hour), (long)meta.getDate(TikaCoreProperties.CREATED).getTime());
    }

    @Test
    public void testGetSetDateUnspecifiedTimezone() {
        Metadata meta = new Metadata();
        meta.set(TikaCoreProperties.CREATED, "1970-01-01T00:00:01");
        Assert.assertEquals((String)"should return string without time zone specifier because zone is not known", (Object)"1970-01-01T00:00:01", (Object)meta.get(TikaCoreProperties.CREATED));
        meta.set(TikaCoreProperties.CREATED, DateUtils.formatDateUnknownTimezone((Date)new Date(1000L)));
        Assert.assertEquals((String)"should return string without time zone specifier because zone is not known", (Object)"1970-01-01T00:00:01", (Object)meta.get(TikaCoreProperties.CREATED));
    }

    @Test
    public void testCompositeProperty() {
        Metadata meta = new Metadata();
        Property compositeProperty = Property.composite((Property)DublinCore.DESCRIPTION, (Property[])new Property[]{Property.internalText((String)"description"), Property.internalText((String)"testDescriptionAlt")});
        String message = "composite description";
        meta.set(compositeProperty, message);
        Assert.assertEquals((Object)message, (Object)meta.get(compositeProperty));
        Assert.assertEquals((Object)message, (Object)meta.get(DublinCore.DESCRIPTION));
        Assert.assertEquals((Object)message, (Object)meta.get("description"));
        Assert.assertEquals((Object)message, (Object)meta.get("testDescriptionAlt"));
    }
}

