/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.MimeTypesReader;
import org.junit.Assert;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;

public class CustomReaderTest {
    @Test
    public void testCustomReader() throws Exception {
        MimeTypes mimeTypes = new MimeTypes();
        CustomMimeTypesReader reader = new CustomMimeTypesReader(mimeTypes);
        reader.read(this.getClass().getResourceAsStream("custom-mimetypes.xml"));
        String key = "hello/world-file";
        MimeType hello = mimeTypes.forName(key);
        Assert.assertEquals((Object)"A \"Hello World\" file", (Object)hello.getDescription());
        Assert.assertEquals((Object)"world", (Object)reader.values.get(key));
        Assert.assertEquals((long)0L, (long)reader.ignorePatterns.size());
        reader.read(this.getClass().getResourceAsStream("custom-mimetypes2.xml"));
        key = "another/world-file";
        MimeType another = mimeTypes.forName(key);
        Assert.assertEquals((Object)"kittens", (Object)reader.values.get(key));
        Assert.assertEquals((long)1L, (long)reader.ignorePatterns.size());
        Assert.assertEquals((Object)(another.toString() + ">>*" + hello.getExtension()), (Object)reader.ignorePatterns.get(0));
    }

    static class CustomMimeTypesReader
    extends MimeTypesReader {
        public Map<String, String> values = new HashMap<String, String>();
        public List<String> ignorePatterns = new ArrayList<String>();

        CustomMimeTypesReader(MimeTypes types) {
            super(types);
        }

        public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
            super.startElement(uri, localName, qName, attributes);
            if ("hello".equals(qName)) {
                this.characters = new StringBuilder();
            }
        }

        public void endElement(String uri, String localName, String qName) {
            super.endElement(uri, localName, qName);
            if (this.type != null && "hello".equals(qName)) {
                this.values.put(this.type.toString(), this.characters.toString().trim());
                this.characters = null;
            }
        }

        protected void handleGlobError(MimeType type, String pattern, MimeTypeException ex, String qName, Attributes attributes) throws SAXException {
            this.ignorePatterns.add(type.toString() + ">>" + pattern);
        }
    }
}

