/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.util.List;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeType;
import org.apache.tika.mime.MimeTypeException;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.Patterns;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PatternsTest {
    private MimeTypes fullTypes = MimeTypes.getDefaultMimeTypes();
    private Patterns patterns;
    private MimeTypes types;
    private MimeType text;

    @Before
    public void setUp() throws MimeTypeException {
        this.patterns = new Patterns(new MediaTypeRegistry());
        this.types = new MimeTypes();
        this.text = this.types.forName("text/plain");
    }

    @Test
    public void testAdd() throws MimeTypeException {
        try {
            this.patterns.add(null, this.text);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.patterns.add("", null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        try {
            this.patterns.add(null, null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testMatches() {
        try {
            this.patterns.matches(null);
            Assert.fail((String)"Expected IllegalArgumentException");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testExtension() throws MimeTypeException {
        MimeType doc = this.types.forName("application/vnd.ms-word");
        this.patterns.add("*.doc", doc);
        Assert.assertEquals((Object)".doc", (Object)doc.getExtension());
    }

    @Test
    public void testExtensions() throws Exception {
        MimeType jpeg = this.fullTypes.forName("image/jpeg");
        Assert.assertEquals((Object)".jpg", (Object)jpeg.getExtension());
        List extensions = jpeg.getExtensions();
        Assert.assertTrue((extensions.size() > 1 ? 1 : 0) != 0);
        Assert.assertTrue((boolean)extensions.contains(".jpg"));
        Assert.assertTrue((boolean)extensions.contains(".jpeg"));
    }
}

