/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.mime;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import org.apache.tika.Tika;
import org.apache.tika.config.ServiceLoader;
import org.apache.tika.detect.DefaultProbDetector;
import org.apache.tika.detect.Detector;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.mime.MediaTypeRegistry;
import org.apache.tika.mime.MimeTypes;
import org.apache.tika.mime.ProbabilisticMimeDetectionSelector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ProbabilisticMimeDetectionTestWithTika {
    private ProbabilisticMimeDetectionSelector proSelector;
    private MediaTypeRegistry registry;
    private Tika tika;

    @Before
    public void setUp() {
        MimeTypes types = MimeTypes.getDefaultMimeTypes();
        ServiceLoader loader = new ServiceLoader();
        this.registry = types.getMediaTypeRegistry();
        ProbabilisticMimeDetectionSelector.Builder builder = new ProbabilisticMimeDetectionSelector.Builder();
        this.proSelector = new ProbabilisticMimeDetectionSelector(types, builder.priorMagicFileType(0.5f).priorExtensionFileType(0.5f).priorMetaFileType(0.5f));
        DefaultProbDetector detector = new DefaultProbDetector(this.proSelector, loader);
        this.tika = new Tika((Detector)detector);
    }

    @Test
    public void testDetection() throws Exception {
        this.testFile("image/svg+xml", "circles.svg");
        this.testFile("image/svg+xml", "circles-with-prefix.svg");
        this.testFile("image/png", "datamatrix.png");
        this.testFile("text/html", "test.html");
        this.testFile("application/xml", "test-iso-8859-1.xml");
        this.testFile("application/xml", "test-utf8.xml");
        this.testFile("application/xml", "test-utf8-bom.xml");
        this.testFile("application/xml", "test-utf16le.xml");
        this.testFile("application/xml", "test-utf16be.xml");
        this.testFile("application/xml", "test-long-comment.xml");
        this.testFile("application/xslt+xml", "stylesheet.xsl");
        this.testUrl("application/rdf+xml", "http://www.ai.sri.com/daml/services/owl-s/1.2/Process.owl", "test-difficult-rdf1.xml");
        this.testUrl("application/rdf+xml", "http://www.w3.org/2002/07/owl#", "test-difficult-rdf2.xml");
        this.testFile("text/html", "test-tika-327.html");
        this.testFile("text/html", "testlargerbuffer.html");
        this.testFile("text/html", "htmlfragment");
        this.testFile("image/cgm", "plotutils-bin-cgm-v3.cgm");
        this.testFile("text/html", "test-malformed-header.html.bin");
    }

    @Test
    public void testByteOrderMark() throws Exception {
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream("\ufefftest".getBytes(StandardCharsets.UTF_16LE)), new Metadata()));
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream("\ufefftest".getBytes(StandardCharsets.UTF_16BE)), new Metadata()));
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream("\ufefftest".getBytes(StandardCharsets.UTF_8)), new Metadata()));
    }

    @Test
    public void testSuperTypes() {
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"text/something; charset=UTF-8"), MediaType.parse((String)"text/something")));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"text/something; charset=UTF-8"), MediaType.TEXT_PLAIN));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"text/something; charset=UTF-8"), MediaType.OCTET_STREAM));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"text/something"), MediaType.TEXT_PLAIN));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"application/something+xml"), MediaType.APPLICATION_XML));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"application/something+zip"), MediaType.APPLICATION_ZIP));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.APPLICATION_XML, MediaType.TEXT_PLAIN));
        Assert.assertTrue((boolean)this.registry.isSpecializationOf(MediaType.parse((String)"application/vnd.apple.iwork"), MediaType.APPLICATION_ZIP));
    }

    private void testUrlOnly(String expected, String url) throws IOException {
        InputStream in = new URL(url).openStream();
        this.testStream(expected, url, in);
    }

    private void testUrl(String expected, String url, String file) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(file);
        this.testStream(expected, url, in);
    }

    private void testFile(String expected, String filename) throws IOException {
        InputStream in = this.getClass().getResourceAsStream(filename);
        this.testStream(expected, filename, in);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void testStream(String expected, String urlOrFileName, InputStream in) throws IOException {
        Assert.assertNotNull((String)("Test stream: [" + urlOrFileName + "] is null!"), (Object)in);
        if (!in.markSupported()) {
            in = new BufferedInputStream(in);
        }
        try {
            Metadata metadata = new Metadata();
            String mime = this.tika.detect(in, metadata).toString();
            Assert.assertEquals((String)(urlOrFileName + " is not properly detected: detected."), (Object)expected, (Object)mime);
            metadata.set("resourceName", urlOrFileName);
            mime = this.tika.detect(in, metadata).toString();
            Assert.assertEquals((String)(urlOrFileName + " is not properly detected after adding resource name."), (Object)expected, (Object)mime);
        }
        finally {
            in.close();
        }
    }

    @Test
    public void testEmptyDocument() throws IOException {
        Assert.assertEquals((Object)MediaType.OCTET_STREAM.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream(new byte[0]), new Metadata()));
        Metadata namehint = new Metadata();
        namehint.set("resourceName", "test.txt");
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream(new byte[0]), namehint));
        Metadata typehint = new Metadata();
        typehint.set("Content-Type", "text/plain");
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream(new byte[0]), typehint));
    }

    @Test
    public void testNotXML() throws IOException {
        Assert.assertEquals((Object)MediaType.TEXT_PLAIN.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream("<!-- test -->".getBytes(StandardCharsets.UTF_8)), new Metadata()));
    }

    @Test
    public void testMimeMagicStability() throws IOException {
        for (int i = 0; i < 100; ++i) {
            this.testFile("application/vnd.ms-excel", "test.xls");
        }
    }

    @Test
    public void testMimeMagicClashSamePriority() throws IOException {
        byte[] helloWorld = "Hello, World!".getBytes(StandardCharsets.UTF_8);
        MediaType helloType = MediaType.parse((String)"hello/world-file");
        MediaType helloXType = MediaType.parse((String)"hello/x-world-hello");
        Metadata metadata = new Metadata();
        metadata.set("resourceName", "test.hello.world");
        Assert.assertEquals((Object)helloType.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream(helloWorld), metadata));
        metadata = new Metadata();
        metadata.set("resourceName", "test.x-hello-world");
        Assert.assertEquals((Object)helloXType.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream(helloWorld), metadata));
        metadata = new Metadata();
        metadata.set("resourceName", "testingTESTINGtesting");
        Assert.assertEquals((Object)helloXType.toString(), (Object)this.tika.detect((InputStream)new ByteArrayInputStream(helloWorld), metadata));
    }
}

