/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mock;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.extractor.EmbeddedDocumentExtractor;
import org.apache.tika.extractor.ParsingEmbeddedDocumentExtractor;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.mime.MediaType;
import org.apache.tika.parser.AbstractParser;
import org.apache.tika.parser.ParseContext;
import org.apache.tika.parser.Parser;
import org.apache.tika.sax.EmbeddedContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class MockParser
extends AbstractParser {
    private static final long serialVersionUID = 1L;

    public Set<MediaType> getSupportedTypes(ParseContext context) {
        HashSet<MediaType> types = new HashSet<MediaType>();
        MediaType type = MediaType.application((String)"mock+xml");
        types.add(type);
        return types;
    }

    public void parse(InputStream stream, ContentHandler handler, Metadata metadata, ParseContext context) throws IOException, SAXException, TikaException {
        Document doc = null;
        DocumentBuilderFactory fact = DocumentBuilderFactory.newInstance();
        DocumentBuilder docBuilder = null;
        try {
            docBuilder = fact.newDocumentBuilder();
            doc = docBuilder.parse(stream);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e);
        }
        catch (SAXException e) {
            throw new IOException(e);
        }
        Element root = doc.getDocumentElement();
        NodeList actions = root.getChildNodes();
        XHTMLContentHandler xhtml = new XHTMLContentHandler(handler, metadata);
        xhtml.startDocument();
        for (int i = 0; i < actions.getLength(); ++i) {
            this.executeAction(actions.item(i), metadata, context, xhtml);
        }
        xhtml.endDocument();
    }

    private void executeAction(Node action, Metadata metadata, ParseContext context, XHTMLContentHandler xhtml) throws SAXException, IOException, TikaException {
        if (action.getNodeType() != 1) {
            return;
        }
        String name = action.getNodeName();
        if ("metadata".equals(name)) {
            this.metadata(action, metadata);
        } else if ("write".equals(name)) {
            this.write(action, xhtml);
        } else if ("throw".equals(name)) {
            this.throwIt(action);
        } else if ("hang".equals(name)) {
            this.hang(action);
        } else if ("oom".equals(name)) {
            this.kabOOM();
        } else if ("print_out".equals(name) || "print_err".equals(name)) {
            this.print(action, name);
        } else if ("embedded".equals(name)) {
            this.handleEmbedded(action, xhtml, context);
        } else if ("throwIllegalChars".equals(name)) {
            this.throwIllegalChars();
        } else {
            throw new IllegalArgumentException("Didn't recognize mock action: " + name);
        }
    }

    private void throwIllegalChars() throws IOException {
        throw new IOException("Can't say \u0000 in xml or \u0001 or \u0002 or \u0003");
    }

    private void handleEmbedded(Node action, XHTMLContentHandler handler, ParseContext context) throws TikaException, SAXException, IOException {
        String fileName = "";
        String contentType = "";
        NamedNodeMap attrs = action.getAttributes();
        if (attrs != null) {
            Node n = attrs.getNamedItem("filename");
            if (n != null) {
                fileName = n.getNodeValue();
            }
            if ((n = attrs.getNamedItem("content-type")) != null) {
                contentType = n.getNodeValue();
            }
        }
        String embeddedText = action.getTextContent();
        EmbeddedDocumentExtractor extractor = this.getEmbeddedDocumentExtractor(context);
        Metadata m = new Metadata();
        m.set("resourceName", fileName);
        if (!"".equals(contentType)) {
            m.set("Content-Type", contentType);
        }
        ByteArrayInputStream is = new ByteArrayInputStream(embeddedText.getBytes(StandardCharsets.UTF_8));
        extractor.parseEmbedded((InputStream)is, (ContentHandler)new EmbeddedContentHandler((ContentHandler)handler), m, true);
    }

    protected EmbeddedDocumentExtractor getEmbeddedDocumentExtractor(ParseContext context) {
        EmbeddedDocumentExtractor extractor = (EmbeddedDocumentExtractor)context.get(EmbeddedDocumentExtractor.class);
        if (extractor == null) {
            Parser p = (Parser)context.get(Parser.class);
            if (p == null) {
                context.set(Parser.class, (Object)new MockParser());
            }
            extractor = new ParsingEmbeddedDocumentExtractor(context);
        }
        return extractor;
    }

    private void print(Node action, String name) {
        String content = action.getTextContent();
        if ("print_out".equals(name)) {
            System.out.println(content);
        } else if ("print_err".equals(name)) {
            System.err.println(content);
        } else {
            throw new IllegalArgumentException("must be print_out or print_err");
        }
    }

    private void hang(Node action) {
        Node mNode;
        Node hNode;
        boolean interruptible = true;
        boolean heavy = false;
        long millis = -1L;
        long pulseMillis = -1L;
        NamedNodeMap attrs = action.getAttributes();
        Node iNode = attrs.getNamedItem("interruptible");
        if (iNode != null) {
            interruptible = "true".equals(iNode.getNodeValue());
        }
        if ((hNode = attrs.getNamedItem("heavy")) != null) {
            heavy = "true".equals(hNode.getNodeValue());
        }
        if ((mNode = attrs.getNamedItem("millis")) == null) {
            throw new RuntimeException("Must specify \"millis\" attribute for hang.");
        }
        String millisString = mNode.getNodeValue();
        try {
            millis = Long.parseLong(millisString);
        }
        catch (NumberFormatException e) {
            throw new RuntimeException("Value for \"millis\" attribute must be a long.");
        }
        if (heavy) {
            Node pNode = attrs.getNamedItem("pulse_millis");
            if (pNode == null) {
                throw new RuntimeException("Must specify attribute \"pulse_millis\" if the hang is \"heavy\"");
            }
            String pulseMillisString = mNode.getNodeValue();
            try {
                pulseMillis = Long.parseLong(pulseMillisString);
            }
            catch (NumberFormatException e) {
                throw new RuntimeException("Value for \"millis\" attribute must be a long.");
            }
        }
        if (heavy) {
            this.hangHeavy(millis, pulseMillis, interruptible);
        } else {
            this.sleep(millis, interruptible);
        }
    }

    private void throwIt(Node action) throws IOException, SAXException, TikaException {
        NamedNodeMap attrs = action.getAttributes();
        String className = attrs.getNamedItem("class").getNodeValue();
        String msg = action.getTextContent();
        this.throwIt(className, msg);
    }

    private void metadata(Node action, Metadata metadata) {
        NamedNodeMap attrs = action.getAttributes();
        String name = attrs.getNamedItem("name").getNodeValue();
        String value = action.getTextContent();
        Node actionType = attrs.getNamedItem("action");
        if (actionType == null) {
            metadata.add(name, value);
        } else if ("set".equals(actionType.getNodeValue())) {
            metadata.set(name, value);
        } else {
            metadata.add(name, value);
        }
    }

    private void write(Node action, XHTMLContentHandler xhtml) throws SAXException {
        NamedNodeMap attrs = action.getAttributes();
        Node eNode = attrs.getNamedItem("element");
        String elementType = "p";
        if (eNode != null) {
            elementType = eNode.getTextContent();
        }
        String text = action.getTextContent();
        xhtml.startElement(elementType);
        xhtml.characters(text);
        xhtml.endElement(elementType);
    }

    private void throwIt(String className, String msg) throws IOException, SAXException, TikaException {
        Throwable t = null;
        if (msg == null || msg.equals("")) {
            try {
                t = (Throwable)Class.forName(className).newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException("couldn't create throwable class:" + className, e);
            }
        }
        try {
            Class<?> clazz = Class.forName(className);
            Constructor<?> con = clazz.getConstructor(String.class);
            t = (Throwable)con.newInstance(msg);
        }
        catch (Exception e) {
            throw new RuntimeException("couldn't create throwable class:" + className, e);
        }
        if (t instanceof SAXException) {
            throw (SAXException)t;
        }
        if (t instanceof IOException) {
            throw (IOException)t;
        }
        if (t instanceof TikaException) {
            throw (TikaException)t;
        }
        if (t instanceof Error) {
            throw (Error)t;
        }
        if (t instanceof RuntimeException) {
            throw (RuntimeException)t;
        }
        throw new RuntimeException(t);
    }

    private void kabOOM() {
        ArrayList<int[]> ints = new ArrayList<int[]>();
        while (true) {
            int[] intArr = new int[32000];
            ints.add(intArr);
        }
    }

    private void hangHeavy(long maxMillis, long pulseCheckMillis, boolean interruptible) {
        long start = new Date().getTime();
        int lastChecked = 0;
        block0: while (true) {
            int i = 1;
            while (true) {
                if (i >= Integer.MAX_VALUE) continue block0;
                for (int j = 1; j < Integer.MAX_VALUE; ++j) {
                    double div = (double)i / (double)j;
                    if ((long)(++lastChecked) <= pulseCheckMillis) continue;
                    lastChecked = 0;
                    if (interruptible && Thread.currentThread().isInterrupted()) {
                        return;
                    }
                    long elapsed = new Date().getTime() - start;
                    if (elapsed <= maxMillis) continue;
                    return;
                }
                ++i;
            }
            break;
        }
    }

    private void sleep(long maxMillis, boolean isInterruptible) {
        long elapsed;
        long start = new Date().getTime();
        long millisRemaining = maxMillis;
        do {
            try {
                Thread.sleep(millisRemaining);
            }
            catch (InterruptedException e) {
                if (!isInterruptible) continue;
                return;
            }
        } while ((millisRemaining = maxMillis - (elapsed = new Date().getTime() - start)) > 0L);
    }
}

