/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import org.apache.tika.sax.SafeContentHandler;
import org.apache.tika.sax.WriteOutContentHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;

public class SafeContentHandlerTest {
    private ContentHandler output;
    private ContentHandler safe;

    @Before
    public void setUp() {
        this.output = new WriteOutContentHandler();
        this.safe = new SafeContentHandler(this.output);
    }

    @Test
    public void testEmptyInput() throws SAXException {
        this.safe.characters(new char[0], 0, 0);
        this.safe.ignorableWhitespace(new char[0], 0, 0);
        Assert.assertEquals((Object)"", (Object)this.output.toString());
    }

    @Test
    public void testNormalCharacters() throws SAXException {
        this.safe.characters("abc".toCharArray(), 0, 3);
        Assert.assertEquals((Object)"abc", (Object)this.output.toString());
    }

    @Test
    public void testNormalWhitespace() throws SAXException {
        this.safe.ignorableWhitespace("abc".toCharArray(), 0, 3);
        Assert.assertEquals((Object)"abc", (Object)this.output.toString());
    }

    @Test
    public void testInvalidCharacters() throws SAXException {
        this.safe.characters("ab\u0007".toCharArray(), 0, 3);
        this.safe.characters("a\u000bc".toCharArray(), 0, 3);
        this.safe.characters("\u0019bc".toCharArray(), 0, 3);
        Assert.assertEquals((Object)"ab\ufffda\ufffdc\ufffdbc", (Object)this.output.toString());
    }

    @Test
    public void testInvalidWhitespace() throws SAXException {
        this.safe.ignorableWhitespace("ab\u0000".toCharArray(), 0, 3);
        this.safe.ignorableWhitespace("a\u0001c".toCharArray(), 0, 3);
        this.safe.ignorableWhitespace("\u0002bc".toCharArray(), 0, 3);
        Assert.assertEquals((Object)"ab\ufffda\ufffdc\ufffdbc", (Object)this.output.toString());
    }

    @Test
    public void testInvalidSurrogates() throws SAXException {
        this.safe.ignorableWhitespace("\udb00\ubfff".toCharArray(), 0, 2);
        Assert.assertEquals((Object)"\ufffd\ubfff", (Object)this.output.toString());
    }
}

