/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.sax;

import java.util.ArrayList;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.sax.BodyContentHandler;
import org.apache.tika.sax.ToHTMLContentHandler;
import org.apache.tika.sax.XHTMLContentHandler;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.xml.sax.Attributes;
import org.xml.sax.ContentHandler;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.AttributesImpl;

public class XHTMLContentHandlerTest {
    private ContentHandler output;
    private XHTMLContentHandler xhtml;

    @Before
    public void setUp() {
        this.output = new BodyContentHandler();
        this.xhtml = new XHTMLContentHandler(this.output, new Metadata());
    }

    @Test
    public void testExtraWhitespace() throws SAXException {
        this.xhtml.startDocument();
        this.xhtml.element("p", "foo");
        this.xhtml.startElement("p");
        this.xhtml.characters("b");
        this.xhtml.element("b", "a");
        this.xhtml.characters("r");
        this.xhtml.endElement("p");
        this.xhtml.startElement("table");
        this.xhtml.startElement("tr");
        this.xhtml.element("th", "x");
        this.xhtml.element("th", "y");
        this.xhtml.endElement("tr");
        this.xhtml.startElement("tr");
        this.xhtml.element("td", "a");
        this.xhtml.element("td", "b");
        this.xhtml.endElement("tr");
        this.xhtml.endElement("table");
        this.xhtml.endDocument();
        String[] words = this.output.toString().split("\\s+");
        Assert.assertEquals((long)6L, (long)words.length);
        Assert.assertEquals((Object)"foo", (Object)words[0]);
        Assert.assertEquals((Object)"bar", (Object)words[1]);
        Assert.assertEquals((Object)"x", (Object)words[2]);
        Assert.assertEquals((Object)"y", (Object)words[3]);
        Assert.assertEquals((Object)"a", (Object)words[4]);
        Assert.assertEquals((Object)"b", (Object)words[5]);
    }

    @Test
    public void testWhitespaceWithOptions() throws Exception {
        this.xhtml.startDocument();
        this.xhtml.startElement("form");
        this.xhtml.startElement("select");
        this.xhtml.element("option", "opt1");
        this.xhtml.element("option", "opt2");
        this.xhtml.endElement("select");
        this.xhtml.endElement("form");
        this.xhtml.endDocument();
        String[] words = this.output.toString().split("\\s+");
        Assert.assertEquals((long)2L, (long)words.length);
        Assert.assertEquals((Object)"opt1", (Object)words[0]);
        Assert.assertEquals((Object)"opt2", (Object)words[1]);
    }

    @Test
    public void testWhitespaceWithMenus() throws Exception {
        this.xhtml.startDocument();
        this.xhtml.startElement("menu");
        this.xhtml.element("li", "one");
        this.xhtml.element("li", "two");
        this.xhtml.endElement("menu");
        this.xhtml.endDocument();
        String[] words = XHTMLContentHandlerTest.getRealWords(this.output.toString());
        Assert.assertEquals((long)2L, (long)words.length);
        Assert.assertEquals((Object)"one", (Object)words[0]);
        Assert.assertEquals((Object)"two", (Object)words[1]);
    }

    @Test
    public void testAttributesOnBody() throws Exception {
        ToHTMLContentHandler toHTMLContentHandler = new ToHTMLContentHandler();
        XHTMLContentHandler xhtmlContentHandler = new XHTMLContentHandler((ContentHandler)toHTMLContentHandler, new Metadata());
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("http://www.w3.org/1999/xhtml", "itemscope", "itemscope", "", "");
        attributes.addAttribute("http://www.w3.org/1999/xhtml", "itemtype", "itemtype", "", "http://schema.org/Event");
        xhtmlContentHandler.startDocument();
        xhtmlContentHandler.startElement("http://www.w3.org/1999/xhtml", "body", "body", (Attributes)attributes);
        xhtmlContentHandler.endElement("body");
        xhtmlContentHandler.endDocument();
        Assert.assertTrue((boolean)toHTMLContentHandler.toString().contains("itemscope"));
    }

    @Test
    public void testAttributesOnHtml() throws Exception {
        ToHTMLContentHandler toHTMLContentHandler = new ToHTMLContentHandler();
        XHTMLContentHandler xhtmlContentHandler = new XHTMLContentHandler((ContentHandler)toHTMLContentHandler, new Metadata());
        AttributesImpl attributes = new AttributesImpl();
        attributes.addAttribute("http://www.w3.org/1999/xhtml", "itemscope", "itemscope", "", "");
        attributes.addAttribute("http://www.w3.org/1999/xhtml", "itemtype", "itemtype", "", "http://schema.org/Event");
        xhtmlContentHandler.startDocument();
        xhtmlContentHandler.startElement("http://www.w3.org/1999/xhtml", "html", "html", (Attributes)attributes);
        xhtmlContentHandler.endElement("html");
        xhtmlContentHandler.endDocument();
        Assert.assertTrue((boolean)toHTMLContentHandler.toString().contains("itemscope"));
    }

    private static String[] getRealWords(String string) {
        String[] possibleWords = string.split("\\s+");
        ArrayList<String> words = new ArrayList<String>(possibleWords.length);
        for (String word : possibleWords) {
            if (word.length() <= 0) continue;
            words.add(word);
        }
        return words.toArray(new String[words.size()]);
    }
}

