/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.utils;

import java.util.List;
import org.apache.tika.utils.RegexUtils;
import org.junit.Assert;
import org.junit.Test;

public class RegexUtilsTest {
    @Test
    public void testExtractLinksNone() {
        List links = null;
        links = RegexUtils.extractLinks(null);
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)0L, (long)links.size());
        links = RegexUtils.extractLinks((String)"");
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)0L, (long)links.size());
        links = RegexUtils.extractLinks((String)"Test with no links What about www.google.com");
        Assert.assertNotNull((Object)links);
        Assert.assertEquals((long)0L, (long)links.size());
    }

    @Test
    public void testExtractLinksHttp() {
        List links = RegexUtils.extractLinks((String)"Test with http://www.nutch.org/index.html is it found? What about www.google.com at http://www.google.de A longer URL could be http://www.sybit.com/solutions/portals.html");
        Assert.assertTrue((String)"Url not found!", (links.size() == 3 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong URL", (Object)"http://www.nutch.org/index.html", links.get(0));
        Assert.assertEquals((String)"Wrong URL", (Object)"http://www.google.de", links.get(1));
        Assert.assertEquals((String)"Wrong URL", (Object)"http://www.sybit.com/solutions/portals.html", links.get(2));
    }

    @Test
    public void testExtractLinksFtp() {
        List links = RegexUtils.extractLinks((String)"Test with ftp://www.nutch.org is it found? What about www.google.com at ftp://www.google.de");
        Assert.assertTrue((String)"Url not found!", (links.size() == 2 ? 1 : 0) != 0);
        Assert.assertEquals((String)"Wrong URL", (Object)"ftp://www.nutch.org", links.get(0));
        Assert.assertEquals((String)"Wrong URL", (Object)"ftp://www.google.de", links.get(1));
    }
}

