/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj;

import java.io.IOException;
import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectParseErrorException;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.StreamObjectTypeHeaderStart;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.BasicObject;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.ExGuid;
import org.apache.tika.parser.microsoft.onenote.fsshttpb.streamobj.basic.SerialNumber;

public class StorageIndexRevisionMapping
extends StreamObject {
    public ExGuid revisionExGuid;
    public ExGuid revisionMappingExGuid;
    public SerialNumber revisionMappingSerialNumber;

    public StorageIndexRevisionMapping() {
        super(StreamObjectTypeHeaderStart.StorageIndexRevisionMapping);
    }

    @Override
    protected void deserializeItemsFromByteArray(byte[] byteArray, AtomicInteger currentIndex, int lengthOfItems) throws TikaException, IOException {
        AtomicInteger index = new AtomicInteger(currentIndex.get());
        this.revisionExGuid = BasicObject.parse(byteArray, index, ExGuid.class);
        this.revisionMappingExGuid = BasicObject.parse(byteArray, index, ExGuid.class);
        this.revisionMappingSerialNumber = BasicObject.parse(byteArray, index, SerialNumber.class);
        if (index.get() - currentIndex.get() != lengthOfItems) {
            throw new StreamObjectParseErrorException(currentIndex.get(), "StorageIndexRevisionMapping", "Stream object over-parse error", null);
        }
        currentIndex.set(index.get());
    }

    @Override
    protected int serializeItemsToByteList(List<Byte> byteList) throws IOException {
        int itemsIndex = byteList.size();
        byteList.addAll(this.revisionExGuid.serializeToByteList());
        byteList.addAll(this.revisionMappingExGuid.serializeToByteList());
        byteList.addAll(this.revisionMappingSerialNumber.serializeToByteList());
        return byteList.size() - itemsIndex;
    }
}

