/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.parser.mp3;

import java.io.IOException;
import org.apache.tika.exception.TikaException;
import org.apache.tika.parser.mp3.ID3Tags;
import org.apache.tika.parser.mp3.ID3v2Frame;
import org.xml.sax.SAXException;

public class ID3v24Handler
implements ID3Tags {
    private String title;
    private String artist;
    private String album;
    private String year;
    private String composer;
    private String comment;
    private String genre;
    private String trackNumber;

    public ID3v24Handler(ID3v2Frame frame) throws IOException, SAXException, TikaException {
        RawV24TagIterator tags = new RawV24TagIterator(frame);
        while (tags.hasNext()) {
            ID3v2Frame.RawTag tag = tags.next();
            if (tag.name.equals("TIT2")) {
                this.title = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TPE1")) {
                this.artist = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TALB")) {
                this.album = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TYER")) {
                this.year = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TDRC")) {
                if (this.year != null) continue;
                this.year = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TCOM")) {
                this.composer = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("COMM")) {
                this.comment = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (tag.name.equals("TRCK")) {
                this.trackNumber = this.getTagString(tag.data, 0, tag.data.length);
                continue;
            }
            if (!tag.name.equals("TCON")) continue;
            String rawGenre = this.getTagString(tag.data, 0, tag.data.length);
            int open = rawGenre.indexOf("(");
            int close = rawGenre.indexOf(")");
            if (open == -1 && close == -1) {
                this.genre = rawGenre;
                continue;
            }
            if (open >= close) continue;
            try {
                int genreID = Integer.parseInt(rawGenre.substring(open + 1, close));
                this.genre = ID3Tags.GENRES[genreID];
            }
            catch (NumberFormatException ignore) {}
        }
    }

    private String getTagString(byte[] data, int offset, int length) {
        return ID3v2Frame.getTagString(data, offset, length);
    }

    public boolean getTagsPresent() {
        return true;
    }

    public String getTitle() {
        return this.title;
    }

    public String getArtist() {
        return this.artist;
    }

    public String getAlbum() {
        return this.album;
    }

    public String getYear() {
        return this.year;
    }

    public String getComposer() {
        return this.composer;
    }

    public String getComment() {
        return this.comment;
    }

    public String getGenre() {
        return this.genre;
    }

    public String getTrackNumber() {
        return this.trackNumber;
    }

    private class RawV24TagIterator
    extends ID3v2Frame.RawTagIterator {
        private RawV24TagIterator(ID3v2Frame frame) {
            ID3v2Frame iD3v2Frame = frame;
            iD3v2Frame.getClass();
            super(iD3v2Frame, 4, 4, 1, 2);
        }
    }
}

