/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tika.metadata.serialization;

import com.google.gson.Gson;
import com.google.gson.JsonIOException;
import com.google.gson.JsonParseException;
import com.google.gson.reflect.TypeToken;
import java.io.Reader;
import java.io.Writer;
import java.lang.reflect.Type;
import java.util.List;
import org.apache.tika.exception.TikaException;
import org.apache.tika.metadata.Metadata;
import org.apache.tika.metadata.serialization.JsonMetadataBase;

public class JsonMetadataList
extends JsonMetadataBase {
    private static final Type listType = new TypeToken<List<Metadata>>(){}.getType();
    private static Gson GSON = JsonMetadataList.defaultInit();

    public static void toJson(List<Metadata> metadataList, Writer writer) throws TikaException {
        try {
            GSON.toJson(metadataList, (Appendable)writer);
        }
        catch (JsonIOException e) {
            throw new TikaException(e.getMessage());
        }
    }

    public static List<Metadata> fromJson(Reader reader) throws TikaException {
        List ms = null;
        if (reader == null) {
            return ms;
        }
        try {
            ms = (List)GSON.fromJson(reader, listType);
        }
        catch (JsonParseException e) {
            throw new TikaException(e.getMessage());
        }
        return ms;
    }

    public static void setGson(Gson gson) {
        GSON = gson;
    }

    public static void setPrettyPrinting(boolean prettyPrint) {
        GSON = prettyPrint ? JsonMetadataList.prettyInit() : JsonMetadataList.defaultInit();
    }
}

