/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tiles.factory;

import java.lang.reflect.Method;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import org.apache.tiles.Initializable;
import org.apache.tiles.TilesApplicationContext;
import org.apache.tiles.TilesContainer;
import org.apache.tiles.awareness.TilesApplicationContextAware;
import org.apache.tiles.awareness.TilesContainerAware;
import org.apache.tiles.awareness.TilesRequestContextFactoryAware;
import org.apache.tiles.context.AbstractTilesApplicationContextFactory;
import org.apache.tiles.context.ChainedTilesApplicationContextFactory;
import org.apache.tiles.context.ChainedTilesRequestContextFactory;
import org.apache.tiles.context.TilesRequestContextFactory;
import org.apache.tiles.definition.DefinitionsFactory;
import org.apache.tiles.definition.UrlDefinitionsFactory;
import org.apache.tiles.evaluator.AttributeEvaluator;
import org.apache.tiles.evaluator.AttributeEvaluatorFactoryAware;
import org.apache.tiles.evaluator.BasicAttributeEvaluatorFactory;
import org.apache.tiles.evaluator.impl.DirectAttributeEvaluator;
import org.apache.tiles.factory.AbstractTilesContainerFactory;
import org.apache.tiles.impl.BasicTilesContainer;
import org.apache.tiles.impl.mgmt.CachingTilesContainer;
import org.apache.tiles.mgmt.MutableTilesContainer;
import org.apache.tiles.preparer.BasicPreparerFactory;
import org.apache.tiles.preparer.PreparerFactory;
import org.apache.tiles.reflect.ClassUtil;
import org.apache.tiles.renderer.RendererFactory;
import org.apache.tiles.renderer.impl.BasicRendererFactory;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class TilesContainerFactory
extends AbstractTilesContainerFactory {
    public static final String CONTAINER_FACTORY_INIT_PARAM = "org.apache.tiles.factory.TilesContainerFactory";
    public static final String CONTAINER_FACTORY_MUTABLE_INIT_PARAM = "org.apache.tiles.factory.TilesContainerFactory.MUTABLE";
    public static final String CONTEXT_FACTORY_INIT_PARAM = "org.apache.tiles.context.TilesContextFactory";
    public static final String REQUEST_CONTEXT_FACTORY_INIT_PARAM = "org.apache.tiles.context.TilesRequestContextFactory";
    public static final String DEFINITIONS_FACTORY_INIT_PARAM = "org.apache.tiles.definition.DefinitionsFactory";
    public static final String PREPARER_FACTORY_INIT_PARAM = "org.apache.tiles.preparer.PreparerFactory";
    public static final String RENDERER_FACTORY_INIT_PARAM = "org.apache.tiles.renderer.RendererFactory";
    public static final String ATTRIBUTE_EVALUATOR_INIT_PARAM = "org.apache.tiles.evaluator.AttributeEvaluator";
    private final Logger log = LoggerFactory.getLogger(TilesContainerFactory.class);
    private static final Map<String, String> DEFAULTS = new HashMap<String, String>();
    protected Map<String, String> defaultConfiguration = new HashMap<String, String>(DEFAULTS);

    @Deprecated
    public static TilesContainerFactory getFactory(Object context) {
        return TilesContainerFactory.getFactory(context, DEFAULTS);
    }

    public static TilesContainerFactory getFactory(Object context, Map<String, String> defaults) {
        HashMap<String, String> configuration = new HashMap<String, String>(defaults);
        configuration.putAll(TilesContainerFactory.getInitParameterMap(context));
        TilesContainerFactory factory = (TilesContainerFactory)TilesContainerFactory.createFactory(configuration, CONTAINER_FACTORY_INIT_PARAM);
        factory.setDefaultConfiguration(defaults);
        return factory;
    }

    @Deprecated
    public TilesContainer createContainer(Object context) {
        if (context instanceof TilesApplicationContext) {
            return this.createContainer((TilesApplicationContext)context);
        }
        throw new UnsupportedOperationException("Class " + context.getClass().getName() + " not recognized a TilesApplicationContext");
    }

    @Override
    public TilesContainer createContainer(TilesApplicationContext context) {
        String value = (String)context.getInitParams().get(CONTAINER_FACTORY_MUTABLE_INIT_PARAM);
        if (Boolean.parseBoolean(value)) {
            return this.createMutableTilesContainer(context);
        }
        return this.createTilesContainer(context);
    }

    public void setDefaultConfiguration(Map<String, String> defaultConfiguration) {
        if (defaultConfiguration != null) {
            this.defaultConfiguration.putAll(defaultConfiguration);
        }
    }

    public void setDefaultValue(String key, String value) {
        this.defaultConfiguration.put(key, value);
    }

    @Deprecated
    public TilesContainer createTilesContainer(Object context) {
        if (context instanceof TilesApplicationContext) {
            return this.createTilesContainer((TilesApplicationContext)context);
        }
        throw new UnsupportedOperationException("Class " + context.getClass().getName() + " not recognized a TilesApplicationContext");
    }

    public TilesContainer createTilesContainer(TilesApplicationContext context) {
        BasicTilesContainer container = new BasicTilesContainer();
        this.initializeContainer(context, container);
        return container;
    }

    @Deprecated
    public TilesContainer createMutableTilesContainer(Object context) {
        if (context instanceof TilesApplicationContext) {
            return this.createMutableTilesContainer((TilesApplicationContext)context);
        }
        throw new UnsupportedOperationException("Class " + context.getClass().getName() + " not recognized a TilesApplicationContext");
    }

    public MutableTilesContainer createMutableTilesContainer(TilesApplicationContext context) {
        CachingTilesContainer container = new CachingTilesContainer();
        this.initializeContainer(context, (BasicTilesContainer)container);
        return container;
    }

    @Deprecated
    protected void initializeContainer(Object context, BasicTilesContainer container) {
        if (context instanceof TilesApplicationContext) {
            this.initializeContainer((TilesApplicationContext)context, container);
        }
        throw new UnsupportedOperationException("Class " + context.getClass().getName() + " not recognized a TilesApplicationContext");
    }

    protected void initializeContainer(TilesApplicationContext context, BasicTilesContainer container) {
        this.log.warn("DEPRECATION WARNING! You are using parameter-based initialization, that is no longer supported! Please see docs: http://tiles.apache.org/framework/tutorial/configuration.html");
        if (this.log.isInfoEnabled()) {
            this.log.info("Initializing Tiles2 container. . .");
        }
        Map initParameterMap = context.getInitParams();
        HashMap<String, String> configuration = new HashMap<String, String>(this.defaultConfiguration);
        configuration.putAll(initParameterMap);
        this.storeContainerDependencies(context, (Map<String, String>)initParameterMap, (Map<String, String>)configuration, container);
        container.init(initParameterMap);
        if (this.log.isInfoEnabled()) {
            this.log.info("Tiles2 container initialized");
        }
    }

    protected void storeContainerDependencies(Object context, Map<String, String> initParameters, Map<String, String> configuration, BasicTilesContainer container) {
        if (context instanceof TilesApplicationContext) {
            this.storeContainerDependencies((TilesApplicationContext)context, initParameters, configuration, container);
        }
        throw new UnsupportedOperationException("Class " + context.getClass().getName() + " not recognized a TilesApplicationContext");
    }

    protected void storeContainerDependencies(TilesApplicationContext context, Map<String, String> initParameters, Map<String, String> configuration, BasicTilesContainer container) {
        AbstractTilesApplicationContextFactory contextFactory = (AbstractTilesApplicationContextFactory)TilesContainerFactory.createFactory(configuration, "org.apache.tiles.context.AbstractTilesApplicationContextFactory");
        if (contextFactory instanceof Initializable) {
            ((Initializable)contextFactory).init(configuration);
        }
        TilesRequestContextFactory requestContextFactory = (TilesRequestContextFactory)TilesContainerFactory.createFactory(configuration, REQUEST_CONTEXT_FACTORY_INIT_PARAM);
        requestContextFactory.init(configuration);
        RendererFactory rendererFactory = (RendererFactory)TilesContainerFactory.createFactory(configuration, RENDERER_FACTORY_INIT_PARAM);
        AttributeEvaluator evaluator = (AttributeEvaluator)TilesContainerFactory.createFactory(configuration, ATTRIBUTE_EVALUATOR_INIT_PARAM);
        BasicAttributeEvaluatorFactory attributeEvaluatorFactory = new BasicAttributeEvaluatorFactory(evaluator);
        if (evaluator instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)evaluator)).setApplicationContext(context);
        }
        if (evaluator instanceof TilesContainerAware) {
            ((TilesContainerAware)((Object)evaluator)).setContainer(container);
        }
        evaluator.init(configuration);
        if (rendererFactory instanceof TilesRequestContextFactoryAware) {
            ((TilesRequestContextFactoryAware)((Object)rendererFactory)).setRequestContextFactory(requestContextFactory);
        }
        if (rendererFactory instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)rendererFactory)).setApplicationContext(context);
        }
        if (rendererFactory instanceof TilesContainerAware) {
            ((TilesContainerAware)((Object)rendererFactory)).setContainer(container);
        }
        if (rendererFactory instanceof AttributeEvaluatorFactoryAware) {
            ((AttributeEvaluatorFactoryAware)((Object)rendererFactory)).setAttributeEvaluatorFactory(attributeEvaluatorFactory);
        }
        rendererFactory.init(initParameters);
        PreparerFactory prepFactory = (PreparerFactory)TilesContainerFactory.createFactory(configuration, PREPARER_FACTORY_INIT_PARAM);
        this.postCreationOperations(requestContextFactory, context, rendererFactory, evaluator, initParameters, configuration, container);
        container.setRequestContextFactory(requestContextFactory);
        container.setPreparerFactory(prepFactory);
        container.setApplicationContext(context);
        container.setRendererFactory(rendererFactory);
        container.setAttributeEvaluatorFactory(attributeEvaluatorFactory);
    }

    protected void postCreationOperations(TilesRequestContextFactory contextFactory, TilesApplicationContext tilesContext, RendererFactory rendererFactory, AttributeEvaluator evaluator, Map<String, String> initParameters, Map<String, String> configuration, BasicTilesContainer container) {
        DefinitionsFactory defsFactory = (DefinitionsFactory)TilesContainerFactory.createFactory(configuration, DEFINITIONS_FACTORY_INIT_PARAM);
        if (defsFactory instanceof TilesApplicationContextAware) {
            ((TilesApplicationContextAware)((Object)defsFactory)).setApplicationContext(tilesContext);
        }
        defsFactory.init(configuration);
        container.setDefinitionsFactory(defsFactory);
    }

    protected static Object createFactory(Map<String, String> configuration, String initParameterName) {
        String factoryName = TilesContainerFactory.resolveFactoryName(configuration, initParameterName);
        return ClassUtil.instantiate((String)factoryName);
    }

    protected static String resolveFactoryName(Map<String, String> configuration, String parameterName) {
        String factoryName = configuration.get(parameterName);
        return factoryName == null ? DEFAULTS.get(parameterName) : factoryName.toString();
    }

    @Deprecated
    protected static String getInitParameter(Object context, String parameterName) {
        Class<?> contextClass = context.getClass();
        Method getInitParameterMethod = ClassUtil.getForcedAccessibleMethod(contextClass, (String)"getInitParameter", (Class[])new Class[]{String.class});
        Object value = ClassUtil.invokeMethod((Object)context, (Method)getInitParameterMethod, (Object[])new Object[]{parameterName});
        return value == null ? null : value.toString();
    }

    @Deprecated
    protected static Map<String, String> getInitParameterMap(Object context) {
        HashMap<String, String> initParameters = new HashMap<String, String>();
        Class<?> contextClass = context.getClass();
        Method method = ClassUtil.getForcedAccessibleMethod(contextClass, (String)"getInitParameterNames", (Class[])new Class[0]);
        Enumeration e = (Enumeration)ClassUtil.invokeMethod((Object)context, (Method)method, (Object[])new Object[0]);
        method = ClassUtil.getForcedAccessibleMethod(contextClass, (String)"getInitParameter", (Class[])new Class[]{String.class});
        while (e.hasMoreElements()) {
            String key = (String)e.nextElement();
            initParameters.put(key, (String)ClassUtil.invokeMethod((Object)context, (Method)method, (Object[])new Object[]{key}));
        }
        return initParameters;
    }

    static {
        DEFAULTS.put("org.apache.tiles.context.AbstractTilesApplicationContextFactory", ChainedTilesApplicationContextFactory.class.getName());
        DEFAULTS.put(REQUEST_CONTEXT_FACTORY_INIT_PARAM, ChainedTilesRequestContextFactory.class.getName());
        DEFAULTS.put(DEFINITIONS_FACTORY_INIT_PARAM, UrlDefinitionsFactory.class.getName());
        DEFAULTS.put(PREPARER_FACTORY_INIT_PARAM, BasicPreparerFactory.class.getName());
        DEFAULTS.put(RENDERER_FACTORY_INIT_PARAM, BasicRendererFactory.class.getName());
        DEFAULTS.put(ATTRIBUTE_EVALUATOR_INIT_PARAM, DirectAttributeEvaluator.class.getName());
    }
}

