/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.process.traversal;

import java.util.function.BiPredicate;
import org.apache.tinkerpop.gremlin.util.NumberHelper;

public enum Compare implements BiPredicate<Object, Object>
{
    eq{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : (Compare.bothAreNumber(first, second) ? NumberHelper.compare((Number)first, (Number)second) == 0 : first.equals(second));
        }

        @Override
        public Compare negate() {
            return neq;
        }
    }
    ,
    neq{

        @Override
        public boolean test(Object first, Object second) {
            return !eq.test(first, second);
        }

        @Override
        public Compare negate() {
            return eq;
        }
    }
    ,
    gt{

        @Override
        public boolean test(Object first, Object second) {
            if (null != first && null != second) {
                if (Compare.bothAreNumber(first, second)) {
                    return NumberHelper.compare((Number)first, (Number)second) > 0;
                }
                if (Compare.bothAreComparableAndOfSameType(first, second)) {
                    return ((Comparable)first).compareTo(second) > 0;
                }
                Compare.throwException(first, second);
            }
            return false;
        }

        @Override
        public Compare negate() {
            return lte;
        }
    }
    ,
    gte{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : null != second && !lt.test(first, second);
        }

        @Override
        public Compare negate() {
            return lt;
        }
    }
    ,
    lt{

        @Override
        public boolean test(Object first, Object second) {
            if (null != first && null != second) {
                if (Compare.bothAreNumber(first, second)) {
                    return NumberHelper.compare((Number)first, (Number)second) < 0;
                }
                if (Compare.bothAreComparableAndOfSameType(first, second)) {
                    return ((Comparable)first).compareTo(second) < 0;
                }
                Compare.throwException(first, second);
            }
            return false;
        }

        @Override
        public Compare negate() {
            return gte;
        }
    }
    ,
    lte{

        @Override
        public boolean test(Object first, Object second) {
            return null == first ? null == second : null != second && !gt.test(first, second);
        }

        @Override
        public Compare negate() {
            return gt;
        }
    };


    private static boolean bothAreNumber(Object first, Object second) {
        return first instanceof Number && second instanceof Number;
    }

    private static boolean bothAreComparableAndOfSameType(Object first, Object second) {
        return first instanceof Comparable && second instanceof Comparable && (first.getClass().isInstance(second) || second.getClass().isInstance(first));
    }

    private static void throwException(Object first, Object second) {
        throw new IllegalArgumentException(String.format("Cannot compare '%s' (%s) and '%s' (%s) as both need to be an instance of Number or Comparable (and of the same type)", first, first.getClass().getSimpleName(), second, second.getClass().getSimpleName()));
    }

    public abstract Compare negate();
}

