/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tinkerpop.gremlin.structure.io.graphson;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.UUID;
import org.apache.tinkerpop.gremlin.structure.io.IoRegistry;
import org.apache.tinkerpop.gremlin.structure.io.Mapper;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONIo;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONModule;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONSerializerProvider;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONTypeIdResolver;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONTypeResolverBuilder;
import org.apache.tinkerpop.gremlin.structure.io.graphson.GraphSONVersion;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TinkerPopJacksonModule;
import org.apache.tinkerpop.gremlin.structure.io.graphson.TypeInfo;
import org.apache.tinkerpop.shaded.jackson.annotation.JsonTypeInfo;
import org.apache.tinkerpop.shaded.jackson.core.JsonGenerator;
import org.apache.tinkerpop.shaded.jackson.databind.Module;
import org.apache.tinkerpop.shaded.jackson.databind.ObjectMapper;
import org.apache.tinkerpop.shaded.jackson.databind.SerializationFeature;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.TypeResolverBuilder;
import org.apache.tinkerpop.shaded.jackson.databind.jsontype.impl.StdTypeResolverBuilder;
import org.apache.tinkerpop.shaded.jackson.databind.module.SimpleModule;
import org.apache.tinkerpop.shaded.jackson.databind.ser.DefaultSerializerProvider;
import org.javatuples.Pair;

public class GraphSONMapper
implements Mapper<ObjectMapper> {
    private final List<SimpleModule> customModules;
    private final boolean loadCustomSerializers;
    private final boolean normalize;
    private final GraphSONVersion version;
    private final TypeInfo typeInfo;

    private GraphSONMapper(Builder builder) {
        this.customModules = builder.customModules;
        this.loadCustomSerializers = builder.loadCustomModules;
        this.normalize = builder.normalize;
        this.version = builder.version;
        this.typeInfo = null == builder.typeInfo ? (builder.version == GraphSONVersion.V1_0 ? TypeInfo.NO_TYPES : TypeInfo.PARTIAL_TYPES) : builder.typeInfo;
    }

    @Override
    public ObjectMapper createMapper() {
        ObjectMapper om = new ObjectMapper();
        om.disable(SerializationFeature.FAIL_ON_EMPTY_BEANS);
        GraphSONModule graphSONModule = this.version.getBuilder().create(this.normalize);
        om.registerModule((Module)graphSONModule);
        this.customModules.forEach(arg_0 -> ((ObjectMapper)om).registerModule(arg_0));
        if (this.loadCustomSerializers) {
            om.findAndRegisterModules();
        }
        if (this.version == GraphSONVersion.V3_0 && this.typeInfo == TypeInfo.NO_TYPES) {
            throw new IllegalStateException(String.format("GraphSON 3.0 does not support %s", new Object[]{TypeInfo.NO_TYPES}));
        }
        if (this.version == GraphSONVersion.V3_0 || this.version == GraphSONVersion.V2_0 && this.typeInfo != TypeInfo.NO_TYPES) {
            GraphSONTypeIdResolver graphSONTypeIdResolver = new GraphSONTypeIdResolver();
            StdTypeResolverBuilder typer = new GraphSONTypeResolverBuilder(this.version).typesEmbedding(this.typeInfo).valuePropertyName("@value").init(JsonTypeInfo.Id.CUSTOM, graphSONTypeIdResolver).typeProperty("@type");
            this.registerJavaBaseTypes(graphSONTypeIdResolver);
            graphSONModule.getTypeDefinitions().forEach((targetClass, typeId) -> graphSONTypeIdResolver.addCustomType(String.format("%s:%s", graphSONModule.getTypeNamespace(), typeId), (Class)targetClass));
            this.customModules.forEach(e -> {
                TinkerPopJacksonModule mod;
                Map<Class, String> moduleTypeDefinitions;
                if (e instanceof TinkerPopJacksonModule && (moduleTypeDefinitions = (mod = (TinkerPopJacksonModule)((Object)e)).getTypeDefinitions()) != null) {
                    if (mod.getTypeNamespace() == null || mod.getTypeNamespace().isEmpty()) {
                        throw new IllegalStateException("Cannot specify a module for GraphSON 2.0 with type definitions but without a type Domain. If no specific type domain is required, use Gremlin's default domain, \"gremlin\" but there may be collisions.");
                    }
                    moduleTypeDefinitions.forEach((targetClass, typeId) -> graphSONTypeIdResolver.addCustomType(String.format("%s:%s", mod.getTypeNamespace(), typeId), (Class)targetClass));
                }
            });
            om.setDefaultTyping((TypeResolverBuilder)typer);
        } else if (this.version == GraphSONVersion.V1_0 || this.version == GraphSONVersion.V2_0) {
            if (this.typeInfo == TypeInfo.PARTIAL_TYPES) {
                StdTypeResolverBuilder typer = new StdTypeResolverBuilder().init(JsonTypeInfo.Id.CLASS, null).inclusion(JsonTypeInfo.As.PROPERTY).typeProperty("@class");
                om.setDefaultTyping((TypeResolverBuilder)typer);
            }
        } else {
            throw new IllegalStateException("Unknown GraphSONVersion : " + (Object)((Object)this.version));
        }
        GraphSONSerializerProvider provider = new GraphSONSerializerProvider(this.version);
        om.setSerializerProvider((DefaultSerializerProvider)provider);
        if (this.normalize) {
            om.enable(SerializationFeature.ORDER_MAP_ENTRIES_BY_KEYS);
        }
        om.getFactory().disable(JsonGenerator.Feature.AUTO_CLOSE_TARGET);
        return om;
    }

    public GraphSONVersion getVersion() {
        return this.version;
    }

    public static Builder build() {
        return new Builder();
    }

    public static Builder build(GraphSONMapper mapper) {
        Builder builder = GraphSONMapper.build();
        builder.customModules = mapper.customModules;
        builder.version = mapper.version;
        builder.loadCustomModules = mapper.loadCustomSerializers;
        builder.normalize = mapper.normalize;
        builder.typeInfo = mapper.typeInfo;
        return builder;
    }

    public TypeInfo getTypeInfo() {
        return this.typeInfo;
    }

    private void registerJavaBaseTypes(GraphSONTypeIdResolver graphSONTypeIdResolver) {
        Arrays.asList(UUID.class, Class.class, Calendar.class, Date.class, TimeZone.class, Timestamp.class).forEach(e -> graphSONTypeIdResolver.addCustomType(String.format("%s:%s", "g", e.getSimpleName()), (Class)e));
    }

    public static class Builder
    implements Mapper.Builder<Builder> {
        private List<SimpleModule> customModules = new ArrayList<SimpleModule>();
        private boolean loadCustomModules = false;
        private boolean normalize = false;
        private List<IoRegistry> registries = new ArrayList<IoRegistry>();
        private GraphSONVersion version = GraphSONVersion.V2_0;
        private TypeInfo typeInfo = null;

        private Builder() {
        }

        @Override
        public Builder addRegistry(IoRegistry registry) {
            this.registries.add(registry);
            return this;
        }

        public Builder version(GraphSONVersion version) {
            this.version = version;
            return this;
        }

        public Builder version(String version) {
            this.version = GraphSONVersion.valueOf(version);
            return this;
        }

        public Builder addCustomModule(SimpleModule custom) {
            this.customModules.add(custom);
            return this;
        }

        public Builder loadCustomModules(boolean loadCustomModules) {
            this.loadCustomModules = loadCustomModules;
            return this;
        }

        public Builder normalize(boolean normalize) {
            this.normalize = normalize;
            return this;
        }

        public Builder typeInfo(TypeInfo typeInfo) {
            this.typeInfo = typeInfo;
            return this;
        }

        public GraphSONMapper create() {
            this.registries.forEach(registry -> {
                List<Pair<Class, SimpleModule>> simpleModules = registry.find(GraphSONIo.class, SimpleModule.class);
                simpleModules.stream().map(Pair::getValue1).forEach(this.customModules::add);
            });
            return new GraphSONMapper(this);
        }
    }
}

