/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.maven.plugin.tomcat7;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.StringTokenizer;
import org.apache.maven.artifact.manager.WagonManager;
import org.apache.maven.execution.MavenSession;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Component;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.settings.Proxy;
import org.apache.maven.wagon.authentication.AuthenticationInfo;
import org.apache.tomcat.maven.common.deployer.TomcatManager;
import org.apache.tomcat.maven.common.deployer.TomcatManagerException;
import org.apache.tomcat.maven.plugin.tomcat7.AbstractTomcat7Mojo;
import org.codehaus.plexus.util.StringUtils;

public abstract class AbstractCatalinaMojo
extends AbstractTomcat7Mojo {
    private String name = "Apache Tomcat Maven Plugin";
    private static final String DEFAULT_USERNAME = "admin";
    private static final String DEFAULT_PASSWORD = "";
    @Component
    private WagonManager wagonManager;
    @Component
    private MavenSession session;
    @Parameter(property="maven.tomcat.url", defaultValue="http://localhost:8080/manager/text", required=true)
    private URL url;
    @Parameter(property="maven.tomcat.server")
    private String server;
    @Parameter(property="maven.tomcat.charset", defaultValue="ISO-8859-1", required=true)
    private String charset;
    @Parameter(property="tomcat.username")
    private String username;
    @Parameter(property="tomcat.password")
    private String password;
    @Parameter(defaultValue="${plugin.version}", required=true, readonly=true)
    private String version;
    @Parameter(property="maven.tomcat.skip", defaultValue="false")
    private boolean skip;
    private TomcatManager manager;

    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().info((CharSequence)"skip execution");
            return;
        }
        try {
            this.invokeManager();
        }
        catch (TomcatManagerException exception) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractCatalinaMojo.managerError", new Object[]{exception.getMessage()}));
        }
        catch (IOException exception) {
            throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractCatalinaMojo.managerIOError"), (Exception)exception);
        }
    }

    protected abstract void invokeManager() throws MojoExecutionException, TomcatManagerException, IOException;

    protected TomcatManager getManager() throws MojoExecutionException {
        if (this.manager == null) {
            String password;
            String userName;
            if (this.server == null) {
                this.getLog().debug((CharSequence)this.messagesProvider.getMessage("AbstractCatalinaMojo.defaultAuth"));
                userName = DEFAULT_USERNAME;
                password = DEFAULT_PASSWORD;
            } else {
                AuthenticationInfo info = this.wagonManager.getAuthenticationInfo(this.server);
                if (info == null) {
                    throw new MojoExecutionException(this.messagesProvider.getMessage("AbstractCatalinaMojo.unknownServer", new Object[]{this.server}));
                }
                userName = info.getUserName();
                if (userName == null) {
                    this.getLog().debug((CharSequence)this.messagesProvider.getMessage("AbstractCatalinaMojo.defaultUserName"));
                    userName = DEFAULT_USERNAME;
                }
                if ((password = info.getPassword()) == null) {
                    this.getLog().debug((CharSequence)this.messagesProvider.getMessage("AbstractCatalinaMojo.defaultPassword"));
                    password = DEFAULT_PASSWORD;
                }
            }
            if (!StringUtils.isEmpty((String)this.username)) {
                userName = this.username;
                password = this.password == null ? DEFAULT_PASSWORD : this.password;
            }
            this.manager = new TomcatManager(this.url, userName, password, this.charset, this.settings.isInteractiveMode());
            this.manager.setUserAgent(this.name + "/" + this.version);
            Proxy proxy = this.session.getSettings().getActiveProxy();
            if (proxy != null && proxy.isActive()) {
                this.getLog().debug((CharSequence)("proxy: " + proxy.getHost() + ":" + proxy.getPort()));
                this.manager.setProxy(proxy);
            }
        }
        return this.manager;
    }

    protected URL getURL() {
        return this.url;
    }

    protected String getPath() {
        return this.path;
    }

    protected URL getDeployedURL() throws MalformedURLException {
        return new URL(this.getURL(), this.getPath());
    }

    protected void log(String string) {
        StringTokenizer tokenizer = new StringTokenizer(string, "\n\r");
        while (tokenizer.hasMoreTokens()) {
            this.getLog().info((CharSequence)tokenizer.nextToken());
        }
    }
}

