/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tomcat.util.http;

import java.text.DateFormat;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.BitSet;
import java.util.Date;
import java.util.Locale;
import java.util.TimeZone;
import javax.servlet.http.Cookie;

public class SetCookieSupport {
    private static final boolean ALWAYS_ADD_EXPIRES;
    private static final BitSet ALLOWED_WITHOUT_QUOTES;
    private static final String OLD_COOKIE_PATTERN = "EEE, dd-MMM-yyyy HH:mm:ss z";
    private static final ThreadLocal<DateFormat> OLD_COOKIE_FORMAT;
    private static final String ancientDate;

    public static String generateHeader(Cookie cookie) {
        int maxAge;
        int version = cookie.getVersion();
        String value = cookie.getValue();
        String path = cookie.getPath();
        String domain = cookie.getDomain();
        String comment = cookie.getComment();
        if (version == 0 && (SetCookieSupport.needsQuotes(value) || comment != null || SetCookieSupport.needsQuotes(path) || SetCookieSupport.needsQuotes(domain))) {
            version = 1;
        }
        StringBuffer buf = new StringBuffer();
        buf.append(cookie.getName());
        buf.append("=");
        SetCookieSupport.maybeQuote(buf, value);
        if (version == 1) {
            buf.append("; Version=1");
            if (comment != null) {
                buf.append("; Comment=");
                SetCookieSupport.maybeQuote(buf, comment);
            }
        }
        if (domain != null) {
            buf.append("; Domain=");
            SetCookieSupport.maybeQuote(buf, domain);
        }
        if ((maxAge = cookie.getMaxAge()) >= 0) {
            if (version > 0) {
                buf.append("; Max-Age=");
                buf.append(maxAge);
            }
            if (version == 0 || ALWAYS_ADD_EXPIRES) {
                buf.append("; Expires=");
                if (maxAge == 0) {
                    buf.append(ancientDate);
                } else {
                    OLD_COOKIE_FORMAT.get().format(new Date(System.currentTimeMillis() + (long)maxAge * 1000L), buf, new FieldPosition(0));
                }
            }
        }
        if (path != null) {
            buf.append("; Path=");
            SetCookieSupport.maybeQuote(buf, path);
        }
        if (cookie.getSecure()) {
            buf.append("; Secure");
        }
        if (cookie.isHttpOnly()) {
            buf.append("; HttpOnly");
        }
        return buf.toString();
    }

    private static void maybeQuote(StringBuffer buf, String value) {
        if (value == null || value.length() == 0) {
            buf.append("\"\"");
        } else if (SetCookieSupport.alreadyQuoted(value)) {
            buf.append('\"');
            SetCookieSupport.escapeDoubleQuotes(buf, value, 1, value.length() - 1);
            buf.append('\"');
        } else if (SetCookieSupport.needsQuotes(value)) {
            buf.append('\"');
            SetCookieSupport.escapeDoubleQuotes(buf, value, 0, value.length());
            buf.append('\"');
        } else {
            buf.append(value);
        }
    }

    private static void escapeDoubleQuotes(StringBuffer b, String s, int beginIndex, int endIndex) {
        if (s.indexOf(34) == -1 && s.indexOf(92) == -1) {
            b.append(s);
            return;
        }
        for (int i = beginIndex; i < endIndex; ++i) {
            char c = s.charAt(i);
            if (c == '\\') {
                b.append('\\').append('\\');
                continue;
            }
            if (c == '\"') {
                b.append('\\').append('\"');
                continue;
            }
            b.append(c);
        }
    }

    private static boolean needsQuotes(String value) {
        if (value == null) {
            return false;
        }
        int i = 0;
        int len = value.length();
        if (SetCookieSupport.alreadyQuoted(value)) {
            ++i;
            --len;
        }
        while (i < len) {
            char c = value.charAt(i);
            if (c < ' ' && c != '\t' || c >= '\u007f') {
                throw new IllegalArgumentException("Control character in cookie value or attribute.");
            }
            if (!ALLOWED_WITHOUT_QUOTES.get(c)) {
                return true;
            }
            ++i;
        }
        return false;
    }

    private static boolean alreadyQuoted(String value) {
        return value.length() >= 2 && value.charAt(0) == '\"' && value.charAt(value.length() - 1) == '\"';
    }

    static {
        String alwaysAddExpires = System.getProperty("org.apache.tomcat.util.http.ServerCookie.ALWAYS_ADD_EXPIRES");
        ALWAYS_ADD_EXPIRES = alwaysAddExpires != null ? Boolean.valueOf(alwaysAddExpires) : !Boolean.getBoolean("org.apache.catalina.STRICT_SERVLET_COMPLIANCE");
        boolean allowSeparatorsInV0 = Boolean.getBoolean("org.apache.tomcat.util.http.ServerCookie.ALLOW_HTTP_SEPARATORS_IN_V0");
        String separators = allowSeparatorsInV0 ? ",; " : "()<>@,;:\\\"/[]?={} \t";
        ALLOWED_WITHOUT_QUOTES = new BitSet(128);
        ALLOWED_WITHOUT_QUOTES.set(32, 127);
        for (char ch : separators.toCharArray()) {
            ALLOWED_WITHOUT_QUOTES.clear(ch);
        }
        if (!allowSeparatorsInV0) {
            boolean allowSlash;
            String prop = System.getProperty("org.apache.tomcat.util.http.ServerCookie.FWD_SLASH_IS_SEPARATOR");
            if (prop != null) {
                allowSlash = !Boolean.parseBoolean(prop);
            } else {
                boolean bl = allowSlash = !Boolean.getBoolean("org.apache.catalina.STRICT_SERVLET_COMPLIANCE");
            }
            if (allowSlash) {
                ALLOWED_WITHOUT_QUOTES.set(47);
            }
        }
        OLD_COOKIE_FORMAT = new ThreadLocal<DateFormat>(){

            @Override
            protected DateFormat initialValue() {
                SimpleDateFormat df = new SimpleDateFormat(SetCookieSupport.OLD_COOKIE_PATTERN, Locale.US);
                df.setTimeZone(TimeZone.getTimeZone("GMT"));
                return df;
            }
        };
        ancientDate = OLD_COOKIE_FORMAT.get().format(new Date(10000L));
    }
}

