/*
 * Decompiled with CFR 0.152.
 */
package org.apache.coyote.http11;

import java.io.IOException;
import javax.servlet.http.HttpUpgradeHandler;
import org.apache.coyote.AbstractProtocol;
import org.apache.coyote.Processor;
import org.apache.coyote.http11.AbstractHttp11Protocol;
import org.apache.coyote.http11.Http11AprProcessor;
import org.apache.coyote.http11.upgrade.AprProcessor;
import org.apache.juli.logging.Log;
import org.apache.juli.logging.LogFactory;
import org.apache.tomcat.util.net.AbstractEndpoint;
import org.apache.tomcat.util.net.AprEndpoint;
import org.apache.tomcat.util.net.SocketStatus;
import org.apache.tomcat.util.net.SocketWrapper;

public class Http11AprProtocol
extends AbstractHttp11Protocol<Long> {
    private static final Log log = LogFactory.getLog(Http11AprProtocol.class);
    private final Http11ConnectionHandler cHandler;

    @Override
    protected Log getLog() {
        return log;
    }

    @Override
    protected AbstractEndpoint.Handler getHandler() {
        return this.cHandler;
    }

    @Override
    public boolean isAprRequired() {
        return true;
    }

    public Http11AprProtocol() {
        this.endpoint = new AprEndpoint();
        this.cHandler = new Http11ConnectionHandler(this);
        ((AprEndpoint)this.endpoint).setHandler(this.cHandler);
        this.setSoLinger(-1);
        this.setSoTimeout(60000);
        this.setTcpNoDelay(true);
    }

    public boolean getUseSendfile() {
        return this.endpoint.getUseSendfile();
    }

    public void setUseSendfile(boolean useSendfile) {
        ((AprEndpoint)this.endpoint).setUseSendfile(useSendfile);
    }

    public int getPollTime() {
        return ((AprEndpoint)this.endpoint).getPollTime();
    }

    public void setPollTime(int pollTime) {
        ((AprEndpoint)this.endpoint).setPollTime(pollTime);
    }

    public void setPollerSize(int pollerSize) {
        this.endpoint.setMaxConnections(pollerSize);
    }

    public int getPollerSize() {
        return this.endpoint.getMaxConnections();
    }

    public int getSendfileSize() {
        return ((AprEndpoint)this.endpoint).getSendfileSize();
    }

    public void setSendfileSize(int sendfileSize) {
        ((AprEndpoint)this.endpoint).setSendfileSize(sendfileSize);
    }

    public void setSendfileThreadCount(int sendfileThreadCount) {
        ((AprEndpoint)this.endpoint).setSendfileThreadCount(sendfileThreadCount);
    }

    public int getSendfileThreadCount() {
        return ((AprEndpoint)this.endpoint).getSendfileThreadCount();
    }

    public boolean getDeferAccept() {
        return ((AprEndpoint)this.endpoint).getDeferAccept();
    }

    public void setDeferAccept(boolean deferAccept) {
        ((AprEndpoint)this.endpoint).setDeferAccept(deferAccept);
    }

    public String getSSLProtocol() {
        return ((AprEndpoint)this.endpoint).getSSLProtocol();
    }

    public void setSSLProtocol(String SSLProtocol) {
        ((AprEndpoint)this.endpoint).setSSLProtocol(SSLProtocol);
    }

    public String getSSLPassword() {
        return ((AprEndpoint)this.endpoint).getSSLPassword();
    }

    public void setSSLPassword(String SSLPassword) {
        ((AprEndpoint)this.endpoint).setSSLPassword(SSLPassword);
    }

    public String getSSLCipherSuite() {
        return ((AprEndpoint)this.endpoint).getSSLCipherSuite();
    }

    public void setSSLCipherSuite(String SSLCipherSuite) {
        ((AprEndpoint)this.endpoint).setSSLCipherSuite(SSLCipherSuite);
    }

    public String[] getCiphersUsed() {
        return this.endpoint.getCiphersUsed();
    }

    public boolean getSSLHonorCipherOrder() {
        return ((AprEndpoint)this.endpoint).getSSLHonorCipherOrder();
    }

    public void setSSLHonorCipherOrder(boolean SSLHonorCipherOrder) {
        ((AprEndpoint)this.endpoint).setSSLHonorCipherOrder(SSLHonorCipherOrder);
    }

    public String getSSLCertificateFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateFile();
    }

    public void setSSLCertificateFile(String SSLCertificateFile) {
        ((AprEndpoint)this.endpoint).setSSLCertificateFile(SSLCertificateFile);
    }

    public String getSSLCertificateKeyFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateKeyFile();
    }

    public void setSSLCertificateKeyFile(String SSLCertificateKeyFile) {
        ((AprEndpoint)this.endpoint).setSSLCertificateKeyFile(SSLCertificateKeyFile);
    }

    public String getSSLCertificateChainFile() {
        return ((AprEndpoint)this.endpoint).getSSLCertificateChainFile();
    }

    public void setSSLCertificateChainFile(String SSLCertificateChainFile) {
        ((AprEndpoint)this.endpoint).setSSLCertificateChainFile(SSLCertificateChainFile);
    }

    public String getSSLCACertificatePath() {
        return ((AprEndpoint)this.endpoint).getSSLCACertificatePath();
    }

    public void setSSLCACertificatePath(String SSLCACertificatePath) {
        ((AprEndpoint)this.endpoint).setSSLCACertificatePath(SSLCACertificatePath);
    }

    public String getSSLCACertificateFile() {
        return ((AprEndpoint)this.endpoint).getSSLCACertificateFile();
    }

    public void setSSLCACertificateFile(String SSLCACertificateFile) {
        ((AprEndpoint)this.endpoint).setSSLCACertificateFile(SSLCACertificateFile);
    }

    public String getSSLCARevocationPath() {
        return ((AprEndpoint)this.endpoint).getSSLCARevocationPath();
    }

    public void setSSLCARevocationPath(String SSLCARevocationPath) {
        ((AprEndpoint)this.endpoint).setSSLCARevocationPath(SSLCARevocationPath);
    }

    public String getSSLCARevocationFile() {
        return ((AprEndpoint)this.endpoint).getSSLCARevocationFile();
    }

    public void setSSLCARevocationFile(String SSLCARevocationFile) {
        ((AprEndpoint)this.endpoint).setSSLCARevocationFile(SSLCARevocationFile);
    }

    public String getSSLVerifyClient() {
        return ((AprEndpoint)this.endpoint).getSSLVerifyClient();
    }

    public void setSSLVerifyClient(String SSLVerifyClient) {
        ((AprEndpoint)this.endpoint).setSSLVerifyClient(SSLVerifyClient);
    }

    public int getSSLVerifyDepth() {
        return ((AprEndpoint)this.endpoint).getSSLVerifyDepth();
    }

    public void setSSLVerifyDepth(int SSLVerifyDepth) {
        ((AprEndpoint)this.endpoint).setSSLVerifyDepth(SSLVerifyDepth);
    }

    public boolean getSSLDisableCompression() {
        return ((AprEndpoint)this.endpoint).getSSLDisableCompression();
    }

    public void setSSLDisableCompression(boolean disable) {
        ((AprEndpoint)this.endpoint).setSSLDisableCompression(disable);
    }

    @Override
    protected String getNamePrefix() {
        return "http-apr";
    }

    @Override
    public void start() throws Exception {
        super.start();
        if (this.npnHandler != null) {
            long sslCtx = ((AprEndpoint)this.endpoint).getJniSslContext();
            this.npnHandler.init(this.endpoint, sslCtx, this.getAdapter());
        }
    }

    protected static class Http11ConnectionHandler
    extends AbstractProtocol.AbstractConnectionHandler<Long, Http11AprProcessor>
    implements AprEndpoint.Handler {
        protected Http11AprProtocol proto;

        Http11ConnectionHandler(Http11AprProtocol proto) {
            this.proto = proto;
        }

        @Override
        protected AbstractProtocol<Long> getProtocol() {
            return this.proto;
        }

        @Override
        protected Log getLog() {
            return log;
        }

        @Override
        public void release(SocketWrapper<Long> socket, Processor<Long> processor, boolean isSocketClosing, boolean addToPoller) {
            processor.recycle(isSocketClosing);
            this.recycledProcessors.push(processor);
            if (addToPoller && this.proto.endpoint.isRunning()) {
                ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket(), this.proto.endpoint.getKeepAliveTimeout(), true, false);
            }
        }

        @Override
        public AbstractEndpoint.Handler.SocketState process(SocketWrapper<Long> socket, SocketStatus status) {
            if (this.proto.npnHandler != null) {
                AbstractEndpoint.Handler.SocketState socketState;
                Processor processor = null;
                if (status == SocketStatus.OPEN_READ) {
                    processor = (Processor)this.connections.get(socket.getSocket());
                }
                if (processor == null && ((socketState = this.proto.npnHandler.process(socket, status)) == AbstractEndpoint.Handler.SocketState.CLOSED || socketState == AbstractEndpoint.Handler.SocketState.LONG)) {
                    return socketState;
                }
            }
            return super.process(socket, status);
        }

        @Override
        protected void initSsl(SocketWrapper<Long> socket, Processor<Long> processor) {
        }

        @Override
        protected void longPoll(SocketWrapper<Long> socket, Processor<Long> processor) {
            if (processor.isAsync()) {
                socket.setAsync(true);
            } else if (processor.isComet()) {
                if (this.proto.endpoint.isRunning()) {
                    socket.setComet(true);
                    ((AprEndpoint)this.proto.endpoint).getPoller().add(socket.getSocket(), this.proto.endpoint.getSoTimeout(), true, false);
                } else {
                    ((AprEndpoint)this.proto.endpoint).processSocket(socket.getSocket(), SocketStatus.STOP);
                }
            } else {
                AprEndpoint.Poller p = ((AprEndpoint)this.proto.endpoint).getPoller();
                if (p == null) {
                    this.release(socket, processor, true, false);
                } else {
                    p.add(socket.getSocket(), -1, true, false);
                }
            }
        }

        @Override
        protected Http11AprProcessor createProcessor() {
            Http11AprProcessor processor = new Http11AprProcessor(this.proto.getMaxHttpHeaderSize(), (AprEndpoint)this.proto.endpoint, this.proto.getMaxTrailerSize(), this.proto.getMaxExtensionSize(), this.proto.getMaxSwallowSize());
            this.proto.configureProcessor(processor);
            processor.setClientCertProvider(this.proto.getClientCertProvider());
            this.register(processor);
            return processor;
        }

        @Override
        protected Processor<Long> createUpgradeProcessor(SocketWrapper<Long> socket, HttpUpgradeHandler httpUpgradeProcessor) throws IOException {
            return new AprProcessor(socket, httpUpgradeProcessor, (AprEndpoint)this.proto.endpoint, this.proto.getUpgradeAsyncWriteBufferSize());
        }
    }
}

