/*
 * Decompiled with CFR 0.152.
 */
package org.apache.juli;

import java.io.File;
import java.io.FileInputStream;
import java.io.FilePermission;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessControlException;
import java.security.AccessController;
import java.security.Permission;
import java.security.PrivilegedAction;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.WeakHashMap;
import java.util.concurrent.ConcurrentHashMap;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.Logger;

public class ClassLoaderLogManager
extends LogManager {
    public static final String DEBUG_PROPERTY = ClassLoaderLogManager.class.getName() + ".debug";
    protected final Map<ClassLoader, ClassLoaderLogInfo> classLoaderLoggers = new WeakHashMap<ClassLoader, ClassLoaderLogInfo>();
    protected ThreadLocal<String> prefix = new ThreadLocal();
    protected volatile boolean useShutdownHook = true;

    public ClassLoaderLogManager() {
        try {
            Runtime.getRuntime().addShutdownHook(new Cleaner());
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    public boolean isUseShutdownHook() {
        return this.useShutdownHook;
    }

    public void setUseShutdownHook(boolean useShutdownHook) {
        this.useShutdownHook = useShutdownHook;
    }

    @Override
    public synchronized boolean addLogger(final Logger logger) {
        String useParentHandlersString;
        int dotIndex;
        String loggerName = logger.getName();
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderLogInfo info = this.getClassLoaderInfo(classLoader);
        if (info.loggers.containsKey(loggerName)) {
            return false;
        }
        info.loggers.put(loggerName, logger);
        final String levelString = this.getProperty(loggerName + ".level");
        if (levelString != null) {
            try {
                AccessController.doPrivileged(new PrivilegedAction<Void>(){

                    @Override
                    public Void run() {
                        logger.setLevel(Level.parse(levelString.trim()));
                        return null;
                    }
                });
            }
            catch (IllegalArgumentException e) {
                // empty catch block
            }
        }
        if ((dotIndex = loggerName.lastIndexOf(46)) >= 0) {
            String parentName = loggerName.substring(0, dotIndex);
            Logger.getLogger(parentName);
        }
        LogNode node = info.rootNode.findNode(loggerName);
        node.logger = logger;
        Logger parentLogger = node.findParentLogger();
        if (parentLogger != null) {
            ClassLoaderLogManager.doSetParentLogger(logger, parentLogger);
        }
        node.setParentLogger(logger);
        String handlers = this.getProperty(loggerName + ".handlers");
        if (handlers != null) {
            logger.setUseParentHandlers(false);
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                String handlerName = tok.nextToken().trim();
                Handler handler = null;
                for (ClassLoader current = classLoader; current != null && ((info = this.classLoaderLoggers.get(current)) == null || (handler = info.handlers.get(handlerName)) == null); current = current.getParent()) {
                }
                if (handler == null) continue;
                logger.addHandler(handler);
            }
        }
        if (Boolean.valueOf(useParentHandlersString = this.getProperty(loggerName + ".useParentHandlers")).booleanValue()) {
            logger.setUseParentHandlers(true);
        }
        return true;
    }

    @Override
    public synchronized Logger getLogger(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return this.getClassLoaderInfo((ClassLoader)classLoader).loggers.get(name);
    }

    @Override
    public synchronized Enumeration<String> getLoggerNames() {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        return Collections.enumeration(this.getClassLoaderInfo((ClassLoader)classLoader).loggers.keySet());
    }

    @Override
    public String getProperty(String name) {
        String prefix = this.prefix.get();
        String result = null;
        if (prefix != null) {
            result = this.findProperty(prefix + name);
        }
        if (result == null) {
            result = this.findProperty(name);
        }
        if (result != null) {
            result = this.replace(result);
        }
        return result;
    }

    private String findProperty(String name) {
        ClassLoader classLoader = Thread.currentThread().getContextClassLoader();
        ClassLoaderLogInfo info = this.getClassLoaderInfo(classLoader);
        String result = info.props.getProperty(name);
        if (result == null && info.props.isEmpty()) {
            for (ClassLoader current = classLoader.getParent(); current != null && ((info = this.classLoaderLoggers.get(current)) == null || (result = info.props.getProperty(name)) == null && info.props.isEmpty()); current = current.getParent()) {
            }
            if (result == null) {
                result = super.getProperty(name);
            }
        }
        return result;
    }

    @Override
    public void readConfiguration() throws IOException, SecurityException {
        this.checkAccess();
        this.readConfiguration(Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void readConfiguration(InputStream is) throws IOException, SecurityException {
        this.checkAccess();
        this.reset();
        this.readConfiguration(is, Thread.currentThread().getContextClassLoader());
    }

    @Override
    public void reset() throws SecurityException {
        Thread thread = Thread.currentThread();
        if (thread.getClass().getName().startsWith("java.util.logging.LogManager$")) {
            return;
        }
        ClassLoader classLoader = thread.getContextClassLoader();
        ClassLoaderLogInfo clLogInfo = this.getClassLoaderInfo(classLoader);
        this.resetLoggers(clLogInfo);
        super.reset();
    }

    public void shutdown() {
        for (ClassLoaderLogInfo clLogInfo : this.classLoaderLoggers.values()) {
            this.resetLoggers(clLogInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void resetLoggers(ClassLoaderLogInfo clLogInfo) {
        ClassLoaderLogInfo classLoaderLogInfo = clLogInfo;
        synchronized (classLoaderLogInfo) {
            for (Logger logger : clLogInfo.loggers.values()) {
                Handler[] handlers;
                for (Handler handler : handlers = logger.getHandlers()) {
                    logger.removeHandler(handler);
                }
            }
            for (Handler handler : clLogInfo.handlers.values()) {
                try {
                    handler.close();
                }
                catch (Exception e) {}
            }
            clLogInfo.handlers.clear();
        }
    }

    protected ClassLoaderLogInfo getClassLoaderInfo(ClassLoader classLoader) {
        ClassLoaderLogInfo info;
        if (classLoader == null) {
            classLoader = ClassLoader.getSystemClassLoader();
        }
        if ((info = this.classLoaderLoggers.get(classLoader)) == null) {
            final ClassLoader classLoaderParam = classLoader;
            AccessController.doPrivileged(new PrivilegedAction<Void>(){

                @Override
                public Void run() {
                    try {
                        ClassLoaderLogManager.this.readConfiguration(classLoaderParam);
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                    return null;
                }
            });
            info = this.classLoaderLoggers.get(classLoader);
        }
        return info;
    }

    protected void readConfiguration(ClassLoader classLoader) throws IOException {
        ClassLoaderLogInfo info;
        InputStream is;
        block19: {
            is = null;
            try {
                if (classLoader instanceof URLClassLoader) {
                    URL logConfig = ((URLClassLoader)classLoader).findResource("logging.properties");
                    if (null != logConfig) {
                        if (Boolean.getBoolean(DEBUG_PROPERTY)) {
                            System.err.println(this.getClass().getName() + ".readConfiguration(): " + "Found logging.properties at " + logConfig);
                        }
                        is = classLoader.getResourceAsStream("logging.properties");
                    } else if (Boolean.getBoolean(DEBUG_PROPERTY)) {
                        System.err.println(this.getClass().getName() + ".readConfiguration(): " + "Found no logging.properties");
                    }
                }
            }
            catch (AccessControlException ace) {
                Logger log;
                info = this.classLoaderLoggers.get(ClassLoader.getSystemClassLoader());
                if (info == null || (log = info.loggers.get("")) == null) break block19;
                Permission perm = ace.getPermission();
                if (perm instanceof FilePermission && perm.getActions().equals("read")) {
                    log.warning("Reading " + perm.getName() + " is not permitted. See \"per context logging\" in the default catalina.policy file.");
                }
                log.warning("Reading logging.properties is not permitted in some context. See \"per context logging\" in the default catalina.policy file.");
                log.warning("Original error was: " + ace.getMessage());
            }
        }
        if (is == null && classLoader == ClassLoader.getSystemClassLoader()) {
            String configFileStr = System.getProperty("java.util.logging.config.file");
            if (configFileStr != null) {
                try {
                    is = new FileInputStream(this.replace(configFileStr));
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
            if (is == null) {
                File defaultFile = new File(new File(System.getProperty("java.home"), "lib"), "logging.properties");
                try {
                    is = new FileInputStream(defaultFile);
                }
                catch (IOException e) {
                    // empty catch block
                }
            }
        }
        RootLogger localRootLogger = new RootLogger();
        if (is == null) {
            ClassLoaderLogInfo info2 = null;
            for (ClassLoader current = classLoader.getParent(); current != null && info2 == null; current = current.getParent()) {
                info2 = this.getClassLoaderInfo(current);
            }
            if (info2 != null) {
                localRootLogger.setParent(info2.rootNode.logger);
            }
        }
        info = new ClassLoaderLogInfo(new LogNode(null, localRootLogger));
        this.classLoaderLoggers.put(classLoader, info);
        if (is != null) {
            this.readConfiguration(is, classLoader);
        }
        this.addLogger(localRootLogger);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void readConfiguration(InputStream is, ClassLoader classLoader) throws IOException {
        ClassLoaderLogInfo info = this.classLoaderLoggers.get(classLoader);
        try {
            info.props.load(is);
        }
        catch (IOException e) {
            System.err.println("Configuration error");
            e.printStackTrace();
        }
        finally {
            try {
                is.close();
            }
            catch (IOException ioe) {}
        }
        String rootHandlers = info.props.getProperty(".handlers");
        String handlers = info.props.getProperty("handlers");
        Logger localRootLogger = info.rootNode.logger;
        if (handlers != null) {
            StringTokenizer tok = new StringTokenizer(handlers, ",");
            while (tok.hasMoreTokens()) {
                int pos;
                String handlerName;
                String handlerClassName = handlerName = tok.nextToken().trim();
                String prefix = "";
                if (handlerClassName.length() <= 0) continue;
                if (Character.isDigit(handlerClassName.charAt(0)) && (pos = handlerClassName.indexOf(46)) >= 0) {
                    prefix = handlerClassName.substring(0, pos + 1);
                    handlerClassName = handlerClassName.substring(pos + 1);
                }
                try {
                    this.prefix.set(prefix);
                    Handler handler = (Handler)classLoader.loadClass(handlerClassName).newInstance();
                    this.prefix.set(null);
                    info.handlers.put(handlerName, handler);
                    if (rootHandlers != null) continue;
                    localRootLogger.addHandler(handler);
                }
                catch (Exception e) {
                    System.err.println("Handler error");
                    e.printStackTrace();
                }
            }
        }
    }

    protected static void doSetParentLogger(final Logger logger, final Logger parent) {
        AccessController.doPrivileged(new PrivilegedAction<Void>(){

            @Override
            public Void run() {
                logger.setParent(parent);
                return null;
            }
        });
    }

    protected String replace(String str) {
        String result = str;
        int pos_start = str.indexOf("${");
        if (pos_start >= 0) {
            StringBuilder builder = new StringBuilder();
            int pos_end = -1;
            while (pos_start >= 0) {
                String replacement;
                builder.append(str, pos_end + 1, pos_start);
                pos_end = str.indexOf(125, pos_start + 2);
                if (pos_end < 0) {
                    pos_end = pos_start - 1;
                    break;
                }
                String propName = str.substring(pos_start + 2, pos_end);
                String string = replacement = propName.length() > 0 ? System.getProperty(propName) : null;
                if (replacement != null) {
                    builder.append(replacement);
                } else {
                    builder.append(str, pos_start, pos_end + 1);
                }
                pos_start = str.indexOf("${", pos_end + 1);
            }
            builder.append(str, pos_end + 1, str.length());
            result = builder.toString();
        }
        return result;
    }

    protected static class RootLogger
    extends Logger {
        public RootLogger() {
            super("", null);
        }
    }

    protected static final class ClassLoaderLogInfo {
        final LogNode rootNode;
        final Map<String, Logger> loggers = new ConcurrentHashMap<String, Logger>();
        final Map<String, Handler> handlers = new HashMap<String, Handler>();
        final Properties props = new Properties();

        ClassLoaderLogInfo(LogNode rootNode) {
            this.rootNode = rootNode;
        }
    }

    protected static final class LogNode {
        Logger logger;
        protected final Map<String, LogNode> children = new HashMap<String, LogNode>();
        protected final LogNode parent;

        LogNode(LogNode parent, Logger logger) {
            this.parent = parent;
            this.logger = logger;
        }

        LogNode(LogNode parent) {
            this(parent, null);
        }

        LogNode findNode(String name) {
            LogNode currentNode = this;
            if (this.logger.getName().equals(name)) {
                return this;
            }
            while (name != null) {
                String nextName;
                int dotIndex = name.indexOf(46);
                if (dotIndex < 0) {
                    nextName = name;
                    name = null;
                } else {
                    nextName = name.substring(0, dotIndex);
                    name = name.substring(dotIndex + 1);
                }
                LogNode childNode = currentNode.children.get(nextName);
                if (childNode == null) {
                    childNode = new LogNode(currentNode);
                    currentNode.children.put(nextName, childNode);
                }
                currentNode = childNode;
            }
            return currentNode;
        }

        Logger findParentLogger() {
            Logger logger = null;
            LogNode node = this.parent;
            while (node != null && logger == null) {
                logger = node.logger;
                node = node.parent;
            }
            return logger;
        }

        void setParentLogger(Logger parent) {
            for (LogNode childNode : this.children.values()) {
                if (childNode.logger == null) {
                    childNode.setParentLogger(parent);
                    continue;
                }
                ClassLoaderLogManager.doSetParentLogger(childNode.logger, parent);
            }
        }
    }

    private final class Cleaner
    extends Thread {
        private Cleaner() {
        }

        @Override
        public void run() {
            if (ClassLoaderLogManager.this.useShutdownHook) {
                ClassLoaderLogManager.this.shutdown();
            }
        }
    }
}

