/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.provider;

import jakarta.activation.DataHandler;
import jakarta.xml.bind.attachment.AttachmentMarshaller;
import java.util.Collection;
import java.util.UUID;
import org.apache.cxf.attachment.AttachmentImpl;
import org.apache.cxf.attachment.AttachmentUtil;
import org.apache.cxf.message.Attachment;

public class JAXBAttachmentMarshaller
extends AttachmentMarshaller {
    private int threshold = 5120;
    private Collection<Attachment> atts;
    private boolean isXop;

    public JAXBAttachmentMarshaller(Collection<Attachment> attachments, Integer mtomThreshold) {
        if (mtomThreshold != null) {
            this.threshold = mtomThreshold;
        }
        this.atts = attachments;
        this.isXop = attachments != null;
    }

    public String addMtomAttachment(byte[] data, int offset, int length, String mimeType, String elementNS, String elementLocalName) {
        Attachment att = AttachmentUtil.createMtomAttachment(this.isXop, mimeType, elementNS, data, offset, length, this.threshold);
        if (att != null) {
            this.atts.add(att);
            return "cid:" + att.getId();
        }
        return null;
    }

    public String addMtomAttachment(DataHandler handler, String elementNS, String elementLocalName) {
        Attachment att = AttachmentUtil.createMtomAttachmentFromDH(this.isXop, handler, elementNS, this.threshold);
        if (att != null) {
            this.atts.add(att);
            return "cid:" + att.getId();
        }
        return null;
    }

    public String addSwaRefAttachment(DataHandler handler) {
        String id = UUID.randomUUID() + "@apache.org";
        AttachmentImpl att = new AttachmentImpl(id, handler);
        att.setXOP(false);
        this.atts.add(att);
        return id;
    }

    public boolean isXOPPackage() {
        return this.isXop;
    }
}

