/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.jaxrs.validation;

import jakarta.validation.ValidationException;
import jakarta.ws.rs.container.ContainerRequestContext;
import jakarta.ws.rs.container.ContainerRequestFilter;
import jakarta.ws.rs.ext.Provider;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.List;
import org.apache.cxf.interceptor.InterceptorChain;
import org.apache.cxf.jaxrs.validation.ValidationUtils;
import org.apache.cxf.logging.FaultListener;
import org.apache.cxf.logging.NoOpFaultListener;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.PhaseInterceptorChain;
import org.apache.cxf.validation.BeanValidationInInterceptor;

@Provider
public class JAXRSBeanValidationInInterceptor
extends BeanValidationInInterceptor
implements ContainerRequestFilter {
    public JAXRSBeanValidationInInterceptor() {
    }

    public JAXRSBeanValidationInInterceptor(String phase) {
        super(phase);
    }

    @Override
    protected Object getServiceObject(Message message) {
        return ValidationUtils.getResourceInstance(message);
    }

    @Override
    protected void handleValidation(Message message, Object resourceInstance, Method method, List<Object> arguments) {
        try {
            super.handleValidation(message, resourceInstance, method, arguments);
        }
        catch (ValidationException ex) {
            message.put(FaultListener.class.getName(), new NoOpFaultListener());
            throw ex;
        }
    }

    public void filter(ContainerRequestContext context) throws IOException {
        InterceptorChain chain = PhaseInterceptorChain.getCurrentMessage().getInterceptorChain();
        chain.add(this);
    }
}

