/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.management.counters;

import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.ObjectName;
import org.apache.cxf.management.counters.Counter;
import org.apache.cxf.management.counters.MessageHandlingTimeRecorder;
import org.apache.cxf.management.counters.ResponseTimeCounterMBean;
import org.apache.cxf.message.FaultMode;

public class ResponseTimeCounter
implements ResponseTimeCounterMBean,
Counter {
    private ObjectName objectName;
    private final AtomicInteger invocations = new AtomicInteger();
    private final AtomicInteger checkedApplicationFaults = new AtomicInteger();
    private final AtomicInteger unCheckedApplicationFaults = new AtomicInteger();
    private final AtomicInteger runtimeFaults = new AtomicInteger();
    private final AtomicInteger logicalRuntimeFaults = new AtomicInteger();
    private final AtomicLong totalHandlingTime = new AtomicLong();
    private final ReentrantLock write = new ReentrantLock();
    private final AtomicLong maxHandlingTime = new AtomicLong();
    private final AtomicLong minHandlingTime = new AtomicLong();
    private final AtomicLong averageProcessingTime = new AtomicLong();
    private boolean enabled = true;

    public ResponseTimeCounter(ObjectName on) {
        this.objectName = on;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void increase(MessageHandlingTimeRecorder mhtr) {
        if (!this.enabled) {
            return;
        }
        long handlingTime = 0L;
        if (mhtr.isOneWay()) {
            if (mhtr.getEndTime() > 0L) {
                handlingTime = mhtr.getHandlingTime();
            }
        } else {
            handlingTime = mhtr.getHandlingTime();
        }
        this.write.lock();
        try {
            FaultMode faultMode = mhtr.getFaultMode();
            this.invocations.getAndIncrement();
            if (null != faultMode) {
                switch (faultMode) {
                    case CHECKED_APPLICATION_FAULT: {
                        this.checkedApplicationFaults.incrementAndGet();
                        break;
                    }
                    case LOGICAL_RUNTIME_FAULT: {
                        this.logicalRuntimeFaults.incrementAndGet();
                        break;
                    }
                    case RUNTIME_FAULT: {
                        this.runtimeFaults.incrementAndGet();
                        break;
                    }
                    case UNCHECKED_APPLICATION_FAULT: {
                        this.unCheckedApplicationFaults.incrementAndGet();
                        break;
                    }
                    default: {
                        this.runtimeFaults.incrementAndGet();
                    }
                }
            }
            this.totalHandlingTime.addAndGet(handlingTime);
            this.averageProcessingTime.getAndSet(this.totalHandlingTime.get() / (long)this.invocations.get());
        }
        finally {
            this.write.unlock();
        }
        this.updateMax(handlingTime);
        this.updateMin(handlingTime);
    }

    @Override
    public void reset() {
        this.invocations.set(0);
        this.checkedApplicationFaults.set(0);
        this.unCheckedApplicationFaults.set(0);
        this.runtimeFaults.set(0);
        this.logicalRuntimeFaults.set(0);
        this.totalHandlingTime.set(0L);
        this.maxHandlingTime.set(0L);
        this.minHandlingTime.set(0L);
        this.averageProcessingTime.set(0L);
    }

    @Override
    public ObjectName getObjectName() {
        return this.objectName;
    }

    @Override
    public Number getAvgResponseTime() {
        return this.averageProcessingTime.get();
    }

    @Override
    public Number getMaxResponseTime() {
        return this.maxHandlingTime.get();
    }

    @Override
    public Number getMinResponseTime() {
        return this.minHandlingTime.get();
    }

    @Override
    public Number getNumInvocations() {
        return this.invocations.get();
    }

    @Override
    public Number getNumCheckedApplicationFaults() {
        return this.checkedApplicationFaults.get();
    }

    @Override
    public Number getNumLogicalRuntimeFaults() {
        return this.logicalRuntimeFaults.get();
    }

    @Override
    public Number getNumRuntimeFaults() {
        return this.runtimeFaults.get();
    }

    @Override
    public Number getNumUnCheckedApplicationFaults() {
        return this.unCheckedApplicationFaults.get();
    }

    @Override
    public Number getTotalHandlingTime() {
        return this.totalHandlingTime;
    }

    @Override
    public void enable(boolean value) {
        this.enabled = value;
    }

    @Override
    public boolean isEnabled() {
        return this.enabled;
    }

    private void updateMax(long handleTime) {
        long current;
        while ((current = this.maxHandlingTime.get()) < handleTime && !this.maxHandlingTime.compareAndSet(current, handleTime)) {
        }
    }

    private void updateMin(long handleTime) {
        long current;
        while (!((current = this.minHandlingTime.get()) < handleTime && current != 0L || this.minHandlingTime.compareAndSet(current, handleTime))) {
        }
    }
}

