/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwe;

import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.logging.Logger;
import org.apache.cxf.common.logging.LogUtils;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObjectReaderWriter;
import org.apache.cxf.rs.security.jose.common.JoseUtils;
import org.apache.cxf.rs.security.jose.jwa.KeyAlgorithm;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionInput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionOutput;
import org.apache.cxf.rs.security.jose.jwe.JweDecryptionProvider;
import org.apache.cxf.rs.security.jose.jwe.JweException;
import org.apache.cxf.rs.security.jose.jwe.JweHeaders;
import org.apache.cxf.rs.security.jose.jwe.JweJsonEncryptionEntry;

public class JweJsonConsumer {
    protected static final Logger LOG = LogUtils.getL7dLogger(JweJsonConsumer.class);
    private String protectedHeaderJson;
    private JweHeaders protectedHeaderJwe;
    private JweHeaders sharedUnprotectedHeader;
    private List<JweJsonEncryptionEntry> recipients = new LinkedList<JweJsonEncryptionEntry>();
    private Map<JweJsonEncryptionEntry, JweHeaders> recipientsMap = new LinkedHashMap<JweJsonEncryptionEntry, JweHeaders>();
    private byte[] aad;
    private byte[] iv;
    private byte[] cipherBytes;
    private byte[] authTag;
    private JsonMapObjectReaderWriter reader = new JsonMapObjectReaderWriter();

    public JweJsonConsumer(String payload) {
        this.prepare(payload);
    }

    public JweDecryptionOutput decryptWith(JweDecryptionProvider jwe) {
        return this.decryptWith(jwe, (Map<String, Object>)null);
    }

    public JweDecryptionOutput decryptWith(JweDecryptionProvider jwe, Map<String, Object> recipientProps) {
        JweJsonEncryptionEntry entry = this.getJweDecryptionEntry(jwe, recipientProps);
        return this.decryptWith(jwe, entry);
    }

    public JweDecryptionOutput decryptWith(JweDecryptionProvider jwe, JweJsonEncryptionEntry entry) {
        JweDecryptionInput jweDecryptionInput = this.getJweDecryptionInput(entry);
        byte[] content = jwe.decrypt(jweDecryptionInput);
        return new JweDecryptionOutput(jweDecryptionInput.getJweHeaders(), content);
    }

    private JweDecryptionInput getJweDecryptionInput(JweJsonEncryptionEntry entry) {
        if (entry == null) {
            LOG.warning("JWE JSON Entry is not available");
            throw new JweException(JweException.Error.INVALID_JSON_JWE);
        }
        JweHeaders unionHeaders = this.recipientsMap.get(entry);
        if (unionHeaders == null) {
            LOG.warning("JWE JSON Entry union headers are not available");
            throw new JweException(JweException.Error.INVALID_JSON_JWE);
        }
        return new JweDecryptionInput(entry.getEncryptedKey(), this.iv, this.cipherBytes, this.authTag, this.aad, this.protectedHeaderJson, unionHeaders);
    }

    public JweJsonEncryptionEntry getJweDecryptionEntry(JweDecryptionProvider jwe) {
        return this.getJweDecryptionEntry(jwe, null);
    }

    public JweJsonEncryptionEntry getJweDecryptionEntry(JweDecryptionProvider jwe, Map<String, Object> recipientProps) {
        for (Map.Entry<JweJsonEncryptionEntry, JweHeaders> entry : this.recipientsMap.entrySet()) {
            KeyAlgorithm keyAlgo = entry.getValue().getKeyEncryptionAlgorithm();
            if ((keyAlgo == null || !keyAlgo.equals((Object)jwe.getKeyAlgorithm())) && (keyAlgo != null || jwe.getKeyAlgorithm() != null && !KeyAlgorithm.DIRECT.equals((Object)jwe.getKeyAlgorithm())) || recipientProps != null && !entry.getValue().asMap().entrySet().containsAll(recipientProps.entrySet())) continue;
            return entry.getKey();
        }
        return null;
    }

    private void prepare(String payload) {
        Map<String, Object> unprotectedHeader;
        Map<String, Object> jsonObjectMap = this.reader.fromJson(payload);
        String encodedProtectedHeader = (String)jsonObjectMap.get("protected");
        if (encodedProtectedHeader != null) {
            this.protectedHeaderJson = JoseUtils.decodeToString(encodedProtectedHeader);
            this.protectedHeaderJwe = new JweHeaders(this.reader.fromJson(this.protectedHeaderJson));
        }
        this.sharedUnprotectedHeader = (unprotectedHeader = CastUtils.cast((Map)jsonObjectMap.get("unprotected"))) == null ? null : new JweHeaders(unprotectedHeader);
        List<Map> encryptionArray = CastUtils.cast((List)jsonObjectMap.get("recipients"));
        if (encryptionArray != null) {
            if (jsonObjectMap.containsKey("encryption_key")) {
                LOG.warning("JWE JSON encryption_key is missing");
                throw new JweException(JweException.Error.INVALID_JSON_JWE);
            }
            for (Map encryptionEntry : encryptionArray) {
                this.recipients.add(this.getEncryptionObject(encryptionEntry));
            }
        } else {
            this.recipients.add(this.getEncryptionObject(jsonObjectMap));
        }
        this.aad = this.getDecodedBytes(jsonObjectMap, "aad");
        this.cipherBytes = this.getDecodedBytes(jsonObjectMap, "ciphertext");
        this.iv = this.getDecodedBytes(jsonObjectMap, "iv");
        this.authTag = this.getDecodedBytes(jsonObjectMap, "tag");
    }

    protected final JweJsonEncryptionEntry getEncryptionObject(Map<String, Object> encryptionEntry) {
        Map<String, Object> header = CastUtils.cast((Map)encryptionEntry.get("header"));
        JweHeaders recipientUnprotected = header == null ? null : new JweHeaders(header);
        String encodedKey = (String)encryptionEntry.get("encrypted_key");
        JweJsonEncryptionEntry entry = new JweJsonEncryptionEntry(recipientUnprotected, encodedKey);
        JweHeaders unionHeaders = new JweHeaders();
        if (this.protectedHeaderJwe != null) {
            unionHeaders.asMap().putAll(this.protectedHeaderJwe.asMap());
            unionHeaders.setProtectedHeaders(this.protectedHeaderJwe);
        }
        if (this.sharedUnprotectedHeader != null) {
            if (!Collections.disjoint(unionHeaders.asMap().keySet(), this.sharedUnprotectedHeader.asMap().keySet())) {
                LOG.warning("Protected and unprotected headers have duplicate values");
                throw new JweException(JweException.Error.INVALID_JSON_JWE);
            }
            unionHeaders.asMap().putAll(this.sharedUnprotectedHeader.asMap());
        }
        if (recipientUnprotected != null) {
            if (!Collections.disjoint(unionHeaders.asMap().keySet(), recipientUnprotected.asMap().keySet())) {
                LOG.warning("Union and recipient unprotected headers have duplicate values");
                throw new JweException(JweException.Error.INVALID_JSON_JWE);
            }
            unionHeaders.asMap().putAll(recipientUnprotected.asMap());
        }
        this.recipientsMap.put(entry, unionHeaders);
        return entry;
    }

    protected byte[] getDecodedBytes(Map<String, Object> map, String name) {
        String value = (String)map.get(name);
        if (value != null) {
            return JoseUtils.decode(value);
        }
        return null;
    }

    public JweHeaders getProtectedHeader() {
        return this.protectedHeaderJwe;
    }

    public JweHeaders getSharedUnprotectedHeader() {
        return this.sharedUnprotectedHeader;
    }

    public byte[] getAad() {
        return this.aad;
    }

    public String getAadText() {
        if (this.aad == null) {
            return null;
        }
        return new String(this.aad, StandardCharsets.UTF_8);
    }

    public byte[] getIvBytes() {
        return this.iv;
    }

    public String getIvText() {
        if (this.iv == null) {
            return null;
        }
        return new String(this.iv, StandardCharsets.UTF_8);
    }

    public byte[] getCipherBytes() {
        return this.cipherBytes;
    }

    public String getCipherText() {
        if (this.cipherBytes == null) {
            return null;
        }
        return new String(this.cipherBytes, StandardCharsets.UTF_8);
    }

    public byte[] getAuthTagBytes() {
        return this.authTag;
    }

    public String getAuthTagText() {
        if (this.authTag == null) {
            return null;
        }
        return new String(this.authTag, StandardCharsets.UTF_8);
    }

    public List<JweJsonEncryptionEntry> getRecipients() {
        return this.recipients;
    }

    public Map<JweJsonEncryptionEntry, JweHeaders> getRecipientsMap() {
        return this.recipientsMap;
    }
}

