/*
 * Decompiled with CFR 0.152.
 */
package org.apache.cxf.rs.security.jose.jwk;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.cxf.helpers.CastUtils;
import org.apache.cxf.jaxrs.json.basic.JsonMapObject;
import org.apache.cxf.rs.security.jose.jwk.KeyOperation;
import org.apache.cxf.rs.security.jose.jwk.KeyType;
import org.apache.cxf.rs.security.jose.jwk.PublicKeyUse;

public class JsonWebKey
extends JsonMapObject {
    public static final String KEY_TYPE = "kty";
    public static final String PUBLIC_KEY_USE = "use";
    public static final String KEY_OPERATIONS = "key_ops";
    public static final String KEY_ALGO = "alg";
    public static final String KEY_ID = "kid";
    public static final String X509_URL = "x5u";
    public static final String X509_CHAIN = "x5c";
    public static final String X509_THUMBPRINT = "x5t";
    public static final String X509_THUMBPRINT_SHA256 = "x5t#S256";
    public static final String KEY_TYPE_RSA = "RSA";
    public static final String RSA_MODULUS = "n";
    public static final String RSA_PUBLIC_EXP = "e";
    public static final String RSA_PRIVATE_EXP = "d";
    public static final String RSA_FIRST_PRIME_FACTOR = "p";
    public static final String RSA_SECOND_PRIME_FACTOR = "q";
    public static final String RSA_FIRST_PRIME_CRT = "dp";
    public static final String RSA_SECOND_PRIME_CRT = "dq";
    public static final String RSA_FIRST_CRT_COEFFICIENT = "qi";
    public static final String KEY_TYPE_OCTET = "oct";
    public static final String OCTET_KEY_VALUE = "k";
    public static final String KEY_TYPE_ELLIPTIC = "EC";
    public static final String EC_CURVE = "crv";
    public static final String EC_CURVE_P256 = "P-256";
    public static final String EC_CURVE_P384 = "P-384";
    public static final String EC_CURVE_P521 = "P-521";
    public static final String EC_X_COORDINATE = "x";
    public static final String EC_Y_COORDINATE = "y";
    public static final String EC_PRIVATE_KEY = "d";
    public static final String PUBLIC_KEY_USE_SIGN = "sig";
    public static final String PUBLIC_KEY_USE_ENCRYPT = "enc";
    public static final String KEY_OPER_SIGN = "sign";
    public static final String KEY_OPER_VERIFY = "verify";
    public static final String KEY_OPER_ENCRYPT = "encrypt";
    public static final String KEY_OPER_DECRYPT = "decrypt";
    public static final String KEY_OPER_WRAP_KEY = "wrapKey";
    public static final String KEY_OPER_UNWRAP_KEY = "unwrapKey";
    public static final String KEY_OPER_DERIVE_KEY = "deriveKey";
    public static final String KEY_OPER_DERIVE_BITS = "deriveBits";
    private static final long serialVersionUID = 3201315996547826368L;

    public JsonWebKey() {
    }

    public JsonWebKey(Map<String, Object> values) {
        super(values);
    }

    public void setKeyType(KeyType keyType) {
        this.setProperty(KEY_TYPE, keyType.toString());
    }

    public KeyType getKeyType() {
        Object prop = this.getProperty(KEY_TYPE);
        return prop == null ? null : KeyType.getKeyType(prop.toString());
    }

    public void setPublicKeyUse(PublicKeyUse use) {
        this.setProperty(PUBLIC_KEY_USE, use.toString());
    }

    public PublicKeyUse getPublicKeyUse() {
        Object prop = this.getProperty(PUBLIC_KEY_USE);
        return prop == null ? null : PublicKeyUse.getPublicKeyUse(prop.toString());
    }

    public void setKeyOperation(List<KeyOperation> keyOperation) {
        ArrayList<String> ops = new ArrayList<String>(keyOperation.size());
        for (KeyOperation op : keyOperation) {
            ops.add(op.toString());
        }
        this.setProperty(KEY_OPERATIONS, ops);
    }

    public List<KeyOperation> getKeyOperation() {
        List ops = CastUtils.cast((List)this.getProperty(KEY_OPERATIONS));
        if (ops == null) {
            return null;
        }
        ArrayList<KeyOperation> keyOps = new ArrayList<KeyOperation>(ops.size());
        for (Object op : ops) {
            keyOps.add(KeyOperation.getKeyOperation(op.toString()));
        }
        return keyOps;
    }

    public void setAlgorithm(String algorithm) {
        this.setProperty(KEY_ALGO, algorithm);
    }

    public String getAlgorithm() {
        return (String)this.getProperty(KEY_ALGO);
    }

    public void setKeyId(String kid) {
        this.setProperty(KEY_ID, kid);
    }

    public String getKeyId() {
        return (String)this.getProperty(KEY_ID);
    }

    public void setX509Url(String x509Url) {
        this.setProperty(X509_URL, x509Url);
    }

    public String getX509Url() {
        return (String)this.getProperty(X509_URL);
    }

    public void setX509Chain(List<String> x509Chain) {
        this.setProperty(X509_CHAIN, x509Chain);
    }

    public List<String> getX509Chain() {
        return CastUtils.cast((List)this.getProperty(X509_CHAIN));
    }

    public void setX509Thumbprint(String x509Thumbprint) {
        this.setProperty(X509_THUMBPRINT, x509Thumbprint);
    }

    public String getX509Thumbprint() {
        return (String)this.getProperty(X509_THUMBPRINT);
    }

    public void setX509ThumbprintSHA256(String x509Thumbprint) {
        this.setProperty(X509_THUMBPRINT_SHA256, x509Thumbprint);
    }

    public String getX509ThumbprintSHA256() {
        return (String)this.getProperty(X509_THUMBPRINT_SHA256);
    }

    public JsonWebKey setKeyProperty(String name, Object value) {
        this.setProperty(name, value);
        return this;
    }

    public Object getKeyProperty(String name) {
        return this.getProperty(name);
    }
}

