/*
 * Decompiled with CFR 0.152.
 */
package javax.ejb.embeddable;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import javax.ejb.EJBException;
import javax.ejb.spi.EJBContainerProvider;
import javax.naming.Context;
import org.apache.geronimo.osgi.locator.ProviderLocator;

public abstract class EJBContainer
implements AutoCloseable {
    public static final String PROVIDER = "javax.ejb.embeddable.provider";
    public static final String APP_NAME = "javax.ejb.embeddable.appName";
    public static final String MODULES = "javax.ejb.embeddable.modules";

    @Override
    public abstract void close();

    public static EJBContainer createEJBContainer() {
        return EJBContainer.createEJBContainer(Collections.EMPTY_MAP);
    }

    public static EJBContainer createEJBContainer(Map<?, ?> properties) {
        if (properties == null) {
            properties = Collections.EMPTY_MAP;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            List<Object> providers = ProviderLocator.getServices(EJBContainerProvider.class.getName(), EJBContainer.class, loader);
            for (Object o : providers) {
                EJBContainer container = ((EJBContainerProvider)o).createEJBContainer(properties);
                if (container == null) continue;
                return container;
            }
            throw new EJBException("Provider error. No provider definition found");
        }
        catch (EJBException e) {
            throw e;
        }
        catch (Exception e) {
            throw new EJBException("Provider error. No provider found", e);
        }
    }

    public abstract Context getContext();
}

