/*
 * Decompiled with CFR 0.152.
 */
package javax.security.enterprise.authentication.mechanism.http;

import java.lang.annotation.ElementType;
import java.lang.annotation.Inherited;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.enterprise.util.AnnotationLiteral;
import javax.enterprise.util.Nonbinding;
import javax.interceptor.InterceptorBinding;

@Inherited
@InterceptorBinding
@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.TYPE})
public @interface LoginToContinue {
    @Nonbinding
    public String loginPage() default "/login";

    @Nonbinding
    public boolean useForwardToLogin() default true;

    @Nonbinding
    public String useForwardToLoginExpression() default "";

    @Nonbinding
    public String errorPage() default "/login-error";

    public static final class Literal
    extends AnnotationLiteral<LoginToContinue>
    implements LoginToContinue {
        private static final long serialVersionUID = 1L;
        private final String loginPage;
        private final boolean useForwardToLogin;
        private final String useForwardToLoginExpression;
        private final String errorPage;

        public static LiteralBuilder builder() {
            return new LiteralBuilder();
        }

        public Literal(String loginPage, boolean useForwardToLogin, String useForwardToLoginExpression, String errorPage) {
            this.loginPage = loginPage;
            this.useForwardToLogin = useForwardToLogin;
            this.useForwardToLoginExpression = useForwardToLoginExpression;
            this.errorPage = errorPage;
        }

        @Override
        public String loginPage() {
            return this.loginPage;
        }

        @Override
        public boolean useForwardToLogin() {
            return this.useForwardToLogin;
        }

        @Override
        public String useForwardToLoginExpression() {
            return this.useForwardToLoginExpression;
        }

        @Override
        public String errorPage() {
            return this.errorPage;
        }

        public static class LiteralBuilder {
            private String loginPage = "/login";
            private boolean useForwardToLogin = true;
            private String useForwardToLoginExpression;
            private String errorPage = "/login-error";

            public LiteralBuilder loginPage(String loginPage) {
                this.loginPage = loginPage;
                return this;
            }

            public LiteralBuilder useForwardToLogin(boolean useForwardToLogin) {
                this.useForwardToLogin = useForwardToLogin;
                return this;
            }

            public LiteralBuilder useForwardToLoginExpression(String useForwardToLoginExpression) {
                this.useForwardToLoginExpression = useForwardToLoginExpression;
                return this;
            }

            public LiteralBuilder errorPage(String errorPage) {
                this.errorPage = errorPage;
                return this;
            }

            public Literal build() {
                return new Literal(this.loginPage, this.useForwardToLogin, this.useForwardToLoginExpression, this.errorPage);
            }
        }
    }
}

