/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.maven.util;

import java.util.Locale;
import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import org.apache.maven.plugin.logging.Log;
import org.apache.openejb.log.logger.AbstractDelegatingLogger;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.LogStream;
import org.apache.openejb.util.LogStreamFactory;
import org.apache.webbeans.logger.WebBeansLoggerFactory;

public class MavenLogStreamFactory
implements LogStreamFactory {
    private static Log logger;

    public LogStream createLogStream(LogCategory logCategory) {
        return new MavenLogStream(logger);
    }

    public static void setLogger(Log logger) {
        MavenLogStreamFactory.logger = logger;
    }

    public static Log currentLogger() {
        return logger;
    }

    static {
        System.setProperty("openwebbeans.logging.factory", OWBMavenLogFactory.class.getName());
        try {
            if (System.getProperty("openjpa.Log") == null) {
                MavenLogStreamFactory.class.getClassLoader().loadClass("org.apache.openjpa.lib.log.LogFactoryAdapter");
                System.setProperty("openjpa.Log", "org.apache.openejb.maven.util.OpenJPALogFactory");
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private static class MavenLogStream
    implements LogStream {
        private final Log log;

        public MavenLogStream(Log logger) {
            this.log = logger;
        }

        public boolean isFatalEnabled() {
            return this.log.isErrorEnabled();
        }

        public void fatal(String message) {
            this.log.error((CharSequence)message);
        }

        public void fatal(String message, Throwable t) {
            this.log.error((CharSequence)message, t);
        }

        public boolean isErrorEnabled() {
            return this.log.isErrorEnabled();
        }

        public void error(String message) {
            this.log.error((CharSequence)message);
        }

        public void error(String message, Throwable t) {
            this.log.error((CharSequence)message, t);
        }

        public boolean isWarnEnabled() {
            return this.log.isWarnEnabled();
        }

        public void warn(String message) {
            this.log.warn((CharSequence)message);
        }

        public void warn(String message, Throwable t) {
            this.log.warn((CharSequence)message, t);
        }

        public boolean isInfoEnabled() {
            return this.log.isInfoEnabled();
        }

        public void info(String message) {
            this.log.info((CharSequence)message);
        }

        public void info(String message, Throwable t) {
            this.log.info((CharSequence)message, t);
        }

        public boolean isDebugEnabled() {
            return this.log.isDebugEnabled();
        }

        public void debug(String message) {
            this.log.debug((CharSequence)message);
        }

        public void debug(String message, Throwable t) {
            this.log.debug((CharSequence)message, t);
        }
    }

    public static class OWBMavenLogFactory
    implements WebBeansLoggerFactory {
        public Logger getLogger(Class<?> clazz, Locale desiredLocale) {
            return new MavenLogger(clazz.getName(), "openwebbeans/Messages");
        }

        public Logger getLogger(Class<?> clazz) {
            return new MavenLogger(clazz.getName(), "openwebbeans/Messages");
        }
    }

    public static class MavenLogger
    extends AbstractDelegatingLogger {
        public MavenLogger(String name, String resourceBundleName) {
            super(name, resourceBundleName);
        }

        public Level getLevel() {
            if (logger.isDebugEnabled()) {
                return Level.FINER;
            }
            if (logger.isInfoEnabled()) {
                return Level.INFO;
            }
            if (logger.isWarnEnabled()) {
                return Level.WARNING;
            }
            if (logger.isErrorEnabled()) {
                return Level.SEVERE;
            }
            return Level.OFF;
        }

        public boolean isLoggable(Level level) {
            int i = level.intValue();
            if (i == Level.OFF.intValue()) {
                return false;
            }
            if (i >= Level.SEVERE.intValue()) {
                return logger.isErrorEnabled();
            }
            if (i >= Level.WARNING.intValue()) {
                return logger.isWarnEnabled();
            }
            if (i >= Level.INFO.intValue()) {
                return logger.isInfoEnabled();
            }
            return logger.isDebugEnabled();
        }

        protected void internalLogFormatted(String msg, LogRecord record) {
            Level level = record.getLevel();
            Throwable t = record.getThrown();
            if (Level.FINE.equals(level) || Level.FINER.equals(level) || Level.CONFIG.equals(level)) {
                if (t == null) {
                    logger.debug((CharSequence)msg);
                } else {
                    logger.debug((CharSequence)msg, t);
                }
            } else if (Level.INFO.equals(level)) {
                if (t == null) {
                    logger.info((CharSequence)msg);
                } else {
                    logger.info((CharSequence)msg, t);
                }
            } else if (Level.WARNING.equals(level)) {
                if (t == null) {
                    logger.warn((CharSequence)msg);
                } else {
                    logger.warn((CharSequence)msg, t);
                }
            } else if (Level.ALL.equals(level) || Level.SEVERE.equals(level)) {
                if (t == null) {
                    logger.error((CharSequence)msg);
                } else {
                    logger.error((CharSequence)msg, t);
                }
            }
        }
    }
}

