/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.io.ByteArrayInputStream;
import java.io.Externalizable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.InvalidObjectException;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.annotation.Annotation;
import java.lang.instrument.ClassFileTransformer;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.lang.reflect.Type;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeMap;
import java.util.concurrent.Callable;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;
import java.util.concurrent.locks.ReentrantLock;
import javax.annotation.PostConstruct;
import javax.annotation.PreDestroy;
import javax.annotation.Resource;
import javax.ejb.EJB;
import javax.enterprise.context.Dependent;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.BeanManager;
import javax.enterprise.inject.spi.DefinitionException;
import javax.enterprise.inject.spi.DeploymentException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanRegistrationException;
import javax.management.MBeanServer;
import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import javax.naming.Binding;
import javax.naming.Context;
import javax.naming.InitialContext;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.resource.cci.Connection;
import javax.resource.cci.ConnectionFactory;
import javax.resource.spi.BootstrapContext;
import javax.resource.spi.ConnectionManager;
import javax.resource.spi.ManagedConnectionFactory;
import javax.resource.spi.ResourceAdapter;
import javax.resource.spi.ResourceAdapterInternalException;
import javax.resource.spi.XATerminator;
import javax.servlet.ServletContext;
import javax.sql.DataSource;
import javax.transaction.TransactionManager;
import javax.transaction.TransactionSynchronizationRegistry;
import javax.validation.ValidationException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.geronimo.connector.GeronimoBootstrapContext;
import org.apache.geronimo.connector.outbound.AbstractConnectionManager;
import org.apache.geronimo.connector.work.GeronimoWorkManager;
import org.apache.geronimo.connector.work.HintsContextHandler;
import org.apache.geronimo.connector.work.TransactionContextHandler;
import org.apache.geronimo.transaction.manager.GeronimoTransactionManager;
import org.apache.geronimo.transaction.manager.XAWork;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.BeanType;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.Container;
import org.apache.openejb.DeploymentContext;
import org.apache.openejb.DuplicateDeploymentIdException;
import org.apache.openejb.Extensions;
import org.apache.openejb.Injection;
import org.apache.openejb.JndiConstants;
import org.apache.openejb.MethodContext;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.api.resource.DestroyableResource;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.ApplicationExceptionInfo;
import org.apache.openejb.assembler.classic.AssemblerTool;
import org.apache.openejb.assembler.classic.ClientInfo;
import org.apache.openejb.assembler.classic.CmpJarBuilder;
import org.apache.openejb.assembler.classic.CommonInfoObject;
import org.apache.openejb.assembler.classic.ComparableValidationConfig;
import org.apache.openejb.assembler.classic.ConnectionManagerInfo;
import org.apache.openejb.assembler.classic.ConnectorInfo;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ContainerSystemInfo;
import org.apache.openejb.assembler.classic.DeployTimeEnhancer;
import org.apache.openejb.assembler.classic.DeploymentExceptionManager;
import org.apache.openejb.assembler.classic.DeploymentListener;
import org.apache.openejb.assembler.classic.EjbJarBuilder;
import org.apache.openejb.assembler.classic.EjbJarInfo;
import org.apache.openejb.assembler.classic.EjbResolver;
import org.apache.openejb.assembler.classic.EnterpriseBeanInfo;
import org.apache.openejb.assembler.classic.EnvEntryInfo;
import org.apache.openejb.assembler.classic.FacilitiesInfo;
import org.apache.openejb.assembler.classic.ImportSql;
import org.apache.openejb.assembler.classic.InjectionBuilder;
import org.apache.openejb.assembler.classic.JaccPermissionsBuilder;
import org.apache.openejb.assembler.classic.JndiBuilder;
import org.apache.openejb.assembler.classic.JndiContextInfo;
import org.apache.openejb.assembler.classic.JndiEncBuilder;
import org.apache.openejb.assembler.classic.LazyValidator;
import org.apache.openejb.assembler.classic.LazyValidatorFactory;
import org.apache.openejb.assembler.classic.MdbContainerInfo;
import org.apache.openejb.assembler.classic.MethodConcurrencyBuilder;
import org.apache.openejb.assembler.classic.MethodTransactionBuilder;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.OpenEjbConfigurationFactory;
import org.apache.openejb.assembler.classic.PersistenceBuilder;
import org.apache.openejb.assembler.classic.PersistenceUnitInfo;
import org.apache.openejb.assembler.classic.PolicyContext;
import org.apache.openejb.assembler.classic.ProxyFactoryInfo;
import org.apache.openejb.assembler.classic.ReloadableEntityManagerFactory;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.assembler.classic.SecurityServiceInfo;
import org.apache.openejb.assembler.classic.ServiceInfo;
import org.apache.openejb.assembler.classic.TransactionServiceInfo;
import org.apache.openejb.assembler.classic.WebAppBuilder;
import org.apache.openejb.assembler.classic.WebAppInfo;
import org.apache.openejb.assembler.classic.event.AssemblerAfterApplicationCreated;
import org.apache.openejb.assembler.classic.event.AssemblerBeforeApplicationDestroyed;
import org.apache.openejb.assembler.classic.event.AssemblerCreated;
import org.apache.openejb.assembler.classic.event.AssemblerDestroyed;
import org.apache.openejb.assembler.classic.event.BeforeStartEjbs;
import org.apache.openejb.assembler.classic.event.ContainerSystemPostCreate;
import org.apache.openejb.assembler.classic.event.ContainerSystemPreDestroy;
import org.apache.openejb.assembler.monitoring.JMXContainer;
import org.apache.openejb.async.AsynchronousPool;
import org.apache.openejb.batchee.BatchEEServiceManager;
import org.apache.openejb.cdi.CdiAppContextsService;
import org.apache.openejb.cdi.CdiBuilder;
import org.apache.openejb.cdi.CdiPlugin;
import org.apache.openejb.cdi.CdiResourceInjectionService;
import org.apache.openejb.cdi.CdiScanner;
import org.apache.openejb.cdi.CustomELAdapter;
import org.apache.openejb.cdi.ManagedSecurityService;
import org.apache.openejb.cdi.OpenEJBBeanInfoService;
import org.apache.openejb.cdi.OpenEJBJndiService;
import org.apache.openejb.cdi.OpenEJBTransactionService;
import org.apache.openejb.cdi.OptimizedLoaderService;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.CompositeClassLoaderConfigurer;
import org.apache.openejb.component.ClassLoaderEnricher;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.NewLoaderLogic;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.config.TldScanner;
import org.apache.openejb.core.ConnectorReference;
import org.apache.openejb.core.CoreContainerSystem;
import org.apache.openejb.core.CoreUserTransaction;
import org.apache.openejb.core.JndiFactory;
import org.apache.openejb.core.ParentClassLoaderFinder;
import org.apache.openejb.core.ServerFederation;
import org.apache.openejb.core.SimpleTransactionSynchronizationRegistry;
import org.apache.openejb.core.TransactionSynchronizationRegistryWrapper;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.ivm.IntraVmProxy;
import org.apache.openejb.core.ivm.naming.ContextualJndiReference;
import org.apache.openejb.core.ivm.naming.IvmContext;
import org.apache.openejb.core.ivm.naming.IvmJndiFactory;
import org.apache.openejb.core.ivm.naming.JndiUrlReference;
import org.apache.openejb.core.ivm.naming.LazyObjectReference;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.core.security.SecurityContextHandler;
import org.apache.openejb.core.timer.EjbTimerServiceImpl;
import org.apache.openejb.core.timer.MemoryTimerStore;
import org.apache.openejb.core.timer.NullEjbTimerServiceImpl;
import org.apache.openejb.core.timer.ScheduleData;
import org.apache.openejb.core.timer.TimerStore;
import org.apache.openejb.core.transaction.JtaTransactionPolicyFactory;
import org.apache.openejb.core.transaction.SimpleBootstrapContext;
import org.apache.openejb.core.transaction.SimpleWorkManager;
import org.apache.openejb.core.transaction.TransactionPolicyFactory;
import org.apache.openejb.core.transaction.TransactionType;
import org.apache.openejb.javaagent.Agent;
import org.apache.openejb.jpa.integration.MakeTxLookup;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.JarLocation;
import org.apache.openejb.loader.Options;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.monitoring.DynamicMBeanWrapper;
import org.apache.openejb.monitoring.LocalMBeanServer;
import org.apache.openejb.monitoring.ObjectNameBuilder;
import org.apache.openejb.monitoring.remote.RemoteResourceMonitor;
import org.apache.openejb.observer.Observes;
import org.apache.openejb.persistence.JtaEntityManagerRegistry;
import org.apache.openejb.persistence.PersistenceClassLoaderHandler;
import org.apache.openejb.quartz.Scheduler;
import org.apache.openejb.resource.GeronimoConnectionManagerFactory;
import org.apache.openejb.resource.PropertiesFactory;
import org.apache.openejb.resource.jdbc.DataSourceFactory;
import org.apache.openejb.spi.ApplicationServer;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Classes;
import org.apache.openejb.util.Contexts;
import org.apache.openejb.util.DaemonThreadFactory;
import org.apache.openejb.util.ExecutorBuilder;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.Messages;
import org.apache.openejb.util.OpenEJBErrorHandler;
import org.apache.openejb.util.PropertiesHelper;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.References;
import org.apache.openejb.util.SafeToolkit;
import org.apache.openejb.util.SetAccessible;
import org.apache.openejb.util.SuperProperties;
import org.apache.openejb.util.URISupport;
import org.apache.openejb.util.URLs;
import org.apache.openejb.util.classloader.ClassLoaderAwareHandler;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.openejb.util.proxy.ProxyFactory;
import org.apache.openejb.util.proxy.ProxyManager;
import org.apache.webbeans.component.ResourceBean;
import org.apache.webbeans.config.WebBeansContext;
import org.apache.webbeans.container.BeanManagerImpl;
import org.apache.webbeans.context.creational.CreationalContextImpl;
import org.apache.webbeans.inject.OWBInjector;
import org.apache.webbeans.logger.JULLoggerFactory;
import org.apache.webbeans.spi.BeanArchiveService;
import org.apache.webbeans.spi.ContainerLifecycle;
import org.apache.webbeans.spi.ContextsService;
import org.apache.webbeans.spi.JNDIService;
import org.apache.webbeans.spi.LoaderService;
import org.apache.webbeans.spi.ResourceInjectionService;
import org.apache.webbeans.spi.ScannerService;
import org.apache.webbeans.spi.SecurityService;
import org.apache.webbeans.spi.TransactionService;
import org.apache.webbeans.spi.adaptor.ELAdaptor;
import org.apache.webbeans.spi.api.ResourceReference;
import org.apache.xbean.finder.AnnotationFinder;
import org.apache.xbean.finder.ClassLoaders;
import org.apache.xbean.finder.ResourceFinder;
import org.apache.xbean.finder.UrlSet;
import org.apache.xbean.finder.archive.Archive;
import org.apache.xbean.finder.archive.ClassesArchive;
import org.apache.xbean.recipe.ConstructionException;
import org.apache.xbean.recipe.ObjectRecipe;
import org.apache.xbean.recipe.Option;
import org.apache.xbean.recipe.UnsetPropertiesRecipe;

public class Assembler
extends AssemblerTool
implements org.apache.openejb.spi.Assembler,
JndiConstants {
    public static final String OPENEJB_URL_PKG_PREFIX;
    public static final String OPENEJB_JPA_DEPLOY_TIME_ENHANCEMENT_PROP = "openejb.jpa.deploy-time-enhancement";
    public static final String PROPAGATE_APPLICATION_EXCEPTIONS = "openejb.propagate.application-exceptions";
    private static final String GLOBAL_UNIQUE_ID = "global";
    public static final String TIMER_STORE_CLASS = "timerStore.class";
    private static final ReentrantLock lock;
    public static final String OPENEJB_TIMERS_ON = "openejb.timers.on";
    public static final Class<?>[] VALIDATOR_FACTORY_INTERFACES;
    public static final Class<?>[] VALIDATOR_INTERFACES;
    private final boolean skipLoaderIfPossible;
    Messages messages = new Messages(Assembler.class.getPackage().getName());
    public final Logger logger;
    private final CoreContainerSystem containerSystem;
    private final PersistenceClassLoaderHandler persistenceClassLoaderHandler;
    private final JndiBuilder jndiBuilder;
    private TransactionManager transactionManager;
    private org.apache.openejb.spi.SecurityService securityService;
    protected OpenEjbConfigurationFactory configFactory;
    private final Map<String, AppInfo> deployedApplications = new HashMap<String, AppInfo>();
    private final Map<ObjectName, CreationalContext> creationalContextForAppMbeans = new HashMap<ObjectName, CreationalContext>();
    private final Set<ObjectName> containerObjectNames = new HashSet<ObjectName>();
    private final RemoteResourceMonitor remoteResourceMonitor = new RemoteResourceMonitor();
    protected SafeToolkit toolkit = SafeToolkit.getToolkit("Assembler");
    protected OpenEjbConfiguration config;
    private static final ThreadLocal<Map<String, Object>> context;

    @Override
    public ContainerSystem getContainerSystem() {
        return this.containerSystem;
    }

    @Override
    public TransactionManager getTransactionManager() {
        return this.transactionManager;
    }

    @Override
    public org.apache.openejb.spi.SecurityService getSecurityService() {
        return this.securityService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addDeploymentListener(DeploymentListener deploymentListener) {
        ReentrantLock l = lock;
        l.lock();
        try {
            this.logger.warning("DeploymentListener API is replaced by @Observes event");
            SystemInstance.get().addObserver((Object)new DeploymentListenerObserver(deploymentListener));
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeDeploymentListener(DeploymentListener deploymentListener) {
        ReentrantLock l = lock;
        l.lock();
        try {
            SystemInstance.get().removeObserver((Object)new DeploymentListenerObserver(deploymentListener));
        }
        finally {
            l.unlock();
        }
    }

    public Assembler() {
        this(new IvmJndiFactory());
    }

    public Assembler(JndiFactory jndiFactory) {
        this.logger = Logger.getInstance(LogCategory.OPENEJB_STARTUP, Assembler.class);
        this.skipLoaderIfPossible = "true".equalsIgnoreCase(SystemInstance.get().getProperty("openejb.classloader.skip-app-loader-if-possible", "true"));
        this.persistenceClassLoaderHandler = new PersistenceClassLoaderHandlerImpl();
        Assembler.installNaming();
        SystemInstance system = SystemInstance.get();
        system.setComponent(org.apache.openejb.spi.Assembler.class, (Object)this);
        system.setComponent(Assembler.class, (Object)this);
        this.containerSystem = new CoreContainerSystem(jndiFactory);
        system.setComponent(ContainerSystem.class, (Object)this.containerSystem);
        this.jndiBuilder = new JndiBuilder(this.containerSystem.getJNDIContext());
        this.setConfiguration(new OpenEjbConfiguration());
        ApplicationServer appServer = (ApplicationServer)system.getComponent(ApplicationServer.class);
        if (appServer == null) {
            system.setComponent(ApplicationServer.class, (Object)new ServerFederation());
        }
        system.setComponent(EjbResolver.class, (Object)new EjbResolver(null, EjbResolver.Scope.GLOBAL, new EjbJarInfo[0]));
        this.installExtensions();
        system.fireEvent((Object)new AssemblerCreated());
        this.initBValFiltering();
    }

    private void initBValFiltering() {
        if ("true".equals(SystemInstance.get().getProperty("openejb.cdi.bval.filter", "true"))) {
            try {
                ClassLoader loader = ParentClassLoaderFinder.Helper.get();
                Object filter = loader.loadClass("org.apache.openejb.bval.BValCdiFilter").newInstance();
                loader.loadClass("org.apache.bval.cdi.BValExtension").getMethod("setAnnotatedTypeFilter", new Class[0]).invoke(null, filter);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private void installExtensions() {
        try {
            List urls = NewLoaderLogic.applyBuiltinExcludes(new UrlSet(Assembler.class.getClassLoader()).excludeJvm()).getUrls();
            Extensions.installExtensions(new Extensions.Finder("META-INF", false, urls.toArray(new URL[urls.size()])));
            return;
        }
        catch (IOException iOException) {
            Extensions.installExtensions(new Extensions.Finder("META-INF", true, new URL[0]));
            return;
        }
    }

    private void setConfiguration(OpenEjbConfiguration config) {
        this.config = config;
        if (config.containerSystem == null) {
            config.containerSystem = new ContainerSystemInfo();
        }
        if (config.facilities == null) {
            config.facilities = new FacilitiesInfo();
        }
        SystemInstance.get().setComponent(OpenEjbConfiguration.class, (Object)this.config);
    }

    @Override
    public void init(Properties props) throws OpenEJBException {
        this.props = new Properties(props);
        Options options = new Options(props, SystemInstance.get().getOptions());
        String className = options.get("openejb.configurator", "org.apache.openejb.config.ConfigurationFactory");
        this.configFactory = "org.apache.openejb.config.ConfigurationFactory".equals(className) ? new ConfigurationFactory() : (OpenEjbConfigurationFactory)this.toolkit.newInstance(className);
        this.configFactory.init(props);
        SystemInstance.get().setComponent(OpenEjbConfigurationFactory.class, (Object)this.configFactory);
    }

    public static void installNaming() {
        if (SystemInstance.get().hasProperty("openejb.geronimo")) {
            return;
        }
        Assembler.installNaming(OPENEJB_URL_PKG_PREFIX);
    }

    public static void installNaming(String prefix) {
        Assembler.installNaming(prefix, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void installNaming(String prefix, boolean clean) {
        ReentrantLock l = lock;
        l.lock();
        try {
            Properties systemProperties = System.getProperties();
            String str = systemProperties.getProperty("java.naming.factory.url.pkgs");
            if (str == null || clean) {
                str = prefix;
            } else if (!str.contains(prefix)) {
                str = str + ":" + prefix;
            }
            systemProperties.setProperty("java.naming.factory.url.pkgs", str);
        }
        finally {
            l.unlock();
        }
    }

    public static void setContext(Map<String, Object> map) {
        context.set(map);
    }

    public static Map<String, Object> getContext() {
        Map<String, Object> map = context.get();
        if (map == null) {
            map = new HashMap<String, Object>();
            context.set(map);
        }
        return map;
    }

    @Override
    public void build() throws OpenEJBException {
        Assembler.setContext(new HashMap<String, Object>());
        try {
            OpenEjbConfiguration config = this.getOpenEjbConfiguration();
            this.buildContainerSystem(config);
        }
        catch (OpenEJBException ae) {
            throw ae;
        }
        catch (Exception e) {
            OpenEJBErrorHandler.handleUnknownError(e, "Assembler");
            throw new OpenEJBException(e);
        }
        finally {
            context.set(null);
        }
    }

    protected OpenEjbConfiguration getOpenEjbConfiguration() throws OpenEJBException {
        return this.configFactory.getOpenEjbConfiguration();
    }

    public void buildContainerSystem(OpenEjbConfiguration configInfo) throws Exception {
        SystemInstance systemInstance = SystemInstance.get();
        if (systemInstance.getOptions().get(OPENEJB_JPA_DEPLOY_TIME_ENHANCEMENT_PROP, false)) {
            systemInstance.addObserver((Object)new DeployTimeEnhancer());
        }
        if (Assembler.hasBatchEE()) {
            systemInstance.addObserver((Object)new BatchEEServiceManager());
        }
        for (ServiceInfo serviceInfo : configInfo.facilities.services) {
            this.createService(serviceInfo);
        }
        ContainerSystemInfo containerSystemInfo = configInfo.containerSystem;
        if (configInfo.facilities.intraVmServer != null) {
            this.createProxyFactory(configInfo.facilities.intraVmServer);
        }
        for (JndiContextInfo contextInfo : configInfo.facilities.remoteJndiContexts) {
            this.createExternalContext(contextInfo);
        }
        this.createTransactionManager(configInfo.facilities.transactionService);
        this.createSecurityService(configInfo.facilities.securityService);
        HashSet<String> reservedResourceIds = new HashSet<String>(configInfo.facilities.resources.size());
        for (AppInfo appInfo : containerSystemInfo.applications) {
            reservedResourceIds.addAll(appInfo.resourceIds);
        }
        HashSet<String> rIds = new HashSet<String>(configInfo.facilities.resources.size());
        for (ResourceInfo resourceInfo : configInfo.facilities.resources) {
            this.createResource(resourceInfo);
            rIds.add(resourceInfo.id);
        }
        rIds.removeAll(reservedResourceIds);
        this.postConstructResources(rIds, ParentClassLoaderFinder.Helper.get(), ((ContainerSystem)systemInstance.getComponent(ContainerSystem.class)).getJNDIContext(), null);
        for (ContainerInfo serviceInfo : containerSystemInfo.containers) {
            this.createContainer(serviceInfo);
        }
        this.createJavaGlobal();
        for (AppInfo appInfo : containerSystemInfo.applications) {
            try {
                this.createApplication(appInfo, this.createAppClassLoader(appInfo));
            }
            catch (DuplicateDeploymentIdException e) {
            }
            catch (Throwable e) {
                this.logger.error("appNotDeployed", e, appInfo.path);
                DeploymentExceptionManager exceptionManager = (DeploymentExceptionManager)systemInstance.getComponent(DeploymentExceptionManager.class);
                if (exceptionManager == null || !(e instanceof Exception)) continue;
                exceptionManager.saveDeploymentException(appInfo, (Exception)e);
            }
        }
        systemInstance.fireEvent((Object)new ContainerSystemPostCreate());
    }

    private static boolean hasBatchEE() {
        try {
            Class.forName("org.apache.batchee.container.services.ServicesManager", true, Assembler.class.getClassLoader());
            return true;
        }
        catch (Throwable e) {
            return false;
        }
    }

    private void createJavaGlobal() {
        try {
            this.containerSystem.getJNDIContext().createSubcontext(GLOBAL_UNIQUE_ID);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    public AppInfo getAppInfo(String path) {
        return this.deployedApplications.get(ProvisioningUtil.realLocation((String)path).iterator().next());
    }

    public boolean isDeployed(String path) {
        return this.deployedApplications.containsKey(ProvisioningUtil.realLocation((String)path).iterator().next());
    }

    public Collection<AppInfo> getDeployedApplications() {
        return new ArrayList<AppInfo>(this.deployedApplications.values());
    }

    public AppContext createApplication(EjbJarInfo ejbJar) throws NamingException, IOException, OpenEJBException {
        return this.createEjbJar(ejbJar);
    }

    public AppContext createEjbJar(EjbJarInfo ejbJar) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = ejbJar.path;
        appInfo.appId = ejbJar.moduleName;
        appInfo.ejbJars.add(ejbJar);
        return this.createApplication(appInfo);
    }

    public AppContext createApplication(EjbJarInfo ejbJar, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        return this.createEjbJar(ejbJar, classLoader);
    }

    public AppContext createEjbJar(EjbJarInfo ejbJar, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = ejbJar.path;
        appInfo.appId = ejbJar.moduleName;
        appInfo.ejbJars.add(ejbJar);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createClient(ClientInfo clientInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = clientInfo.path;
        appInfo.appId = clientInfo.moduleId;
        appInfo.clients.add(clientInfo);
        return this.createApplication(appInfo);
    }

    public AppContext createClient(ClientInfo clientInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = clientInfo.path;
        appInfo.appId = clientInfo.moduleId;
        appInfo.clients.add(clientInfo);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createConnector(ConnectorInfo connectorInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = connectorInfo.path;
        appInfo.appId = connectorInfo.moduleId;
        appInfo.connectors.add(connectorInfo);
        return this.createApplication(appInfo);
    }

    public AppContext createConnector(ConnectorInfo connectorInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = connectorInfo.path;
        appInfo.appId = connectorInfo.moduleId;
        appInfo.connectors.add(connectorInfo);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createWebApp(WebAppInfo webAppInfo) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = webAppInfo.path;
        appInfo.appId = webAppInfo.moduleId;
        appInfo.webApps.add(webAppInfo);
        return this.createApplication(appInfo);
    }

    public AppContext createWebApp(WebAppInfo webAppInfo, ClassLoader classLoader) throws NamingException, IOException, OpenEJBException {
        AppInfo appInfo = new AppInfo();
        appInfo.path = webAppInfo.path;
        appInfo.appId = webAppInfo.moduleId;
        appInfo.webApps.add(webAppInfo);
        return this.createApplication(appInfo, classLoader);
    }

    public AppContext createApplication(AppInfo appInfo) throws OpenEJBException, IOException, NamingException {
        return this.createApplication(appInfo, this.createAppClassLoader(appInfo));
    }

    public AppContext createApplication(AppInfo appInfo, ClassLoader classLoader) throws OpenEJBException, IOException, NamingException {
        return this.createApplication(appInfo, classLoader, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AppContext createApplication(AppInfo appInfo, ClassLoader classLoader, boolean start) throws OpenEJBException, IOException, NamingException {
        try {
            Assembler.mergeServices(appInfo);
        }
        catch (URISyntaxException e) {
            this.logger.info("Can't merge resources.xml services and appInfo.properties");
        }
        if (appInfo.appId == null) {
            throw new IllegalArgumentException("AppInfo.appId cannot be null");
        }
        if (appInfo.path == null) {
            appInfo.path = appInfo.appId;
        }
        Extensions.addExtensions(classLoader, appInfo.eventClassesNeedingAppClassloader);
        this.logger.info("createApplication.start", appInfo.path);
        Context containerSystemContext = this.containerSystem.getJNDIContext();
        ArrayList<String> used = new ArrayList<String>();
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
                if (this.containerSystem.getBeanContext(beanInfo.ejbDeploymentId) == null) continue;
                used.add(beanInfo.ejbDeploymentId);
            }
        }
        if (used.size() > 0) {
            String message = this.logger.error("createApplication.appFailedDuplicateIds", appInfo.path);
            for (String id : used) {
                this.logger.error("createApplication.deploymentIdInUse", id);
                message = message + "\n    " + id;
            }
            throw new DuplicateDeploymentIdException(message);
        }
        InjectionBuilder injectionBuilder = new InjectionBuilder(classLoader);
        HashSet<Injection> injections = new HashSet<Injection>();
        injections.addAll(injectionBuilder.buildInjections(appInfo.globalJndiEnc));
        injections.addAll(injectionBuilder.buildInjections(appInfo.appJndiEnc));
        JndiEncBuilder globalBuilder = new JndiEncBuilder(appInfo.globalJndiEnc, injections, appInfo.appId, null, GLOBAL_UNIQUE_ID, classLoader, appInfo.properties);
        Map<String, Object> globalBindings = globalBuilder.buildBindings(JndiEncBuilder.JndiScope.global);
        Context globalJndiContext = globalBuilder.build(globalBindings);
        JndiEncBuilder appBuilder = new JndiEncBuilder(appInfo.appJndiEnc, injections, appInfo.appId, null, appInfo.appId, classLoader, appInfo.properties);
        Map<String, Object> appBindings = appBuilder.buildBindings(JndiEncBuilder.JndiScope.app);
        Context appJndiContext = appBuilder.build(appBindings);
        try {
            CmpJarBuilder cmpJarBuilder = new CmpJarBuilder(appInfo, classLoader);
            File generatedJar = cmpJarBuilder.getJarFile();
            if (generatedJar != null) {
                classLoader = ClassLoaderUtil.createClassLoader(appInfo.path, new URL[]{generatedJar.toURI().toURL()}, classLoader);
            }
            AppContext appContext = new AppContext(appInfo.appId, SystemInstance.get(), classLoader, globalJndiContext, appJndiContext, appInfo.standaloneModule);
            appContext.getProperties().putAll((Map<?, ?>)appInfo.properties);
            appContext.getInjections().addAll(injections);
            appContext.getBindings().putAll(globalBindings);
            appContext.getBindings().putAll(appBindings);
            this.containerSystem.addAppContext(appContext);
            appContext.set(AsynchronousPool.class, AsynchronousPool.create(appContext));
            HashMap<String, LazyValidatorFactory> lazyValidatorFactories = new HashMap<String, LazyValidatorFactory>();
            HashMap<String, LazyValidator> lazyValidators = new HashMap<String, LazyValidator>();
            boolean isGeronimo = SystemInstance.get().hasProperty("openejb.geronimo");
            HashMap<ComparableValidationConfig, ValidatorFactory> validatorFactoriesByConfig = new HashMap<ComparableValidationConfig, ValidatorFactory>();
            if (!isGeronimo) {
                ValidatorFactory factory;
                List<CommonInfoObject> vfs = Assembler.listCommonInfoObjectsForAppInfo(appInfo);
                HashMap<String, ValidatorFactory> validatorFactories = new HashMap<String, ValidatorFactory>();
                for (CommonInfoObject commonInfoObject : vfs) {
                    if (commonInfoObject.validationInfo == null) continue;
                    ComparableValidationConfig conf = new ComparableValidationConfig(commonInfoObject.validationInfo.providerClassName, commonInfoObject.validationInfo.messageInterpolatorClass, commonInfoObject.validationInfo.traversableResolverClass, commonInfoObject.validationInfo.constraintFactoryClass, commonInfoObject.validationInfo.parameterNameProviderClass, commonInfoObject.validationInfo.version, commonInfoObject.validationInfo.propertyTypes, commonInfoObject.validationInfo.constraintMappings, commonInfoObject.validationInfo.executableValidationEnabled, commonInfoObject.validationInfo.validatedTypes);
                    factory = (ValidatorFactory)validatorFactoriesByConfig.get(conf);
                    if (factory == null) {
                        try {
                            LazyValidatorFactory handler = new LazyValidatorFactory(classLoader, commonInfoObject.validationInfo);
                            factory = (ValidatorFactory)Proxy.newProxyInstance(appContext.getClassLoader(), VALIDATOR_FACTORY_INTERFACES, (InvocationHandler)handler);
                            lazyValidatorFactories.put(commonInfoObject.uniqueId, handler);
                        }
                        catch (ValidationException ve) {
                            this.logger.warning("can't build the validation factory for module " + commonInfoObject.uniqueId, ve);
                            continue;
                        }
                        validatorFactoriesByConfig.put(conf, factory);
                    } else {
                        lazyValidatorFactories.put(commonInfoObject.uniqueId, (LazyValidatorFactory)LazyValidatorFactory.class.cast(Proxy.getInvocationHandler(factory)));
                    }
                    validatorFactories.put(commonInfoObject.uniqueId, factory);
                }
                for (Map.Entry entry : validatorFactories.entrySet()) {
                    String id = (String)entry.getKey();
                    factory = (ValidatorFactory)entry.getValue();
                    try {
                        Validator validator;
                        containerSystemContext.bind("openejb/ValidatorFactory/" + id, (Object)factory);
                        try {
                            LazyValidator lazyValidator = new LazyValidator(factory);
                            validator = (Validator)Proxy.newProxyInstance(appContext.getClassLoader(), VALIDATOR_INTERFACES, (InvocationHandler)lazyValidator);
                            lazyValidators.put(id, lazyValidator);
                        }
                        catch (Exception e) {
                            this.logger.error(e.getMessage(), e);
                            continue;
                        }
                        containerSystemContext.bind("openejb/Validator/" + id, (Object)validator);
                    }
                    catch (NameAlreadyBoundException e) {
                        throw new OpenEJBException("ValidatorFactory already exists for module " + id, e);
                    }
                    catch (Exception e) {
                        throw new OpenEJBException(e);
                    }
                }
                validatorFactories.clear();
            }
            HashMap<String, String> units = new HashMap<String, String>();
            PersistenceBuilder persistenceBuilder = new PersistenceBuilder(this.persistenceClassLoaderHandler);
            for (PersistenceUnitInfo persistenceUnitInfo : appInfo.persistenceUnits) {
                ReloadableEntityManagerFactory factory;
                try {
                    factory = persistenceBuilder.createEntityManagerFactory(persistenceUnitInfo, classLoader, validatorFactoriesByConfig);
                    this.containerSystem.getJNDIContext().bind("openejb/PersistenceUnit/" + persistenceUnitInfo.id, (Object)factory);
                    units.put(persistenceUnitInfo.name, "openejb/PersistenceUnit/" + persistenceUnitInfo.id);
                }
                catch (NameAlreadyBoundException e) {
                    throw new OpenEJBException("PersistenceUnit already deployed: " + persistenceUnitInfo.persistenceUnitRootUrl);
                }
                catch (Exception e) {
                    throw new OpenEJBException(e);
                }
                factory.register();
            }
            this.logger.debug("Loaded peristence units: " + units);
            for (ConnectorInfo connectorInfo : appInfo.connectors) {
                ClassLoader oldClassLoader = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    if (connectorInfo.resourceAdapter != null) {
                        this.createResource(connectorInfo.resourceAdapter);
                    }
                    for (ResourceInfo outbound : connectorInfo.outbound) {
                        this.createResource(outbound);
                        outbound.properties.setProperty("openejb.connector", "true");
                    }
                    for (MdbContainerInfo inbound : connectorInfo.inbound) {
                        this.createContainer(inbound);
                    }
                    for (ResourceInfo adminObject : connectorInfo.adminObject) {
                        this.createResource(adminObject);
                    }
                }
                finally {
                    Thread.currentThread().setContextClassLoader(oldClassLoader);
                }
            }
            List<BeanContext> allDeployments = this.initEjbs(classLoader, appInfo, appContext, injections, new ArrayList<BeanContext>(), null);
            if ("true".equalsIgnoreCase(SystemInstance.get().getProperty(PROPAGATE_APPLICATION_EXCEPTIONS, appInfo.properties.getProperty(PROPAGATE_APPLICATION_EXCEPTIONS, "false")))) {
                this.propagateApplicationExceptions(appInfo, classLoader, allDeployments);
            }
            if (this.shouldStartCdi(appInfo)) {
                new CdiBuilder().build(appInfo, appContext, allDeployments);
                this.ensureWebBeansContext(appContext);
                appJndiContext.bind("app/BeanManager", (Object)appContext.getBeanManager());
                appContext.getBindings().put("app/BeanManager", appContext.getBeanManager());
            } else {
                appInfo.properties.setProperty("openejb.cdi.activated", "false");
            }
            if (!isGeronimo) {
                for (Map.Entry lazyValidator : lazyValidators.entrySet()) {
                    String id = (String)lazyValidator.getKey();
                    ValidatorFactory factory = ((LazyValidatorFactory)lazyValidatorFactories.get(lazyValidator.getKey())).getFactory();
                    try {
                        String factoryName = "openejb/ValidatorFactory/" + id;
                        containerSystemContext.unbind(factoryName);
                        containerSystemContext.bind(factoryName, (Object)factory);
                        String validatoryName = "openejb/Validator/" + id;
                        try {
                            Validator val = ((LazyValidator)lazyValidator.getValue()).getValidator();
                            containerSystemContext.unbind(validatoryName);
                            containerSystemContext.bind(validatoryName, (Object)val);
                        }
                        catch (Exception e) {
                            this.logger.error(e.getMessage(), e);
                        }
                    }
                    catch (NameAlreadyBoundException e) {
                        throw new OpenEJBException("ValidatorFactory already exists for module " + id, e);
                    }
                    catch (Exception e) {
                        throw new OpenEJBException(e);
                    }
                }
            }
            this.startEjbs(start, allDeployments);
            for (ClientInfo clientInfo : appInfo.clients) {
                List<Injection> clientInjections = injectionBuilder.buildInjections(clientInfo.jndiEnc);
                JndiEncBuilder jndiEncBuilder = new JndiEncBuilder(clientInfo.jndiEnc, clientInjections, "Bean", clientInfo.moduleId, null, clientInfo.uniqueId, classLoader, new Properties());
                if (clientInfo.remoteClients.size() > 0 || clientInfo.localClients.size() == 0) {
                    jndiEncBuilder.setClient(true);
                }
                jndiEncBuilder.setUseCrossClassLoaderRef(false);
                Context context = jndiEncBuilder.build(JndiEncBuilder.JndiScope.comp);
                containerSystemContext.bind("openejb/client/" + clientInfo.moduleId, (Object)context);
                if (clientInfo.path != null) {
                    context.bind("info/path", (Object)clientInfo.path);
                }
                if (clientInfo.mainClass != null) {
                    context.bind("info/mainClass", (Object)clientInfo.mainClass);
                }
                if (clientInfo.callbackHandler != null) {
                    context.bind("info/callbackHandler", (Object)clientInfo.callbackHandler);
                }
                context.bind("info/injections", clientInjections);
                for (String clientClassName : clientInfo.remoteClients) {
                    containerSystemContext.bind("openejb/client/" + clientClassName, (Object)clientInfo.moduleId);
                }
                for (String clientClassName : clientInfo.localClients) {
                    containerSystemContext.bind("openejb/client/" + clientClassName, (Object)clientInfo.moduleId);
                    this.logger.getChildLogger("client").info("createApplication.createLocalClient", clientClassName, clientInfo.moduleId);
                }
            }
            SystemInstance systemInstance = SystemInstance.get();
            WebAppBuilder webAppBuilder = (WebAppBuilder)systemInstance.getComponent(WebAppBuilder.class);
            if (webAppBuilder != null) {
                webAppBuilder.deployWebApps(appInfo, classLoader);
            }
            if (start) {
                EjbResolver globalEjbResolver = (EjbResolver)systemInstance.getComponent(EjbResolver.class);
                globalEjbResolver.addAll(appInfo.ejbJars);
            }
            this.bindGlobals(appContext.getBindings());
            this.validateCdiResourceProducers(appContext, appInfo);
            for (String mbean : appInfo.mbeans) {
                this.deployMBean(appContext.getWebBeansContext(), classLoader, mbean, appInfo.jmx, appInfo.appId);
            }
            for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
                for (String mbean : ejbJarInfo.mbeans) {
                    this.deployMBean(appContext.getWebBeansContext(), classLoader, mbean, appInfo.jmx, ejbJarInfo.moduleName);
                }
            }
            for (ConnectorInfo connectorInfo : appInfo.connectors) {
                for (String mbean : connectorInfo.mbeans) {
                    this.deployMBean(appContext.getWebBeansContext(), classLoader, mbean, appInfo.jmx, appInfo.appId + ".add-lib");
                }
            }
            this.postConstructResources(appInfo.resourceIds, classLoader, containerSystemContext, appContext);
            this.deployedApplications.put(appInfo.path, appInfo);
            this.resumePersistentSchedulers(appContext);
            systemInstance.fireEvent((Object)new AssemblerAfterApplicationCreated(appInfo, appContext, allDeployments));
            this.logger.info("createApplication.success", appInfo.path);
            return appContext;
        }
        catch (DeploymentException | ValidationException ve) {
            throw ve;
        }
        catch (Throwable t) {
            try {
                this.destroyApplication(appInfo);
            }
            catch (Exception e1) {
                this.logger.debug("createApplication.undeployFailed", e1, appInfo.path);
            }
            throw new OpenEJBException(this.messages.format("createApplication.failed", appInfo.path), t);
        }
    }

    private boolean shouldStartCdi(AppInfo appInfo) {
        if (!"true".equalsIgnoreCase(appInfo.properties.getProperty("openejb.cdi.activated", "true"))) {
            return false;
        }
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            if (ejbJarInfo.beans == null || ejbJarInfo.beans.bdas.isEmpty() && ejbJarInfo.beans.noDescriptorBdas.isEmpty()) continue;
            return true;
        }
        return false;
    }

    private void validateCdiResourceProducers(AppContext appContext, AppInfo info) {
        if (appContext.getWebBeansContext() == null) {
            return;
        }
        if (appContext.isStandaloneModule() && !appContext.getProperties().containsKey("openejb.cdi.skip-resource-validation")) {
            Map<String, Object> bindings;
            Map<String, Object> map = bindings = appContext.getWebContexts().isEmpty() ? appContext.getBindings() : appContext.getWebContexts().iterator().next().getBindings();
            if (bindings != null && appContext.getWebBeansContext() != null && appContext.getWebBeansContext().getBeanManagerImpl().isInUse()) {
                for (Bean bean : appContext.getWebBeansContext().getBeanManagerImpl().getBeans()) {
                    Object lookup;
                    ResourceReference reference;
                    block18: {
                        Resource r;
                        CdiPlugin plugin;
                        if (!ResourceBean.class.isInstance(bean)) continue;
                        reference = ((ResourceBean)ResourceBean.class.cast(bean)).getReference();
                        String jndi = reference.getJndiName().replace("java:", "");
                        if (reference.getJndiName().startsWith("java:/")) {
                            jndi = jndi.substring(1);
                        }
                        if ((lookup = bindings.get(jndi)) == null && reference.getAnnotation(EJB.class) != null && !(plugin = (CdiPlugin)((Object)CdiPlugin.class.cast(appContext.getWebBeansContext().getPluginLoader().getEjbPlugin()))).isSessionBean(reference.getResourceType())) {
                            boolean ok = false;
                            for (BeanContext bc : appContext.getBeanContexts()) {
                                if (!bc.getBusinessLocalInterfaces().contains(reference.getResourceType()) && !bc.getBusinessRemoteInterfaces().contains(reference.getResourceType())) continue;
                                ok = true;
                                break;
                            }
                            if (!ok) {
                                throw new DefinitionException("EJB " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to " + reference.getResourceType());
                            }
                        }
                        if (Reference.class.isInstance(lookup)) {
                            try {
                                lookup = ((Reference)((Object)Reference.class.cast(lookup))).getContent();
                                break block18;
                            }
                            catch (Exception e) {
                                if (!JndiUrlReference.class.isInstance(lookup)) continue;
                                this.checkBuiltInResourceTypes(reference, ((JndiUrlReference)((Object)JndiUrlReference.class.cast(lookup))).getJndiName());
                                continue;
                            }
                        }
                        if (lookup == null && (r = (Resource)Resource.class.cast(reference.getAnnotation(Resource.class))) != null) {
                            if (!r.lookup().isEmpty()) {
                                this.checkBuiltInResourceTypes(reference, r.lookup());
                            } else if (!r.name().isEmpty()) {
                                String name = "comp/env/" + r.name();
                                boolean done = false;
                                for (WebAppInfo w : info.webApps) {
                                    for (EnvEntryInfo e : w.jndiEnc.envEntries) {
                                        if (!name.equals(e.referenceName)) continue;
                                        if (e.type != null && !reference.getResourceType().getName().equals(e.type)) {
                                            throw new DefinitionException("Env Entry " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to " + reference.getResourceType());
                                        }
                                        done = true;
                                        break;
                                    }
                                    if (!done) continue;
                                    break;
                                }
                            }
                        }
                    }
                    if (lookup == null || reference.getResourceType().isInstance(lookup)) continue;
                    throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast, instance is " + lookup);
                }
            }
        }
    }

    private void checkBuiltInResourceTypes(ResourceReference reference, String jndi) {
        Class resourceType = reference.getResourceType();
        if ("java:comp/BeanManager".equals(jndi) && resourceType != BeanManager.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a BeanManager");
        }
        if ("java:comp/TransactionSynchronizationRegistry".equals(jndi) && resourceType != TransactionSynchronizationRegistry.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a TransactionSynchronizationRegistry");
        }
        if ("java:comp/TransactionManager".equals(jndi) && resourceType != TransactionManager.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a TransactionManager");
        }
        if ("java:comp/ValidatorFactory".equals(jndi) && resourceType != ValidatorFactory.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a ValidatorFactory");
        }
        if ("java:comp/Validator".equals(jndi) && resourceType != Validator.class) {
            throw new DefinitionException("Resource " + reference.getJndiName() + " in " + reference.getOwnerClass() + " can't be cast to a Validator");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void postConstructResources(Set<String> resourceIds, ClassLoader classLoader, Context containerSystemContext, AppContext appContext) throws NamingException, OpenEJBException {
        Thread thread = Thread.currentThread();
        ClassLoader oldCl = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(classLoader);
            List<ResourceInfo> resourceList = this.config.facilities.resources;
            for (ResourceInfo resourceInfo : resourceList) {
                if (!resourceIds.contains(resourceInfo.id) || Assembler.isTemplatizedResource(resourceInfo)) continue;
                try {
                    Class<?> clazz;
                    try {
                        clazz = classLoader.loadClass(resourceInfo.className);
                    }
                    catch (ClassNotFoundException cnfe) {
                        clazz = containerSystemContext.lookup("openejb/Resource/" + resourceInfo.id).getClass();
                    }
                    boolean initialize = "true".equalsIgnoreCase(String.valueOf(resourceInfo.properties.remove("InitializeAfterDeployment")));
                    AnnotationFinder finder = Proxy.isProxyClass(clazz) ? null : new AnnotationFinder((Archive)new ClassesArchive(Classes.ancestors(clazz)));
                    List postConstructs = finder == null ? Collections.emptyList() : finder.findAnnotatedMethods(PostConstruct.class);
                    List preDestroys = finder == null ? Collections.emptyList() : finder.findAnnotatedMethods(PreDestroy.class);
                    CreationalContextImpl creationalContext = null;
                    Object originalResource = null;
                    if (!postConstructs.isEmpty() || initialize) {
                        originalResource = containerSystemContext.lookup("openejb/Resource/" + resourceInfo.id);
                        Object resource = originalResource;
                        if (resource instanceof Reference) {
                            resource = Assembler.unwrapReference(resource);
                            this.bindResource(resourceInfo.id, resource, true);
                        }
                        try {
                            BeanManagerImpl beanManager;
                            if (appContext != null && appContext.getWebBeansContext() != null && (beanManager = appContext.getWebBeansContext().getBeanManagerImpl()).isInUse()) {
                                creationalContext = beanManager.createCreationalContext(null);
                                OWBInjector.inject((BeanManager)beanManager, (Object)resource, (CreationalContext)creationalContext);
                            }
                            if (!"none".equals(resourceInfo.postConstruct)) {
                                if (resourceInfo.postConstruct != null) {
                                    Method p = clazz.getDeclaredMethod(resourceInfo.postConstruct, new Class[0]);
                                    if (!p.isAccessible()) {
                                        SetAccessible.on(p);
                                    }
                                    p.invoke(resource, new Object[0]);
                                }
                                for (Method m : postConstructs) {
                                    if (!m.isAccessible()) {
                                        SetAccessible.on(m);
                                    }
                                    m.invoke(resource, new Object[0]);
                                }
                            }
                        }
                        catch (Exception e) {
                            this.logger.fatal("Error calling @PostConstruct method on " + resource.getClass().getName());
                            throw new OpenEJBException(e);
                        }
                    }
                    if (!"none".equals(resourceInfo.preDestroy)) {
                        if (resourceInfo.preDestroy != null) {
                            Method p = clazz.getDeclaredMethod(resourceInfo.preDestroy, new Class[0]);
                            if (!p.isAccessible()) {
                                SetAccessible.on(p);
                            }
                            preDestroys.add(p);
                        }
                        if (!preDestroys.isEmpty() || creationalContext != null) {
                            String name = "openejb/Resource/" + resourceInfo.id;
                            if (originalResource == null) {
                                originalResource = containerSystemContext.lookup(name);
                            }
                            this.bindResource(resourceInfo.id, new ResourceInstance(name, originalResource, preDestroys, (CreationalContext<?>)creationalContext), true);
                        }
                    }
                    if (resourceInfo.unsetProperties == null || Assembler.isPassthroughType(resourceInfo)) continue;
                    Set<String> unsetKeys = resourceInfo.unsetProperties.stringPropertyNames();
                    for (String key : unsetKeys) {
                        Assembler.unusedProperty(resourceInfo.id, this.logger, key);
                    }
                }
                catch (Exception e) {
                    this.logger.fatal("Error calling @PostConstruct method on " + resourceInfo.id);
                    throw new OpenEJBException(e);
                    return;
                }
            }
        }
        finally {
            thread.setContextClassLoader(oldCl);
        }
    }

    private static boolean isTemplatizedResource(ResourceInfo resourceInfo) {
        return resourceInfo.className == null || resourceInfo.className.isEmpty();
    }

    public static void mergeServices(AppInfo appInfo) throws URISyntaxException {
        for (ServiceInfo si : appInfo.services) {
            if (appInfo.properties.containsKey(si.id)) continue;
            HashMap<String, String> query = new HashMap<String, String>();
            if (si.types != null && !si.types.isEmpty()) {
                query.put("type", si.types.iterator().next());
            }
            if (si.className != null) {
                query.put("class-name", si.className);
            }
            if (si.factoryMethod != null) {
                query.put("factory-name", si.factoryMethod);
            }
            if (si.constructorArgs != null && !si.constructorArgs.isEmpty()) {
                query.put("constructor", Join.join(",", si.constructorArgs));
            }
            appInfo.properties.put(si.id, "new://Service?" + URISupport.createQueryString(query));
            if (si.properties == null) continue;
            for (String k : si.properties.stringPropertyNames()) {
                appInfo.properties.setProperty(si.id + "." + k, si.properties.getProperty(k));
            }
        }
    }

    private static List<CommonInfoObject> listCommonInfoObjectsForAppInfo(AppInfo appInfo) {
        ArrayList<CommonInfoObject> vfs = new ArrayList<CommonInfoObject>(appInfo.clients.size() + appInfo.connectors.size() + appInfo.ejbJars.size() + appInfo.webApps.size());
        for (ClientInfo clientInfo : appInfo.clients) {
            vfs.add(clientInfo);
        }
        for (ConnectorInfo connectorInfo : appInfo.connectors) {
            vfs.add(connectorInfo);
        }
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            vfs.add(ejbJarInfo);
        }
        for (WebAppInfo webAppInfo : appInfo.webApps) {
            vfs.add(webAppInfo);
        }
        return vfs;
    }

    public void bindGlobals(Map<String, Object> bindings) throws NamingException {
        Context containerSystemContext = this.containerSystem.getJNDIContext();
        for (Map.Entry<String, Object> value : bindings.entrySet()) {
            String path = value.getKey();
            if (path.startsWith("module/") || path.startsWith("app/") || path.startsWith("comp/") || path.equalsIgnoreCase("global/dummy")) continue;
            Context lastContext = Contexts.createSubcontexts(containerSystemContext, path);
            try {
                lastContext.rebind(path.substring(path.lastIndexOf("/") + 1, path.length()), value.getValue());
            }
            catch (NameAlreadyBoundException nabe) {
                nabe.printStackTrace();
            }
            containerSystemContext.rebind(path, value.getValue());
        }
    }

    private void propagateApplicationExceptions(AppInfo appInfo, ClassLoader classLoader, List<BeanContext> allDeployments) {
        for (BeanContext context : allDeployments) {
            if (BeanContext.Comp.class.equals((Object)context.getBeanClass())) continue;
            for (EjbJarInfo jar : appInfo.ejbJars) {
                for (ApplicationExceptionInfo exception : jar.applicationException) {
                    try {
                        Class<?> exceptionClass = classLoader.loadClass(exception.exceptionClass);
                        context.addApplicationException(exceptionClass, exception.rollback, exception.inherited);
                    }
                    catch (Exception e) {}
                }
            }
        }
    }

    private void resumePersistentSchedulers(AppContext appContext) {
        try {
            Scheduler globalScheduler = (Scheduler)SystemInstance.get().getComponent(Scheduler.class);
            ArrayList<Scheduler> schedulers = new ArrayList<Scheduler>();
            for (BeanContext ejb : appContext.getBeanContexts()) {
                Scheduler scheduler = ejb.get(Scheduler.class);
                if (scheduler == null || scheduler == globalScheduler || schedulers.contains(scheduler)) continue;
                schedulers.add(scheduler);
                try {
                    scheduler.resumeAll();
                }
                catch (Exception e) {
                    this.logger.warning("Can't resume scheduler for " + ejb.getEjbName(), e);
                }
            }
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            // empty catch block
        }
    }

    public List<BeanContext> initEjbs(ClassLoader classLoader, AppInfo appInfo, AppContext appContext, Set<Injection> injections, List<BeanContext> allDeployments, String webappId) throws OpenEJBException {
        String globalTimersOn = SystemInstance.get().getProperty(OPENEJB_TIMERS_ON, "true");
        EjbJarBuilder ejbJarBuilder = new EjbJarBuilder(this.props, appContext);
        for (EjbJarInfo ejbJar : appInfo.ejbJars) {
            boolean skip = false;
            if (!appInfo.webAppAlone) {
                if (webappId == null) {
                    skip = ejbJar.webapp;
                } else if (!ejbJar.webapp || !ejbJar.moduleId.equals(webappId) && !ejbJar.properties.getProperty("openejb.ejbmodule.webappId", "-").equals(webappId)) {
                    skip = true;
                }
            }
            if (skip) continue;
            HashMap<String, BeanContext> deployments = ejbJarBuilder.build(ejbJar, injections, classLoader);
            JaccPermissionsBuilder jaccPermissionsBuilder = new JaccPermissionsBuilder();
            PolicyContext policyContext = jaccPermissionsBuilder.build(ejbJar, deployments);
            jaccPermissionsBuilder.install(policyContext);
            TransactionPolicyFactory transactionPolicyFactory = this.createTransactionPolicyFactory(ejbJar, classLoader);
            for (BeanContext beanContext : deployments.values()) {
                beanContext.setTransactionPolicyFactory(transactionPolicyFactory);
            }
            MethodTransactionBuilder methodTransactionBuilder = new MethodTransactionBuilder();
            methodTransactionBuilder.build(deployments, ejbJar.methodTransactions);
            MethodConcurrencyBuilder methodConcurrencyBuilder = new MethodConcurrencyBuilder();
            methodConcurrencyBuilder.build(deployments, ejbJar.methodConcurrency);
            for (BeanContext beanContext : deployments.values()) {
                this.containerSystem.addDeployment(beanContext);
            }
            this.jndiBuilder.build(ejbJar, deployments);
            for (BeanContext beanContext : deployments.values()) {
                if (beanContext.getComponentType() != BeanType.STATEFUL) {
                    Method ejbTimeout = beanContext.getEjbTimeout();
                    boolean timerServiceRequired = false;
                    if (ejbTimeout != null) {
                        if (beanContext.getTransactionType(ejbTimeout) == TransactionType.RequiresNew) {
                            beanContext.setMethodTransactionAttribute(ejbTimeout, TransactionType.Required);
                        }
                        timerServiceRequired = true;
                    }
                    Iterator<Map.Entry<Method, MethodContext>> it = beanContext.iteratorMethodContext();
                    while (it.hasNext()) {
                        Map.Entry<Method, MethodContext> entry = it.next();
                        MethodContext methodContext = entry.getValue();
                        if (methodContext.getSchedules().size() <= 0) continue;
                        timerServiceRequired = true;
                        Method method = entry.getKey();
                        if (beanContext.getTransactionType(method) != TransactionType.RequiresNew) continue;
                        beanContext.setMethodTransactionAttribute(method, TransactionType.Required);
                    }
                    if (timerServiceRequired && "true".equalsIgnoreCase(appInfo.properties.getProperty(OPENEJB_TIMERS_ON, globalTimersOn))) {
                        EjbTimerServiceImpl timerService = new EjbTimerServiceImpl(beanContext, this.newTimerStore(beanContext));
                        TimerStore timerStore = timerService.getTimerStore();
                        Iterator<Map.Entry<Method, MethodContext>> it2 = beanContext.iteratorMethodContext();
                        while (it2.hasNext()) {
                            Map.Entry<Method, MethodContext> entry = it2.next();
                            MethodContext methodContext = entry.getValue();
                            for (ScheduleData scheduleData : methodContext.getSchedules()) {
                                timerStore.createCalendarTimer(timerService, (String)beanContext.getDeploymentID(), null, entry.getKey(), scheduleData.getExpression(), scheduleData.getConfig(), true);
                            }
                        }
                        beanContext.setEjbTimerService(timerService);
                    } else {
                        beanContext.setEjbTimerService(new NullEjbTimerServiceImpl());
                    }
                }
                Iterator<Map.Entry<Method, MethodContext>> it = beanContext.iteratorMethodContext();
                while (it.hasNext()) {
                    Map.Entry<Method, MethodContext> entry = it.next();
                    if (!entry.getValue().isAsynchronous() || beanContext.getTransactionType(entry.getKey()) != TransactionType.RequiresNew) continue;
                    beanContext.setMethodTransactionAttribute(entry.getKey(), TransactionType.Required);
                }
                if (!beanContext.isLocalbean() || beanContext.getComponentType().isMessageDriven() || beanContext.isDynamicallyImplemented()) continue;
                ArrayList<Class<BeanContext.Removable>> interfaces = new ArrayList<Class<BeanContext.Removable>>(3);
                interfaces.add(Serializable.class);
                interfaces.add(IntraVmProxy.class);
                BeanType type = beanContext.getComponentType();
                if (BeanType.STATEFUL.equals((Object)type) || BeanType.MANAGED.equals((Object)type)) {
                    interfaces.add(BeanContext.Removable.class);
                }
                beanContext.set(BeanContext.ProxyClass.class, new BeanContext.ProxyClass(beanContext, interfaces.toArray(new Class[interfaces.size()])));
            }
            for (ApplicationExceptionInfo exceptionInfo : ejbJar.applicationException) {
                try {
                    Class<?> exceptionClass = classLoader.loadClass(exceptionInfo.exceptionClass);
                    for (BeanContext beanContext : deployments.values()) {
                        beanContext.addApplicationException(exceptionClass, exceptionInfo.rollback, exceptionInfo.inherited);
                    }
                }
                catch (ClassNotFoundException e) {
                    this.logger.error("createApplication.invalidClass", e, exceptionInfo.exceptionClass, e.getMessage());
                }
            }
            allDeployments.addAll(deployments.values());
        }
        List<BeanContext> ejbs = Assembler.sort(allDeployments);
        for (BeanContext b : ejbs) {
            if (appContext.getBeanContexts().contains(b)) continue;
            appContext.getBeanContexts().add(b);
        }
        return ejbs;
    }

    private TimerStore newTimerStore(BeanContext beanContext) {
        for (DeploymentContext context : Arrays.asList(beanContext, beanContext.getModuleContext(), beanContext.getModuleContext().getAppContext())) {
            String timerStoreClass = context.getProperties().getProperty(TIMER_STORE_CLASS);
            if (timerStoreClass == null) continue;
            this.logger.info("Found timer class: " + timerStoreClass);
            try {
                Class<?> clazz = beanContext.getClassLoader().loadClass(timerStoreClass);
                try {
                    Constructor<?> constructor = clazz.getConstructor(TransactionManager.class);
                    return (TimerStore)TimerStore.class.cast(constructor.newInstance(EjbTimerServiceImpl.getDefaultTransactionManager()));
                }
                catch (Exception ignored) {
                    return (TimerStore)TimerStore.class.cast(clazz.newInstance());
                }
            }
            catch (Exception e) {
                this.logger.error("Can't instantiate " + timerStoreClass + ", using default memory timer store");
            }
        }
        return new MemoryTimerStore(EjbTimerServiceImpl.getDefaultTransactionManager());
    }

    public void startEjbs(boolean start, List<BeanContext> allDeployments) throws OpenEJBException {
        if (start) {
            Container container;
            SystemInstance.get().fireEvent((Object)new BeforeStartEjbs(allDeployments));
            ArrayList<BeanContext> toStart = new ArrayList<BeanContext>();
            for (BeanContext deployment : allDeployments) {
                try {
                    container = deployment.getContainer();
                    if (container.getBeanContext(deployment.getDeploymentID()) != null) continue;
                    container.deploy(deployment);
                    if (!((String)deployment.getDeploymentID()).endsWith(".Comp") && !deployment.isHidden()) {
                        this.logger.info("createApplication.createdEjb", deployment.getDeploymentID(), deployment.getEjbName(), container.getContainerID());
                    }
                    if (this.logger.isDebugEnabled()) {
                        for (Map.Entry<Object, Object> entry : deployment.getProperties().entrySet()) {
                            this.logger.info("createApplication.createdEjb.property", deployment.getEjbName(), entry.getKey(), entry.getValue());
                        }
                    }
                    toStart.add(deployment);
                }
                catch (Throwable t) {
                    throw new OpenEJBException("Error deploying '" + deployment.getEjbName() + "'.  Exception: " + t.getClass() + ": " + t.getMessage(), t);
                }
            }
            for (BeanContext deployment : toStart) {
                try {
                    container = deployment.getContainer();
                    container.start(deployment);
                    if (((String)deployment.getDeploymentID()).endsWith(".Comp") || deployment.isHidden()) continue;
                    this.logger.info("createApplication.startedEjb", deployment.getDeploymentID(), deployment.getEjbName(), container.getContainerID());
                }
                catch (Throwable t) {
                    throw new OpenEJBException("Error starting '" + deployment.getEjbName() + "'.  Exception: " + t.getClass() + ": " + t.getMessage(), t);
                }
            }
        }
    }

    private void deployMBean(WebBeansContext wc, ClassLoader cl, String mbeanClass, Properties appMbeans, String id) {
        if (LocalMBeanServer.isJMXActive()) {
            CreationalContext creationalContext;
            Object instance;
            Bean bean;
            BeanManagerImpl bm;
            Class<?> clazz;
            try {
                clazz = cl.loadClass(mbeanClass);
            }
            catch (ClassNotFoundException e) {
                throw new OpenEJBRuntimeException(e);
            }
            if (wc == null) {
                bm = null;
                bean = null;
            } else {
                bm = wc.getBeanManagerImpl();
                Set beans = bm.getBeans(clazz, new Annotation[0]);
                bean = bm.resolve(beans);
            }
            if (bean == null) {
                try {
                    instance = clazz.newInstance();
                }
                catch (InstantiationException e) {
                    this.logger.error("the mbean " + mbeanClass + " can't be registered because it can't be instantiated", e);
                    return;
                }
                catch (IllegalAccessException e) {
                    this.logger.error("the mbean " + mbeanClass + " can't be registered because it can't be accessed", e);
                    return;
                }
                creationalContext = null;
            } else {
                creationalContext = bm.createCreationalContext(bean);
                instance = bm.getReference(bean, clazz, creationalContext);
            }
            MBeanServer server = LocalMBeanServer.get();
            try {
                ObjectName leaf = new ObjectNameBuilder("openejb.user.mbeans").set("application", id).set("group", clazz.getPackage().getName()).set("name", clazz.getSimpleName()).build();
                server.registerMBean(new DynamicMBeanWrapper(wc, instance), leaf);
                appMbeans.put(mbeanClass, leaf.getCanonicalName());
                if (creationalContext != null && (bean.getScope() == null || Dependent.class.equals((Object)bean.getScope()))) {
                    this.creationalContextForAppMbeans.put(leaf, creationalContext);
                }
                this.logger.info("Deployed MBean(" + leaf.getCanonicalName() + ")");
            }
            catch (Exception e) {
                this.logger.error("the mbean " + mbeanClass + " can't be registered", e);
            }
        }
    }

    private void ensureWebBeansContext(AppContext appContext) {
        WebBeansContext webBeansContext = appContext.get(WebBeansContext.class);
        if (webBeansContext != null) {
            if (null == appContext.getWebBeansContext()) {
                appContext.setWebBeansContext(webBeansContext);
            }
            return;
        }
        webBeansContext = appContext.getWebBeansContext();
        if (webBeansContext == null) {
            HashMap<Class, Object> services = new HashMap<Class, Object>();
            services.put(JNDIService.class, new OpenEJBJndiService());
            services.put(AppContext.class, appContext);
            services.put(ScannerService.class, new CdiScanner());
            services.put(BeanArchiveService.class, new OpenEJBBeanInfoService());
            services.put(ELAdaptor.class, new CustomELAdapter(appContext));
            services.put(LoaderService.class, new OptimizedLoaderService());
            Properties properties = new Properties();
            properties.setProperty(SecurityService.class.getName(), ManagedSecurityService.class.getName());
            properties.setProperty(ContextsService.class.getName(), CdiAppContextsService.class.getName());
            properties.setProperty(ResourceInjectionService.class.getName(), CdiResourceInjectionService.class.getName());
            properties.setProperty(TransactionService.class.getName(), OpenEJBTransactionService.class.getName());
            webBeansContext = new WebBeansContext(services, properties);
            appContext.setCdiEnabled(false);
            appContext.set(WebBeansContext.class, webBeansContext);
            appContext.setWebBeansContext(webBeansContext);
        }
    }

    private TransactionPolicyFactory createTransactionPolicyFactory(EjbJarInfo ejbJar, ClassLoader classLoader) {
        TransactionPolicyFactory factory = null;
        Object value = ejbJar.properties.get(TransactionPolicyFactory.class.getName());
        if (value instanceof TransactionPolicyFactory) {
            factory = (TransactionPolicyFactory)value;
        } else if (value instanceof String) {
            try {
                String[] parts = ((String)value).split(":", 2);
                ResourceFinder finder = new ResourceFinder("META-INF", classLoader);
                Map plugins = finder.mapAvailableImplementations(TransactionPolicyFactory.class);
                Class clazz = (Class)plugins.get(parts[0]);
                if (clazz != null) {
                    factory = parts.length == 1 ? (TransactionPolicyFactory)clazz.getConstructor(String.class).newInstance(parts[1]) : (TransactionPolicyFactory)clazz.newInstance();
                }
            }
            catch (Exception ignored) {
                // empty catch block
            }
        }
        if (factory == null) {
            factory = new JtaTransactionPolicyFactory(this.transactionManager);
        }
        return factory;
    }

    private static List<BeanContext> sort(List<BeanContext> deployments) {
        Collections.sort(deployments, new Comparator<BeanContext>(){

            @Override
            public int compare(BeanContext a, BeanContext b) {
                int aa = a.getComponentType() == BeanType.SINGLETON ? 1 : 0;
                int bb = b.getComponentType() == BeanType.SINGLETON ? 1 : 0;
                return aa - bb;
            }
        });
        deployments = References.sort(deployments, new References.Visitor<BeanContext>(){

            @Override
            public String getName(BeanContext t) {
                return (String)t.getDeploymentID();
            }

            @Override
            public Set<String> getReferences(BeanContext t) {
                return t.getDependsOn();
            }
        });
        Collections.sort(deployments, new Comparator<BeanContext>(){

            @Override
            public int compare(BeanContext a, BeanContext b) {
                int aa = a.getComponentType() == BeanType.MESSAGE_DRIVEN ? 1 : 0;
                int bb = b.getComponentType() == BeanType.MESSAGE_DRIVEN ? 1 : 0;
                return aa - bb;
            }
        });
        return deployments;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void destroy() {
        ReentrantLock l = lock;
        l.lock();
        try {
            SystemInstance systemInstance = SystemInstance.get();
            systemInstance.fireEvent((Object)new ContainerSystemPreDestroy());
            try {
                EjbTimerServiceImpl.shutdown();
            }
            catch (Exception e) {
                this.logger.warning("Unable to shutdown scheduler", e);
            }
            catch (NoClassDefFoundError ncdfe) {
                // empty catch block
            }
            this.logger.debug("Undeploying Applications");
            Assembler assembler = this;
            ArrayList<AppInfo> deployedApps = new ArrayList<AppInfo>(assembler.getDeployedApplications());
            Collections.reverse(deployedApps);
            for (AppInfo appInfo : deployedApps) {
                try {
                    assembler.destroyApplication(appInfo.path);
                }
                catch (UndeployException e) {
                    this.logger.error("Undeployment failed: " + appInfo.path, e);
                }
                catch (NoSuchApplicationException e) {}
            }
            Iterator<ObjectName> it = this.containerObjectNames.iterator();
            MBeanServer server = LocalMBeanServer.get();
            while (it.hasNext()) {
                try {
                    server.unregisterMBean(it.next());
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                it.remove();
            }
            try {
                this.remoteResourceMonitor.unregister();
            }
            catch (Exception ignored) {
                // empty catch block
            }
            NamingEnumeration<Binding> namingEnumeration = null;
            try {
                namingEnumeration = this.containerSystem.getJNDIContext().listBindings("openejb/Resource");
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            this.destroyResourceTree(namingEnumeration);
            try {
                this.containerSystem.getJNDIContext().unbind("java:global");
            }
            catch (NamingException ignored) {
                // empty catch block
            }
            systemInstance.removeComponent(OpenEjbConfiguration.class);
            systemInstance.removeComponent(JtaEntityManagerRegistry.class);
            systemInstance.removeComponent(TransactionSynchronizationRegistry.class);
            systemInstance.removeComponent(EjbResolver.class);
            systemInstance.fireEvent((Object)new AssemblerDestroyed());
            systemInstance.removeObservers();
            SystemInstance.reset();
        }
        finally {
            l.unlock();
        }
    }

    private Collection<DestroyingResource> destroyResourceTree(NamingEnumeration<Binding> namingEnumeration) {
        LinkedList<DestroyingResource> resources = new LinkedList<DestroyingResource>();
        while (namingEnumeration != null && namingEnumeration.hasMoreElements()) {
            Binding binding = (Binding)namingEnumeration.nextElement();
            Object object = binding.getObject();
            if (Context.class.isInstance(object)) {
                try {
                    resources.addAll(this.destroyResourceTree(((Context)Context.class.cast(object)).listBindings("")));
                }
                catch (Exception ignored) {}
                continue;
            }
            resources.add(new DestroyingResource(binding.getName(), binding.getClassName(), object));
        }
        Collections.sort(resources, new Comparator<DestroyingResource>(){

            @Override
            public int compare(DestroyingResource o1, DestroyingResource o2) {
                if (ResourceAdapter.class.isInstance(o2.instance) && !ResourceAdapter.class.isInstance(o1.instance)) {
                    return -1;
                }
                return 1;
            }
        });
        for (DestroyingResource resource : resources) {
            try {
                this.destroyResource(resource.name, resource.clazz, resource.instance);
            }
            catch (Throwable th) {
                this.logger.debug(th.getMessage(), th);
            }
        }
        return resources;
    }

    private void destroyResource(String name, String className, Object object) {
        ResourceAdapterReference resourceAdapter;
        Object preDestroy = null;
        if (object instanceof ResourceAdapterReference) {
            resourceAdapter = (ResourceAdapterReference)((Object)object);
            try {
                this.logger.info("Stopping ResourceAdapter: " + name);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Stopping ResourceAdapter: " + className);
                }
                if (resourceAdapter.pool != null && ExecutorService.class.isInstance(resourceAdapter.pool)) {
                    ((ExecutorService)ExecutorService.class.cast(resourceAdapter.pool)).shutdownNow();
                }
                resourceAdapter.ra.stop();
            }
            catch (Throwable t) {
                this.logger.fatal("ResourceAdapter Shutdown Failed: " + name, t);
            }
        } else if (object instanceof ResourceAdapter) {
            resourceAdapter = (ResourceAdapter)object;
            try {
                this.logger.info("Stopping ResourceAdapter: " + name);
                if (this.logger.isDebugEnabled()) {
                    this.logger.debug("Stopping ResourceAdapter: " + className);
                }
                resourceAdapter.stop();
            }
            catch (Throwable t) {
                this.logger.fatal("ResourceAdapter Shutdown Failed: " + name, t);
            }
        } else if (DataSourceFactory.knows(object)) {
            this.logger.info("Closing DataSource: " + name);
            try {
                DataSourceFactory.destroy(object);
            }
            catch (Throwable t) {}
        } else if (object instanceof ConnectorReference) {
            ConnectorReference cr = (ConnectorReference)((Object)object);
            try {
                ConnectionManager cm = cr.getConnectionManager();
                if (cm != null && cm instanceof AbstractConnectionManager) {
                    ((AbstractConnectionManager)cm).doStop();
                }
            }
            catch (Exception e) {
                this.logger.debug("Not processing resource on destroy: " + className, e);
            }
        } else if (DestroyableResource.class.isInstance(object)) {
            try {
                ((DestroyableResource)DestroyableResource.class.cast(object)).destroyResource();
            }
            catch (RuntimeException e) {
                this.logger.error(e.getMessage(), e);
            }
        } else if (this.logger.isDebugEnabled() && !DataSource.class.isInstance(object)) {
            this.logger.debug("Not processing resource on destroy: " + className);
        }
        try {
            OpenEjbConfiguration configuration = (OpenEjbConfiguration)SystemInstance.get().getComponent(OpenEjbConfiguration.class);
            Iterator<ResourceInfo> iterator = configuration.facilities.resources.iterator();
            while (iterator.hasNext()) {
                ResourceInfo info = iterator.next();
                if (!name.equals(info.id)) continue;
                iterator.remove();
                break;
            }
        }
        catch (Exception e) {
            this.logger.debug("Failed to purge resource on destroy: " + e.getMessage());
        }
    }

    private static Object unwrapReference(Object object) {
        Object o = object;
        while (o != null && Reference.class.isInstance(o)) {
            try {
                o = ((Reference)((Object)Reference.class.cast(o))).getObject();
            }
            catch (NamingException namingException) {}
        }
        if (o == null) {
            o = object;
        }
        return o;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApplication(String filePath) throws UndeployException, NoSuchApplicationException {
        ReentrantLock l = lock;
        l.lock();
        try {
            AppInfo appInfo = this.deployedApplications.remove(filePath);
            if (appInfo == null) {
                throw new NoSuchApplicationException(filePath);
            }
            this.destroyApplication(appInfo);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApplication(AppContext appContext) throws UndeployException {
        ReentrantLock l = lock;
        l.lock();
        try {
            AppInfo appInfo = this.deployedApplications.remove(appContext.getId());
            if (appInfo == null) {
                throw new IllegalStateException(String.format("Cannot find AppInfo for app: %s", appContext.getId()));
            }
            this.destroyApplication(appInfo);
        }
        finally {
            l.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroyApplication(AppInfo appInfo) throws UndeployException {
        ReentrantLock l = lock;
        l.lock();
        try {
            String name;
            Container container;
            String deploymentID;
            this.deployedApplications.remove(appInfo.path);
            this.logger.info("destroyApplication.start", appInfo.path);
            Context globalContext = this.containerSystem.getJNDIContext();
            AppContext appContext = this.containerSystem.getAppContext(appInfo.appId);
            ClassLoader classLoader = appContext.getClassLoader();
            SystemInstance.get().fireEvent((Object)new AssemblerBeforeApplicationDestroyed(appInfo, appContext));
            if (null == appContext) {
                this.logger.warning("Application id '" + appInfo.appId + "' not found in: " + Arrays.toString(this.containerSystem.getAppContextKeys()));
                return;
            }
            WebBeansContext webBeansContext = appContext.getWebBeansContext();
            if (webBeansContext != null) {
                ClassLoader old = Thread.currentThread().getContextClassLoader();
                Thread.currentThread().setContextClassLoader(classLoader);
                try {
                    ServletContext context = appContext.isStandaloneModule() && appContext.getWebContexts().iterator().hasNext() ? appContext.getWebContexts().iterator().next().getServletContext() : null;
                    ((ContainerLifecycle)webBeansContext.getService(ContainerLifecycle.class)).stopApplication(context);
                }
                finally {
                    Thread.currentThread().setContextClassLoader(old);
                }
            }
            Map<String, Object> cb = appContext.getBindings();
            for (Map.Entry<String, Object> value : cb.entrySet()) {
                String path = value.getKey();
                if (path.startsWith(GLOBAL_UNIQUE_ID)) {
                    path = "java:" + path;
                }
                if (!path.startsWith("java:global")) continue;
                this.unbind(globalContext, path);
                this.unbind(globalContext, "openejb/global/" + path.substring("java:".length()));
                this.unbind(globalContext, path.substring("java:global".length()));
            }
            if (appInfo.appId != null && !appInfo.appId.isEmpty() && !"openejb".equals(appInfo.appId)) {
                this.unbind(globalContext, "global/" + appInfo.appId);
                this.unbind(globalContext, appInfo.appId);
            }
            EjbResolver globalResolver = new EjbResolver(null, EjbResolver.Scope.GLOBAL, new EjbJarInfo[0]);
            for (AppInfo info : this.deployedApplications.values()) {
                globalResolver.addAll(info.ejbJars);
            }
            SystemInstance.get().setComponent(EjbResolver.class, (Object)globalResolver);
            UndeployException undeployException = new UndeployException(this.messages.format("destroyApplication.failed", appInfo.path));
            WebAppBuilder webAppBuilder = (WebAppBuilder)SystemInstance.get().getComponent(WebAppBuilder.class);
            if (webAppBuilder != null && !appInfo.webAppAlone) {
                try {
                    webAppBuilder.undeployWebApps(appInfo);
                }
                catch (Exception e) {
                    undeployException.getCauses().add(new Exception("App: " + appInfo.path + ": " + e.getMessage(), e));
                }
            }
            List<BeanContext> deployments = new ArrayList<BeanContext>();
            for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
                for (EnterpriseBeanInfo beanInfo : ejbJarInfo.enterpriseBeans) {
                    String deploymentId = beanInfo.ejbDeploymentId;
                    BeanContext beanContext = this.containerSystem.getBeanContext(deploymentId);
                    if (beanContext == null) {
                        undeployException.getCauses().add(new Exception("deployment not found: " + deploymentId));
                        continue;
                    }
                    deployments.add(beanContext);
                }
            }
            deployments = Assembler.sort(deployments);
            Collections.reverse(deployments);
            for (BeanContext deployment : deployments) {
                deploymentID = String.valueOf(deployment.getDeploymentID());
                try {
                    container = deployment.getContainer();
                    container.stop(deployment);
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("bean: " + deploymentID + ": " + t.getMessage(), t));
                }
            }
            for (BeanContext bean : deployments) {
                deploymentID = String.valueOf(bean.getDeploymentID());
                try {
                    container = bean.getContainer();
                    container.undeploy(bean);
                    bean.setContainer(null);
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("bean: " + deploymentID + ": " + t.getMessage(), t));
                }
                finally {
                    bean.setDestroyed(true);
                }
            }
            if (webAppBuilder != null && appInfo.webAppAlone) {
                try {
                    webAppBuilder.undeployWebApps(appInfo);
                }
                catch (Exception e) {
                    undeployException.getCauses().add(new Exception("App: " + appInfo.path + ": " + e.getMessage(), e));
                }
            }
            ArrayList<String> clientIds = new ArrayList<String>();
            for (ClientInfo clientInfo : appInfo.clients) {
                clientIds.add(clientInfo.moduleId);
                for (String className : clientInfo.localClients) {
                    clientIds.add(className);
                }
                for (String className : clientInfo.remoteClients) {
                    clientIds.add(className);
                }
            }
            for (WebContext webContext : appContext.getWebContexts()) {
                this.containerSystem.removeWebContext(webContext);
            }
            TldScanner.forceCompleteClean(classLoader);
            for (BeanContext deployment : deployments) {
                JndiBuilder.Bindings bindings;
                String deploymentID2 = String.valueOf(deployment.getDeploymentID());
                try {
                    this.containerSystem.removeBeanContext(deployment);
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception(deploymentID2, t));
                }
                if ((bindings = deployment.get(JndiBuilder.Bindings.class)) == null) continue;
                for (String name2 : bindings.getBindings()) {
                    try {
                        globalContext.unbind(name2);
                    }
                    catch (Throwable t) {
                        undeployException.getCauses().add(new Exception("bean: " + deploymentID2 + ": " + t.getMessage(), t));
                    }
                }
            }
            AsynchronousPool pool = appContext.get(AsynchronousPool.class);
            if (pool != null) {
                pool.stop();
            }
            for (CommonInfoObject jar : Assembler.listCommonInfoObjectsForAppInfo(appInfo)) {
                try {
                    globalContext.unbind("openejb/ValidatorFactory/" + jar.uniqueId);
                    globalContext.unbind("openejb/Validator/" + jar.uniqueId);
                }
                catch (NamingException e) {
                    if (!EjbJarInfo.class.isInstance(jar)) continue;
                    undeployException.getCauses().add(new Exception("validator: " + jar.uniqueId + ": " + e.getMessage(), e));
                }
            }
            try {
                if (globalContext instanceof IvmContext) {
                    IvmContext ivmContext = (IvmContext)globalContext;
                    ivmContext.prune("openejb/Deployment");
                    ivmContext.prune("openejb/local");
                    ivmContext.prune("openejb/remote");
                    ivmContext.prune("openejb/global");
                }
            }
            catch (NamingException e) {
                undeployException.getCauses().add(new Exception("Unable to prune openejb/Deployments and openejb/local namespaces, this could cause future deployments to fail.", e));
            }
            deployments.clear();
            for (String clientId : clientIds) {
                try {
                    globalContext.unbind("/openejb/client/" + clientId);
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("client: " + clientId + ": " + t.getMessage(), t));
                }
            }
            MBeanServer server = LocalMBeanServer.get();
            for (Object objectName : appInfo.jmx.values()) {
                try {
                    CreationalContext cc;
                    ObjectName on = new ObjectName((String)objectName);
                    if (server.isRegistered(on)) {
                        server.unregisterMBean(on);
                    }
                    if ((cc = this.creationalContextForAppMbeans.remove(on)) == null) continue;
                    cc.release();
                }
                catch (InstanceNotFoundException e) {
                    this.logger.warning("can't unregister " + objectName + " because the mbean was not found", e);
                }
                catch (MBeanRegistrationException e) {
                    this.logger.warning("can't unregister " + objectName, e);
                }
                catch (MalformedObjectNameException mone) {
                    this.logger.warning("can't unregister because the ObjectName is malformed: " + objectName, mone);
                }
            }
            for (PersistenceUnitInfo unitInfo : appInfo.persistenceUnits) {
                try {
                    Object object = globalContext.lookup("openejb/PersistenceUnit/" + unitInfo.id);
                    globalContext.unbind("openejb/PersistenceUnit/" + unitInfo.id);
                    ReloadableEntityManagerFactory remf = (ReloadableEntityManagerFactory)object;
                    remf.close();
                    this.persistenceClassLoaderHandler.destroy(unitInfo.id);
                    remf.unregister();
                }
                catch (Throwable t) {
                    undeployException.getCauses().add(new Exception("persistence-unit: " + unitInfo.id + ": " + t.getMessage(), t));
                }
            }
            for (String id : appInfo.resourceAliases) {
                name = "openejb/Resource/" + id;
                ContextualJndiReference.followReference.set(false);
                try {
                    Object object;
                    try {
                        object = globalContext.lookup(name);
                    }
                    finally {
                        ContextualJndiReference.followReference.remove();
                    }
                    if (object instanceof ContextualJndiReference) {
                        ContextualJndiReference contextualJndiReference = (ContextualJndiReference)((Object)ContextualJndiReference.class.cast(object));
                        contextualJndiReference.removePrefix(appContext.getId());
                        if (!contextualJndiReference.hasNoMorePrefix()) continue;
                        globalContext.unbind(name);
                        continue;
                    }
                    globalContext.unbind(name);
                }
                catch (NamingException e) {
                    this.logger.warning("can't unbind resource '{0}'", id);
                }
            }
            for (String id : appInfo.resourceIds) {
                name = "openejb/Resource/" + id;
                try {
                    this.destroyLookedUpResource(globalContext, id, name);
                }
                catch (NamingException e) {
                    this.logger.warning("can't unbind resource '{0}'", id);
                }
            }
            for (ConnectorInfo connector : appInfo.connectors) {
                if (connector.resourceAdapter == null || connector.resourceAdapter.id == null) continue;
                name = "openejb/Resource/" + connector.resourceAdapter.id;
                try {
                    this.destroyLookedUpResource(globalContext, connector.resourceAdapter.id, name);
                }
                catch (NamingException e) {
                    this.logger.warning("can't unbind resource '{0}'", connector);
                }
                for (ResourceInfo outbound : connector.outbound) {
                    try {
                        this.destroyLookedUpResource(globalContext, outbound.id, "openejb/Resource/" + outbound.id);
                    }
                    catch (Exception e) {}
                }
                for (ResourceInfo outbound : connector.adminObject) {
                    try {
                        this.destroyLookedUpResource(globalContext, outbound.id, "openejb/Resource/" + outbound.id);
                    }
                    catch (Exception e) {}
                }
                for (MdbContainerInfo container2 : connector.inbound) {
                    try {
                        this.containerSystem.removeContainer(container2.id);
                        this.config.containerSystem.containers.remove(container2);
                        this.containerSystem.getJNDIContext().unbind("openejb/" + container2.service + "/" + container2.id);
                    }
                    catch (Exception e) {}
                }
            }
            for (String id : appInfo.containerIds) {
                this.removeContainer(id);
            }
            this.containerSystem.removeAppContext(appInfo.appId);
            if (!appInfo.properties.containsKey("tomee.destroying")) {
                try {
                    Method m = classLoader.getClass().getMethod("internalStop", new Class[0]);
                    m.invoke((Object)classLoader, new Object[0]);
                }
                catch (NoSuchMethodException nsme) {
                }
                catch (Exception e) {
                    this.logger.error("error stopping classloader of webapp " + appInfo.appId, e);
                }
                ClassLoaderUtil.cleanOpenJPACache(classLoader);
            }
            ClassLoaderUtil.destroyClassLoader(appInfo.appId, appInfo.path);
            if (undeployException.getCauses().size() > 0) {
                throw undeployException;
            }
            this.logger.debug("destroyApplication.success", appInfo.path);
        }
        finally {
            l.unlock();
        }
    }

    private void destroyLookedUpResource(Context globalContext, String id, String name) throws NamingException {
        Object object = globalContext.lookup(name);
        String clazz = object == null ? "?" : object.getClass().getName();
        this.destroyResource(id, clazz, object);
        globalContext.unbind(name);
    }

    private void unbind(Context context, String name) {
        try {
            context.unbind(name);
        }
        catch (NamingException namingException) {
            // empty catch block
        }
    }

    /*
     * WARNING - void declaration
     */
    public ClassLoader createAppClassLoader(AppInfo appInfo) throws OpenEJBException, IOException {
        void var4_16;
        if ("openejb".equals(appInfo.appId)) {
            return ParentClassLoaderFinder.Helper.get();
        }
        HashSet<URL> jars = new HashSet<URL>();
        for (EjbJarInfo ejbJarInfo : appInfo.ejbJars) {
            if (ejbJarInfo.path == null) continue;
            jars.add(this.toUrl(ejbJarInfo.path));
        }
        for (ClientInfo clientInfo : appInfo.clients) {
            if (clientInfo.path == null) continue;
            jars.add(this.toUrl(clientInfo.path));
        }
        for (ConnectorInfo connectorInfo : appInfo.connectors) {
            for (String jarPath : connectorInfo.libs) {
                jars.add(this.toUrl(jarPath));
            }
        }
        for (String string : appInfo.libs) {
            jars.add(this.toUrl(string));
        }
        if (appInfo.libs.size() > 0) {
            try {
                File jpaIntegrationFile = JarLocation.jarLocation(MakeTxLookup.class);
                URL uRL = jpaIntegrationFile.toURI().toURL();
                if (!jars.contains(uRL)) {
                    jars.add(uRL);
                }
            }
            catch (RuntimeException re) {
                this.logger.warning("can't find open-jpa-integration jar");
            }
        }
        jars.addAll(Arrays.asList(((ClassLoaderEnricher)SystemInstance.get().getComponent(ClassLoaderEnricher.class)).applicationEnrichment()));
        ClassLoader parent = ParentClassLoaderFinder.Helper.get();
        if (appInfo.webAppAlone) {
            String string = "WEB-INF/";
        } else {
            String string = "META-INF/";
        }
        ClassLoaderConfigurer configurer1 = QuickJarsTxtParser.parse(new File(appInfo.path, (String)var4_16 + "jars.txt"));
        ClassLoaderConfigurer configurer2 = ClassLoaderUtil.configurer(appInfo.appId);
        if (configurer1 != null || configurer2 != null) {
            CompositeClassLoaderConfigurer configurer = new CompositeClassLoaderConfigurer(configurer1, configurer2);
            ClassLoaderConfigurer.Helper.configure(jars, configurer);
        }
        URL[] filtered = jars.toArray(new URL[jars.size()]);
        if (this.skipLoaderIfPossible) {
            if ("classpath.ear".equals(appInfo.appId)) {
                return parent;
            }
            HashSet<File> urls = new HashSet<File>();
            for (URL url : ClassLoaders.findUrls((ClassLoader)parent)) {
                try {
                    urls.add(URLs.toFile(url).getCanonicalFile());
                }
                catch (Exception error) {
                    if (!this.logger.isDebugEnabled()) continue;
                    this.logger.debug("Can't determine url for: " + url.toExternalForm(), error);
                }
            }
            boolean allIsIntheClasspath = true;
            for (URL url : filtered) {
                try {
                    if (urls.contains(URLs.toFile(url).getCanonicalFile())) continue;
                    allIsIntheClasspath = false;
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug(url.toExternalForm() + " (" + URLs.toFile(url) + ") is not in the classloader so we'll create a dedicated classloader for this app");
                }
                catch (Exception ignored) {
                    allIsIntheClasspath = false;
                    if (!this.logger.isDebugEnabled()) break;
                    this.logger.debug(url.toExternalForm() + " (" + URLs.toFile(url) + ") is not in the classloader", ignored);
                }
                break;
            }
            if (allIsIntheClasspath) {
                this.logger.info("Not creating another application classloader for " + appInfo.appId);
                return parent;
            }
            if (this.logger.isDebugEnabled()) {
                this.logger.debug("Logging all urls from the app since we don't skip the app classloader creation:");
                for (URL url : filtered) {
                    this.logger.debug(" -> " + url.toExternalForm());
                }
                this.logger.debug("Logging all urls from the classloader since we don't skip the app classloader creation:");
                for (File url : urls) {
                    this.logger.debug(" -> " + url.getAbsolutePath());
                }
            }
        }
        this.logger.info("Creating dedicated application classloader for " + appInfo.appId);
        if (!appInfo.delegateFirst) {
            return ClassLoaderUtil.createClassLoader(appInfo.path, filtered, parent);
        }
        return ClassLoaderUtil.createClassLoaderFirst(appInfo.path, filtered, parent);
    }

    public void createExternalContext(JndiContextInfo contextInfo) throws OpenEJBException {
        InitialContext initialContext;
        this.logger.getChildLogger("service").info("createService", contextInfo.service, contextInfo.id, contextInfo.className);
        try {
            initialContext = new InitialContext(contextInfo.properties);
        }
        catch (NamingException ne) {
            throw new OpenEJBException(String.format("JndiProvider(id=\"%s\") could not be created.  Failed to create the InitialContext using the supplied properties", contextInfo.id), ne);
        }
        try {
            this.containerSystem.getJNDIContext().bind("openejb/remote_jndi_contexts/" + contextInfo.id, (Object)initialContext);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + contextInfo.service + " with id " + contextInfo.id, e);
        }
        this.config.facilities.remoteJndiContexts.add(contextInfo);
        this.logger.getChildLogger("service").debug("createService.success", contextInfo.service, contextInfo.id, contextInfo.className);
    }

    public void createContainer(ContainerInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        serviceRecipe.setProperty("id", (Object)serviceInfo.id);
        serviceRecipe.setProperty("transactionManager", this.props.get(TransactionManager.class.getName()));
        serviceRecipe.setProperty("securityService", this.props.get(org.apache.openejb.spi.SecurityService.class.getName()));
        serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe());
        this.replaceResourceAdapterProperty(serviceRecipe);
        Object service = serviceRecipe.create();
        serviceRecipe.getUnsetProperties().remove("id");
        serviceRecipe.getUnsetProperties().remove("securityService");
        Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.containerSystem.addContainer(serviceInfo.id, (Container)service);
        this.config.containerSystem.containers.add(serviceInfo);
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
        if (Container.class.isInstance(service) && LocalMBeanServer.isJMXActive()) {
            ObjectName objectName = ObjectNameBuilder.uniqueName("containers", serviceInfo.id, service);
            try {
                LocalMBeanServer.get().registerMBean(new DynamicMBeanWrapper(new JMXContainer(serviceInfo, (Container)service)), objectName);
                this.containerObjectNames.add(objectName);
            }
            catch (Exception | NoClassDefFoundError e) {
                // empty catch block
            }
        }
    }

    private void bindService(ServiceInfo serviceInfo, Object service) throws OpenEJBException {
        try {
            this.containerSystem.getJNDIContext().bind("openejb/" + serviceInfo.service + "/" + serviceInfo.id, service);
        }
        catch (NamingException e) {
            throw new OpenEJBException(this.messages.format("assembler.cannotBindServiceWithId", serviceInfo.service, serviceInfo.id), e);
        }
    }

    public void removeContainer(String containerId) {
        this.containerSystem.removeContainer(containerId);
        Iterator<ContainerInfo> iterator = this.config.containerSystem.containers.iterator();
        while (iterator.hasNext()) {
            ContainerInfo containerInfo = iterator.next();
            if (!containerInfo.id.equals(containerId)) continue;
            iterator.remove();
            try {
                this.containerSystem.getJNDIContext().unbind("openejb/" + containerInfo.service + "/" + containerInfo.id);
            }
            catch (Exception e) {
                this.logger.error("removeContainer.unbindFailed", containerId);
            }
        }
    }

    public void createService(ServiceInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe());
        Object service = serviceRecipe.create();
        SystemInstance.get().addObserver(service);
        Assembler.logUnusedProperties(serviceRecipe, serviceInfo);
        Class<?> serviceClass = service.getClass();
        Assembler.getContext().put(serviceClass.getName(), service);
        this.props.put(serviceClass.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.services.add(serviceInfo);
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createProxyFactory(ProxyFactoryInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        Object service = serviceRecipe.create();
        Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        ProxyManager.registerFactory(serviceInfo.id, (ProxyFactory)service);
        ProxyManager.setDefaultFactory(serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.intraVmServer = serviceInfo;
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    private void replaceResourceAdapterProperty(ObjectRecipe serviceRecipe) throws OpenEJBException {
        Object resourceAdapterId = serviceRecipe.getProperty("ResourceAdapter");
        if (resourceAdapterId instanceof String) {
            String id = (String)resourceAdapterId;
            id = id.trim();
            Object resourceAdapter = null;
            try {
                resourceAdapter = this.containerSystem.getJNDIContext().lookup("openejb/Resource/" + id);
            }
            catch (NamingException e) {
                // empty catch block
            }
            if (resourceAdapter == null) {
                throw new OpenEJBException("No existing resource adapter defined with id '" + id + "'.");
            }
            if (!(resourceAdapter instanceof ResourceAdapter)) {
                throw new OpenEJBException(this.messages.format("assembler.resourceAdapterNotResourceAdapter", id, resourceAdapter.getClass()));
            }
            serviceRecipe.setProperty("ResourceAdapter", resourceAdapter);
        }
    }

    public void createResource(ResourceInfo serviceInfo) throws OpenEJBException {
        Object service;
        boolean usesCdiPwdCipher = this.usesCdiPwdCipher(serviceInfo);
        Object object = service = "true".equalsIgnoreCase(String.valueOf(serviceInfo.properties.remove("Lazy"))) || usesCdiPwdCipher ? this.newLazyResource(serviceInfo) : this.doCreateResource(serviceInfo);
        if (usesCdiPwdCipher && !serviceInfo.properties.contains("InitializeAfterDeployment")) {
            serviceInfo.properties.put("InitializeAfterDeployment", "true");
        }
        this.bindResource(serviceInfo.id, service, false);
        for (String alias : serviceInfo.aliases) {
            this.bindResource(alias, service, false);
        }
        if (!(serviceInfo.originAppName == null || serviceInfo.originAppName.isEmpty() || "/".equals(serviceInfo.originAppName) || serviceInfo.id.startsWith(GLOBAL_UNIQUE_ID))) {
            String baseJndiName = serviceInfo.id.substring(serviceInfo.originAppName.length() + 1);
            serviceInfo.aliases.add(baseJndiName);
            ContextualJndiReference ref = new ContextualJndiReference(baseJndiName);
            ref.addPrefix(serviceInfo.originAppName);
            this.bindResource(baseJndiName, (Object)ref, false);
        }
        this.config.facilities.resources.add(serviceInfo);
        if (this.logger.isDebugEnabled()) {
            this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
        }
    }

    private boolean usesCdiPwdCipher(ResourceInfo serviceInfo) {
        for (Object val : serviceInfo.properties.values()) {
            if (!String.valueOf(val).startsWith("cipher:cdi:")) continue;
            return true;
        }
        return false;
    }

    private LazyResource newLazyResource(final ResourceInfo serviceInfo) {
        final ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return new LazyResource(new Callable<Object>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Object call() throws Exception {
                boolean appClassLoader = "true".equals(serviceInfo.properties.remove("UseAppClassLoader"));
                ClassLoader old = null;
                if (!appClassLoader) {
                    old = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(loader);
                }
                try {
                    Object object = Assembler.this.doCreateResource(serviceInfo);
                    return object;
                }
                finally {
                    if (old != null) {
                        Thread.currentThread().setContextClassLoader(old);
                    }
                }
            }
        });
    }

    private Object doCreateResource(ResourceInfo serviceInfo) throws OpenEJBException {
        ArrayList apis;
        final ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        boolean properties = PropertiesFactory.class.getName().equals(serviceInfo.className);
        if ("false".equalsIgnoreCase(serviceInfo.properties.getProperty("SkipImplicitAttributes", "false")) && !properties) {
            serviceRecipe.setProperty("transactionManager", (Object)this.transactionManager);
            serviceRecipe.setProperty("ServiceId", (Object)serviceInfo.id);
        }
        serviceInfo.properties.remove("SkipImplicitAttributes");
        String skipPropertiesFallback = (String)serviceInfo.properties.remove("SkipPropertiesFallback");
        final AtomicReference<7> injectedProperties = new AtomicReference<7>();
        if (!"true".equalsIgnoreCase(skipPropertiesFallback)) {
            serviceRecipe.setProperty("properties", (Object)new UnsetPropertiesRecipe(){

                protected Object internalCreate(Type expectedType, boolean lazyRefAllowed) throws ConstructionException {
                    final Map original = serviceRecipe.getUnsetProperties();
                    SuperProperties properties = new SuperProperties(){

                        @Override
                        public Object remove(Object key) {
                            original.remove(key);
                            return super.remove(key);
                        }
                    }.caseInsensitive(true);
                    for (Map.Entry entry : original.entrySet()) {
                        ((Properties)properties).put(entry.getKey(), entry.getValue());
                    }
                    injectedProperties.set(properties);
                    return properties;
                }
            });
        } else {
            final Map unsetProperties = serviceRecipe.getUnsetProperties();
            injectedProperties.set(new Properties(){

                @Override
                public String getProperty(String key) {
                    Object obj = unsetProperties.get(key);
                    return String.class.isInstance(obj) ? String.valueOf(obj) : null;
                }

                @Override
                public Set<String> stringPropertyNames() {
                    return unsetProperties.keySet();
                }

                @Override
                public Set<Object> keySet() {
                    return (Set)Set.class.cast(unsetProperties.keySet());
                }

                @Override
                public synchronized boolean containsKey(Object key) {
                    return this.getProperty(String.valueOf(key)) != null;
                }
            });
        }
        if (serviceInfo.types.contains("DataSource") || serviceInfo.types.contains(DataSource.class.getName())) {
            Properties props = PropertyPlaceHolderHelper.simpleHolds(serviceInfo.properties);
            if (serviceInfo.properties.containsKey("Definition")) {
                Object encoding = serviceInfo.properties.remove("DefitionEncoding");
                try {
                    ByteArrayInputStream is = new ByteArrayInputStream(serviceInfo.properties.getProperty("Definition").getBytes(encoding != null ? encoding.toString() : "ISO-8859-1"));
                    SuperProperties p = new SuperProperties();
                    IO.readProperties((InputStream)is, (Properties)p);
                    for (Map.Entry<Object, Object> entry : ((Properties)p).entrySet()) {
                        String key = entry.getKey().toString();
                        if (props.containsKey(key) || key.equalsIgnoreCase("url") && props.containsKey("JdbcUrl")) continue;
                        props.put(key, entry.getValue());
                    }
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
            serviceRecipe.setProperty("Definition", (Object)PropertiesHelper.propertiesToString(props));
        }
        this.replaceResourceAdapterProperty(serviceRecipe);
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        boolean customLoader = false;
        try {
            if (serviceInfo.classpath != null && serviceInfo.classpath.length > 0) {
                URL[] urls = new URL[serviceInfo.classpath.length];
                for (int i = 0; i < serviceInfo.classpath.length; ++i) {
                    urls[i] = serviceInfo.classpath[i].toURL();
                }
                loader = new URLClassLoaderFirst(urls, loader);
                customLoader = true;
            }
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException("Unable to create a classloader for " + serviceInfo.id, e);
        }
        Object service = serviceRecipe.create(loader);
        if (customLoader && (apis = new ArrayList(Arrays.asList(service.getClass().getInterfaces()))).size() - (apis.contains(Serializable.class) ? 1 : 0) - (apis.contains(Externalizable.class) ? 1 : 0) > 0) {
            service = Proxy.newProxyInstance(loader, apis.toArray(new Class[apis.size()]), (InvocationHandler)new ClassLoaderAwareHandler(null, service, loader));
        }
        serviceInfo.unsetProperties = (Properties)injectedProperties.get();
        if (service instanceof ResourceAdapter) {
            SimpleWorkManager workManager;
            ExecutorService threadPool;
            ResourceAdapter resourceAdapter = (ResourceAdapter)service;
            int threadPoolSize = this.getIntProperty(serviceInfo.properties, "threadPoolSize", 30);
            if (threadPoolSize <= 0) {
                this.logger.warning("Thread pool for '" + serviceInfo.id + "' is (unbounded), consider setting a size using: " + serviceInfo.id + ".QueueSize=[size]");
                threadPool = Executors.newCachedThreadPool(new DaemonThreadFactory(serviceInfo.id + "-worker-"));
            } else {
                threadPool = new ExecutorBuilder().size(threadPoolSize).prefix(serviceInfo.id).threadFactory(new DaemonThreadFactory(serviceInfo.id + "-worker-")).build(new Options(serviceInfo.properties, SystemInstance.get().getOptions()));
                this.logger.info("Thread pool size for '" + serviceInfo.id + "' is (" + threadPoolSize + ")");
            }
            if (GeronimoTransactionManager.class.isInstance(this.transactionManager)) {
                GeronimoTransactionManager geronimoTransactionManager = (GeronimoTransactionManager)this.transactionManager;
                TransactionContextHandler txWorkContextHandler = new TransactionContextHandler((XAWork)geronimoTransactionManager);
                String securityRealmName = this.getStringProperty(serviceInfo.properties, "realm", serviceInfo.id);
                SecurityContextHandler securityContextHandler = new SecurityContextHandler(securityRealmName);
                HintsContextHandler hintsContextHandler = new HintsContextHandler();
                ArrayList<Object> workContextHandlers = new ArrayList<Object>();
                workContextHandlers.add(txWorkContextHandler);
                workContextHandlers.add(securityContextHandler);
                workContextHandlers.add(hintsContextHandler);
                workManager = new GeronimoWorkManager((Executor)threadPool, (Executor)threadPool, (Executor)threadPool, workContextHandlers);
            } else {
                workManager = new SimpleWorkManager(threadPool);
            }
            SimpleBootstrapContext bootstrapContext = this.transactionManager instanceof GeronimoTransactionManager ? new GeronimoBootstrapContext((GeronimoWorkManager)GeronimoWorkManager.class.cast(workManager), (XATerminator)((GeronimoTransactionManager)this.transactionManager), (TransactionSynchronizationRegistry)((GeronimoTransactionManager)this.transactionManager)) : (this.transactionManager instanceof XATerminator ? new SimpleBootstrapContext(workManager, (XATerminator)this.transactionManager) : new SimpleBootstrapContext(workManager));
            try {
                this.logger.debug("createResource.startingResourceAdapter", serviceInfo.id, service.getClass().getName());
                resourceAdapter.start((BootstrapContext)bootstrapContext);
            }
            catch (ResourceAdapterInternalException e) {
                throw new OpenEJBException(e);
            }
            Map unset = serviceRecipe.getUnsetProperties();
            unset.remove("threadPoolSize");
            Assembler.logUnusedProperties(unset, (ServiceInfo)serviceInfo);
            service = new ResourceAdapterReference(resourceAdapter, threadPool, "openejb/Resource/" + serviceInfo.id);
        } else if (service instanceof ManagedConnectionFactory) {
            ManagedConnectionFactory managedConnectionFactory = (ManagedConnectionFactory)service;
            ObjectRecipe connectionManagerRecipe = new ObjectRecipe(GeronimoConnectionManagerFactory.class, "create");
            connectionManagerRecipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
            connectionManagerRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
            connectionManagerRecipe.setAllProperties((Map)serviceInfo.properties);
            connectionManagerRecipe.setProperty("name", (Object)serviceInfo.id);
            connectionManagerRecipe.setProperty("mcf", (Object)managedConnectionFactory);
            connectionManagerRecipe.setProperty("transactionManager", (Object)this.transactionManager);
            ClassLoader classLoader = loader;
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if (classLoader == null) {
                classLoader = ClassLoader.getSystemClassLoader();
            }
            connectionManagerRecipe.setProperty("classLoader", (Object)classLoader);
            this.logger.getChildLogger("service").info("createResource.createConnectionManager", serviceInfo.id, service.getClass().getName());
            ConnectionManager connectionManager = (ConnectionManager)connectionManagerRecipe.create();
            if (connectionManager == null) {
                throw new OpenEJBRuntimeException(this.messages.format("assembler.invalidConnectionManager", serviceInfo.id));
            }
            Map unsetA = serviceRecipe.getUnsetProperties();
            Map unsetB = connectionManagerRecipe.getUnsetProperties();
            HashMap unset = new HashMap();
            for (Map.Entry entry : unsetA.entrySet()) {
                if (!unsetB.containsKey(entry.getKey())) continue;
                unset.put(entry.getKey(), entry.getValue());
            }
            service = new ConnectorReference(connectionManager, managedConnectionFactory);
            Object eagerInit = unset.remove("eagerInit");
            if (eagerInit != null && eagerInit instanceof String && "true".equalsIgnoreCase((String)eagerInit) && connectionManager instanceof AbstractConnectionManager) {
                try {
                    ((AbstractConnectionManager)connectionManager).doStart();
                    try {
                        Object cf = managedConnectionFactory.createConnectionFactory(connectionManager);
                        if (cf instanceof ConnectionFactory) {
                            Connection connection = ((ConnectionFactory)cf).getConnection();
                            connection.getMetaData();
                            connection.close();
                        }
                    }
                    catch (Exception e) {}
                }
                catch (Exception e) {
                    this.logger.warning("Can't start connection manager", e);
                }
            }
            Assembler.logUnusedProperties(unset, (ServiceInfo)serviceInfo);
        } else if (service instanceof DataSource) {
            Properties prop;
            String url;
            ObjectRecipe recipe;
            ImportSql importer;
            ClassLoader classLoader = loader;
            if (classLoader == null) {
                classLoader = this.getClass().getClassLoader();
            }
            if ((importer = new ImportSql(classLoader, serviceInfo.id, (DataSource)service)).hasSomethingToImport()) {
                importer.doImport();
            }
            if ((recipe = DataSourceFactory.forgetRecipe(service, serviceRecipe)) != serviceRecipe || !serviceInfo.properties.containsKey("XaDataSource")) {
                Assembler.logUnusedProperties(recipe, (ServiceInfo)serviceInfo);
            }
            if ((url = (prop = serviceInfo.properties).getProperty("JdbcUrl", prop.getProperty("url"))) == null) {
                url = prop.getProperty("jdbcUrl");
            }
            if (url == null) {
                this.logger.debug("can't find url for " + serviceInfo.id + " will not monitor it");
            } else {
                String host = Assembler.extractHost(url);
                if (host != null) {
                    this.remoteResourceMonitor.addHost(host);
                    this.remoteResourceMonitor.registerIfNot();
                }
            }
        } else if (!Properties.class.isInstance(service) && (serviceInfo.unsetProperties == null || Assembler.isTemplatizedResource(serviceInfo))) {
            Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        }
        return service;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bindResource(String id, Object service, boolean canReplace) throws OpenEJBException {
        String name = "openejb/Resource/" + id;
        Context jndiContext = this.containerSystem.getJNDIContext();
        Object existing = null;
        try {
            ContextualJndiReference.followReference.set(false);
            existing = jndiContext.lookup(name);
        }
        catch (Exception ignored) {
        }
        finally {
            ContextualJndiReference.followReference.remove();
        }
        boolean rebind = false;
        if (existing != null) {
            boolean existingIsContextual = ContextualJndiReference.class.isInstance(existing);
            boolean serviceIsExisting = ContextualJndiReference.class.isInstance(service);
            if (!existingIsContextual && serviceIsExisting) {
                ((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(service))).setDefaultValue(existing);
                rebind = true;
            } else if (existingIsContextual && !serviceIsExisting) {
                ((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(existing))).setDefaultValue(service);
            } else if (existingIsContextual) {
                ContextualJndiReference contextual = (ContextualJndiReference)((Object)ContextualJndiReference.class.cast(existing));
                if (canReplace && contextual.prefixesSize() == 1) {
                    contextual.removePrefix(contextual.lastPrefix());
                    contextual.setDefaultValue(service);
                } else {
                    contextual.addPrefix(((ContextualJndiReference)((Object)ContextualJndiReference.class.cast(service))).lastPrefix());
                }
                return;
            }
        }
        try {
            if (canReplace && existing != null) {
                jndiContext.unbind(name);
            }
            if (rebind) {
                jndiContext.rebind(name, service);
            } else {
                jndiContext.bind(name, service);
            }
        }
        catch (NameAlreadyBoundException nabe) {
            this.logger.warning("unbounding resource " + name + " can happen because of a redeployment or because of a duplicated id");
            try {
                jndiContext.unbind(name);
                jndiContext.bind(name, service);
            }
            catch (NamingException e) {
                throw new OpenEJBException("Cannot bind resource adapter with id " + id, e);
            }
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind resource adapter with id " + id, e);
        }
    }

    private static String extractHost(String url) {
        if (url == null || !url.contains("://")) {
            return null;
        }
        int idx = url.indexOf("://");
        String subUrl = url.substring(idx + 3);
        int port = subUrl.indexOf(58);
        int slash = subUrl.indexOf(47);
        int end = port;
        if (end < 0 || slash > 0 && slash < end) {
            end = slash;
        }
        if (end > 0) {
            return subUrl.substring(0, end);
        }
        return subUrl;
    }

    private int getIntProperty(Properties properties, String propertyName, int defaultValue) {
        String propertyValue = this.getStringProperty(properties, propertyName, Integer.toString(defaultValue));
        if (propertyValue == null) {
            return defaultValue;
        }
        try {
            return Integer.parseInt(propertyValue);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException(propertyName + " is not an integer " + propertyValue, e);
        }
    }

    private String getStringProperty(Properties properties, String propertyName, String defaultValue) {
        String propertyValue = properties.getProperty(propertyName);
        if (propertyValue == null) {
            return defaultValue;
        }
        return propertyValue;
    }

    public void createConnectionManager(ConnectionManagerInfo serviceInfo) throws OpenEJBException {
        ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
        Object object = this.props.get("TransactionManager");
        serviceRecipe.setProperty("transactionManager", object);
        Object service = serviceRecipe.create();
        Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        this.bindService(serviceInfo, service);
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.config.facilities.connectionManagers.add(serviceInfo);
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createSecurityService(SecurityServiceInfo serviceInfo) throws OpenEJBException {
        Object service = SystemInstance.get().getComponent(org.apache.openejb.spi.SecurityService.class);
        if (service == null) {
            ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
            service = serviceRecipe.create();
            Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        }
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        try {
            this.containerSystem.getJNDIContext().bind("openejb/" + serviceInfo.service, service);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + serviceInfo.service + " with id " + serviceInfo.id, e);
        }
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.securityService = (org.apache.openejb.spi.SecurityService)service;
        this.config.facilities.securityService = serviceInfo;
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public void createTransactionManager(TransactionServiceInfo serviceInfo) throws OpenEJBException {
        Object service = SystemInstance.get().getComponent(TransactionManager.class);
        if (service == null) {
            ObjectRecipe serviceRecipe = this.createRecipe(serviceInfo);
            service = serviceRecipe.create();
            Assembler.logUnusedProperties(serviceRecipe, (ServiceInfo)serviceInfo);
        } else {
            this.logger.info("Reusing provided TransactionManager " + service);
        }
        Class interfce = (Class)serviceInterfaces.get(serviceInfo.service);
        Assembler.checkImplementation(interfce, service.getClass(), serviceInfo.service, serviceInfo.id);
        try {
            this.containerSystem.getJNDIContext().bind("openejb/" + serviceInfo.service, service);
            this.containerSystem.getJNDIContext().bind("comp/UserTransaction", (Object)new CoreUserTransaction((TransactionManager)service));
            this.containerSystem.getJNDIContext().bind("comp/TransactionManager", service);
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind " + serviceInfo.service + " with id " + serviceInfo.id, e);
        }
        this.setSystemInstanceComponent(interfce, service);
        Assembler.getContext().put(interfce.getName(), service);
        this.props.put(interfce.getName(), service);
        this.props.put(serviceInfo.service, service);
        this.props.put(serviceInfo.id, service);
        this.transactionManager = (TransactionManager)service;
        this.config.facilities.transactionService = serviceInfo;
        Object synchronizationRegistry = this.transactionManager instanceof TransactionSynchronizationRegistry ? (TransactionSynchronizationRegistry)this.transactionManager : new SimpleTransactionSynchronizationRegistry(this.transactionManager);
        Assembler.getContext().put(TransactionSynchronizationRegistry.class.getName(), synchronizationRegistry);
        SystemInstance.get().setComponent(TransactionSynchronizationRegistry.class, synchronizationRegistry);
        try {
            this.containerSystem.getJNDIContext().bind("comp/TransactionSynchronizationRegistry", (Object)new TransactionSynchronizationRegistryWrapper());
        }
        catch (NamingException e) {
            throw new OpenEJBException("Cannot bind java:comp/TransactionSynchronizationRegistry", e);
        }
        JtaEntityManagerRegistry jtaEntityManagerRegistry = new JtaEntityManagerRegistry((TransactionSynchronizationRegistry)synchronizationRegistry);
        Assembler.getContext().put(JtaEntityManagerRegistry.class.getName(), jtaEntityManagerRegistry);
        SystemInstance.get().setComponent(JtaEntityManagerRegistry.class, (Object)jtaEntityManagerRegistry);
        this.logger.getChildLogger("service").debug("createService.success", serviceInfo.service, serviceInfo.id, serviceInfo.className);
    }

    public static void logUnusedProperties(ObjectRecipe serviceRecipe, ServiceInfo info) {
        Map unsetProperties = serviceRecipe.getUnsetProperties();
        Assembler.logUnusedProperties(unsetProperties, info);
    }

    private static void logUnusedProperties(Map<String, ?> unsetProperties, ServiceInfo info) {
        if (Assembler.isPassthroughType(info)) {
            return;
        }
        boolean ignoreJdbcDefault = "Annotation".equalsIgnoreCase(info.properties.getProperty("Origin"));
        Logger logger = null;
        for (String property : unsetProperties.keySet()) {
            if (ignoreJdbcDefault && ("JdbcUrl".equals(property) || "UserName".equals(property) || "Password".equals(property) || "PasswordCipher".equals(property)) || property.equalsIgnoreCase("Definition") || property.equalsIgnoreCase("SkipImplicitAttributes") || property.equalsIgnoreCase("JndiName") || property.equalsIgnoreCase("Origin") || property.equalsIgnoreCase("DatabaseName")) continue;
            if (property.equalsIgnoreCase("connectionAttributes")) {
                return;
            }
            if (property.equalsIgnoreCase("properties")) {
                return;
            }
            if (property.equalsIgnoreCase("ApplicationWide") || Assembler.isInternalProperty(property) || info.types.isEmpty() && "class".equalsIgnoreCase(property) || "destination".equalsIgnoreCase(property) && info.id.equals(unsetProperties.get("destination"))) continue;
            if (logger == null) {
                logger = ((Assembler)SystemInstance.get().getComponent(Assembler.class)).logger;
            }
            Assembler.unusedProperty(info.id, logger, property);
        }
    }

    private static boolean isPassthroughType(ServiceInfo info) {
        return info.types.contains("javax.mail.Session");
    }

    private static void unusedProperty(String id, Logger parentLogger, String property) {
        if (Assembler.isInternalProperty(property)) {
            return;
        }
        parentLogger.getChildLogger("service").warning("unusedProperty", property, id);
    }

    private static boolean isInternalProperty(String property) {
        if (property.equalsIgnoreCase("ServiceId")) {
            return true;
        }
        return property.equalsIgnoreCase("transactionManager");
    }

    private static void unusedProperty(String id, String property) {
        Assembler.unusedProperty(id, ((Assembler)SystemInstance.get().getComponent(Assembler.class)).logger, property);
    }

    public static ObjectRecipe prepareRecipe(ServiceInfo info) {
        String[] constructorArgs = info.constructorArgs.toArray(new String[info.constructorArgs.size()]);
        ObjectRecipe serviceRecipe = new ObjectRecipe(info.className, info.factoryMethod, constructorArgs, null);
        serviceRecipe.allow(Option.CASE_INSENSITIVE_PROPERTIES);
        serviceRecipe.allow(Option.IGNORE_MISSING_PROPERTIES);
        serviceRecipe.allow(Option.PRIVATE_PROPERTIES);
        return serviceRecipe;
    }

    private ObjectRecipe createRecipe(ServiceInfo info) {
        Logger serviceLogger = this.logger.getChildLogger("service");
        if (info instanceof ResourceInfo) {
            List<String> aliasesList = ((ResourceInfo)info).aliases;
            if (!aliasesList.isEmpty()) {
                String aliases = Join.join(", ", aliasesList);
                serviceLogger.info("createServiceWithAliases", info.service, info.id, aliases);
            } else {
                serviceLogger.info("createService", info.service, info.id);
            }
        } else {
            serviceLogger.info("createService", info.service, info.id);
        }
        ObjectRecipe serviceRecipe = Assembler.prepareRecipe(info);
        Object value = info.properties.remove("SkipImplicitAttributes");
        Properties allProperties = PropertyPlaceHolderHelper.simpleHolds(info.properties);
        allProperties.remove("SkipPropertiesFallback");
        serviceRecipe.setAllProperties((Map)allProperties);
        if (value != null) {
            info.properties.put("SkipImplicitAttributes", value);
        }
        if (serviceLogger.isDebugEnabled()) {
            for (Map.Entry entry : serviceRecipe.getProperties().entrySet()) {
                serviceLogger.debug("createService.props", entry.getKey(), entry.getValue());
            }
        }
        return serviceRecipe;
    }

    private void setSystemInstanceComponent(Class interfce, Object service) {
        SystemInstance.get().setComponent(interfce, service);
    }

    private URL toUrl(String jarPath) throws OpenEJBException {
        try {
            return new File(jarPath).toURI().toURL();
        }
        catch (MalformedURLException e) {
            throw new OpenEJBException(this.messages.format("cl0001", jarPath, e.getMessage()), e);
        }
    }

    static {
        JULLoggerFactory.class.getName();
        OPENEJB_URL_PKG_PREFIX = IvmContext.class.getPackage().getName();
        lock = new ReentrantLock(true);
        VALIDATOR_FACTORY_INTERFACES = new Class[]{ValidatorFactory.class};
        VALIDATOR_INTERFACES = new Class[]{Validator.class};
        context = new ThreadLocal();
    }

    public static class ResourceInstance
    extends Reference
    implements Serializable,
    DestroyableResource {
        private final String name;
        private final Object delegate;
        private transient Collection<Method> preDestroys;
        private transient CreationalContext<?> context;

        public ResourceInstance(String name, Object delegate, Collection<Method> preDestroys, CreationalContext<?> context) {
            this.name = name;
            this.delegate = delegate;
            this.preDestroys = preDestroys;
            this.context = context;
        }

        @Override
        public Object getObject() throws NamingException {
            return this.delegate;
        }

        public void destroyResource() {
            Object o = Assembler.unwrapReference(this.delegate);
            for (Method m : this.preDestroys) {
                try {
                    if (!m.isAccessible()) {
                        SetAccessible.on(m);
                    }
                    m.invoke(o, new Object[0]);
                }
                catch (Exception e) {
                    ((Assembler)SystemInstance.get().getComponent(Assembler.class)).logger.error(e.getMessage(), e);
                }
            }
            try {
                if (this.context != null) {
                    this.context.release();
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }

        Object readResolve() throws ObjectStreamException {
            try {
                return ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext().lookup(this.name);
            }
            catch (NamingException e) {
                throw new IllegalStateException(e);
            }
        }
    }

    public static class LazyResource
    extends LazyObjectReference<Object> {
        public LazyResource(Callable<Object> creator) {
            super(creator);
        }

        Object writeReplace() throws ObjectStreamException {
            try {
                return this.getObject();
            }
            catch (NamingException e) {
                return null;
            }
        }
    }

    public static final class ResourceAdapterReference
    extends Reference {
        private transient ResourceAdapter ra;
        private transient Executor pool;
        private final String jndi;

        public ResourceAdapterReference(ResourceAdapter ra, Executor pool, String jndi) {
            this.ra = ra;
            this.pool = pool;
            this.jndi = jndi;
        }

        public Executor getPool() {
            return this.pool;
        }

        public ResourceAdapter getRa() {
            return this.ra;
        }

        public String getJndi() {
            return this.jndi;
        }

        @Override
        public Object getObject() throws NamingException {
            return this.ra;
        }

        protected Object readResolve() throws ObjectStreamException {
            try {
                return ((ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class)).getJNDIContext().lookup(this.jndi);
            }
            catch (NamingException e) {
                throw new InvalidObjectException("name not found: " + this.jndi);
            }
        }
    }

    private static final class DestroyingResource {
        private final String name;
        private final String clazz;
        private final Object instance;

        private DestroyingResource(String name, String clazz, Object instance) {
            this.name = name;
            this.clazz = clazz;
            this.instance = instance;
        }
    }

    public static class DeploymentListenerObserver {
        private final DeploymentListener delegate;

        public DeploymentListenerObserver(DeploymentListener deploymentListener) {
            this.delegate = deploymentListener;
        }

        public void afterApplicationCreated(@Observes AssemblerAfterApplicationCreated event) {
            this.delegate.afterApplicationCreated(event.getApp());
        }

        public void beforeApplicationDestroyed(@Observes AssemblerBeforeApplicationDestroyed event) {
            this.delegate.beforeApplicationDestroyed(event.getApp());
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof DeploymentListenerObserver)) {
                return false;
            }
            DeploymentListenerObserver that = (DeploymentListenerObserver)o;
            return !(this.delegate == null ? that.delegate != null : !this.delegate.equals(that.delegate));
        }

        public int hashCode() {
            return this.delegate != null ? this.delegate.hashCode() : 0;
        }
    }

    private static class PersistenceClassLoaderHandlerImpl
    implements PersistenceClassLoaderHandler {
        private static final AtomicBoolean logged = new AtomicBoolean(false);
        private final Map<String, List<ClassFileTransformer>> transformers = new TreeMap<String, List<ClassFileTransformer>>();

        private PersistenceClassLoaderHandlerImpl() {
        }

        @Override
        public void addTransformer(String unitId, ClassLoader classLoader, ClassFileTransformer classFileTransformer) {
            Instrumentation instrumentation = Agent.getInstrumentation();
            if (instrumentation != null) {
                instrumentation.addTransformer(classFileTransformer);
                if (unitId != null) {
                    List<ClassFileTransformer> transformers = this.transformers.get(unitId);
                    if (transformers == null) {
                        transformers = new ArrayList<ClassFileTransformer>(1);
                        this.transformers.put(unitId, transformers);
                    }
                    transformers.add(classFileTransformer);
                }
            } else if (!logged.getAndSet(true)) {
                ((Assembler)SystemInstance.get().getComponent(Assembler.class)).logger.info("assembler.noAgent");
            }
        }

        @Override
        public void destroy(String unitId) {
            List<ClassFileTransformer> transformers = this.transformers.remove(unitId);
            if (transformers != null) {
                Instrumentation instrumentation = Agent.getInstrumentation();
                if (instrumentation != null) {
                    for (ClassFileTransformer transformer : transformers) {
                        instrumentation.removeTransformer(transformer);
                    }
                } else {
                    ((Assembler)SystemInstance.get().getComponent(Assembler.class)).logger.info("assembler.noAgent");
                }
            }
        }

        @Override
        public ClassLoader getNewTempClassLoader(ClassLoader classLoader) {
            return ClassLoaderUtil.createTempClassLoader(classLoader);
        }
    }
}

