/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler.classic;

import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.Callable;
import javax.persistence.EntityManagerFactory;
import javax.persistence.ValidationMode;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.validation.ValidatorFactory;
import org.apache.openejb.assembler.classic.ComparableValidationConfig;
import org.apache.openejb.assembler.classic.ImportSql;
import org.apache.openejb.assembler.classic.ValidatorFactoryWrapper;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.persistence.PersistenceUnitInfoImpl;

public class EntityManagerFactoryCallable
implements Callable<EntityManagerFactory> {
    public static final String OPENEJB_JPA_INIT_ENTITYMANAGER = "openejb.jpa.init-entitymanager";
    public static final String OPENJPA_ENTITY_MANAGER_FACTORY_POOL = "openjpa.EntityManagerFactoryPool";
    private final String persistenceProviderClassName;
    private final PersistenceUnitInfoImpl unitInfo;
    private final Map<ComparableValidationConfig, ValidatorFactory> potentialValidators;
    private ClassLoader appClassLoader;

    public EntityManagerFactoryCallable(String persistenceProviderClassName, PersistenceUnitInfoImpl unitInfo, ClassLoader cl, Map<ComparableValidationConfig, ValidatorFactory> validators) {
        this.persistenceProviderClassName = persistenceProviderClassName;
        this.unitInfo = unitInfo;
        this.appClassLoader = cl;
        this.potentialValidators = validators;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public EntityManagerFactory call() throws Exception {
        ClassLoader old = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.appClassLoader);
        try {
            ImportSql importer;
            Class<?> clazz = this.appClassLoader.loadClass(this.persistenceProviderClassName);
            PersistenceProvider persistenceProvider = (PersistenceProvider)clazz.newInstance();
            HashMap<String, Object> properties = new HashMap<String, Object>();
            if (!ValidationMode.NONE.equals((Object)this.unitInfo.getValidationMode())) {
                properties.put("javax.persistence.validation.factory", new ValidatorFactoryWrapper(this.potentialValidators));
            }
            this.customizeProperties(properties);
            EntityManagerFactory emf = persistenceProvider.createContainerEntityManagerFactory((PersistenceUnitInfo)this.unitInfo, properties);
            if (this.unitInfo.getProperties() != null && "true".equalsIgnoreCase(this.unitInfo.getProperties().getProperty(OPENEJB_JPA_INIT_ENTITYMANAGER)) || SystemInstance.get().getOptions().get(OPENEJB_JPA_INIT_ENTITYMANAGER, false)) {
                emf.createEntityManager().close();
            }
            if (this.unitInfo.getNonJtaDataSource() != null && (importer = new ImportSql(this.appClassLoader, this.unitInfo.getPersistenceUnitName(), this.unitInfo.getNonJtaDataSource())).hasSomethingToImport()) {
                emf.createEntityManager().close();
                importer.doImport();
            }
            EntityManagerFactory entityManagerFactory = emf;
            return entityManagerFactory;
        }
        finally {
            Thread.currentThread().setContextClassLoader(old);
        }
    }

    private void customizeProperties(Map<String, Object> properties) {
        String pool = SystemInstance.get().getProperty(OPENJPA_ENTITY_MANAGER_FACTORY_POOL);
        if (pool != null) {
            properties.put(OPENJPA_ENTITY_MANAGER_FACTORY_POOL, pool);
        }
    }

    public PersistenceUnitInfoImpl getUnitInfo() {
        return this.unitInfo;
    }

    public void overrideClassLoader(ClassLoader loader) {
        this.appClassLoader = loader;
    }
}

