/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.bval;

import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.Proxy;
import java.util.ArrayList;
import javax.naming.InitialContext;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import javax.validation.Validator;
import javax.validation.ValidatorFactory;
import org.apache.openejb.AppContext;
import org.apache.openejb.BeanContext;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;

public final class ValidatorUtil {
    private ValidatorUtil() {
    }

    public static ValidatorFactory validatorFactory() {
        try {
            return ValidatorUtil.lookupFactory();
        }
        catch (NamingException e) {
            return ValidatorUtil.tryJndiLaterFactory();
        }
    }

    public static ValidatorFactory lookupFactory() throws NamingException {
        return (ValidatorFactory)new InitialContext().lookup("java:comp/ValidatorFactory");
    }

    public static ValidatorFactory tryJndiLaterFactory() {
        return ValidatorUtil.proxy(ValidatorFactory.class, "java:comp/ValidatorFactory");
    }

    public static Validator validator() {
        try {
            return (Validator)new InitialContext().lookup("java:comp/Validator");
        }
        catch (NamingException e) {
            return ValidatorUtil.proxy(Validator.class, "java:comp/Validator");
        }
    }

    private static <T> T proxy(final Class<T> t, final String jndi) {
        return t.cast(Proxy.newProxyInstance(Thread.currentThread().getContextClassLoader(), new Class[]{t}, new InvocationHandler(){

            @Override
            public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
                if (Object.class.equals(method.getDeclaringClass())) {
                    return method.invoke((Object)this, new Object[0]);
                }
                ThreadContext ctx = ThreadContext.getThreadContext();
                if (ctx != null) {
                    return method.invoke(ctx.getBeanContext().getJndiContext().lookup(jndi), args);
                }
                ClassLoader tccl = Thread.currentThread().getContextClassLoader();
                if (tccl == null) {
                    return null;
                }
                ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
                Object value = null;
                for (AppContext appContext : containerSystem.getAppContexts()) {
                    ClassLoader appContextClassLoader = appContext.getClassLoader();
                    if (tccl.equals(appContextClassLoader) || appContextClassLoader.equals(tccl)) {
                        ArrayList<String> tested = new ArrayList<String>();
                        for (BeanContext bean : appContext.getBeanContexts()) {
                            String uniqueId;
                            if (!BeanContext.Comp.class.equals((Object)bean.getBeanClass()) || tested.contains(uniqueId = bean.getModuleContext().getUniqueId())) continue;
                            tested.add(uniqueId);
                            try {
                                value = containerSystem.getJNDIContext().lookup((jndi.endsWith("Factory") ? "openejb/ValidatorFactory/" : "openejb/Validator/") + uniqueId);
                                break;
                            }
                            catch (NameNotFoundException nameNotFoundException) {
                            }
                        }
                        if (ClassLoader.getSystemClassLoader() != appContextClassLoader) break;
                    }
                    for (WebContext web : appContext.getWebContexts()) {
                        ClassLoader webClassLoader = web.getClassLoader();
                        if (!webClassLoader.equals(tccl) && !tccl.equals(webClassLoader)) continue;
                        value = web.getJndiEnc().lookup(jndi);
                        break;
                    }
                    if (value == null) continue;
                    break;
                }
                if (value != null) {
                    return method.invoke(value, args);
                }
                return null;
            }

            public String toString() {
                return "Proxy::" + t.getName();
            }
        }));
    }
}

