/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.security.jacc;

import java.security.CodeSource;
import java.security.Permission;
import java.security.PermissionCollection;
import java.security.Policy;
import java.security.ProtectionDomain;
import java.util.HashMap;
import java.util.Map;
import javax.security.jacc.PolicyConfiguration;
import javax.security.jacc.PolicyContext;
import javax.security.jacc.PolicyContextException;
import org.apache.openejb.core.security.JaccProvider;
import org.apache.openejb.core.security.jacc.BasicPolicyConfiguration;

public class BasicJaccProvider
extends JaccProvider {
    private final Map<String, BasicPolicyConfiguration> configurations = new HashMap<String, BasicPolicyConfiguration>();
    private final Policy systemPolicy = JaccProvider.Policy.getPolicy();

    @Override
    public PolicyConfiguration getPolicyConfiguration(String contextID, boolean remove) throws PolicyContextException {
        BasicPolicyConfiguration configuration = this.configurations.get(contextID);
        if (configuration == null) {
            configuration = this.createPolicyConfiguration(contextID);
            this.configurations.put(contextID, configuration);
        } else {
            configuration.open(remove);
        }
        return configuration;
    }

    protected BasicPolicyConfiguration createPolicyConfiguration(String contextID) {
        return new BasicPolicyConfiguration(contextID);
    }

    @Override
    public boolean inService(String contextID) throws PolicyContextException {
        PolicyConfiguration configuration = this.getPolicyConfiguration(contextID, false);
        return configuration.inService();
    }

    @Override
    public PermissionCollection getPermissions(CodeSource codesource) {
        return this.systemPolicy == null ? null : this.systemPolicy.getPermissions(codesource);
    }

    @Override
    public void refresh() {
    }

    @Override
    public boolean implies(ProtectionDomain domain, Permission permission) {
        String contextID = PolicyContext.getContextID();
        if (contextID != null) {
            try {
                BasicPolicyConfiguration configuration = this.configurations.get(contextID);
                if (configuration == null || !configuration.inService()) {
                    return false;
                }
                return configuration.implies(domain, permission);
            }
            catch (PolicyContextException policyContextException) {
                // empty catch block
            }
        }
        return this.systemPolicy != null ? this.systemPolicy.implies(domain, permission) : false;
    }

    static {
        try {
            Class.forName(PolicyContext.class.getName());
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
    }
}

