/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.threads.task;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.Callable;
import javax.security.auth.login.LoginException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.core.ThreadContext;
import org.apache.openejb.core.ivm.ClientSecurity;
import org.apache.openejb.core.security.AbstractSecurityService;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.SecurityService;
import org.apache.openejb.threads.task.ManagedTaskListenerTask;
import org.apache.openejb.util.Join;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

public abstract class CUTask<T>
extends ManagedTaskListenerTask
implements Comparable<Object> {
    private static final SecurityService SECURITY_SERVICE = (SecurityService)SystemInstance.get().getComponent(SecurityService.class);
    private static volatile ContainerListener[] CONTAINER_LISTENERS = new ContainerListener[0];
    private final Context initialContext;
    private final Object[] containerListenerStates;

    public static void addContainerListener(ContainerListener cl) {
        ContainerListener[] array = new ContainerListener[CONTAINER_LISTENERS.length + 1];
        if (CONTAINER_LISTENERS.length > 0) {
            System.arraycopy(CONTAINER_LISTENERS, 0, array, 0, CONTAINER_LISTENERS.length);
        }
        array[CUTask.CONTAINER_LISTENERS.length] = cl;
        CONTAINER_LISTENERS = array;
    }

    public CUTask(Object task) {
        super(task);
        Object stateTmp = SECURITY_SERVICE.currentState();
        boolean associate = stateTmp == null ? (stateTmp = ClientSecurity.getIdentity()) != null : false;
        ThreadContext threadContext = ThreadContext.getThreadContext();
        AbstractSecurityService.SecurityContext sc = threadContext == null ? null : threadContext.get(AbstractSecurityService.SecurityContext.class);
        this.initialContext = threadContext != null && threadContext.getBeanContext() != null && (threadContext.getBeanContext().getRunAs() != null || threadContext.getBeanContext().getRunAsUser() != null) ? new Context(associate, stateTmp, new AbstractSecurityService.SecurityContext(((AbstractSecurityService)AbstractSecurityService.class.cast(SECURITY_SERVICE)).getRunAsSubject(threadContext.getBeanContext())), threadContext, Thread.currentThread().getContextClassLoader(), null) : new Context(associate, stateTmp, sc, threadContext, Thread.currentThread().getContextClassLoader(), null);
        if (CONTAINER_LISTENERS.length > 0) {
            this.containerListenerStates = new Object[CONTAINER_LISTENERS.length];
            for (int i = 0; i < CONTAINER_LISTENERS.length; ++i) {
                this.containerListenerStates[i] = CONTAINER_LISTENERS[i].onCreation();
            }
        } else {
            this.containerListenerStates = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected T invoke(Callable<T> call) throws Exception {
        Object[] oldStates;
        this.initialContext.enter();
        if (CONTAINER_LISTENERS.length > 0) {
            oldStates = new Object[CONTAINER_LISTENERS.length];
            for (int i = 0; i < CONTAINER_LISTENERS.length; ++i) {
                oldStates[i] = CONTAINER_LISTENERS[i].onStart(this.containerListenerStates[i]);
            }
        } else {
            oldStates = null;
        }
        Throwable throwable = null;
        try {
            this.taskStarting(this.future, this.executor, this.delegate);
            T t = call.call();
            return t;
        }
        catch (Throwable t) {
            throwable = t;
            this.taskAborted(throwable);
            T t2 = this.rethrow(t);
            return t2;
        }
        finally {
            try {
                this.taskDone(this.future, this.executor, this.delegate, throwable);
            }
            finally {
                if (CONTAINER_LISTENERS.length > 0) {
                    for (int i = 0; i < CONTAINER_LISTENERS.length; ++i) {
                        CONTAINER_LISTENERS[i].onEnd(oldStates[i]);
                    }
                }
                this.initialContext.exit();
            }
        }
    }

    private T rethrow(Throwable t) throws Exception {
        if (Exception.class.isInstance(t)) {
            throw (Exception)Exception.class.cast(t);
        }
        if (Error.class.isInstance(t)) {
            throw (Error)Error.class.cast(t);
        }
        throw new OpenEJBRuntimeException(t.getMessage(), t);
    }

    @Override
    public int compareTo(Object o) {
        return Comparable.class.isInstance(this.delegate) ? ((Comparable)Comparable.class.cast(this.delegate)).compareTo(o) : -1;
    }

    public static interface ContainerListener<T> {
        public T onCreation();

        public T onStart(T var1);

        public void onEnd(T var1);
    }

    public static final class Context {
        public static final ThreadLocal<Context> CURRENT = new ThreadLocal();
        private final Object securityServiceState;
        private final ThreadContext threadContext;
        private final ClassLoader loader;
        private final boolean associate;
        private final AbstractSecurityService.SecurityContext securityContext;
        private final Context stack;
        private Context currentContext;
        private Collection<Runnable> exitTasks;

        private Context(boolean associate, Object initialSecurityServiceState, AbstractSecurityService.SecurityContext securityContext, ThreadContext initialThreadContext, ClassLoader initialLoader, Context stack) {
            this.associate = associate;
            this.securityServiceState = initialSecurityServiceState;
            this.securityContext = securityContext;
            this.loader = initialLoader;
            this.stack = stack;
            this.threadContext = initialThreadContext == null ? null : new ThreadContext(initialThreadContext);
        }

        public void enter() {
            ThreadContext oldCtx;
            Object threadState;
            Thread thread = Thread.currentThread();
            ClassLoader oldCl = thread.getContextClassLoader();
            thread.setContextClassLoader(this.loader);
            if (this.associate) {
                try {
                    SECURITY_SERVICE.associate(this.securityServiceState);
                }
                catch (LoginException e) {
                    throw new IllegalStateException(e);
                }
                threadState = null;
            } else {
                threadState = SECURITY_SERVICE.currentState();
                SECURITY_SERVICE.setState(this.securityServiceState);
            }
            if (this.threadContext != null) {
                ThreadContext newContext = new ThreadContext(this.threadContext);
                newContext.set(Context.class, this);
                if (this.securityContext != null) {
                    newContext.set(AbstractSecurityService.ProvidedSecurityContext.class, new AbstractSecurityService.ProvidedSecurityContext(this.securityContext));
                }
                oldCtx = ThreadContext.enter(newContext);
            } else {
                oldCtx = null;
            }
            this.currentContext = new Context(this.associate, threadState, this.securityContext, oldCtx, oldCl, this);
            CURRENT.set(this);
        }

        public void exit() {
            ArrayList<RuntimeException> errors = null;
            if (this.exitTasks != null) {
                for (Runnable r : this.exitTasks) {
                    try {
                        r.run();
                    }
                    catch (RuntimeException re) {
                        if (errors == null) {
                            errors = new ArrayList();
                        }
                        errors.add(re);
                        Logger.getInstance(LogCategory.OPENEJB, CUTask.class).warning(re.getMessage(), re);
                    }
                }
            }
            if (this.threadContext != null) {
                try {
                    ThreadContext.exit(this.currentContext.threadContext);
                }
                catch (RuntimeException re) {
                    if (errors == null) {
                        errors = new ArrayList<RuntimeException>();
                    }
                    errors.add(re);
                    Logger.getInstance(LogCategory.OPENEJB, CUTask.class).warning(re.getMessage(), re);
                }
            }
            try {
                if (!this.associate) {
                    SECURITY_SERVICE.setState(this.currentContext.securityServiceState);
                } else {
                    SECURITY_SERVICE.disassociate();
                }
            }
            catch (RuntimeException re) {
                if (errors == null) {
                    errors = new ArrayList();
                }
                errors.add(re);
                Logger.getInstance(LogCategory.OPENEJB, CUTask.class).warning(re.getMessage(), re);
            }
            Thread.currentThread().setContextClassLoader(this.currentContext.loader);
            if (this.currentContext.stack == null) {
                CURRENT.remove();
            } else {
                CURRENT.set(this.currentContext.stack);
            }
            this.currentContext = null;
            if (errors != null) {
                if (errors.size() == 1) {
                    throw (RuntimeException)errors.iterator().next();
                }
                throw new OpenEJBRuntimeException(Join.join("\n", new Join.NameCallback<RuntimeException>(){

                    @Override
                    public String getName(RuntimeException object) {
                        return object.getMessage();
                    }
                }, errors));
            }
        }

        public void pushExitTask(Runnable runnable) {
            if (this.exitTasks == null) {
                this.exitTasks = new ArrayList<Runnable>(2);
            }
            this.exitTasks.add(runnable);
        }
    }
}

