/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.io.Closeable;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.jar.JarEntry;
import java.util.jar.JarOutputStream;
import org.apache.openejb.loader.IO;

public final class JarCreator {
    private static final int BUFFER_SIZE = 1024;

    private JarCreator() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void jarDir(File dir, File zipName) throws IOException, IllegalArgumentException {
        String[] entries = dir.list();
        JarOutputStream out = new JarOutputStream(new FileOutputStream(zipName));
        try {
            String prefix = dir.getAbsolutePath();
            if (!prefix.endsWith(File.separator)) {
                prefix = prefix + File.separator;
            }
            for (String entry : entries) {
                File f = new File(dir, entry);
                JarCreator.jarFile(out, f, prefix);
            }
        }
        finally {
            IO.close((Closeable)out);
        }
    }

    private static void jarFile(JarOutputStream out, File f, String prefix) throws IOException {
        block15: {
            block14: {
                if (!f.isDirectory()) break block14;
                File[] files = f.listFiles();
                if (null == files) break block15;
                for (File child : files) {
                    JarCreator.jarFile(out, child, prefix);
                }
                break block15;
            }
            String path = f.getPath().replace(prefix, "");
            try (FileInputStream in = new FileInputStream(f);){
                int bytesRead;
                JarEntry entry = new JarEntry(path);
                out.putNextEntry(entry);
                byte[] buffer = new byte[1024];
                while ((bytesRead = in.read(buffer)) != -1) {
                    out.write(buffer, 0, bytesRead);
                }
            }
        }
    }
}

