/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.assembler;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.security.SecureRandom;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.TreeMap;
import javax.ejb.Lock;
import javax.ejb.LockType;
import javax.ejb.Remote;
import javax.ejb.Singleton;
import javax.ejb.TransactionManagement;
import javax.ejb.TransactionManagementType;
import javax.enterprise.inject.Alternative;
import javax.validation.ValidationException;
import org.apache.openejb.ClassLoaderUtil;
import org.apache.openejb.NoSuchApplicationException;
import org.apache.openejb.OpenEJBException;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.UndeployException;
import org.apache.openejb.assembler.Deployer;
import org.apache.openejb.assembler.WebAppDeployer;
import org.apache.openejb.assembler.classic.AppInfo;
import org.apache.openejb.assembler.classic.Assembler;
import org.apache.openejb.assembler.classic.ContainerInfo;
import org.apache.openejb.assembler.classic.ContainerSystemInfo;
import org.apache.openejb.assembler.classic.DeploymentExceptionManager;
import org.apache.openejb.assembler.classic.FacilitiesInfo;
import org.apache.openejb.assembler.classic.OpenEjbConfiguration;
import org.apache.openejb.assembler.classic.ResourceInfo;
import org.apache.openejb.config.AppModule;
import org.apache.openejb.config.ConfigurationFactory;
import org.apache.openejb.config.DeploymentLoader;
import org.apache.openejb.config.DeploymentModule;
import org.apache.openejb.config.WebModule;
import org.apache.openejb.config.sys.AdditionalDeployments;
import org.apache.openejb.config.sys.Deployments;
import org.apache.openejb.config.sys.JaxbOpenejb;
import org.apache.openejb.loader.Files;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.ProvisioningUtil;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.loader.provisining.ProvisioningResolver;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;

@Singleton(name="openejb/Deployer")
@Lock(value=LockType.READ)
@Remote(value={Deployer.class})
@TransactionManagement(value=TransactionManagementType.BEAN)
@Alternative
public class DeployerEjb
implements Deployer {
    private static final Logger LOGGER;
    public static final String OPENEJB_DEPLOYER_FORCED_APP_ID_PROP = "openejb.deployer.forced.appId";
    public static final String OPENEJB_DEPLOYER_HOST = "openejb.deployer.host";
    public static final String OPENEJB_USE_BINARIES = "openejb.deployer.binaries.use";
    public static final String OPENEJB_PATH_BINARIES = "openejb.deployer.binaries.path";
    public static final String OPENEJB_VALUE_BINARIES = "openejb.deployer.binaries.value";
    public static final String OPENEJB_APP_AUTODEPLOY = "openejb.app.autodeploy";
    public static final ThreadLocal<Boolean> AUTO_DEPLOY;
    private static final File uniqueFile;
    private static final boolean oldWarDeployer;
    private static final String OPENEJB_DEPLOYER_SAVE_DEPLOYMENTS = "openejb.deployer.save-deployments";
    private static final boolean SAVE_DEPLOYMENTS;
    private final DeploymentLoader deploymentLoader = new DeploymentLoader();
    private final Assembler assembler = (Assembler)SystemInstance.get().getComponent(org.apache.openejb.spi.Assembler.class);

    @Override
    public String getUniqueFile() {
        return uniqueFile.getAbsolutePath();
    }

    @Override
    public Collection<AppInfo> getDeployedApps() {
        return this.assembler.getDeployedApplications();
    }

    @Override
    public AppInfo deploy(String location) throws OpenEJBException {
        return this.deploy(location, null);
    }

    @Override
    public AppInfo deploy(Properties properties) throws OpenEJBException {
        return this.deploy(null, properties);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public AppInfo deploy(String inLocation, Properties properties) throws OpenEJBException {
        String rawLocation = inLocation;
        if (rawLocation == null && properties == null) {
            throw new NullPointerException("location and properties are null");
        }
        if (rawLocation == null) {
            rawLocation = properties.getProperty("filename");
        }
        if (properties == null) {
            properties = new Properties();
        }
        AppModule appModule = null;
        File file = "true".equalsIgnoreCase(properties.getProperty(OPENEJB_USE_BINARIES, "false")) ? this.copyBinaries(properties) : new File((String)ProvisioningUtil.realLocation((String)rawLocation).iterator().next());
        boolean autoDeploy = Boolean.parseBoolean(properties.getProperty(OPENEJB_APP_AUTODEPLOY, "false"));
        String host = properties.getProperty(OPENEJB_DEPLOYER_HOST, null);
        if (WebAppDeployer.Helper.isWebApp(file) && !oldWarDeployer) {
            AUTO_DEPLOY.set(autoDeploy);
            try {
                AppInfo appInfo = ((WebAppDeployer)SystemInstance.get().getComponent(WebAppDeployer.class)).deploy(host, this.contextRoot(properties, file), file);
                if (appInfo != null) {
                    this.saveIfNeeded(properties, file, appInfo);
                    AppInfo appInfo2 = appInfo;
                    return appInfo2;
                }
                throw new OpenEJBException("can't deploy " + file.getAbsolutePath());
            }
            finally {
                AUTO_DEPLOY.remove();
            }
        }
        AppInfo appInfo = null;
        try {
            appModule = this.deploymentLoader.load(file, null);
            TreeMap<String, DeploymentModule> modules = new TreeMap<String, DeploymentModule>();
            for (DeploymentModule deploymentModule : appModule.getEjbModules()) {
                modules.put(deploymentModule.getModuleId(), deploymentModule);
            }
            for (DeploymentModule deploymentModule : appModule.getClientModules()) {
                modules.put(deploymentModule.getModuleId(), deploymentModule);
            }
            for (WebModule webModule : appModule.getWebModules()) {
                String contextRoot = this.contextRoot(properties, webModule.getJarLocation());
                if (contextRoot != null) {
                    webModule.setContextRoot(contextRoot);
                    webModule.setHost(host);
                }
                modules.put(webModule.getModuleId(), webModule);
            }
            for (DeploymentModule deploymentModule : appModule.getConnectorModules()) {
                modules.put(deploymentModule.getModuleId(), deploymentModule);
            }
            for (Map.Entry entry : properties.entrySet()) {
                DeploymentModule module;
                String name = (String)entry.getKey();
                if (!name.startsWith("altDD/")) continue;
                int slash = (name = name.substring("altDD".length() + 1)).indexOf(47);
                if (slash > 0) {
                    String moduleId = name.substring(0, slash);
                    name = name.substring(slash + 1);
                    module = (DeploymentModule)modules.get(moduleId);
                } else {
                    module = appModule;
                }
                if (module == null) continue;
                String value = (String)entry.getValue();
                File dd = new File(value);
                if (dd.canRead()) {
                    module.getAltDDs().put(name, dd.toURI().toURL());
                    continue;
                }
                module.getAltDDs().put(name, value);
            }
            OpenEjbConfiguration configuration = new OpenEjbConfiguration();
            configuration.containerSystem = new ContainerSystemInfo();
            configuration.facilities = new FacilitiesInfo();
            ConfigurationFactory configurationFactory = new ConfigurationFactory(false, configuration);
            appInfo = configurationFactory.configureApplication(appModule);
            appInfo.autoDeploy = autoDeploy;
            if (properties != null && properties.containsKey(OPENEJB_DEPLOYER_FORCED_APP_ID_PROP)) {
                appInfo.appId = properties.getProperty(OPENEJB_DEPLOYER_FORCED_APP_ID_PROP);
            }
            if (!appInfo.webApps.isEmpty()) {
                appInfo.properties.setProperty("tomcat.unpackWar", "false");
            }
            if (!appInfo.webApps.isEmpty()) {
                appInfo.properties.setProperty("tomcat.unpackWar", "false");
            }
            ClassLoader oldCl = Thread.currentThread().getContextClassLoader();
            ClassLoader appClassLoader = this.assembler.createAppClassLoader(appInfo);
            try {
                Thread.currentThread().setContextClassLoader(appClassLoader);
                for (ResourceInfo resource : configuration.facilities.resources) {
                    this.assembler.createResource(resource);
                }
                for (ContainerInfo container : configuration.containerSystem.containers) {
                    this.assembler.createContainer(container);
                }
            }
            finally {
                Thread.currentThread().setContextClassLoader(oldCl);
            }
            this.assembler.createApplication(appInfo, appClassLoader);
            this.saveIfNeeded(properties, file, appInfo);
            return appInfo;
        }
        catch (Throwable e) {
            Throwable ex;
            if (appModule != null) {
                ClassLoaderUtil.destroyClassLoader(appModule.getJarLocation());
            }
            if (null != appInfo) {
                ClassLoaderUtil.destroyClassLoader(appInfo.appId, appInfo.path);
            }
            LOGGER.error("Can't deploy " + inLocation, e);
            if (e instanceof ValidationException) {
                throw (ValidationException)e;
            }
            DeploymentExceptionManager deploymentExceptionManager = (DeploymentExceptionManager)SystemInstance.get().getComponent(DeploymentExceptionManager.class);
            if (deploymentExceptionManager != null) {
                ex = deploymentExceptionManager.hasDeploymentFailed() ? deploymentExceptionManager.getLastException() : e;
                if (appInfo != null) {
                    deploymentExceptionManager.clearLastException(appInfo);
                }
            } else {
                ex = e;
            }
            if (ex instanceof OpenEJBException) {
                if (ex.getCause() instanceof ValidationException) {
                    throw (ValidationException)ex.getCause();
                }
                throw (OpenEJBException)ex;
            }
            throw new OpenEJBException(ex);
        }
    }

    private void saveIfNeeded(Properties properties, File file, AppInfo appInfo) {
        if (SAVE_DEPLOYMENTS && null == properties.getProperty(OPENEJB_DEPLOYER_SAVE_DEPLOYMENTS) || "true".equalsIgnoreCase(properties.getProperty(OPENEJB_DEPLOYER_SAVE_DEPLOYMENTS, "false"))) {
            appInfo.properties.setProperty("save-deployment", "true");
            this.saveDeployment(file, true);
        }
    }

    private synchronized File copyBinaries(Properties props) throws OpenEJBException {
        File dump = ProvisioningResolver.cacheFile((String)props.getProperty(OPENEJB_PATH_BINARIES, "dump.war"));
        if (dump.exists()) {
            File exploded;
            Files.delete((File)dump);
            String name = dump.getName();
            if (name.endsWith("ar") && name.length() > 4 && (exploded = new File(dump.getParentFile(), name.substring(0, name.length() - 4))).exists()) {
                Files.delete((File)exploded);
            }
        }
        try {
            IO.copy((byte[])((byte[])byte[].class.cast(props.get(OPENEJB_VALUE_BINARIES))), (File)dump);
        }
        catch (IOException e) {
            throw new OpenEJBException(e);
        }
        return dump;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void saveDeployment(File file, boolean add) {
        File config;
        Deployments deps = new Deployments();
        if (file.isDirectory()) {
            deps.setDir(file.getAbsolutePath());
        } else {
            deps.setFile(file.getAbsolutePath());
        }
        try {
            config = SystemInstance.get().getBase().getFile("conf/deployments.xml", false);
        }
        catch (IOException e) {
            config = null;
        }
        if (config == null || !config.getParentFile().exists()) {
            LOGGER.info("Cannot save the added app because the conf folder does not exist, it will not be present on a restart");
            return;
        }
        OutputStream os = null;
        try {
            AdditionalDeployments additionalDeployments;
            block21: {
                block20: {
                    if (config.exists() && config.length() > 0L) {
                        InputStream fis = IO.read((File)config);
                        try {
                            additionalDeployments = JaxbOpenejb.unmarshal(AdditionalDeployments.class, fis);
                        }
                        finally {
                            IO.close((Closeable)fis);
                        }
                    } else {
                        additionalDeployments = new AdditionalDeployments();
                    }
                    if (!add) break block20;
                    if (additionalDeployments.getDeployments().contains(deps)) break block21;
                    additionalDeployments.getDeployments().add(deps);
                    break block21;
                }
                Iterator<Deployments> it = additionalDeployments.getDeployments().iterator();
                while (it.hasNext()) {
                    String substring;
                    Deployments current = it.next();
                    if (deps.getDir() != null && deps.getDir().equals(current.getDir())) {
                        it.remove();
                        break;
                    }
                    if (deps.getFile() != null && deps.getFile().equals(current.getFile())) {
                        it.remove();
                        break;
                    }
                    String jar = deps.getFile();
                    if (jar != null && jar.length() > 3) {
                        String substring2 = jar.substring(0, jar.length() - 4);
                        if (!substring2.equals(current.getDir()) && !substring2.equals(current.getFile())) continue;
                        it.remove();
                        break;
                    }
                    String jarC = current.getFile();
                    if (jarC == null || jarC.length() <= 3 || !(substring = jarC.substring(0, jarC.length() - 4)).equals(deps.getDir()) && !substring.equals(deps.getFile())) continue;
                    it.remove();
                    break;
                }
            }
            os = IO.write((File)config);
            JaxbOpenejb.marshal(AdditionalDeployments.class, additionalDeployments, os);
            IO.close((Closeable)os);
        }
        catch (Exception e) {
            LOGGER.error("cannot save the added app, will not be present next time you'll start", e);
        }
        finally {
            IO.close(os);
        }
    }

    @Override
    public void undeploy(String moduleId) throws UndeployException, NoSuchApplicationException {
        AppInfo appInfo = this.assembler.getAppInfo(moduleId);
        if (appInfo == null && (appInfo = this.assembler.getAppInfo((String)ProvisioningUtil.realLocation((String)moduleId).iterator().next())) == null && (appInfo = this.assembler.getAppInfo(new File(moduleId).getAbsolutePath())) == null) {
            appInfo = this.assembler.getAppInfo(new File((String)ProvisioningUtil.realLocation((String)moduleId).iterator().next()).getAbsolutePath());
        }
        if (appInfo != null) {
            try {
                this.assembler.destroyApplication(appInfo);
            }
            finally {
                if (appInfo.properties.containsKey("save-deployment")) {
                    this.saveDeployment(new File(moduleId), false);
                }
            }
        } else {
            throw new NoSuchApplicationException(moduleId);
        }
    }

    private String contextRoot(Properties properties, String jarPath) {
        File file = new File(jarPath);
        return file.exists() ? this.contextRoot(properties, file) : properties.getProperty("webapp." + jarPath + ".context-root");
    }

    private String contextRoot(Properties properties, File jarPath) {
        return properties.getProperty("webapp." + jarPath.getName() + ".context-root");
    }

    @Override
    public void reload(String moduleId) {
        for (AppInfo info : this.assembler.getDeployedApplications()) {
            if (!info.path.equals(moduleId)) continue;
            this.reload(info);
            break;
        }
    }

    private void reload(AppInfo info) {
        WebAppDeployer component;
        if (info.webAppAlone && null != (component = (WebAppDeployer)SystemInstance.get().getComponent(WebAppDeployer.class))) {
            component.reload(info.path);
            return;
        }
        try {
            this.assembler.destroyApplication(info);
            this.assembler.createApplication(info);
        }
        catch (Exception e) {
            throw new OpenEJBRuntimeException(e);
        }
    }

    static {
        File unique;
        LOGGER = Logger.getInstance(LogCategory.OPENEJB, DeployerEjb.class);
        AUTO_DEPLOY = new ThreadLocal();
        oldWarDeployer = "old".equalsIgnoreCase(SystemInstance.get().getOptions().get("openejb.deployer.war", "new"));
        SAVE_DEPLOYMENTS = SystemInstance.get().getOptions().get(OPENEJB_DEPLOYER_SAVE_DEPLOYMENTS, false);
        String uniqueName = "OpenEJB-" + new BigInteger(128, new SecureRandom()).toString(36);
        String tempDir = JavaSecurityManagers.getSystemProperty("java.io.tmpdir");
        try {
            unique = new File(tempDir, uniqueName).getCanonicalFile();
            if (!unique.createNewFile()) {
                throw new IOException("Failed to create file in temp: " + unique);
            }
        }
        catch (IOException e) {
            unique = new File(SystemInstance.get().getBase().getDirectory(), "work");
            if (unique.exists()) {
                try {
                    unique = new File(unique, uniqueName).getCanonicalFile();
                    if (!unique.createNewFile()) {
                        throw new IOException("Failed to create file in work: " + unique);
                    }
                }
                catch (IOException e1) {
                    throw new OpenEJBRuntimeException(e);
                }
            }
            throw new OpenEJBRuntimeException("cannot create unique file, please set java.io.tmpdir to a writable folder or create work folder", e);
        }
        uniqueFile = unique;
        uniqueFile.deleteOnExit();
    }
}

