/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.config;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Field;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import java.util.logging.Level;
import java.util.logging.Logger;
import org.apache.openejb.OpenEJBRuntimeException;
import org.apache.openejb.loader.IO;
import org.apache.openejb.loader.Options;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.Join;

public class RemoteServer {
    private static final Options systemPropertiesOptions = new Options(JavaSecurityManagers.getSystemProperties());
    public static final String SERVER_DEBUG_PORT = "server.debug.port";
    public static final String SERVER_SHUTDOWN_PORT = "server.shutdown.port";
    public static final String SERVER_SHUTDOWN_HOST = "server.shutdown.host";
    public static final String SERVER_SHUTDOWN_COMMAND = "server.shutdown.command";
    public static final String SOCKET_TIMEOUT = "server.socket.timeout";
    public static final String OPENEJB_SERVER_DEBUG = "openejb.server.debug";
    public static final String START = "start";
    public static final String STOP = "stop";
    private final Options options;
    private final boolean profile;
    private final String javaOpts;
    private final boolean tomcat;
    private final int ejbPort;
    private final String ejbPproviderUrl;
    private boolean debug;
    private String additionalClasspath;
    private boolean serverHasAlreadyBeenStarted = true;
    private final AtomicReference<Process> server = new AtomicReference();
    private final int tries;
    private final boolean verbose;
    private final int portShutdown;
    private final String host;
    private final String command;
    private File home;
    private int portStartup;
    private final int connectTimeout;
    private static final List<Process> kill = new ArrayList<Process>();

    public RemoteServer() {
        this(systemPropertiesOptions.get("connect.tries", 60), systemPropertiesOptions.get("verbose", false));
    }

    public RemoteServer(int tries, boolean verbose) {
        this(new Properties(), tries, verbose);
    }

    public RemoteServer(Properties overrides, int tries, boolean verbose) {
        this.tries = tries < 1 ? 1 : (tries > 3600 ? 3600 : tries);
        this.verbose = verbose;
        this.options = new Options(overrides, systemPropertiesOptions);
        this.home = this.getHome();
        this.tomcat = this.home != null && new File(new File(this.home, "bin"), "catalina.sh").exists();
        this.portStartup = this.portShutdown = this.options.get(SERVER_SHUTDOWN_PORT, this.tomcat ? 8005 : 4200);
        this.command = this.options.get(SERVER_SHUTDOWN_COMMAND, "SHUTDOWN");
        this.host = this.options.get(SERVER_SHUTDOWN_HOST, "localhost");
        this.connectTimeout = this.options.get(SOCKET_TIMEOUT, 1000);
        this.debug = this.options.get(OPENEJB_SERVER_DEBUG, false);
        this.profile = this.options.get("openejb.server.profile", false);
        this.javaOpts = this.options.get("java.opts", (String)null);
        this.ejbPort = this.options.get("ejbd.port", 4201);
        this.ejbPproviderUrl = this.options.get("java.naming.provider.url", "127.0.0.1:" + this.ejbPort);
    }

    public void init(Properties props) {
        props.put("java.naming.factory.initial", "org.apache.openejb.client.RemoteInitialContextFactory");
        props.put("java.naming.provider.url", this.ejbPproviderUrl);
        props.put("java.naming.security.principal", "testuser");
        props.put("java.naming.security.credentials", "testpassword");
    }

    public static void main(String[] args) {
        assert (args.length > 0) : "no arguments supplied: valid arguments are 'start' or 'stop'";
        if (args[0].equalsIgnoreCase(START)) {
            RemoteServer remoteServer = new RemoteServer();
            try {
                remoteServer.start();
            }
            catch (Exception e) {
                remoteServer.destroy();
                throw e;
            }
        } else if (args[0].equalsIgnoreCase(STOP)) {
            RemoteServer remoteServer = new RemoteServer();
            remoteServer.serverHasAlreadyBeenStarted = false;
            try {
                remoteServer.forceStop();
            }
            catch (Exception e) {
                e.printStackTrace(System.err);
            }
        } else {
            throw new OpenEJBRuntimeException("valid arguments are 'start' or 'stop'");
        }
    }

    public int getPortStartup() {
        return this.portStartup;
    }

    public void setPortStartup(int portStartup) {
        this.portStartup = portStartup;
    }

    public void destroy() {
        try {
            boolean stopSent = this.stop();
            Process p = this.server.get();
            if (p != null) {
                if (stopSent) {
                    this.waitFor(p);
                } else {
                    p.destroy();
                }
            }
        }
        catch (Exception e) {
            Logger.getLogger(RemoteServer.class.getName()).log(Level.WARNING, "Failed to destroy server", e);
        }
    }

    public void start() {
        this.start(Collections.emptyList(), START, true);
    }

    public void start(List<String> additionalArgs, String cmd, boolean checkPortAvailable) {
        this.cmd(additionalArgs, cmd, checkPortAvailable);
    }

    private void cmd(List<String> additionalArgs, String cmd, boolean checkPortAvailable) {
        int port;
        boolean ok = true;
        int n = port = START.equals(cmd) && this.portStartup > 0 ? this.portStartup : this.portShutdown;
        if (checkPortAvailable) {
            boolean bl = ok = !this.connect(port, 1);
        }
        if (ok) {
            try {
                if (this.verbose) {
                    System.out.println("[] " + cmd.toUpperCase(Locale.ENGLISH) + " SERVER");
                }
                File home = this.getHome();
                String javaVersion = this.options.get("java.version", (String)null);
                String javaHome = this.options.get("java.home", (String)null);
                if (this.verbose) {
                    System.out.println("OPENEJB_HOME = " + home.getAbsolutePath());
                    String systemInfo = "Java " + javaVersion + "; " + this.options.get("os.name", (String)null) + "/" + this.options.get("os.version", (String)null);
                    System.out.println("SYSTEM_INFO  = " + systemInfo);
                }
                this.serverHasAlreadyBeenStarted = false;
                File lib = new File(home, "lib");
                File webapplib = new File(new File(new File(home, "webapps"), "tomee"), "lib");
                File javaagentJar = null;
                try {
                    javaagentJar = this.lib("openejb-javaagent", lib, webapplib);
                }
                catch (IllegalStateException illegalStateException) {
                    // empty catch block
                }
                File conf = new File(home, "conf");
                File loggingProperties = new File(conf, "logging.properties");
                boolean isWindows = this.options.get("os.name", "unknown").toLowerCase(Locale.ENGLISH).startsWith("windows");
                String java = isWindows && START.equals(cmd) && this.options.get("server.windows.fork", false) ? new File(javaHome, "bin/javaw").getAbsolutePath() : new File(javaHome, "bin/java").getAbsolutePath();
                ArrayList<String> argsList = new ArrayList<String>(20);
                argsList.add(java);
                argsList.add("-XX:+HeapDumpOnOutOfMemoryError");
                if (this.debug) {
                    argsList.add("-Xdebug");
                    argsList.add("-Xnoagent");
                    argsList.add("-Djava.compiler=NONE");
                    argsList.add("-Xrunjdwp:transport=dt_socket,server=y,suspend=y,address=" + this.options.get(SERVER_DEBUG_PORT, 5005));
                }
                if (this.profile) {
                    String yourkitHome = this.options.get("yourkit.home", "/Applications/YourKit_Java_Profiler_9.5.6.app/bin/mac/");
                    if (!yourkitHome.endsWith("/")) {
                        yourkitHome = yourkitHome + "/";
                    }
                    String yourkitOpts = this.options.get("yourkit.opts", "disablestacktelemetry,disableexceptiontelemetry,builtinprobes=none,delay=10000,sessionname=Tomcat");
                    argsList.add("-agentpath:" + yourkitHome + "libyjpagent.jnilib=" + (String)yourkitOpts);
                }
                if (this.javaOpts != null) {
                    argsList.addAll(RemoteServer.parse(this.javaOpts.replace("${openejb.base}", home.getAbsolutePath())));
                }
                HashMap<String, String> addedArgs = new HashMap<String, String>();
                if (additionalArgs != null) {
                    for (String arg : additionalArgs) {
                        int equal = arg.indexOf(61);
                        if (equal < 0) {
                            addedArgs.put(arg, "null");
                        } else {
                            addedArgs.put(arg.substring(0, equal), arg.substring(equal + 1).replace("${openejb.base}", home.getAbsolutePath()));
                        }
                        argsList.add(arg.replace("${openejb.base}", home.getAbsolutePath()));
                    }
                }
                if (!addedArgs.containsKey("-Djava.util.logging.config.file") && loggingProperties.exists()) {
                    argsList.add("-Djava.util.logging.config.file=" + loggingProperties.getAbsolutePath());
                }
                if (javaagentJar != null && javaagentJar.exists()) {
                    argsList.add("-javaagent:" + javaagentJar.getAbsolutePath());
                }
                String ps = File.pathSeparator;
                if (!this.tomcat) {
                    File openejbJar = this.lib("openejb-core", lib, webapplib);
                    StringBuilder cp = new StringBuilder(openejbJar.getAbsolutePath());
                    if (this.additionalClasspath != null) {
                        cp.append(ps).append(this.additionalClasspath.replace("${openejb.base}", home.getAbsolutePath()));
                    }
                    argsList.add("-cp");
                    argsList.add(cp.toString());
                    argsList.add("org.apache.openejb.cli.Bootstrap");
                } else {
                    File bin = new File(home, "bin");
                    File tlib = new File(home, "lib");
                    File bootstrapJar = new File(bin, "bootstrap.jar");
                    File juliJar = new File(bin, "tomcat-juli.jar");
                    File commonsLoggingJar = new File(bin, "commons-logging-api.jar");
                    File endorsed = new File(home, "endorsed");
                    File temp = new File(home, "temp");
                    if (!addedArgs.containsKey("-Djava.util.logging.manager")) {
                        argsList.add("-Djava.util.logging.manager=org.apache.juli.ClassLoaderLogManager");
                    }
                    if (!addedArgs.containsKey("-Djava.io.tmpdir")) {
                        argsList.add("-Djava.io.tmpdir=" + temp.getAbsolutePath());
                    }
                    if ((javaVersion.startsWith("1.7") || javaVersion.startsWith("1.8")) && !addedArgs.containsKey("-Djava.endorsed.dirs") && endorsed.exists()) {
                        argsList.add("-Djava.endorsed.dirs=" + endorsed.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Dcatalina.base")) {
                        argsList.add("-Dcatalina.base=" + home.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Dcatalina.home")) {
                        argsList.add("-Dcatalina.home=" + home.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Dcatalina.ext.dirs")) {
                        argsList.add("-Dcatalina.ext.dirs=" + tlib.getAbsolutePath());
                    }
                    if (!addedArgs.containsKey("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE")) {
                        argsList.add("-Dorg.apache.catalina.STRICT_SERVLET_COMPLIANCE=true");
                    }
                    if (!addedArgs.containsKey("-Dorg.apache.tomcat.util.http.ServerCookie.ALLOW_HTTP_SEPARATORS_IN_V0")) {
                        argsList.add("-Dorg.apache.tomcat.util.http.ServerCookie.ALLOW_HTTP_SEPARATORS_IN_V0=true");
                    }
                    if (addedArgs.isEmpty()) {
                        this.addIfSet(argsList, "javax.net.ssl.keyStore");
                        this.addIfSet(argsList, "javax.net.ssl.keyStorePassword");
                        this.addIfSet(argsList, "javax.net.ssl.trustStore");
                        this.addIfSet(argsList, "java.protocol.handler.pkgs");
                    }
                    if (!addedArgs.containsKey("-da")) {
                        argsList.add("-ea");
                    }
                    argsList.add("-classpath");
                    StringBuilder cp = new StringBuilder(bootstrapJar.getAbsolutePath()).append(ps).append(juliJar.getAbsolutePath());
                    if (commonsLoggingJar.exists()) {
                        cp.append(ps).append(commonsLoggingJar.getAbsolutePath());
                    }
                    if (this.additionalClasspath != null) {
                        cp.append(ps).append(this.additionalClasspath.replace("${openejb.base}", home.getAbsolutePath()));
                    }
                    argsList.add(cp.toString());
                    argsList.add("org.apache.catalina.startup.Bootstrap");
                }
                if (cmd == null) {
                    argsList.add(START);
                } else {
                    argsList.add(cmd);
                }
                Object[] args = argsList.toArray(new String[argsList.size()]);
                if (this.verbose) {
                    System.out.println(Join.join("\n", args));
                }
                ProcessBuilder pb = new ProcessBuilder((String[])args).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).directory(home.getAbsoluteFile());
                Process p = pb.start();
                if (START.equals(cmd)) {
                    this.server.set(p);
                } else if (STOP.equals(cmd)) {
                    this.waitFor(p);
                    p = this.server.get();
                    if (p != null) {
                        this.waitFor(p);
                    }
                }
            }
            catch (Exception e) {
                throw (RuntimeException)new OpenEJBRuntimeException("Cannot start the server.  Exception: " + e.getClass().getName() + ": " + e.getMessage()).initCause(e);
            }
            if (port > 0 && (this.debug ? !this.connect(port, Integer.MAX_VALUE) : !this.connect(port, this.tries))) {
                throw new OpenEJBRuntimeException("Could not connect to server: " + this.host + ":" + port);
            }
        } else if (this.verbose) {
            System.out.println("[] FOUND STARTED SERVER");
        }
    }

    private void waitFor(final Process p) {
        final CountDownLatch latch = new CountDownLatch(1);
        Thread t = new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    p.waitFor();
                    List list = kill;
                    synchronized (list) {
                        kill.remove(p);
                    }
                }
                catch (InterruptedException e) {
                    Thread.interrupted();
                }
                finally {
                    latch.countDown();
                }
            }
        }, "process-waitFor");
        t.start();
        try {
            if (!latch.await(Integer.getInteger("openejb.server.waitFor.seconds", 10).intValue(), TimeUnit.SECONDS)) {
                RemoteServer.killOnExit(p);
                throw new RuntimeException("Timeout waiting for process");
            }
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            RemoteServer.killOnExit(p);
        }
    }

    public void kill3UNIX() {
        if (this.options.get("os.name", "unknown").toLowerCase(Locale.ENGLISH).startsWith("windows")) {
            return;
        }
        try {
            Field f = this.server.get().getClass().getDeclaredField("pid");
            f.setAccessible(true);
            int pid = (Integer)f.get(this.server.get());
            new ProcessBuilder("kill", "-3", Integer.toString(pid)).redirectOutput(ProcessBuilder.Redirect.INHERIT).redirectError(ProcessBuilder.Redirect.INHERIT).start();
        }
        catch (Exception e1) {
            e1.printStackTrace();
        }
    }

    private File lib(String name, File ... dirs) {
        for (File dir : dirs) {
            File[] files = dir.listFiles();
            if (files == null) continue;
            for (File file : files) {
                if (!file.isFile() || !file.getName().endsWith(".jar") || !file.getName().startsWith(name)) continue;
                return file;
            }
        }
        if (this.debug) {
            for (File dir : dirs) {
                RemoteServer.dumpLibs(dir);
            }
        }
        throw new IllegalStateException("Cannot find the " + name + " jar");
    }

    private static void dumpLibs(File dir) {
        if (!dir.exists()) {
            System.out.println("lib dir doesn't exist");
            return;
        }
        File[] files = dir.listFiles();
        if (files != null) {
            for (File lib : files) {
                System.out.println(lib.getAbsolutePath());
            }
        }
    }

    public Process getServer() {
        return this.server.get();
    }

    private void addIfSet(List<String> argsList, String key) {
        String systemProperty = this.options.get(key, (String)null);
        if (systemProperty != null) {
            argsList.add("-D" + key + "=" + systemProperty);
        }
    }

    private File getHome() {
        if (this.home != null) {
            return this.home;
        }
        String openejbHome = this.options.get("openejb.home", (String)null);
        if (openejbHome != null) {
            this.home = new File(openejbHome);
        }
        return this.home;
    }

    public boolean stop() {
        if (this.sendShutdown(5)) {
            return true;
        }
        if (this.verbose) {
            this.notSent();
        }
        return false;
    }

    private void notSent() {
        System.out.println("Failed to send the shutdown notification - TomEE is likely shut down already");
    }

    public void forceStop() throws Exception {
        if (this.sendShutdown(5)) {
            this.waitForServerShutdown();
        } else if (this.verbose) {
            this.notSent();
        }
    }

    private void waitForServerShutdown() throws Exception {
        if (this.verbose) {
            System.out.print("Waiting for TomEE shutdown.");
        }
        boolean b = this.disconnect(this.portShutdown, this.tries);
        if (this.verbose) {
            System.out.println();
        }
        if (!b) {
            System.out.println("SEVERE: Failed to shutdown TomEE running on port " + this.portStartup + " using shutdown port: " + this.portShutdown);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean sendShutdown(int attempts) {
        OutputStream stream = null;
        try (Socket socket = new Socket(this.host, this.portShutdown);){
            stream = socket.getOutputStream();
            String shutdown = this.command + Character.toString('\u0000');
            for (int i = 0; i < shutdown.length(); ++i) {
                stream.write(shutdown.charAt(i));
            }
            stream.flush();
        }
        catch (Exception e) {
            block16: {
                if (attempts <= 0) break block16;
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException ie) {
                    boolean bl = false;
                    IO.close((Closeable)stream);
                    return bl;
                }
                boolean bl = this.sendShutdown(--attempts);
                IO.close((Closeable)stream);
                return bl;
            }
            try {
                boolean bl = false;
                return bl;
            }
            finally {
                IO.close(stream);
            }
        }
        IO.close((Closeable)stream);
        return true;
    }

    private boolean connect(int port, int tries) {
        if (this.verbose) {
            System.out.println("[] CONNECT ATTEMPT " + (this.tries - tries) + " on port: " + port);
        }
        try (Socket s = new Socket();){
            s.connect(new InetSocketAddress(this.host, port), this.connectTimeout);
            s.getOutputStream().close();
            if (this.verbose) {
                System.out.println("[] CONNECTED IN " + (this.tries - tries));
            }
        }
        catch (Exception e) {
            if (tries < 2) {
                if (this.verbose) {
                    System.out.println("[] CONNECT ATTEMPTS FAILED ( " + (this.tries - tries) + " ATTEMPTS)");
                }
                return false;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                Thread.interrupted();
            }
            return this.connect(port, --tries);
        }
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private boolean disconnect(int port, int tries) {
        if (this.verbose) {
            System.out.println("[] DISCONNECT ATTEMPT " + (this.tries - tries) + " on port: " + port);
        }
        try (Socket s = new Socket();){
            s.connect(new InetSocketAddress(this.host, port), this.connectTimeout);
            s.getOutputStream().close();
            if (this.verbose) {
                System.out.println("[] NOT DISCONNECTED AFTER ( " + (this.tries - tries) + " ATTEMPTS)");
            }
            if (tries < 2) {
                boolean bl = false;
                return bl;
            }
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e2) {
                Thread.interrupted();
            }
            boolean bl = this.disconnect(port, --tries);
            return bl;
        }
        catch (IOException iOException) {
            return true;
        }
    }

    public void setAdditionalClasspath(String additionalClasspath) {
        this.additionalClasspath = additionalClasspath;
    }

    public void killOnExit() {
        Process p = this.server.get();
        if (!this.serverHasAlreadyBeenStarted && kill.contains(p)) {
            return;
        }
        RemoteServer.killOnExit(p);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void killOnExit(Process p) {
        List<Process> list = kill;
        synchronized (list) {
            kill.add(p);
        }
    }

    public void setDebug(boolean debug) {
        this.debug = debug;
    }

    private static Collection<String> parse(String raw) {
        LinkedList<String> result = new LinkedList<String>();
        Character end = null;
        boolean escaped = false;
        StringBuilder current = new StringBuilder();
        for (int i = 0; i < raw.length(); ++i) {
            char c = raw.charAt(i);
            if (escaped) {
                escaped = false;
                current.append(c);
                continue;
            }
            if (end != null && end.charValue() == c || c == ' ' && end == null) {
                if (current.length() > 0) {
                    result.add(current.toString());
                    current.setLength(0);
                }
                end = null;
                continue;
            }
            if (c == '\\') {
                escaped = true;
                continue;
            }
            if (c == '\"' || c == '\'') {
                end = Character.valueOf(c);
                continue;
            }
            current.append(c);
        }
        if (current.length() > 0) {
            result.add(current.toString());
        }
        return result;
    }

    static {
        Runtime.getRuntime().addShutdownHook(new CleanUpThread());
    }

    public static class CleanUpThread
    extends Thread {
        @Override
        public void run() {
            for (Process server : kill) {
                try {
                    if (server == null) continue;
                    server.destroy();
                    server.waitFor();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

