/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.core.ivm.naming;

import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import javax.naming.Context;
import javax.naming.NameNotFoundException;
import javax.naming.NamingException;
import org.apache.openejb.AppContext;
import org.apache.openejb.core.WebContext;
import org.apache.openejb.core.ivm.naming.IntraVmJndiReference;
import org.apache.openejb.core.ivm.naming.Reference;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.spi.ContainerSystem;
import org.apache.openejb.util.Strings;

public class ContextualJndiReference
extends IntraVmJndiReference {
    public static final ThreadLocal<Boolean> followReference = new ThreadLocal<Boolean>(){

        @Override
        public Boolean initialValue() {
            return true;
        }
    };
    private Object defaultValue;
    private final List<String> prefixes = new CopyOnWriteArrayList<String>();

    public ContextualJndiReference(String jndiName) {
        super(jndiName);
    }

    public void setDefaultValue(Object defaultValue) {
        this.defaultValue = defaultValue;
    }

    public void addPrefix(String value) {
        if (value != null) {
            this.prefixes.add(value);
        }
    }

    public void removePrefix(String value) {
        if (value != null) {
            this.prefixes.remove(value);
        }
    }

    public String lastPrefix() {
        if (this.prefixes.isEmpty()) {
            return null;
        }
        return this.prefixes.get(this.prefixes.size() - 1);
    }

    public boolean hasNoMorePrefix() {
        return this.prefixes.isEmpty();
    }

    public int prefixesSize() {
        return this.prefixes.size();
    }

    @Override
    public Object getObject() throws NamingException {
        Object delegate = this.findDelegate();
        if (Reference.class.isInstance(delegate)) {
            return ((Reference)((Object)Reference.class.cast(delegate))).getObject();
        }
        return delegate;
    }

    private Object findDelegate() throws NameNotFoundException {
        Boolean rawValue = followReference.get() == false;
        followReference.remove();
        if (rawValue.booleanValue()) {
            return this;
        }
        String prefix = this.findPrefix();
        String jndiName = this.getJndiName();
        if (prefix != null && !prefix.isEmpty()) {
            try {
                return this.lookup(prefix + '/' + jndiName);
            }
            catch (NamingException namingException) {
                // empty catch block
            }
        }
        ArrayList<Object> values = new ArrayList<Object>();
        for (String p : this.prefixes) {
            if (p == null || p.isEmpty()) continue;
            try {
                values.add(this.lookup(p + '/' + jndiName));
            }
            catch (NamingException namingException) {}
        }
        if (1 == values.size()) {
            return values.iterator().next();
        }
        if (!values.isEmpty()) {
            throw new NameNotFoundException("Ambiguous resource '" + this.getJndiName() + "'  for classloader " + Thread.currentThread().getContextClassLoader());
        }
        return this.defaultValue;
    }

    private String findPrefix() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        for (AppContext appContext : containerSystem.getAppContexts()) {
            if (appContext.getClassLoader().equals(loader)) {
                return appContext.getId();
            }
            for (WebContext web : appContext.getWebContexts()) {
                if (!web.getClassLoader().equals(loader)) continue;
                return appContext.getId();
            }
        }
        if (1 == containerSystem.getAppContexts().size()) {
            return containerSystem.getAppContexts().iterator().next().getId();
        }
        return null;
    }

    private Object lookup(String s) throws NamingException {
        ContainerSystem containerSystem = (ContainerSystem)SystemInstance.get().getComponent(ContainerSystem.class);
        Context jndiContext = containerSystem.getJNDIContext();
        try {
            if (s.startsWith("java:") | s.startsWith("openejb:")) {
                return jndiContext.lookup(s);
            }
            return jndiContext.lookup("openejb/Resource/" + s);
        }
        catch (NameNotFoundException e) {
            return jndiContext.lookup("java:module/" + Strings.lastPart(this.getClassName(), '.'));
        }
        catch (NamingException e) {
            throw (NamingException)new NamingException("could not look up " + s).initCause(e);
        }
    }

    @Override
    public String toString() {
        return "ContextualJndiReference{jndiName='" + this.getJndiName() + '\'' + '}';
    }
}

