/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.util;

import java.lang.reflect.Array;
import java.util.AbstractList;
import java.util.AbstractMap;
import java.util.AbstractSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Set;

public class Index<K, V>
extends AbstractMap<K, V> {
    private final IndexEntry<K, V>[] entries;
    private final LinkedHashMap<K, Integer> keyIndicies;
    private final IndexEntrySet entrySet;
    private IndexValueList<V> indexValueList;

    public Index(Map<K, V> map) {
        this.entries = new IndexEntry[map.size()];
        this.keyIndicies = new LinkedHashMap(map.size());
        int i = 0;
        for (Map.Entry<K, V> entry : map.entrySet()) {
            this.entries[i] = new IndexEntry(entry);
            this.keyIndicies.put(entry.getKey(), i);
            ++i;
        }
        this.entrySet = new IndexEntrySet();
    }

    public Index(List<K> keys) {
        this.entries = new IndexEntry[keys.size()];
        this.keyIndicies = new LinkedHashMap(keys.size());
        for (int i = 0; i < keys.size(); ++i) {
            K key = keys.get(i);
            this.entries[i] = new IndexEntry(key, null);
            this.keyIndicies.put(key, i);
        }
        this.entrySet = new IndexEntrySet();
    }

    public Index(K[] keys) {
        this.entries = new IndexEntry[keys.length];
        this.keyIndicies = new LinkedHashMap(keys.length);
        for (int i = 0; i < keys.length; ++i) {
            K key = keys[i];
            this.entries[i] = new IndexEntry(key, null);
            this.keyIndicies.put(key, i);
        }
        this.entrySet = new IndexEntrySet();
    }

    @Override
    public List<V> values() {
        if (this.indexValueList == null) {
            this.indexValueList = new IndexValueList();
        }
        return this.indexValueList;
    }

    @Override
    public Set<Map.Entry<K, V>> entrySet() {
        return this.entrySet;
    }

    public K getKey(int index) {
        if (index < 0 || index >= this.entries.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.entries[index].getKey();
    }

    public V get(int index) {
        if (index < 0 || index >= this.entries.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return this.entries[index].getValue();
    }

    public V set(int index, V value) {
        if (index < 0 || index >= this.entries.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        IndexEntry<K, V> entry = this.entries[index];
        V oldValue = entry.getValue();
        entry.setValue(value);
        return oldValue;
    }

    @Override
    public V put(K key, V value) {
        int i = this.indexOf(key);
        if (i < 0) {
            throw new IllegalArgumentException("Index does not contain this key and new entries cannot be added: " + key);
        }
        IndexEntry<K, V> entry = this.entries[i];
        V oldValue = entry.getValue();
        entry.setValue(value);
        return oldValue;
    }

    @Override
    public boolean containsKey(Object key) {
        return this.keyIndicies.containsKey(key);
    }

    public int indexOf(K key) {
        Integer index = this.keyIndicies.get(key);
        if (index == null) {
            return -1;
        }
        return index;
    }

    @Override
    public V get(Object key) {
        int i = this.indexOf(key);
        if (i < 0) {
            return null;
        }
        IndexEntry<K, V> entryMetadata = this.entries[i];
        V value = entryMetadata.getValue();
        return value;
    }

    public Iterator<V> iterator() {
        return new IndexIterator();
    }

    public ListIterator<V> listIterator() {
        return new IndexListIterator(0);
    }

    public ListIterator<V> listIterator(int index) {
        if (index < 0 || index >= this.entries.length) {
            throw new IndexOutOfBoundsException(String.valueOf(index));
        }
        return new IndexListIterator(index);
    }

    public Object[] toArray() {
        return this.toArray(new Object[this.entries.length]);
    }

    public Object[] toArray(Object[] values) {
        if (values.length < this.entries.length) {
            values = (Object[])Array.newInstance(values.getClass().getComponentType(), this.entries.length);
        }
        for (int i = 0; i < this.entries.length; ++i) {
            IndexEntry<K, V> indexEntry = this.entries[i];
            values[i] = indexEntry.getValue();
        }
        return values;
    }

    private static final class IndexEntry<K, V>
    implements Map.Entry<K, V> {
        private final K key;
        private V value;

        private IndexEntry(K key, V value) {
            this.key = key;
            this.value = value;
        }

        private IndexEntry(Map.Entry<K, V> entry) {
            this.key = entry.getKey();
            this.value = entry.getValue();
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V value) {
            V oldValue = this.value;
            this.value = value;
            return oldValue;
        }
    }

    private class IndexEntrySet
    extends AbstractSet {
        private IndexEntrySet() {
        }

        @Override
        public Iterator iterator() {
            return new Iterator(){
                private int index;

                @Override
                public boolean hasNext() {
                    return this.index < Index.this.entries.length;
                }

                public Object next() {
                    return Index.this.entries[this.index++];
                }

                @Override
                public void remove() {
                    throw new UnsupportedOperationException("Index entries cannot be removed");
                }
            };
        }

        @Override
        public int size() {
            return Index.this.entries.length;
        }
    }

    private class IndexValueList<E>
    extends AbstractList<E> {
        private IndexValueList() {
        }

        @Override
        public E get(int index) {
            return (E)Index.this.get(index);
        }

        @Override
        public E set(int index, E element) {
            return Index.this.set(index, element);
        }

        @Override
        public int size() {
            return Index.this.size();
        }
    }

    private class IndexIterator<E>
    implements Iterator<E> {
        protected int index;

        private IndexIterator() {
        }

        @Override
        public boolean hasNext() {
            return this.index < Index.this.entries.length;
        }

        @Override
        public E next() {
            IndexEntry entryMetadata = Index.this.entries[this.index++];
            return (E)entryMetadata.getValue();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException("Index entries cannot be removed");
        }
    }

    private class IndexListIterator<E>
    extends IndexIterator<E>
    implements ListIterator<E> {
        public IndexListIterator(int index2) {
            this.index = index2;
        }

        @Override
        public int nextIndex() {
            return this.index;
        }

        @Override
        public boolean hasPrevious() {
            return this.index > 0;
        }

        @Override
        public E previous() {
            return (E)Index.this.entries[--this.index].getValue();
        }

        @Override
        public int previousIndex() {
            return this.index - 1;
        }

        @Override
        public void set(E o) {
            Index.this.entries[this.index].setValue(o);
        }

        @Override
        public void add(E o) {
            throw new UnsupportedOperationException("Entries cannot be added to a Index");
        }
    }
}

