/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb;

import java.beans.Introspector;
import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamClass;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.net.URL;
import java.net.URLClassLoader;
import java.security.AccessController;
import java.security.PrivilegedAction;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.jar.JarFile;
import java.util.zip.ZipFile;
import org.apache.openejb.classloader.ClassLoaderConfigurer;
import org.apache.openejb.classloader.CompositeClassLoaderConfigurer;
import org.apache.openejb.config.QuickJarsTxtParser;
import org.apache.openejb.core.TempClassLoader;
import org.apache.openejb.loader.SystemInstance;
import org.apache.openejb.util.LogCategory;
import org.apache.openejb.util.Logger;
import org.apache.openejb.util.UrlCache;
import org.apache.openejb.util.classloader.URLClassLoaderFirst;
import org.apache.xbean.recipe.ObjectRecipe;

public class ClassLoaderUtil {
    private static final Logger logger = Logger.getInstance(LogCategory.OPENEJB, ClassLoaderUtil.class);
    private static final Map<String, List<ClassLoader>> classLoadersByApp = new HashMap<String, List<ClassLoader>>();
    private static final Map<ClassLoader, Set<String>> appsByClassLoader = new HashMap<ClassLoader, Set<String>>();
    private static final UrlCache localUrlCache = new UrlCache();
    private static final AtomicBoolean skipClearSunJarFile = new AtomicBoolean();

    public static void destroyClassLoader(String appId, String appPath) {
        ClassLoaderUtil.destroyClassLoader(appId);
        ClassLoaderUtil.destroyClassLoader(appPath);
    }

    public static ClassLoader getContextClassLoader() {
        return AccessController.doPrivileged(new PrivilegedAction<ClassLoader>(){

            @Override
            public ClassLoader run() {
                return Thread.currentThread().getContextClassLoader();
            }
        });
    }

    public static File getUrlCachedName(String appId, URL url) {
        return localUrlCache.getUrlCachedName(appId, url);
    }

    public static boolean isUrlCached(String appId, URL url) {
        return localUrlCache.isUrlCached(appId, url);
    }

    public static URL getUrlKeyCached(String appId, File file) {
        return localUrlCache.getUrlKeyCached(appId, file);
    }

    public static URLClassLoader createClassLoaderFirst(String appId, URL[] urls, ClassLoader parent) {
        return ClassLoaderUtil.cacheClassLoader(appId, new URLClassLoaderFirst(localUrlCache.cacheUrls(appId, urls), parent));
    }

    public static URLClassLoader createClassLoader(String appId, URL[] urls, ClassLoader parent) {
        return ClassLoaderUtil.cacheClassLoader(appId, new URLClassLoader(localUrlCache.cacheUrls(appId, urls), parent));
    }

    private static URLClassLoader cacheClassLoader(String appId, URLClassLoader classLoader) {
        List classLoaders = classLoadersByApp.computeIfAbsent(appId, k -> new ArrayList(2));
        classLoaders.add(classLoader);
        Set apps = appsByClassLoader.computeIfAbsent(classLoader, k -> new LinkedHashSet(1));
        apps.add(appId);
        return classLoader;
    }

    public static void destroyClassLoader(ClassLoader classLoader) {
        Set<String> apps = appsByClassLoader.remove(classLoader);
        logger.debug("Destroying classLoader '" + ClassLoaderUtil.toString(classLoader) + "' for apps: " + apps);
        if (apps != null) {
            for (String appId : apps) {
                List<ClassLoader> classLoaders = classLoadersByApp.get(appId);
                if (classLoaders != null) {
                    classLoaders.remove(classLoader);
                }
                if (null != classLoaders && !classLoaders.isEmpty()) continue;
                ClassLoaderUtil.destroyClassLoader(appId);
            }
        }
        ClassLoaderUtil.cleanOpenJPACache(classLoader);
        for (String jar : ClassLoaderUtil.getClosedJarFiles(classLoader)) {
            ClassLoaderUtil.clearSunJarFileFactoryCache(jar);
        }
        if (Closeable.class.isInstance(classLoader)) {
            try {
                ((Closeable)Closeable.class.cast(classLoader)).close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }

    private static List<String> getClosedJarFiles(ClassLoader cl) {
        ArrayList<String> files = new ArrayList<String>();
        if (null != cl && cl instanceof URLClassLoader) {
            URLClassLoader ucl = (URLClassLoader)cl;
            Class<URLClassLoader> clazz = URLClassLoader.class;
            try {
                Field ucp = clazz.getDeclaredField("ucp");
                ucp.setAccessible(true);
                Object cp = ucp.get(ucl);
                Field loaders = cp.getClass().getDeclaredField("loaders");
                loaders.setAccessible(true);
                Collection c = (Collection)loaders.get(cp);
                for (Object jl : c.toArray()) {
                    try {
                        Field loader = jl.getClass().getDeclaredField("jar");
                        loader.setAccessible(true);
                        JarFile jf = (JarFile)loader.get(jl);
                        files.add(jf.getName());
                        jf.close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                }
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        return files;
    }

    public boolean finalizeNativeLibs(ClassLoader cl) {
        Class<ClassLoader> classClassLoader = ClassLoader.class;
        Field nativeLibraries = null;
        try {
            nativeLibraries = classClassLoader.getDeclaredField("nativeLibraries");
        }
        catch (NoSuchFieldException noSuchFieldException) {
            // empty catch block
        }
        if (nativeLibraries == null) {
            return false;
        }
        nativeLibraries.setAccessible(true);
        Object obj = null;
        try {
            obj = nativeLibraries.get(cl);
        }
        catch (IllegalAccessException illegalAccessException) {
            // empty catch block
        }
        if (!(obj instanceof Vector)) {
            return false;
        }
        Vector javaLangClassLoaderNativeLibrary = (Vector)obj;
        for (Object lib : javaLangClassLoaderNativeLibrary) {
            try {
                Method finalize = lib.getClass().getDeclaredMethod("finalize", new Class[0]);
                if (finalize == null) continue;
                finalize.setAccessible(true);
                try {
                    finalize.invoke(lib, new Object[0]);
                }
                catch (Throwable throwable) {
                }
            }
            catch (Throwable throwable) {}
        }
        return true;
    }

    public static void destroyClassLoader(String appId) {
        logger.debug("Destroying classLoaders for application " + appId);
        List<ClassLoader> classLoaders = classLoadersByApp.remove(appId);
        if (classLoaders != null) {
            Iterator<ClassLoader> it = classLoaders.iterator();
            while (it.hasNext()) {
                ClassLoader cl = it.next();
                Set<String> apps = appsByClassLoader.get(cl);
                if (null != apps) {
                    apps.remove(appId);
                }
                if (null == apps || apps.isEmpty()) {
                    it.remove();
                    appsByClassLoader.remove(cl);
                    ClassLoaderUtil.destroyClassLoader(cl);
                    System.gc();
                    continue;
                }
                logger.debug("ClassLoader " + ClassLoaderUtil.toString(cl) + " held open by the applications: " + apps);
            }
        }
        localUrlCache.releaseUrls(appId);
        ClassLoaderUtil.clearSunJarFileFactoryCache(appId);
    }

    public static URLClassLoader createTempClassLoader(ClassLoader parent) {
        return new TempClassLoader(parent);
    }

    public static URLClassLoader createTempClassLoader(String appId, URL[] rawUrls, ClassLoader parent) {
        URL[] urls;
        File file;
        String updatedAppId = appId;
        if (appId != null && (file = new File(appId)).exists() && ((updatedAppId = file.getName()).endsWith(".war") || updatedAppId.endsWith(".ear"))) {
            updatedAppId = updatedAppId.substring(0, updatedAppId.length() - ".war".length());
        }
        ClassLoaderConfigurer configurer1 = QuickJarsTxtParser.parse(new File(appId, "META-INF/jars.txt"));
        ClassLoaderConfigurer configurer2 = QuickJarsTxtParser.parse(new File(appId, "WEB-INF/jars.txt"));
        ClassLoaderConfigurer configurer3 = ClassLoaderUtil.configurer(updatedAppId);
        if (configurer3 == null) {
            configurer3 = ClassLoaderUtil.configurer(appId);
        }
        if (configurer1 == null && configurer2 == null && configurer3 == null) {
            urls = rawUrls;
        } else {
            CompositeClassLoaderConfigurer configurer = new CompositeClassLoaderConfigurer(configurer1, configurer2, configurer3);
            ArrayList<URL> list = new ArrayList<URL>(Arrays.asList(rawUrls));
            ClassLoaderConfigurer.Helper.configure(list, configurer);
            urls = list.toArray(new URL[list.size()]);
        }
        return new TempClassLoader(ClassLoaderUtil.createClassLoader(appId, urls, parent));
    }

    public static void clearClassLoaderCaches() {
        ClassLoaderUtil.clearSunSoftCache(ObjectInputStream.class, "subclassAudits");
        ClassLoaderUtil.clearSunSoftCache(ObjectOutputStream.class, "subclassAudits");
        ClassLoaderUtil.clearSunSoftCache(ObjectStreamClass.class, "localDescs");
        ClassLoaderUtil.clearSunSoftCache(ObjectStreamClass.class, "reflectors");
        Introspector.flushCaches();
    }

    public static void clearSunJarFileFactoryCache(String jarLocation) {
        ClassLoaderUtil.clearSunJarFileFactoryCacheImpl(jarLocation, 5);
    }

    private static synchronized void clearSunJarFileFactoryCacheImpl(String jarLocation, int attempt) {
        if (skipClearSunJarFile.get()) {
            return;
        }
        logger.debug("Clearing Sun JarFileFactory cache for directory " + jarLocation);
        try {
            Object remove;
            Class<?> jarFileFactory = Class.forName("sun.net.www.protocol.jar.JarFileFactory");
            Field fileCacheField = jarFileFactory.getDeclaredField("fileCache");
            fileCacheField.setAccessible(true);
            Map fileCache = (Map)fileCacheField.get(null);
            HashMap fileCacheCopy = new HashMap(fileCache);
            Field urlCacheField = jarFileFactory.getDeclaredField("urlCache");
            urlCacheField.setAccessible(true);
            Map urlCache = (Map)urlCacheField.get(null);
            HashMap urlCacheCopy = new HashMap(urlCache);
            Iterator iterator = urlCacheCopy.entrySet().iterator();
            ArrayList urlCacheRemoveKeys = new ArrayList();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object key = entry.getKey();
                if (key instanceof ZipFile) {
                    ZipFile zf = (ZipFile)key;
                    File file = new File(zf.getName());
                    if (!ClassLoaderUtil.isParent(jarLocation, file)) continue;
                    urlCacheRemoveKeys.add(key);
                    continue;
                }
                logger.warning("Unexpected key type: " + key);
            }
            iterator = fileCacheCopy.entrySet().iterator();
            ArrayList fileCacheRemoveKeys = new ArrayList();
            while (iterator.hasNext()) {
                Map.Entry entry = iterator.next();
                Object value = entry.getValue();
                if (!urlCacheRemoveKeys.contains(value)) continue;
                fileCacheRemoveKeys.add(entry.getKey());
            }
            for (Map.Entry next : fileCacheRemoveKeys) {
                try {
                    remove = fileCache.remove(next);
                    if (null == remove) continue;
                    logger.debug("Removed item from fileCache: " + remove);
                }
                catch (Throwable e) {
                    logger.warning("Failed to remove item from fileCache: " + next);
                }
            }
            for (Map.Entry next : urlCacheRemoveKeys) {
                try {
                    remove = urlCache.remove(next);
                    try {
                        ((ZipFile)((Object)next)).close();
                    }
                    catch (Throwable throwable) {
                        // empty catch block
                    }
                    if (null == remove) continue;
                    logger.debug("Removed item from urlCache: " + remove);
                }
                catch (Throwable e) {
                    logger.warning("Failed to remove item from urlCache: " + next);
                }
            }
        }
        catch (ConcurrentModificationException e) {
            if (attempt > 0) {
                ClassLoaderUtil.clearSunJarFileFactoryCacheImpl(jarLocation, attempt - 1);
            } else {
                logger.error("Unable to clear Sun JarFileFactory cache after 5 attempts", e);
            }
        }
        catch (ClassNotFoundException | NoSuchFieldException e) {
        }
        catch (RuntimeException re) {
            if ("java.lang.reflect.InaccessibleObjectException".equals(re.getClass().getName())) {
                skipClearSunJarFile.compareAndSet(false, true);
                return;
            }
            throw re;
        }
        catch (Throwable e) {
            if (Boolean.getBoolean("openejb.java9.hack")) {
                return;
            }
            logger.error("Unable to clear Sun JarFileFactory cache", e);
        }
    }

    private static boolean isParent(String jarLocation, File file) {
        File dir = new File(jarLocation);
        while (file != null) {
            if (file.equals(dir)) {
                return true;
            }
            file = file.getParentFile();
        }
        return false;
    }

    public static void clearSunSoftCache(Class clazz, String fieldName) {
        try {
            Field field = clazz.getDeclaredField(fieldName);
            field.setAccessible(true);
            Map cache = (Map)field.get(null);
            cache.clear();
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    public static void cleanOpenJPACache(ClassLoader classLoader) {
        if (classLoader != ClassLoader.getSystemClassLoader()) {
            try {
                Class<?> pcRegistryClass = ClassLoaderUtil.class.getClassLoader().loadClass("org.apache.openjpa.enhance.PCRegistry");
                Method deRegisterMethod = pcRegistryClass.getMethod("deRegister", ClassLoader.class);
                deRegisterMethod.invoke(null, classLoader);
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    private static String toString(ClassLoader classLoader) {
        if (classLoader == null) {
            return "null";
        }
        return classLoader.getClass().getSimpleName() + "@" + System.identityHashCode(classLoader);
    }

    public static String resourceName(String s) {
        return s.replace(".", "/") + ".class";
    }

    public static ClassLoaderConfigurer configurer(String rawId) {
        String id = rawId;
        if (id != null && (id.startsWith("/") || id.startsWith("\\")) && !new File(id).exists() && id.length() > 1) {
            id = id.substring(1);
        }
        if (id == null) {
            id = "";
        }
        String key = "tomee.classloader.configurer." + id + ".clazz";
        String impl = SystemInstance.get().getProperty(key);
        if (impl == null) {
            key = "tomee.classloader.configurer.clazz";
            impl = SystemInstance.get().getProperty(key);
            if (impl == null) {
                key = "openejb.classloader.configurer." + id + ".clazz";
                impl = SystemInstance.get().getProperty(key);
                if (impl == null) {
                    key = "openejb.classloader.configurer.clazz";
                    impl = SystemInstance.get().getProperty(key);
                }
            }
        }
        if (impl != null) {
            key = key.substring(0, key.length() - "clazz".length());
            boolean list = false;
            try {
                ClassLoaderUtil.class.getClassLoader().loadClass(impl);
            }
            catch (ClassNotFoundException e) {
                list = true;
            }
            if (!list) {
                return ClassLoaderUtil.createConfigurer(key, impl);
            }
            String[] names = impl.split(",");
            ClassLoaderConfigurer[] configurers = new ClassLoaderConfigurer[names.length];
            for (int i = 0; i < names.length; ++i) {
                configurers[i] = ClassLoaderUtil.createConfigurer(names[i], SystemInstance.get().getProperty(names[i] + ".clazz"));
            }
            return new CompositeClassLoaderConfigurer(configurers);
        }
        return null;
    }

    private static ClassLoaderConfigurer createConfigurer(String key, String impl) {
        try {
            ObjectRecipe recipe = new ObjectRecipe(impl);
            for (Map.Entry<Object, Object> entry : SystemInstance.get().getProperties().entrySet()) {
                String newKey;
                String entryKey = entry.getKey().toString();
                if (!entryKey.startsWith(key) || "clazz".equals(newKey = entryKey.substring(key.length()))) continue;
                recipe.setProperty(newKey, entry.getValue());
            }
            Object instance = recipe.create();
            if (instance instanceof ClassLoaderConfigurer) {
                return (ClassLoaderConfigurer)instance;
            }
            logger.error(impl + " is not a classlaoder configurer, using default behavior");
        }
        catch (Exception e) {
            logger.error("Can't create classloader configurer " + impl + ", using default behavior");
        }
        return null;
    }
}

