/*
 * Decompiled with CFR 0.152.
 */
package org.apache.openejb.cli;

import java.io.File;
import java.io.FilenameFilter;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.StringTokenizer;
import org.apache.openejb.loader.BasicURLClassPath;
import org.apache.openejb.loader.IO;
import org.apache.openejb.util.JavaSecurityManagers;
import org.apache.openejb.util.PropertyPlaceHolderHelper;
import org.apache.openejb.util.URLs;

public class Bootstrap {
    private static final String OPENEJB_VERSION_PROPERTIES_FILE_NAME = "openejb-version.properties";
    private static final String OPENEJB_HOME_PROPERTY_NAME = "openejb.home";
    private static final String OPENEJB_BASE_PROPERTY_NAME = "openejb.base";
    private static final String OPENEJB_CLI_MAIN_CLASS_NAME = "org.apache.openejb.cli.MainImpl";

    private static void setupHome(String[] args) {
        for (String arg : args) {
            if (arg.startsWith("-Dopenejb.home")) {
                Bootstrap.addProperty(arg);
                continue;
            }
            if (!arg.startsWith("-Dopenejb.base")) continue;
            Bootstrap.addProperty(arg);
        }
        String homeProperty = JavaSecurityManagers.getSystemProperty(OPENEJB_HOME_PROPERTY_NAME);
        if (homeProperty != null && new File(homeProperty).exists()) {
            return;
        }
        try {
            URL classURL = Thread.currentThread().getContextClassLoader().getResource(OPENEJB_VERSION_PROPERTIES_FILE_NAME);
            if (classURL != null) {
                String propsString = classURL.getFile();
                URI uri = URLs.uri(propsString = propsString.substring(0, propsString.indexOf(33)));
                File jarFile = new File(uri.getSchemeSpecificPart());
                if (jarFile.getName().contains("openejb-core")) {
                    File lib = jarFile.getParentFile();
                    File home = lib.getParentFile().getCanonicalFile();
                    JavaSecurityManagers.setSystemProperty(OPENEJB_HOME_PROPERTY_NAME, home.getAbsolutePath());
                }
            }
        }
        catch (Exception e) {
            System.err.println("Error setting openejb.home property: " + e.getClass() + ": " + e.getMessage());
        }
    }

    private static void addProperty(String arg) {
        String prop = arg.substring(arg.indexOf("-D") + 2, arg.indexOf(61));
        String val = arg.substring(arg.indexOf(61) + 1);
        JavaSecurityManagers.setSystemProperty(prop, val);
    }

    private static URLClassLoader setupClasspath() {
        String base = JavaSecurityManagers.getSystemProperty(OPENEJB_BASE_PROPERTY_NAME, "");
        String home = JavaSecurityManagers.getSystemProperty("catalina.home", JavaSecurityManagers.getSystemProperty(OPENEJB_HOME_PROPERTY_NAME, base));
        try {
            File lib = new File(home + File.separator + "lib");
            BasicURLClassPath.CustomizableURLClassLoader dynamicURLClassLoader = new BasicURLClassPath.CustomizableURLClassLoader(ClassLoader.getSystemClassLoader());
            File config = new File(base, "conf/catalina.properties");
            if (!config.isFile()) {
                config = new File(home, "conf/catalina.properties");
            }
            if (config.isFile()) {
                String val = IO.readProperties((File)config).getProperty("common.loader", lib.getAbsolutePath());
                val = PropertyPlaceHolderHelper.simpleValue(val.replace("${catalina.", "${openejb."));
                StringTokenizer tokenizer = new StringTokenizer(val, ",");
                while (tokenizer.hasMoreElements()) {
                    File dir;
                    String repository = tokenizer.nextToken().trim();
                    if (repository.isEmpty()) continue;
                    if (repository.startsWith("\"") && repository.endsWith("\"")) {
                        repository = repository.substring(1, repository.length() - 1);
                    }
                    if (repository.endsWith("*.jar")) {
                        dir = new File(repository.substring(0, repository.length() - "*.jar".length()));
                        if (!dir.isDirectory()) continue;
                        Bootstrap.addJarsToPath(dynamicURLClassLoader, dir);
                        dynamicURLClassLoader.add(dir.toURI().toURL());
                        continue;
                    }
                    if (repository.endsWith(".jar")) {
                        File file = new File(repository);
                        if (!file.isFile()) continue;
                        dynamicURLClassLoader.add(file.toURI().toURL());
                        continue;
                    }
                    dir = new File(repository);
                    if (!dir.isDirectory()) continue;
                    dynamicURLClassLoader.add(dir.toURI().toURL());
                }
            } else {
                Bootstrap.addJarsToPath(dynamicURLClassLoader, lib);
                dynamicURLClassLoader.add(lib.toURI().toURL());
            }
            return dynamicURLClassLoader;
        }
        catch (Exception e) {
            System.err.println("Error setting up the classpath: " + e.getClass() + ": " + e.getMessage());
            e.printStackTrace();
            return null;
        }
    }

    private static void addJarsToPath(BasicURLClassPath.CustomizableURLClassLoader classLoader, File folder) throws MalformedURLException {
        File[] jarFiles;
        if (classLoader == null || folder == null) {
            return;
        }
        if (!folder.exists()) {
            return;
        }
        for (File jarFile : jarFiles = folder.listFiles(new FilenameFilter(){

            @Override
            public boolean accept(File dir, String name) {
                return name.endsWith(".jar");
            }
        })) {
            classLoader.add(jarFile.toURI().toURL());
        }
    }

    public static void main(String[] args) throws Exception {
        ClassLoader cl = null;
        Bootstrap.setupHome(args);
        try {
            try (URLClassLoader loader = Bootstrap.setupClasspath();){
                if (loader != null) {
                    cl = Thread.currentThread().getContextClassLoader();
                    Thread.currentThread().setContextClassLoader(loader);
                    if (loader != ClassLoader.getSystemClassLoader()) {
                        System.setProperty("openejb.classloader.first.disallow-system-loading", "true");
                    }
                }
                Class<?> clazz = (loader == null ? Bootstrap.class.getClassLoader() : loader).loadClass(OPENEJB_CLI_MAIN_CLASS_NAME);
                Object main = clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
                main.getClass().getMethod("main", String[].class).invoke(main, new Object[]{args});
            }
            if (cl != null) {
                Thread.currentThread().setContextClassLoader(cl);
            }
        }
        catch (InvocationTargetException e) {
            try {
                Throwable cause = e.getCause();
                if ("org.apache.openejb.cli.SystemExitException".equals(cause.getClass().getName())) {
                    System.exit(((Number)Number.class.cast(cause.getClass().getMethod("getExitCode", new Class[0]).invoke((Object)cause, new Object[0]))).intValue());
                }
                if (Exception.class.isInstance(cause)) {
                    throw (Exception)Exception.class.cast(cause);
                }
                if (Error.class.isInstance(cause)) {
                    throw (Error)Error.class.cast(cause);
                }
                throw new IllegalStateException(cause);
            }
            catch (Throwable throwable) {
                if (cl != null) {
                    Thread.currentThread().setContextClassLoader(cl);
                }
                throw throwable;
            }
        }
    }
}

